# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # NotebookExecutionJob represents an instance of a notebook execution.
        # @!attribute [rw] dataform_repository_source
        #   @return [::Google::Cloud::AIPlatform::V1::NotebookExecutionJob::DataformRepositorySource]
        #     The Dataform Repository pointing to a single file notebook repository.
        #
        #     Note: The following fields are mutually exclusive: `dataform_repository_source`, `gcs_notebook_source`, `direct_notebook_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gcs_notebook_source
        #   @return [::Google::Cloud::AIPlatform::V1::NotebookExecutionJob::GcsNotebookSource]
        #     The Cloud Storage url pointing to the ipynb file. Format:
        #     `gs://bucket/notebook_file.ipynb`
        #
        #     Note: The following fields are mutually exclusive: `gcs_notebook_source`, `dataform_repository_source`, `direct_notebook_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] direct_notebook_source
        #   @return [::Google::Cloud::AIPlatform::V1::NotebookExecutionJob::DirectNotebookSource]
        #     The contents of an input notebook file.
        #
        #     Note: The following fields are mutually exclusive: `direct_notebook_source`, `dataform_repository_source`, `gcs_notebook_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] notebook_runtime_template_resource_name
        #   @return [::String]
        #     The NotebookRuntimeTemplate to source compute configuration from.
        #
        #     Note: The following fields are mutually exclusive: `notebook_runtime_template_resource_name`, `custom_environment_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] custom_environment_spec
        #   @return [::Google::Cloud::AIPlatform::V1::NotebookExecutionJob::CustomEnvironmentSpec]
        #     The custom compute configuration for an execution job.
        #
        #     Note: The following fields are mutually exclusive: `custom_environment_spec`, `notebook_runtime_template_resource_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gcs_output_uri
        #   @return [::String]
        #     The Cloud Storage location to upload the result to. Format:
        #     `gs://bucket-name`
        # @!attribute [rw] execution_user
        #   @return [::String]
        #     The user email to run the execution as. Only supported by Colab runtimes.
        #
        #     Note: The following fields are mutually exclusive: `execution_user`, `service_account`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     The service account to run the execution as.
        #
        #     Note: The following fields are mutually exclusive: `service_account`, `execution_user`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] workbench_runtime
        #   @return [::Google::Cloud::AIPlatform::V1::NotebookExecutionJob::WorkbenchRuntime]
        #     The Workbench runtime configuration to use for the notebook execution.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of this NotebookExecutionJob. Format:
        #     `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of the NotebookExecutionJob. The name can be up to 128
        #     characters long and can consist of any UTF-8 characters.
        # @!attribute [rw] execution_timeout
        #   @return [::Google::Protobuf::Duration]
        #     Max running time of the execution job in seconds (default 86400s / 24 hrs).
        # @!attribute [rw] schedule_resource_name
        #   @return [::String]
        #     The Schedule resource name if this job is triggered by one. Format:
        #     `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
        # @!attribute [r] job_state
        #   @return [::Google::Cloud::AIPlatform::V1::JobState]
        #     Output only. The state of the NotebookExecutionJob.
        # @!attribute [r] status
        #   @return [::Google::Rpc::Status]
        #     Output only. Populated when the NotebookExecutionJob is completed. When
        #     there is an error during notebook execution, the error details are
        #     populated.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this NotebookExecutionJob was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this NotebookExecutionJob was most recently
        #     updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels with user-defined metadata to organize NotebookExecutionJobs.
        #
        #     Label keys and values can be no longer than 64 characters
        #     (Unicode codepoints), can only contain lowercase letters, numeric
        #     characters, underscores and dashes. International characters are allowed.
        #
        #     See https://goo.gl/xmQnxf for more information and examples of labels.
        #     System reserved label keys are prefixed with "aiplatform.googleapis.com/"
        #     and are immutable.
        # @!attribute [rw] kernel_name
        #   @return [::String]
        #     The name of the kernel to use during notebook execution. If unset, the
        #     default kernel is used.
        # @!attribute [rw] encryption_spec
        #   @return [::Google::Cloud::AIPlatform::V1::EncryptionSpec]
        #     Customer-managed encryption key spec for the notebook execution job.
        #     This field is auto-populated if the
        #     {::Google::Cloud::AIPlatform::V1::NotebookRuntimeTemplate NotebookRuntimeTemplate}
        #     has an encryption spec.
        class NotebookExecutionJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The Dataform Repository containing the input notebook.
          # @!attribute [rw] dataform_repository_resource_name
          #   @return [::String]
          #     The resource name of the Dataform Repository. Format:
          #     `projects/{project_id}/locations/{location}/repositories/{repository_id}`
          # @!attribute [rw] commit_sha
          #   @return [::String]
          #     The commit SHA to read repository with. If unset, the file will be read
          #     at HEAD.
          class DataformRepositorySource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The Cloud Storage uri for the input notebook.
          # @!attribute [rw] uri
          #   @return [::String]
          #     The Cloud Storage uri pointing to the ipynb file. Format:
          #     `gs://bucket/notebook_file.ipynb`
          # @!attribute [rw] generation
          #   @return [::String]
          #     The version of the Cloud Storage object to read. If unset, the current
          #     version of the object is read. See
          #     https://cloud.google.com/storage/docs/metadata#generation-number.
          class GcsNotebookSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The content of the input notebook in ipynb format.
          # @!attribute [rw] content
          #   @return [::String]
          #     The base64-encoded contents of the input notebook file.
          class DirectNotebookSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Compute configuration to use for an execution job.
          # @!attribute [rw] machine_spec
          #   @return [::Google::Cloud::AIPlatform::V1::MachineSpec]
          #     The specification of a single machine for the execution job.
          # @!attribute [rw] persistent_disk_spec
          #   @return [::Google::Cloud::AIPlatform::V1::PersistentDiskSpec]
          #     The specification of a persistent disk to attach for the execution job.
          # @!attribute [rw] network_spec
          #   @return [::Google::Cloud::AIPlatform::V1::NetworkSpec]
          #     The network configuration to use for the execution job.
          class CustomEnvironmentSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for a Workbench Instances-based environment.
          class WorkbenchRuntime
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
