# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Represents a Neural Architecture Search (NAS) job.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the NasJob.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the NasJob.
        #     The name can be up to 128 characters long and can consist of any UTF-8
        #     characters.
        # @!attribute [rw] nas_job_spec
        #   @return [::Google::Cloud::AIPlatform::V1::NasJobSpec]
        #     Required. The specification of a NasJob.
        # @!attribute [r] nas_job_output
        #   @return [::Google::Cloud::AIPlatform::V1::NasJobOutput]
        #     Output only. Output of the NasJob.
        # @!attribute [r] state
        #   @return [::Google::Cloud::AIPlatform::V1::JobState]
        #     Output only. The detailed state of the job.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the NasJob was created.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the NasJob for the first time entered the
        #     `JOB_STATE_RUNNING` state.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the NasJob entered any of the following states:
        #     `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the NasJob was most recently updated.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. Only populated when job's state is JOB_STATE_FAILED or
        #     JOB_STATE_CANCELLED.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels with user-defined metadata to organize NasJobs.
        #
        #     Label keys and values can be no longer than 64 characters
        #     (Unicode codepoints), can only contain lowercase letters, numeric
        #     characters, underscores and dashes. International characters are allowed.
        #
        #     See https://goo.gl/xmQnxf for more information and examples of labels.
        # @!attribute [rw] encryption_spec
        #   @return [::Google::Cloud::AIPlatform::V1::EncryptionSpec]
        #     Customer-managed encryption key options for a NasJob.
        #     If this is set, then all resources created by the NasJob
        #     will be encrypted with the provided encryption key.
        # @!attribute [rw] enable_restricted_image_training
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Optional. Enable a separation of Custom model training
        #     and restricted image training for tenant project.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        class NasJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents a NasTrial details along with its parameters. If there is a
        # corresponding train NasTrial, the train NasTrial is also returned.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the NasTrialDetail.
        # @!attribute [rw] parameters
        #   @return [::String]
        #     The parameters for the NasJob NasTrial.
        # @!attribute [rw] search_trial
        #   @return [::Google::Cloud::AIPlatform::V1::NasTrial]
        #     The requested search NasTrial.
        # @!attribute [rw] train_trial
        #   @return [::Google::Cloud::AIPlatform::V1::NasTrial]
        #     The train NasTrial corresponding to
        #     {::Google::Cloud::AIPlatform::V1::NasTrialDetail#search_trial search_trial}.
        #     Only populated if
        #     {::Google::Cloud::AIPlatform::V1::NasTrialDetail#search_trial search_trial} is
        #     used for training.
        class NasTrialDetail
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the spec of a NasJob.
        # @!attribute [rw] multi_trial_algorithm_spec
        #   @return [::Google::Cloud::AIPlatform::V1::NasJobSpec::MultiTrialAlgorithmSpec]
        #     The spec of multi-trial algorithms.
        # @!attribute [rw] resume_nas_job_id
        #   @return [::String]
        #     The ID of the existing NasJob in the same Project and Location
        #     which will be used to resume search. search_space_spec and
        #     nas_algorithm_spec are obtained from previous NasJob hence should not
        #     provide them again for this NasJob.
        # @!attribute [rw] search_space_spec
        #   @return [::String]
        #     It defines the search space for Neural Architecture Search (NAS).
        class NasJobSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The spec of multi-trial Neural Architecture Search (NAS).
          # @!attribute [rw] multi_trial_algorithm
          #   @return [::Google::Cloud::AIPlatform::V1::NasJobSpec::MultiTrialAlgorithmSpec::MultiTrialAlgorithm]
          #     The multi-trial Neural Architecture Search (NAS) algorithm
          #     type. Defaults to `REINFORCEMENT_LEARNING`.
          # @!attribute [rw] metric
          #   @return [::Google::Cloud::AIPlatform::V1::NasJobSpec::MultiTrialAlgorithmSpec::MetricSpec]
          #     Metric specs for the NAS job.
          #     Validation for this field is done at `multi_trial_algorithm_spec` field.
          # @!attribute [rw] search_trial_spec
          #   @return [::Google::Cloud::AIPlatform::V1::NasJobSpec::MultiTrialAlgorithmSpec::SearchTrialSpec]
          #     Required. Spec for search trials.
          # @!attribute [rw] train_trial_spec
          #   @return [::Google::Cloud::AIPlatform::V1::NasJobSpec::MultiTrialAlgorithmSpec::TrainTrialSpec]
          #     Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
          #     search trials will be trained for every M
          #     [TrainTrialSpec.frequency] trials searched.
          class MultiTrialAlgorithmSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents a metric to optimize.
            # @!attribute [rw] metric_id
            #   @return [::String]
            #     Required. The ID of the metric. Must not contain whitespaces.
            # @!attribute [rw] goal
            #   @return [::Google::Cloud::AIPlatform::V1::NasJobSpec::MultiTrialAlgorithmSpec::MetricSpec::GoalType]
            #     Required. The optimization goal of the metric.
            class MetricSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # The available types of optimization goals.
              module GoalType
                # Goal Type will default to maximize.
                GOAL_TYPE_UNSPECIFIED = 0

                # Maximize the goal metric.
                MAXIMIZE = 1

                # Minimize the goal metric.
                MINIMIZE = 2
              end
            end

            # Represent spec for search trials.
            # @!attribute [rw] search_trial_job_spec
            #   @return [::Google::Cloud::AIPlatform::V1::CustomJobSpec]
            #     Required. The spec of a search trial job. The same spec applies to
            #     all search trials.
            # @!attribute [rw] max_trial_count
            #   @return [::Integer]
            #     Required. The maximum number of Neural Architecture Search (NAS) trials
            #     to run.
            # @!attribute [rw] max_parallel_trial_count
            #   @return [::Integer]
            #     Required. The maximum number of trials to run in parallel.
            # @!attribute [rw] max_failed_trial_count
            #   @return [::Integer]
            #     The number of failed trials that need to be seen before failing
            #     the NasJob.
            #
            #     If set to 0, Vertex AI decides how many trials must fail
            #     before the whole job fails.
            class SearchTrialSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Represent spec for train trials.
            # @!attribute [rw] train_trial_job_spec
            #   @return [::Google::Cloud::AIPlatform::V1::CustomJobSpec]
            #     Required. The spec of a train trial job. The same spec applies to
            #     all train trials.
            # @!attribute [rw] max_parallel_trial_count
            #   @return [::Integer]
            #     Required. The maximum number of trials to run in parallel.
            # @!attribute [rw] frequency
            #   @return [::Integer]
            #     Required. Frequency of search trials to start train stage. Top N
            #     [TrainTrialSpec.max_parallel_trial_count]
            #     search trials will be trained for every M
            #     [TrainTrialSpec.frequency] trials searched.
            class TrainTrialSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The available types of multi-trial algorithms.
            module MultiTrialAlgorithm
              # Defaults to `REINFORCEMENT_LEARNING`.
              MULTI_TRIAL_ALGORITHM_UNSPECIFIED = 0

              # The Reinforcement Learning Algorithm for Multi-trial Neural
              # Architecture Search (NAS).
              REINFORCEMENT_LEARNING = 1

              # The Grid Search Algorithm for Multi-trial Neural
              # Architecture Search (NAS).
              GRID_SEARCH = 2
            end
          end
        end

        # Represents a uCAIP NasJob output.
        # @!attribute [r] multi_trial_job_output
        #   @return [::Google::Cloud::AIPlatform::V1::NasJobOutput::MultiTrialJobOutput]
        #     Output only. The output of this multi-trial Neural Architecture Search
        #     (NAS) job.
        class NasJobOutput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The output of a multi-trial Neural Architecture Search (NAS) jobs.
          # @!attribute [r] search_trials
          #   @return [::Array<::Google::Cloud::AIPlatform::V1::NasTrial>]
          #     Output only. List of NasTrials that were started as part of search stage.
          # @!attribute [r] train_trials
          #   @return [::Array<::Google::Cloud::AIPlatform::V1::NasTrial>]
          #     Output only. List of NasTrials that were started as part of train stage.
          class MultiTrialJobOutput
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents a uCAIP NasJob trial.
        # @!attribute [r] id
        #   @return [::String]
        #     Output only. The identifier of the NasTrial assigned by the service.
        # @!attribute [r] state
        #   @return [::Google::Cloud::AIPlatform::V1::NasTrial::State]
        #     Output only. The detailed state of the NasTrial.
        # @!attribute [r] final_measurement
        #   @return [::Google::Cloud::AIPlatform::V1::Measurement]
        #     Output only. The final measurement containing the objective value.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the NasTrial was started.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the NasTrial's status changed to `SUCCEEDED` or
        #     `INFEASIBLE`.
        class NasTrial
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes a NasTrial state.
          module State
            # The NasTrial state is unspecified.
            STATE_UNSPECIFIED = 0

            # Indicates that a specific NasTrial has been requested, but it has not yet
            # been suggested by the service.
            REQUESTED = 1

            # Indicates that the NasTrial has been suggested.
            ACTIVE = 2

            # Indicates that the NasTrial should stop according to the service.
            STOPPING = 3

            # Indicates that the NasTrial is completed successfully.
            SUCCEEDED = 4

            # Indicates that the NasTrial should not be attempted again.
            # The service will set a NasTrial to INFEASIBLE when it's done but missing
            # the final_measurement.
            INFEASIBLE = 5
          end
        end
      end
    end
  end
end
