# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#upload_model ModelService.UploadModel}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location into which to upload the Model.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] parent_model
        #   @return [::String]
        #     Optional. The resource name of the model into which to upload the version.
        #     Only specify this field when uploading a new version.
        # @!attribute [rw] model_id
        #   @return [::String]
        #     Optional. The ID to use for the uploaded Model, which will become the final
        #     component of the model resource name.
        #
        #     This value may be up to 63 characters, and valid characters are
        #     `[a-z0-9_-]`. The first character cannot be a number or hyphen.
        # @!attribute [rw] model
        #   @return [::Google::Cloud::AIPlatform::V1::Model]
        #     Required. The Model to create.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. The user-provided custom service account to use to do the model
        #     upload. If empty, [Vertex AI Service
        #     Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
        #     will be used to access resources needed to upload the model. This account
        #     must belong to the target project where the model is uploaded to, i.e., the
        #     project specified in the `parent` field of this request and have necessary
        #     read permissions (to Google Cloud Storage, Artifact Registry, etc.).
        class UploadModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#upload_model ModelService.UploadModel}
        # operation.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     The common part of the operation metadata.
        class UploadModelOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message of
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#upload_model ModelService.UploadModel}
        # operation.
        # @!attribute [rw] model
        #   @return [::String]
        #     The name of the uploaded Model resource.
        #     Format: `projects/{project}/locations/{location}/models/{model}`
        # @!attribute [r] model_version_id
        #   @return [::String]
        #     Output only. The version ID of the model that is uploaded.
        class UploadModelResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#get_model ModelService.GetModel}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Model resource.
        #     Format: `projects/{project}/locations/{location}/models/{model}`
        #
        #     In order to retrieve a specific version of the model, also provide
        #     the version ID or version alias.
        #       Example: `projects/{project}/locations/{location}/models/{model}@2`
        #                  or
        #                `projects/{project}/locations/{location}/models/{model}@golden`
        #     If no version ID or alias is specified, the "default" version will be
        #     returned. The "default" version alias is created for the first version of
        #     the model, and can be moved to other versions later on. There will be
        #     exactly one default version.
        class GetModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_models ModelService.ListModels}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to list the Models from.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression for filtering the results of the request. For field names
        #     both snake_case and camelCase are supported.
        #
        #       * `model` supports = and !=. `model` represents the Model ID,
        #         i.e. the last segment of the Model's [resource
        #         name][google.cloud.aiplatform.v1.Model.name].
        #       * `display_name` supports = and !=
        #       * `labels` supports general map functions that is:
        #         * `labels.key=value` - key:value equality
        #         * `labels.key:* or labels:key - key existence
        #         * A key including a space must be quoted. `labels."a key"`.
        #       * `base_model_name` only supports =
        #
        #     Some examples:
        #
        #       * `model=1234`
        #       * `displayName="myDisplayName"`
        #       * `labels.myKey="myValue"`
        #       * `baseModelName="text-bison"`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The standard list page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The standard list page token.
        #     Typically obtained via
        #     {::Google::Cloud::AIPlatform::V1::ListModelsResponse#next_page_token ListModelsResponse.next_page_token}
        #     of the previous
        #     {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_models ModelService.ListModels}
        #     call.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        #     Supported fields:
        #
        #       * `display_name`
        #       * `create_time`
        #       * `update_time`
        #
        #     Example: `display_name, create_time desc`.
        class ListModelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_models ModelService.ListModels}
        # @!attribute [rw] models
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Model>]
        #     List of Models in the requested page.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve next page of results.
        #     Pass to
        #     {::Google::Cloud::AIPlatform::V1::ListModelsRequest#page_token ListModelsRequest.page_token}
        #     to obtain that page.
        class ListModelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_versions ModelService.ListModelVersions}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the model to list versions for.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The standard list page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The standard list page token.
        #     Typically obtained via
        #     {::Google::Cloud::AIPlatform::V1::ListModelVersionsResponse#next_page_token next_page_token}
        #     of the previous
        #     {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_versions ListModelVersions}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression for filtering the results of the request. For field names
        #     both snake_case and camelCase are supported.
        #
        #       * `labels` supports general map functions that is:
        #         * `labels.key=value` - key:value equality
        #         * `labels.key:* or labels:key - key existence
        #         * A key including a space must be quoted. `labels."a key"`.
        #
        #     Some examples:
        #
        #       * `labels.myKey="myValue"`
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        #     Supported fields:
        #
        #       * `create_time`
        #       * `update_time`
        #
        #     Example: `update_time asc, create_time desc`.
        class ListModelVersionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_versions ModelService.ListModelVersions}
        # @!attribute [rw] models
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Model>]
        #     List of Model versions in the requested page.
        #     In the returned Model name field, version ID instead of regvision tag will
        #     be included.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        #     Pass to
        #     {::Google::Cloud::AIPlatform::V1::ListModelVersionsRequest#page_token ListModelVersionsRequest.page_token}
        #     to obtain that page.
        class ListModelVersionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_version_checkpoints ModelService.ListModelVersionCheckpoints}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the model version to list checkpoints for.
        #     `projects/{project}/locations/{location}/models/{model}@{version}`
        #     Example: `projects/{project}/locations/{location}/models/{model}@2`
        #     or
        #     `projects/{project}/locations/{location}/models/{model}@golden`
        #     If no version ID or alias is specified, the latest version will be
        #     used.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The standard list page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The standard list page token.
        #     Typically obtained via
        #     {::Google::Cloud::AIPlatform::V1::ListModelVersionCheckpointsResponse#next_page_token next_page_token}
        #     of the previous
        #     {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_version_checkpoints ListModelVersionCheckpoints}
        #     call.
        class ListModelVersionCheckpointsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A proto representation of a Spanner-stored ModelVersionCheckpoint.
        # The meaning of the fields is equivalent to their in-Spanner counterparts.
        # @!attribute [rw] checkpoint_id
        #   @return [::String]
        #     The ID of the checkpoint.
        # @!attribute [rw] epoch
        #   @return [::Integer]
        #     The epoch of the checkpoint.
        # @!attribute [rw] step
        #   @return [::Integer]
        #     The step of the checkpoint.
        class ModelVersionCheckpoint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_version_checkpoints ModelService.ListModelVersionCheckpoints}
        # @!attribute [rw] checkpoints
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ModelVersionCheckpoint>]
        #     List of Model Version checkpoints.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        #     Pass to
        #     {::Google::Cloud::AIPlatform::V1::ListModelVersionCheckpointsRequest#page_token ListModelVersionCheckpointsRequest.page_token}
        #     to obtain that page.
        class ListModelVersionCheckpointsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#update_model ModelService.UpdateModel}.
        # @!attribute [rw] model
        #   @return [::Google::Cloud::AIPlatform::V1::Model]
        #     Required. The Model which replaces the resource on the server.
        #     When Model Versioning is enabled, the model.name will be used to determine
        #     whether to update the model or model version.
        #     1. model.name with the @ value, e.g. models/123@1, refers to a version
        #     specific update.
        #     2. model.name without the @ value, e.g. models/123, refers to a model
        #     update.
        #     3. model.name with @-, e.g. models/123@-, refers to a model update.
        #     4. Supported model fields: display_name, description; supported
        #     version-specific fields: version_description. Labels are supported in both
        #     scenarios. Both the model labels and the version labels are merged when a
        #     model is returned. When updating labels, if the request is for
        #     model-specific update, model label gets updated. Otherwise, version labels
        #     get updated.
        #     5. A model name or model version name fields update mismatch will cause a
        #     precondition error.
        #     6. One request cannot update both the model and the version fields. You
        #     must update them separately.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The update mask applies to the resource.
        #     For the `FieldMask` definition, see
        #     {::Google::Protobuf::FieldMask google.protobuf.FieldMask}.
        class UpdateModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#update_explanation_dataset ModelService.UpdateExplanationDataset}.
        # @!attribute [rw] model
        #   @return [::String]
        #     Required. The resource name of the Model to update.
        #     Format: `projects/{project}/locations/{location}/models/{model}`
        # @!attribute [rw] examples
        #   @return [::Google::Cloud::AIPlatform::V1::Examples]
        #     The example config containing the location of the dataset.
        class UpdateExplanationDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Runtime operation information for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#update_explanation_dataset ModelService.UpdateExplanationDataset}.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     The common part of the operation metadata.
        class UpdateExplanationDatasetOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#delete_model ModelService.DeleteModel}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Model resource to be deleted.
        #     Format: `projects/{project}/locations/{location}/models/{model}`
        class DeleteModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#delete_model_version ModelService.DeleteModelVersion}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the model version to be deleted, with a version ID
        #     explicitly included.
        #
        #     Example: `projects/{project}/locations/{location}/models/{model}@1234`
        class DeleteModelVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#merge_version_aliases ModelService.MergeVersionAliases}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the model version to merge aliases, with a version ID
        #     explicitly included.
        #
        #     Example: `projects/{project}/locations/{location}/models/{model}@1234`
        # @!attribute [rw] version_aliases
        #   @return [::Array<::String>]
        #     Required. The set of version aliases to merge.
        #     The alias should be at most 128 characters, and match
        #     `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
        #     Add the `-` prefix to an alias means removing that alias from the version.
        #     `-` is NOT counted in the 128 characters. Example: `-golden` means removing
        #     the `golden` alias from the version.
        #
        #     There is NO ordering in aliases, which means
        #     1) The aliases returned from GetModel API might not have the exactly same
        #     order from this MergeVersionAliases API. 2) Adding and deleting the same
        #     alias in the request is not recommended, and the 2 operations will be
        #     cancelled out.
        class MergeVersionAliasesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#export_model ModelService.ExportModel}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Model to export.
        #     The resource name may contain version id or version alias to specify the
        #     version, if no version is specified, the default version will be exported.
        # @!attribute [rw] output_config
        #   @return [::Google::Cloud::AIPlatform::V1::ExportModelRequest::OutputConfig]
        #     Required. The desired output location and configuration.
        class ExportModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Output configuration for the Model export.
          # @!attribute [rw] export_format_id
          #   @return [::String]
          #     The ID of the format in which the Model must be exported. Each Model
          #     lists the [export formats it
          #     supports][google.cloud.aiplatform.v1.Model.supported_export_formats]. If
          #     no value is provided here, then the first from the list of the Model's
          #     supported formats is used by default.
          # @!attribute [rw] artifact_destination
          #   @return [::Google::Cloud::AIPlatform::V1::GcsDestination]
          #     The Cloud Storage location where the Model artifact is to be
          #     written to. Under the directory given as the destination a new one with
          #     name "`model-export-<model-display-name>-<timestamp-of-export-call>`",
          #     where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
          #     will be created. Inside, the Model and any of its supporting files
          #     will be written.
          #     This field should only be set when the `exportableContent` field of the
          #     [Model.supported_export_formats] object contains `ARTIFACT`.
          # @!attribute [rw] image_destination
          #   @return [::Google::Cloud::AIPlatform::V1::ContainerRegistryDestination]
          #     The Google Container Registry or Artifact Registry uri where the
          #     Model container image will be copied to.
          #     This field should only be set when the `exportableContent` field of the
          #     [Model.supported_export_formats] object contains `IMAGE`.
          class OutputConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Details of
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#export_model ModelService.ExportModel}
        # operation.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     The common part of the operation metadata.
        # @!attribute [r] output_info
        #   @return [::Google::Cloud::AIPlatform::V1::ExportModelOperationMetadata::OutputInfo]
        #     Output only. Information further describing the output of this Model
        #     export.
        class ExportModelOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Further describes the output of the ExportModel. Supplements
          # {::Google::Cloud::AIPlatform::V1::ExportModelRequest::OutputConfig ExportModelRequest.OutputConfig}.
          # @!attribute [r] artifact_output_uri
          #   @return [::String]
          #     Output only. If the Model artifact is being exported to Google Cloud
          #     Storage this is the full path of the directory created, into which the
          #     Model files are being written to.
          # @!attribute [r] image_output_uri
          #   @return [::String]
          #     Output only. If the Model image is being exported to Google Container
          #     Registry or Artifact Registry this is the full path of the image created.
          class OutputInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message of
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#update_explanation_dataset ModelService.UpdateExplanationDataset}
        # operation.
        class UpdateExplanationDatasetResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message of
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#export_model ModelService.ExportModel}
        # operation.
        class ExportModelResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#copy_model ModelService.CopyModel}.
        # @!attribute [rw] model_id
        #   @return [::String]
        #     Optional. Copy source_model into a new Model with this ID. The ID will
        #     become the final component of the model resource name.
        #
        #     This value may be up to 63 characters, and valid characters are
        #     `[a-z0-9_-]`. The first character cannot be a number or hyphen.
        #
        #     Note: The following fields are mutually exclusive: `model_id`, `parent_model`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent_model
        #   @return [::String]
        #     Optional. Specify this field to copy source_model into this existing
        #     Model as a new version. Format:
        #     `projects/{project}/locations/{location}/models/{model}`
        #
        #     Note: The following fields are mutually exclusive: `parent_model`, `model_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location into which to copy the Model.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] source_model
        #   @return [::String]
        #     Required. The resource name of the Model to copy. That Model must be in the
        #     same Project. Format:
        #     `projects/{project}/locations/{location}/models/{model}`
        # @!attribute [rw] encryption_spec
        #   @return [::Google::Cloud::AIPlatform::V1::EncryptionSpec]
        #     Customer-managed encryption key options. If this is set,
        #     then the Model copy will be encrypted with the provided encryption key.
        class CopyModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#copy_model ModelService.CopyModel}
        # operation.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     The common part of the operation metadata.
        class CopyModelOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message of
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#copy_model ModelService.CopyModel}
        # operation.
        # @!attribute [rw] model
        #   @return [::String]
        #     The name of the copied Model resource.
        #     Format: `projects/{project}/locations/{location}/models/{model}`
        # @!attribute [r] model_version_id
        #   @return [::String]
        #     Output only. The version ID of the model that is copied.
        class CopyModelResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#import_model_evaluation ModelService.ImportModelEvaluation}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent model resource.
        #     Format: `projects/{project}/locations/{location}/models/{model}`
        # @!attribute [rw] model_evaluation
        #   @return [::Google::Cloud::AIPlatform::V1::ModelEvaluation]
        #     Required. Model evaluation resource to be imported.
        class ImportModelEvaluationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#batch_import_model_evaluation_slices ModelService.BatchImportModelEvaluationSlices}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent ModelEvaluation resource.
        #     Format:
        #     `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}`
        # @!attribute [rw] model_evaluation_slices
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ModelEvaluationSlice>]
        #     Required. Model evaluation slice resource to be imported.
        class BatchImportModelEvaluationSlicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#batch_import_model_evaluation_slices ModelService.BatchImportModelEvaluationSlices}
        # @!attribute [r] imported_model_evaluation_slices
        #   @return [::Array<::String>]
        #     Output only. List of imported
        #     {::Google::Cloud::AIPlatform::V1::ModelEvaluationSlice#name ModelEvaluationSlice.name}.
        class BatchImportModelEvaluationSlicesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#batch_import_evaluated_annotations ModelService.BatchImportEvaluatedAnnotations}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent ModelEvaluationSlice resource.
        #     Format:
        #     `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}/slices/{slice}`
        # @!attribute [rw] evaluated_annotations
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::EvaluatedAnnotation>]
        #     Required. Evaluated annotations resource to be imported.
        class BatchImportEvaluatedAnnotationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#batch_import_evaluated_annotations ModelService.BatchImportEvaluatedAnnotations}
        # @!attribute [r] imported_evaluated_annotations_count
        #   @return [::Integer]
        #     Output only. Number of EvaluatedAnnotations imported.
        class BatchImportEvaluatedAnnotationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#get_model_evaluation ModelService.GetModelEvaluation}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the ModelEvaluation resource.
        #     Format:
        #     `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}`
        class GetModelEvaluationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_evaluations ModelService.ListModelEvaluations}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Model to list the ModelEvaluations from.
        #     Format: `projects/{project}/locations/{location}/models/{model}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     The standard list filter.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The standard list page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The standard list page token.
        #     Typically obtained via
        #     {::Google::Cloud::AIPlatform::V1::ListModelEvaluationsResponse#next_page_token ListModelEvaluationsResponse.next_page_token}
        #     of the previous
        #     {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_evaluations ModelService.ListModelEvaluations}
        #     call.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        class ListModelEvaluationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_evaluations ModelService.ListModelEvaluations}.
        # @!attribute [rw] model_evaluations
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ModelEvaluation>]
        #     List of ModelEvaluations in the requested page.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve next page of results.
        #     Pass to
        #     {::Google::Cloud::AIPlatform::V1::ListModelEvaluationsRequest#page_token ListModelEvaluationsRequest.page_token}
        #     to obtain that page.
        class ListModelEvaluationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#get_model_evaluation_slice ModelService.GetModelEvaluationSlice}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the ModelEvaluationSlice resource.
        #     Format:
        #     `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}/slices/{slice}`
        class GetModelEvaluationSliceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_evaluation_slices ModelService.ListModelEvaluationSlices}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the ModelEvaluation to list the
        #     ModelEvaluationSlices from. Format:
        #     `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     The standard list filter.
        #
        #       * `slice.dimension` - for =.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The standard list page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The standard list page token.
        #     Typically obtained via
        #     {::Google::Cloud::AIPlatform::V1::ListModelEvaluationSlicesResponse#next_page_token ListModelEvaluationSlicesResponse.next_page_token}
        #     of the previous
        #     {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_evaluation_slices ModelService.ListModelEvaluationSlices}
        #     call.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        class ListModelEvaluationSlicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_evaluation_slices ModelService.ListModelEvaluationSlices}.
        # @!attribute [rw] model_evaluation_slices
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ModelEvaluationSlice>]
        #     List of ModelEvaluations in the requested page.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve next page of results.
        #     Pass to
        #     {::Google::Cloud::AIPlatform::V1::ListModelEvaluationSlicesRequest#page_token ListModelEvaluationSlicesRequest.page_token}
        #     to obtain that page.
        class ListModelEvaluationSlicesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
