# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # A trained machine learning Model.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the Model.
        # @!attribute [r] version_id
        #   @return [::String]
        #     Output only. Immutable. The version ID of the model.
        #     A new version is committed when a new model version is uploaded or
        #     trained under an existing model id. It is an auto-incrementing decimal
        #     number in string representation.
        # @!attribute [rw] version_aliases
        #   @return [::Array<::String>]
        #     User provided version aliases so that a model version can be referenced via
        #     alias (i.e.
        #     `projects/{project}/locations/{location}/models/{model_id}@{version_alias}`
        #     instead of auto-generated version id (i.e.
        #     `projects/{project}/locations/{location}/models/{model_id}@{version_id})`.
        #     The format is [a-z][a-zA-Z0-9-]\\{0,126}[a-z0-9] to distinguish from
        #     version_id. A default version alias will be created for the first version
        #     of the model, and there must be exactly one default version alias for a
        #     model.
        # @!attribute [r] version_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this version was created.
        # @!attribute [r] version_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this version was most recently updated.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the Model.
        #     The name can be up to 128 characters long and can consist of any UTF-8
        #     characters.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description of the Model.
        # @!attribute [rw] version_description
        #   @return [::String]
        #     The description of this version.
        # @!attribute [rw] default_checkpoint_id
        #   @return [::String]
        #     The default checkpoint id of a model version.
        # @!attribute [rw] predict_schemata
        #   @return [::Google::Cloud::AIPlatform::V1::PredictSchemata]
        #     The schemata that describe formats of the Model's predictions and
        #     explanations as given and returned via
        #     {::Google::Cloud::AIPlatform::V1::PredictionService::Client#predict PredictionService.Predict}
        #     and
        #     {::Google::Cloud::AIPlatform::V1::PredictionService::Client#explain PredictionService.Explain}.
        # @!attribute [rw] metadata_schema_uri
        #   @return [::String]
        #     Immutable. Points to a YAML file stored on Google Cloud Storage describing
        #     additional information about the Model, that is specific to it. Unset if
        #     the Model does not have any additional information. The schema is defined
        #     as an OpenAPI 3.0.2 [Schema
        #     Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
        #     AutoML Models always have this field populated by Vertex AI, if no
        #     additional metadata is needed, this field is set to an empty string.
        #     Note: The URI given on output will be immutable and probably different,
        #     including the URI scheme, than the one given on input. The output URI will
        #     point to a location where the user only has a read access.
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Value]
        #     Immutable. An additional information about the Model; the schema of the
        #     metadata can be found in
        #     {::Google::Cloud::AIPlatform::V1::Model#metadata_schema_uri metadata_schema}.
        #     Unset if the Model does not have any additional information.
        # @!attribute [r] supported_export_formats
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Model::ExportFormat>]
        #     Output only. The formats in which this Model may be exported. If empty,
        #     this Model is not available for export.
        # @!attribute [r] training_pipeline
        #   @return [::String]
        #     Output only. The resource name of the TrainingPipeline that uploaded this
        #     Model, if any.
        # @!attribute [rw] pipeline_job
        #   @return [::String]
        #     Optional. This field is populated if the model is produced by a pipeline
        #     job.
        # @!attribute [rw] container_spec
        #   @return [::Google::Cloud::AIPlatform::V1::ModelContainerSpec]
        #     Input only. The specification of the container that is to be used when
        #     deploying this Model. The specification is ingested upon
        #     {::Google::Cloud::AIPlatform::V1::ModelService::Client#upload_model ModelService.UploadModel},
        #     and all binaries it contains are copied and stored internally by Vertex AI.
        #     Not required for AutoML Models.
        # @!attribute [rw] artifact_uri
        #   @return [::String]
        #     Immutable. The path to the directory containing the Model artifact and any
        #     of its supporting files. Not required for AutoML Models.
        # @!attribute [r] supported_deployment_resources_types
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Model::DeploymentResourcesType>]
        #     Output only. When this Model is deployed, its prediction resources are
        #     described by the `prediction_resources` field of the
        #     {::Google::Cloud::AIPlatform::V1::Endpoint#deployed_models Endpoint.deployed_models}
        #     object. Because not all Models support all resource configuration types,
        #     the configuration types this Model supports are listed here. If no
        #     configuration types are listed, the Model cannot be deployed to an
        #     {::Google::Cloud::AIPlatform::V1::Endpoint Endpoint} and does not support
        #     online predictions
        #     ({::Google::Cloud::AIPlatform::V1::PredictionService::Client#predict PredictionService.Predict}
        #     or
        #     {::Google::Cloud::AIPlatform::V1::PredictionService::Client#explain PredictionService.Explain}).
        #     Such a Model can serve predictions by using a
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob BatchPredictionJob}, if it
        #     has at least one entry each in
        #     {::Google::Cloud::AIPlatform::V1::Model#supported_input_storage_formats supported_input_storage_formats}
        #     and
        #     {::Google::Cloud::AIPlatform::V1::Model#supported_output_storage_formats supported_output_storage_formats}.
        # @!attribute [r] supported_input_storage_formats
        #   @return [::Array<::String>]
        #     Output only. The formats this Model supports in
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob#input_config BatchPredictionJob.input_config}.
        #     If
        #     {::Google::Cloud::AIPlatform::V1::PredictSchemata#instance_schema_uri PredictSchemata.instance_schema_uri}
        #     exists, the instances should be given as per that schema.
        #
        #     The possible formats are:
        #
        #     * `jsonl`
        #     The JSON Lines format, where each instance is a single line. Uses
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob::InputConfig#gcs_source GcsSource}.
        #
        #     * `csv`
        #     The CSV format, where each instance is a single comma-separated line.
        #     The first line in the file is the header, containing comma-separated field
        #     names. Uses
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob::InputConfig#gcs_source GcsSource}.
        #
        #     * `tf-record`
        #     The TFRecord format, where each instance is a single record in tfrecord
        #     syntax. Uses
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob::InputConfig#gcs_source GcsSource}.
        #
        #     * `tf-record-gzip`
        #     Similar to `tf-record`, but the file is gzipped. Uses
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob::InputConfig#gcs_source GcsSource}.
        #
        #     * `bigquery`
        #     Each instance is a single row in BigQuery. Uses
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob::InputConfig#bigquery_source BigQuerySource}.
        #
        #     * `file-list`
        #     Each line of the file is the location of an instance to process, uses
        #     `gcs_source` field of the
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob::InputConfig InputConfig}
        #     object.
        #
        #
        #     If this Model doesn't support any of these formats it means it cannot be
        #     used with a
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob BatchPredictionJob}.
        #     However, if it has
        #     {::Google::Cloud::AIPlatform::V1::Model#supported_deployment_resources_types supported_deployment_resources_types},
        #     it could serve online predictions by using
        #     {::Google::Cloud::AIPlatform::V1::PredictionService::Client#predict PredictionService.Predict}
        #     or
        #     {::Google::Cloud::AIPlatform::V1::PredictionService::Client#explain PredictionService.Explain}.
        # @!attribute [r] supported_output_storage_formats
        #   @return [::Array<::String>]
        #     Output only. The formats this Model supports in
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob#output_config BatchPredictionJob.output_config}.
        #     If both
        #     {::Google::Cloud::AIPlatform::V1::PredictSchemata#instance_schema_uri PredictSchemata.instance_schema_uri}
        #     and
        #     {::Google::Cloud::AIPlatform::V1::PredictSchemata#prediction_schema_uri PredictSchemata.prediction_schema_uri}
        #     exist, the predictions are returned together with their instances. In other
        #     words, the prediction has the original instance data first, followed by the
        #     actual prediction content (as per the schema).
        #
        #     The possible formats are:
        #
        #     * `jsonl`
        #     The JSON Lines format, where each prediction is a single line. Uses
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob::OutputConfig#gcs_destination GcsDestination}.
        #
        #     * `csv`
        #     The CSV format, where each prediction is a single comma-separated line.
        #     The first line in the file is the header, containing comma-separated field
        #     names. Uses
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob::OutputConfig#gcs_destination GcsDestination}.
        #
        #     * `bigquery`
        #     Each prediction is a single row in a BigQuery table, uses
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob::OutputConfig#bigquery_destination BigQueryDestination}
        #     .
        #
        #
        #     If this Model doesn't support any of these formats it means it cannot be
        #     used with a
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob BatchPredictionJob}.
        #     However, if it has
        #     {::Google::Cloud::AIPlatform::V1::Model#supported_deployment_resources_types supported_deployment_resources_types},
        #     it could serve online predictions by using
        #     {::Google::Cloud::AIPlatform::V1::PredictionService::Client#predict PredictionService.Predict}
        #     or
        #     {::Google::Cloud::AIPlatform::V1::PredictionService::Client#explain PredictionService.Explain}.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this Model was uploaded into Vertex AI.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this Model was most recently updated.
        # @!attribute [r] deployed_models
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::DeployedModelRef>]
        #     Output only. The pointers to DeployedModels created from this Model. Note
        #     that Model could have been deployed to Endpoints in different Locations.
        # @!attribute [rw] explanation_spec
        #   @return [::Google::Cloud::AIPlatform::V1::ExplanationSpec]
        #     The default explanation specification for this Model.
        #
        #     The Model can be used for
        #     [requesting
        #     explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
        #     being {::Google::Cloud::AIPlatform::V1::EndpointService::Client#deploy_model deployed} if
        #     it is populated. The Model can be used for [batch
        #     explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
        #     if it is populated.
        #
        #     All fields of the explanation_spec can be overridden by
        #     {::Google::Cloud::AIPlatform::V1::DeployedModel#explanation_spec explanation_spec}
        #     of
        #     {::Google::Cloud::AIPlatform::V1::DeployModelRequest#deployed_model DeployModelRequest.deployed_model},
        #     or
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob#explanation_spec explanation_spec}
        #     of {::Google::Cloud::AIPlatform::V1::BatchPredictionJob BatchPredictionJob}.
        #
        #     If the default explanation specification is not set for this Model, this
        #     Model can still be used for
        #     [requesting
        #     explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
        #     setting
        #     {::Google::Cloud::AIPlatform::V1::DeployedModel#explanation_spec explanation_spec}
        #     of
        #     {::Google::Cloud::AIPlatform::V1::DeployModelRequest#deployed_model DeployModelRequest.deployed_model}
        #     and for [batch
        #     explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
        #     by setting
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob#explanation_spec explanation_spec}
        #     of {::Google::Cloud::AIPlatform::V1::BatchPredictionJob BatchPredictionJob}.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Used to perform consistent read-modify-write updates. If not set, a blind
        #     "overwrite" update happens.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels with user-defined metadata to organize your Models.
        #
        #     Label keys and values can be no longer than 64 characters
        #     (Unicode codepoints), can only contain lowercase letters, numeric
        #     characters, underscores and dashes. International characters are allowed.
        #
        #     See https://goo.gl/xmQnxf for more information and examples of labels.
        # @!attribute [rw] data_stats
        #   @return [::Google::Cloud::AIPlatform::V1::Model::DataStats]
        #     Stats of data used for training or evaluating the Model.
        #
        #     Only populated when the Model is trained by a TrainingPipeline with
        #     {::Google::Cloud::AIPlatform::V1::TrainingPipeline#input_data_config data_input_config}.
        # @!attribute [rw] encryption_spec
        #   @return [::Google::Cloud::AIPlatform::V1::EncryptionSpec]
        #     Customer-managed encryption key spec for a Model. If set, this
        #     Model and all sub-resources of this Model will be secured by this key.
        # @!attribute [r] model_source_info
        #   @return [::Google::Cloud::AIPlatform::V1::ModelSourceInfo]
        #     Output only. Source of a model. It can either be automl training pipeline,
        #     custom training pipeline, BigQuery ML, or saved and tuned from Genie or
        #     Model Garden.
        # @!attribute [r] original_model_info
        #   @return [::Google::Cloud::AIPlatform::V1::Model::OriginalModelInfo]
        #     Output only. If this Model is a copy of another Model, this contains info
        #     about the original.
        # @!attribute [r] metadata_artifact
        #   @return [::String]
        #     Output only. The resource name of the Artifact that was created in
        #     MetadataStore when creating the Model. The Artifact resource name pattern
        #     is
        #     `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
        # @!attribute [rw] base_model_source
        #   @return [::Google::Cloud::AIPlatform::V1::Model::BaseModelSource]
        #     Optional. User input field to specify the base model source. Currently it
        #     only supports specifing the Model Garden models and Genie models.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] checkpoints
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Checkpoint>]
        #     Optional. Output only. The checkpoints of the model.
        class Model
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents export format supported by the Model.
          # All formats export to Google Cloud Storage.
          # @!attribute [r] id
          #   @return [::String]
          #     Output only. The ID of the export format.
          #     The possible format IDs are:
          #
          #     * `tflite`
          #     Used for Android mobile devices.
          #
          #     * `edgetpu-tflite`
          #     Used for [Edge TPU](https://cloud.google.com/edge-tpu/) devices.
          #
          #     * `tf-saved-model`
          #     A tensorflow model in SavedModel format.
          #
          #     * `tf-js`
          #     A [TensorFlow.js](https://www.tensorflow.org/js) model that can be used
          #     in the browser and in Node.js using JavaScript.
          #
          #     * `core-ml`
          #     Used for iOS mobile devices.
          #
          #     * `custom-trained`
          #     A Model that was uploaded or trained by custom code.
          # @!attribute [r] exportable_contents
          #   @return [::Array<::Google::Cloud::AIPlatform::V1::Model::ExportFormat::ExportableContent>]
          #     Output only. The content of this Model that may be exported.
          class ExportFormat
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The Model content that can be exported.
            module ExportableContent
              # Should not be used.
              EXPORTABLE_CONTENT_UNSPECIFIED = 0

              # Model artifact and any of its supported files. Will be exported to the
              # location specified by the `artifactDestination` field of the
              # {::Google::Cloud::AIPlatform::V1::ExportModelRequest#output_config ExportModelRequest.output_config}
              # object.
              ARTIFACT = 1

              # The container image that is to be used when deploying this Model. Will
              # be exported to the location specified by the `imageDestination` field
              # of the
              # {::Google::Cloud::AIPlatform::V1::ExportModelRequest#output_config ExportModelRequest.output_config}
              # object.
              IMAGE = 2
            end
          end

          # Stats of data used for train or evaluate the Model.
          # @!attribute [rw] training_data_items_count
          #   @return [::Integer]
          #     Number of DataItems that were used for training this Model.
          # @!attribute [rw] validation_data_items_count
          #   @return [::Integer]
          #     Number of DataItems that were used for validating this Model during
          #     training.
          # @!attribute [rw] test_data_items_count
          #   @return [::Integer]
          #     Number of DataItems that were used for evaluating this Model. If the
          #     Model is evaluated multiple times, this will be the number of test
          #     DataItems used by the first evaluation. If the Model is not evaluated,
          #     the number is 0.
          # @!attribute [rw] training_annotations_count
          #   @return [::Integer]
          #     Number of Annotations that are used for training this Model.
          # @!attribute [rw] validation_annotations_count
          #   @return [::Integer]
          #     Number of Annotations that are used for validating this Model during
          #     training.
          # @!attribute [rw] test_annotations_count
          #   @return [::Integer]
          #     Number of Annotations that are used for evaluating this Model. If the
          #     Model is evaluated multiple times, this will be the number of test
          #     Annotations used by the first evaluation. If the Model is not evaluated,
          #     the number is 0.
          class DataStats
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Contains information about the original Model if this Model is a copy.
          # @!attribute [r] model
          #   @return [::String]
          #     Output only. The resource name of the Model this Model is a copy of,
          #     including the revision. Format:
          #     `projects/{project}/locations/{location}/models/{model_id}@{version_id}`
          class OriginalModelInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # User input field to specify the base model source. Currently it only
          # supports specifing the Model Garden models and Genie models.
          # @!attribute [rw] model_garden_source
          #   @return [::Google::Cloud::AIPlatform::V1::ModelGardenSource]
          #     Source information of Model Garden models.
          #
          #     Note: The following fields are mutually exclusive: `model_garden_source`, `genie_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] genie_source
          #   @return [::Google::Cloud::AIPlatform::V1::GenieSource]
          #     Information about the base model of Genie models.
          #
          #     Note: The following fields are mutually exclusive: `genie_source`, `model_garden_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class BaseModelSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Identifies a type of Model's prediction resources.
          module DeploymentResourcesType
            # Should not be used.
            DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED = 0

            # Resources that are dedicated to the
            # {::Google::Cloud::AIPlatform::V1::DeployedModel DeployedModel}, and that need
            # a higher degree of manual configuration.
            DEDICATED_RESOURCES = 1

            # Resources that to large degree are decided by Vertex AI, and require
            # only a modest additional configuration.
            AUTOMATIC_RESOURCES = 2

            # Resources that can be shared by multiple
            # {::Google::Cloud::AIPlatform::V1::DeployedModel DeployedModels}. A
            # pre-configured
            # {::Google::Cloud::AIPlatform::V1::DeploymentResourcePool DeploymentResourcePool}
            # is required.
            SHARED_RESOURCES = 3
          end
        end

        # Contains information about the Large Model.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The unique name of the large Foundation or pre-built model. Like
        #     "chat-bison", "text-bison". Or model name with version ID, like
        #     "chat-bison@001", "text-bison@005", etc.
        class LargeModelReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains information about the source of the models generated from Model
        # Garden.
        # @!attribute [rw] public_model_name
        #   @return [::String]
        #     Required. The model garden source model resource name.
        # @!attribute [rw] version_id
        #   @return [::String]
        #     Optional. The model garden source model version ID.
        # @!attribute [rw] skip_hf_model_cache
        #   @return [::Boolean]
        #     Optional. Whether to avoid pulling the model from the HF cache.
        class ModelGardenSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains information about the source of the models generated from Generative
        # AI Studio.
        # @!attribute [rw] base_model_uri
        #   @return [::String]
        #     Required. The public base model URI.
        class GenieSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains the schemata used in Model's predictions and explanations via
        # {::Google::Cloud::AIPlatform::V1::PredictionService::Client#predict PredictionService.Predict},
        # {::Google::Cloud::AIPlatform::V1::PredictionService::Client#explain PredictionService.Explain}
        # and {::Google::Cloud::AIPlatform::V1::BatchPredictionJob BatchPredictionJob}.
        # @!attribute [rw] instance_schema_uri
        #   @return [::String]
        #     Immutable. Points to a YAML file stored on Google Cloud Storage describing
        #     the format of a single instance, which are used in
        #     {::Google::Cloud::AIPlatform::V1::PredictRequest#instances PredictRequest.instances},
        #     {::Google::Cloud::AIPlatform::V1::ExplainRequest#instances ExplainRequest.instances}
        #     and
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob#input_config BatchPredictionJob.input_config}.
        #     The schema is defined as an OpenAPI 3.0.2 [Schema
        #     Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
        #     AutoML Models always have this field populated by Vertex AI.
        #     Note: The URI given on output will be immutable and probably different,
        #     including the URI scheme, than the one given on input. The output URI will
        #     point to a location where the user only has a read access.
        # @!attribute [rw] parameters_schema_uri
        #   @return [::String]
        #     Immutable. Points to a YAML file stored on Google Cloud Storage describing
        #     the parameters of prediction and explanation via
        #     {::Google::Cloud::AIPlatform::V1::PredictRequest#parameters PredictRequest.parameters},
        #     {::Google::Cloud::AIPlatform::V1::ExplainRequest#parameters ExplainRequest.parameters}
        #     and
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob#model_parameters BatchPredictionJob.model_parameters}.
        #     The schema is defined as an OpenAPI 3.0.2 [Schema
        #     Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
        #     AutoML Models always have this field populated by Vertex AI, if no
        #     parameters are supported, then it is set to an empty string.
        #     Note: The URI given on output will be immutable and probably different,
        #     including the URI scheme, than the one given on input. The output URI will
        #     point to a location where the user only has a read access.
        # @!attribute [rw] prediction_schema_uri
        #   @return [::String]
        #     Immutable. Points to a YAML file stored on Google Cloud Storage describing
        #     the format of a single prediction produced by this Model, which are
        #     returned via
        #     {::Google::Cloud::AIPlatform::V1::PredictResponse#predictions PredictResponse.predictions},
        #     {::Google::Cloud::AIPlatform::V1::ExplainResponse#explanations ExplainResponse.explanations},
        #     and
        #     {::Google::Cloud::AIPlatform::V1::BatchPredictionJob#output_config BatchPredictionJob.output_config}.
        #     The schema is defined as an OpenAPI 3.0.2 [Schema
        #     Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
        #     AutoML Models always have this field populated by Vertex AI.
        #     Note: The URI given on output will be immutable and probably different,
        #     including the URI scheme, than the one given on input. The output URI will
        #     point to a location where the user only has a read access.
        class PredictSchemata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specification of a container for serving predictions. Some fields in this
        # message correspond to fields in the [Kubernetes Container v1 core
        # specification](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
        # @!attribute [rw] image_uri
        #   @return [::String]
        #     Required. Immutable. URI of the Docker image to be used as the custom
        #     container for serving predictions. This URI must identify an image in
        #     Artifact Registry or Container Registry. Learn more about the [container
        #     publishing
        #     requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
        #     including permissions requirements for the Vertex AI Service Agent.
        #
        #     The container image is ingested upon
        #     {::Google::Cloud::AIPlatform::V1::ModelService::Client#upload_model ModelService.UploadModel},
        #     stored internally, and this original path is afterwards not used.
        #
        #     To learn about the requirements for the Docker image itself, see
        #     [Custom container
        #     requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
        #
        #     You can use the URI to one of Vertex AI's [pre-built container images for
        #     prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
        #     in this field.
        # @!attribute [rw] command
        #   @return [::Array<::String>]
        #     Immutable. Specifies the command that runs when the container starts. This
        #     overrides the container's
        #     [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
        #     Specify this field as an array of executable and arguments, similar to a
        #     Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
        #
        #     If you do not specify this field, then the container's `ENTRYPOINT` runs,
        #     in conjunction with the
        #     {::Google::Cloud::AIPlatform::V1::ModelContainerSpec#args args} field or the
        #     container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
        #     if either exists. If this field is not specified and the container does not
        #     have an `ENTRYPOINT`, then refer to the Docker documentation about [how
        #     `CMD` and `ENTRYPOINT`
        #     interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
        #
        #     If you specify this field, then you can also specify the `args` field to
        #     provide additional arguments for this command. However, if you specify this
        #     field, then the container's `CMD` is ignored. See the
        #     [Kubernetes documentation about how the
        #     `command` and `args` fields interact with a container's `ENTRYPOINT` and
        #     `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
        #
        #     In this field, you can reference [environment variables set by Vertex
        #     AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
        #     and environment variables set in the
        #     {::Google::Cloud::AIPlatform::V1::ModelContainerSpec#env env} field. You cannot
        #     reference environment variables set in the Docker image. In order for
        #     environment variables to be expanded, reference them by using the following
        #     syntax: <code>$(<var>VARIABLE_NAME</var>)</code> Note that this differs
        #     from Bash variable expansion, which does not use parentheses. If a variable
        #     cannot be resolved, the reference in the input string is used unchanged. To
        #     avoid variable expansion, you can escape this syntax with `$$`; for
        #     example: <code>$$(<var>VARIABLE_NAME</var>)</code> This field corresponds
        #     to the `command` field of the Kubernetes Containers [v1 core
        #     API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
        # @!attribute [rw] args
        #   @return [::Array<::String>]
        #     Immutable. Specifies arguments for the command that runs when the container
        #     starts. This overrides the container's
        #     [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
        #     this field as an array of executable and arguments, similar to a Docker
        #     `CMD`'s "default parameters" form.
        #
        #     If you don't specify this field but do specify the
        #     {::Google::Cloud::AIPlatform::V1::ModelContainerSpec#command command} field,
        #     then the command from the `command` field runs without any additional
        #     arguments. See the [Kubernetes documentation about how the `command` and
        #     `args` fields interact with a container's `ENTRYPOINT` and
        #     `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
        #
        #     If you don't specify this field and don't specify the `command` field,
        #     then the container's
        #     [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
        #     `CMD` determine what runs based on their default behavior. See the Docker
        #     documentation about [how `CMD` and `ENTRYPOINT`
        #     interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
        #
        #     In this field, you can reference [environment variables
        #     set by Vertex
        #     AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
        #     and environment variables set in the
        #     {::Google::Cloud::AIPlatform::V1::ModelContainerSpec#env env} field. You cannot
        #     reference environment variables set in the Docker image. In order for
        #     environment variables to be expanded, reference them by using the following
        #     syntax: <code>$(<var>VARIABLE_NAME</var>)</code> Note that this differs
        #     from Bash variable expansion, which does not use parentheses. If a variable
        #     cannot be resolved, the reference in the input string is used unchanged. To
        #     avoid variable expansion, you can escape this syntax with `$$`; for
        #     example: <code>$$(<var>VARIABLE_NAME</var>)</code> This field corresponds
        #     to the `args` field of the Kubernetes Containers [v1 core
        #     API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
        # @!attribute [rw] env
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::EnvVar>]
        #     Immutable. List of environment variables to set in the container. After the
        #     container starts running, code running in the container can read these
        #     environment variables.
        #
        #     Additionally, the
        #     {::Google::Cloud::AIPlatform::V1::ModelContainerSpec#command command} and
        #     {::Google::Cloud::AIPlatform::V1::ModelContainerSpec#args args} fields can
        #     reference these variables. Later entries in this list can also reference
        #     earlier entries. For example, the following example sets the variable
        #     `VAR_2` to have the value `foo bar`:
        #
        #     ```json
        #     [
        #       {
        #         "name": "VAR_1",
        #         "value": "foo"
        #       },
        #       {
        #         "name": "VAR_2",
        #         "value": "$(VAR_1) bar"
        #       }
        #     ]
        #     ```
        #
        #     If you switch the order of the variables in the example, then the expansion
        #     does not occur.
        #
        #     This field corresponds to the `env` field of the Kubernetes Containers
        #     [v1 core
        #     API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
        # @!attribute [rw] ports
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Port>]
        #     Immutable. List of ports to expose from the container. Vertex AI sends any
        #     prediction requests that it receives to the first port on this list. Vertex
        #     AI also sends
        #     [liveness and health
        #     checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
        #     to this port.
        #
        #     If you do not specify this field, it defaults to following value:
        #
        #     ```json
        #     [
        #       {
        #         "containerPort": 8080
        #       }
        #     ]
        #     ```
        #
        #     Vertex AI does not use ports other than the first one listed. This field
        #     corresponds to the `ports` field of the Kubernetes Containers
        #     [v1 core
        #     API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
        # @!attribute [rw] predict_route
        #   @return [::String]
        #     Immutable. HTTP path on the container to send prediction requests to.
        #     Vertex AI forwards requests sent using
        #     {::Google::Cloud::AIPlatform::V1::PredictionService::Client#predict projects.locations.endpoints.predict}
        #     to this path on the container's IP address and port. Vertex AI then returns
        #     the container's response in the API response.
        #
        #     For example, if you set this field to `/foo`, then when Vertex AI
        #     receives a prediction request, it forwards the request body in a POST
        #     request to the `/foo` path on the port of your container specified by the
        #     first value of this `ModelContainerSpec`'s
        #     {::Google::Cloud::AIPlatform::V1::ModelContainerSpec#ports ports} field.
        #
        #     If you don't specify this field, it defaults to the following value when
        #     you [deploy this Model to an
        #     Endpoint][google.cloud.aiplatform.v1.EndpointService.DeployModel]:
        #     <code>/v1/endpoints/<var>ENDPOINT</var>/deployedModels/<var>DEPLOYED_MODEL</var>:predict</code>
        #     The placeholders in this value are replaced as follows:
        #
        #     * <var>ENDPOINT</var>: The last segment (following `endpoints/`)of the
        #       Endpoint.name][] field of the Endpoint where this Model has been
        #       deployed. (Vertex AI makes this value available to your container code
        #       as the [`AIP_ENDPOINT_ID` environment
        #      variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
        #
        #     * <var>DEPLOYED_MODEL</var>:
        #     {::Google::Cloud::AIPlatform::V1::DeployedModel#id DeployedModel.id} of the
        #     `DeployedModel`.
        #       (Vertex AI makes this value available to your container code
        #       as the [`AIP_DEPLOYED_MODEL_ID` environment
        #       variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
        # @!attribute [rw] health_route
        #   @return [::String]
        #     Immutable. HTTP path on the container to send health checks to. Vertex AI
        #     intermittently sends GET requests to this path on the container's IP
        #     address and port to check that the container is healthy. Read more about
        #     [health
        #     checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
        #
        #     For example, if you set this field to `/bar`, then Vertex AI
        #     intermittently sends a GET request to the `/bar` path on the port of your
        #     container specified by the first value of this `ModelContainerSpec`'s
        #     {::Google::Cloud::AIPlatform::V1::ModelContainerSpec#ports ports} field.
        #
        #     If you don't specify this field, it defaults to the following value when
        #     you [deploy this Model to an
        #     Endpoint][google.cloud.aiplatform.v1.EndpointService.DeployModel]:
        #     <code>/v1/endpoints/<var>ENDPOINT</var>/deployedModels/<var>DEPLOYED_MODEL</var>:predict</code>
        #     The placeholders in this value are replaced as follows:
        #
        #     * <var>ENDPOINT</var>: The last segment (following `endpoints/`)of the
        #       Endpoint.name][] field of the Endpoint where this Model has been
        #       deployed. (Vertex AI makes this value available to your container code
        #       as the [`AIP_ENDPOINT_ID` environment
        #       variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
        #
        #     * <var>DEPLOYED_MODEL</var>:
        #     {::Google::Cloud::AIPlatform::V1::DeployedModel#id DeployedModel.id} of the
        #     `DeployedModel`.
        #       (Vertex AI makes this value available to your container code as the
        #       [`AIP_DEPLOYED_MODEL_ID` environment
        #       variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
        # @!attribute [rw] invoke_route_prefix
        #   @return [::String]
        #     Immutable. Invoke route prefix for the custom container. "/*" is the only
        #     supported value right now. By setting this field, any non-root route on
        #     this model will be accessible with invoke http call eg: "/invoke/foo/bar",
        #     however the [PredictionService.Invoke] RPC is not supported yet.
        #
        #     Only one of `predict_route` or `invoke_route_prefix` can be set, and we
        #     default to using `predict_route` if this field is not set. If this field
        #     is set, the Model can only be deployed to dedicated endpoint.
        # @!attribute [rw] grpc_ports
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Port>]
        #     Immutable. List of ports to expose from the container. Vertex AI sends gRPC
        #     prediction requests that it receives to the first port on this list. Vertex
        #     AI also sends liveness and health checks to this port.
        #
        #     If you do not specify this field, gRPC requests to the container will be
        #     disabled.
        #
        #     Vertex AI does not use ports other than the first one listed. This field
        #     corresponds to the `ports` field of the Kubernetes Containers v1 core API.
        # @!attribute [rw] deployment_timeout
        #   @return [::Google::Protobuf::Duration]
        #     Immutable. Deployment timeout.
        #     Limit for deployment timeout is 2 hours.
        # @!attribute [rw] shared_memory_size_mb
        #   @return [::Integer]
        #     Immutable. The amount of the VM memory to reserve as the shared memory for
        #     the model in megabytes.
        # @!attribute [rw] startup_probe
        #   @return [::Google::Cloud::AIPlatform::V1::Probe]
        #     Immutable. Specification for Kubernetes startup probe.
        # @!attribute [rw] health_probe
        #   @return [::Google::Cloud::AIPlatform::V1::Probe]
        #     Immutable. Specification for Kubernetes readiness probe.
        # @!attribute [rw] liveness_probe
        #   @return [::Google::Cloud::AIPlatform::V1::Probe]
        #     Immutable. Specification for Kubernetes liveness probe.
        class ModelContainerSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a network port in a container.
        # @!attribute [rw] container_port
        #   @return [::Integer]
        #     The number of the port to expose on the pod's IP address.
        #     Must be a valid port number, between 1 and 65535 inclusive.
        class Port
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Detail description of the source information of the model.
        # @!attribute [rw] source_type
        #   @return [::Google::Cloud::AIPlatform::V1::ModelSourceInfo::ModelSourceType]
        #     Type of the model source.
        # @!attribute [rw] copy
        #   @return [::Boolean]
        #     If this Model is copy of another Model. If true then
        #     {::Google::Cloud::AIPlatform::V1::ModelSourceInfo#source_type source_type}
        #     pertains to the original.
        class ModelSourceInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Source of the model.
          # Different from `objective` field, this `ModelSourceType` enum
          # indicates the source from which the model was accessed or obtained,
          # whereas the `objective` indicates the overall aim or function of this
          # model.
          module ModelSourceType
            # Should not be used.
            MODEL_SOURCE_TYPE_UNSPECIFIED = 0

            # The Model is uploaded by automl training pipeline.
            AUTOML = 1

            # The Model is uploaded by user or custom training pipeline.
            CUSTOM = 2

            # The Model is registered and sync'ed from BigQuery ML.
            BQML = 3

            # The Model is saved or tuned from Model Garden.
            MODEL_GARDEN = 4

            # The Model is saved or tuned from Genie.
            GENIE = 5

            # The Model is uploaded by text embedding finetuning pipeline.
            CUSTOM_TEXT_EMBEDDING = 6

            # The Model is saved or tuned from Marketplace.
            MARKETPLACE = 7
          end
        end

        # Probe describes a health check to be performed against a container to
        # determine whether it is alive or ready to receive traffic.
        # @!attribute [rw] exec
        #   @return [::Google::Cloud::AIPlatform::V1::Probe::ExecAction]
        #     ExecAction probes the health of a container by executing a command.
        #
        #     Note: The following fields are mutually exclusive: `exec`, `http_get`, `grpc`, `tcp_socket`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] http_get
        #   @return [::Google::Cloud::AIPlatform::V1::Probe::HttpGetAction]
        #     HttpGetAction probes the health of a container by sending an HTTP GET
        #     request.
        #
        #     Note: The following fields are mutually exclusive: `http_get`, `exec`, `grpc`, `tcp_socket`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] grpc
        #   @return [::Google::Cloud::AIPlatform::V1::Probe::GrpcAction]
        #     GrpcAction probes the health of a container by sending a gRPC request.
        #
        #     Note: The following fields are mutually exclusive: `grpc`, `exec`, `http_get`, `tcp_socket`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tcp_socket
        #   @return [::Google::Cloud::AIPlatform::V1::Probe::TcpSocketAction]
        #     TcpSocketAction probes the health of a container by opening a TCP socket
        #     connection.
        #
        #     Note: The following fields are mutually exclusive: `tcp_socket`, `exec`, `http_get`, `grpc`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] period_seconds
        #   @return [::Integer]
        #     How often (in seconds) to perform the probe. Default to 10 seconds.
        #     Minimum value is 1. Must be less than timeout_seconds.
        #
        #     Maps to Kubernetes probe argument 'periodSeconds'.
        # @!attribute [rw] timeout_seconds
        #   @return [::Integer]
        #     Number of seconds after which the probe times out. Defaults to 1 second.
        #     Minimum value is 1. Must be greater or equal to period_seconds.
        #
        #     Maps to Kubernetes probe argument 'timeoutSeconds'.
        # @!attribute [rw] failure_threshold
        #   @return [::Integer]
        #     Number of consecutive failures before the probe is considered failed.
        #     Defaults to 3. Minimum value is 1.
        #
        #     Maps to Kubernetes probe argument 'failureThreshold'.
        # @!attribute [rw] success_threshold
        #   @return [::Integer]
        #     Number of consecutive successes before the probe is considered successful.
        #     Defaults to 1. Minimum value is 1.
        #
        #     Maps to Kubernetes probe argument 'successThreshold'.
        # @!attribute [rw] initial_delay_seconds
        #   @return [::Integer]
        #     Number of seconds to wait before starting the probe. Defaults to 0.
        #     Minimum value is 0.
        #
        #     Maps to Kubernetes probe argument 'initialDelaySeconds'.
        class Probe
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # ExecAction specifies a command to execute.
          # @!attribute [rw] command
          #   @return [::Array<::String>]
          #     Command is the command line to execute inside the container, the working
          #     directory for the command is root ('/') in the container's filesystem.
          #     The command is simply exec'd, it is not run inside a shell, so
          #     traditional shell instructions ('|', etc) won't work. To use a shell, you
          #     need to explicitly call out to that shell. Exit status of 0 is treated as
          #     live/healthy and non-zero is unhealthy.
          class ExecAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # HttpGetAction describes an action based on HTTP Get requests.
          # @!attribute [rw] path
          #   @return [::String]
          #     Path to access on the HTTP server.
          # @!attribute [rw] port
          #   @return [::Integer]
          #     Number of the port to access on the container.
          #     Number must be in the range 1 to 65535.
          # @!attribute [rw] host
          #   @return [::String]
          #     Host name to connect to, defaults to the model serving container's IP.
          #     You probably want to set "Host" in httpHeaders instead.
          # @!attribute [rw] scheme
          #   @return [::String]
          #     Scheme to use for connecting to the host.
          #     Defaults to HTTP. Acceptable values are "HTTP" or "HTTPS".
          # @!attribute [rw] http_headers
          #   @return [::Array<::Google::Cloud::AIPlatform::V1::Probe::HttpHeader>]
          #     Custom headers to set in the request. HTTP allows repeated headers.
          class HttpGetAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # GrpcAction checks the health of a container using a gRPC service.
          # @!attribute [rw] port
          #   @return [::Integer]
          #     Port number of the gRPC service. Number must be in the range 1 to 65535.
          # @!attribute [rw] service
          #   @return [::String]
          #     Service is the name of the service to place in the gRPC
          #     HealthCheckRequest (see
          #     https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
          #
          #     If this is not specified, the default behavior is defined by gRPC.
          class GrpcAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # TcpSocketAction probes the health of a container by opening a TCP socket
          # connection.
          # @!attribute [rw] port
          #   @return [::Integer]
          #     Number of the port to access on the container.
          #     Number must be in the range 1 to 65535.
          # @!attribute [rw] host
          #   @return [::String]
          #     Optional: Host name to connect to, defaults to the model serving
          #     container's IP.
          class TcpSocketAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # HttpHeader describes a custom header to be used in HTTP probes
          # @!attribute [rw] name
          #   @return [::String]
          #     The header field name.
          #     This will be canonicalized upon output, so case-variant names will be
          #     understood as the same header.
          # @!attribute [rw] value
          #   @return [::String]
          #     The header field value
          class HttpHeader
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Describes the machine learning model version checkpoint.
        # @!attribute [rw] checkpoint_id
        #   @return [::String]
        #     The ID of the checkpoint.
        # @!attribute [rw] epoch
        #   @return [::Integer]
        #     The epoch of the checkpoint.
        # @!attribute [rw] step
        #   @return [::Integer]
        #     The step of the checkpoint.
        class Checkpoint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
