# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Instance of a metadata store. Contains a set of metadata that can be
        # queried.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the MetadataStore instance.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this MetadataStore was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this MetadataStore was last updated.
        # @!attribute [rw] encryption_spec
        #   @return [::Google::Cloud::AIPlatform::V1::EncryptionSpec]
        #     Customer-managed encryption key spec for a Metadata Store. If set, this
        #     Metadata Store and all sub-resources of this Metadata Store are secured
        #     using this key.
        # @!attribute [rw] description
        #   @return [::String]
        #     Description of the MetadataStore.
        # @!attribute [r] state
        #   @return [::Google::Cloud::AIPlatform::V1::MetadataStore::MetadataStoreState]
        #     Output only. State information of the MetadataStore.
        # @!attribute [rw] dataplex_config
        #   @return [::Google::Cloud::AIPlatform::V1::MetadataStore::DataplexConfig]
        #     Optional. Dataplex integration settings.
        class MetadataStore
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents state information for a MetadataStore.
          # @!attribute [rw] disk_utilization_bytes
          #   @return [::Integer]
          #     The disk utilization of the MetadataStore in bytes.
          class MetadataStoreState
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents Dataplex integration settings.
          # @!attribute [rw] enabled_pipelines_lineage
          #   @return [::Boolean]
          #     Optional. Whether or not Data Lineage synchronization is enabled for
          #     Vertex Pipelines.
          class DataplexConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
