# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#create_metadata_store MetadataService.CreateMetadataStore}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location where the MetadataStore should
        #     be created.
        #     Format: `projects/{project}/locations/{location}/`
        # @!attribute [rw] metadata_store
        #   @return [::Google::Cloud::AIPlatform::V1::MetadataStore]
        #     Required. The MetadataStore to create.
        # @!attribute [rw] metadata_store_id
        #   @return [::String]
        #     The \\{metadatastore} portion of the resource name with the format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
        #     If not provided, the MetadataStore's ID will be a UUID generated by the
        #     service.
        #     Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
        #     Must be unique across all MetadataStores in the parent Location.
        #     (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
        #     if the caller can't view the preexisting MetadataStore.)
        class CreateMetadataStoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#create_metadata_store MetadataService.CreateMetadataStore}.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for creating a MetadataStore.
        class CreateMetadataStoreOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#get_metadata_store MetadataService.GetMetadataStore}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the MetadataStore to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
        class GetMetadataStoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_metadata_stores MetadataService.ListMetadataStores}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Location whose MetadataStores should be listed.
        #     Format:
        #     `projects/{project}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of Metadata Stores to return. The service may return
        #     fewer.
        #     Must be in range 1-1000, inclusive. Defaults to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_metadata_stores MetadataService.ListMetadataStores}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other provided parameters must match the call that
        #     provided the page token. (Otherwise the request will fail with
        #     INVALID_ARGUMENT error.)
        class ListMetadataStoresRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_metadata_stores MetadataService.ListMetadataStores}.
        # @!attribute [rw] metadata_stores
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::MetadataStore>]
        #     The MetadataStores found for the Location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListMetadataStoresRequest#page_token ListMetadataStoresRequest.page_token}
        #     to retrieve the next page. If this field is not populated, there are no
        #     subsequent pages.
        class ListMetadataStoresResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#delete_metadata_store MetadataService.DeleteMetadataStore}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the MetadataStore to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
        # @!attribute [rw] force
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Deprecated: Field is no longer supported.
        class DeleteMetadataStoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#delete_metadata_store MetadataService.DeleteMetadataStore}.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for deleting a MetadataStore.
        class DeleteMetadataStoreOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#create_artifact MetadataService.CreateArtifact}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the MetadataStore where the Artifact should
        #     be created.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
        # @!attribute [rw] artifact
        #   @return [::Google::Cloud::AIPlatform::V1::Artifact]
        #     Required. The Artifact to create.
        # @!attribute [rw] artifact_id
        #   @return [::String]
        #     The \\{artifact} portion of the resource name with the format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
        #     If not provided, the Artifact's ID will be a UUID generated by the service.
        #     Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
        #     Must be unique across all Artifacts in the parent MetadataStore. (Otherwise
        #     the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED if the
        #     caller can't view the preexisting Artifact.)
        class CreateArtifactRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#get_artifact MetadataService.GetArtifact}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Artifact to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
        class GetArtifactRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_artifacts MetadataService.ListArtifacts}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The MetadataStore whose Artifacts should be listed.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of Artifacts to return. The service may return fewer.
        #     Must be in range 1-1000, inclusive. Defaults to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_artifacts MetadataService.ListArtifacts}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other provided parameters must match the call that
        #     provided the page token. (Otherwise the request will fail with
        #     INVALID_ARGUMENT error.)
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter specifying the boolean condition for the Artifacts to satisfy in
        #     order to be part of the result set.
        #     The syntax to define filter query is based on https://google.aip.dev/160.
        #     The supported set of filters include the following:
        #
        #     *   **Attribute filtering**:
        #         For example: `display_name = "test"`.
        #         Supported fields include: `name`, `display_name`, `uri`, `state`,
        #         `schema_title`, `create_time`, and `update_time`.
        #         Time fields, such as `create_time` and `update_time`, require values
        #         specified in RFC-3339 format.
        #         For example: `create_time = "2020-11-19T11:30:00-04:00"`
        #     *   **Metadata field**:
        #         To filter on metadata fields use traversal operation as follows:
        #         `metadata.<field_name>.<type_value>`.
        #         For example: `metadata.field_1.number_value = 10.0`
        #         In case the field name contains special characters (such as colon), one
        #         can embed it inside double quote.
        #         For example: `metadata."field:1".number_value = 10.0`
        #     *   **Context based filtering**:
        #         To filter Artifacts based on the contexts to which they belong, use the
        #         function operator with the full resource name
        #         `in_context(<context-name>)`.
        #         For example:
        #         `in_context("projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context-id>")`
        #
        #     Each of the above supported filter types can be combined together using
        #     logical operators (`AND` & `OR`). Maximum nested expression depth allowed
        #     is 5.
        #
        #     For example: `display_name = "test" AND metadata.field1.bool_value = true`.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     How the list of messages is ordered. Specify the values to order by and an
        #     ordering operation. The default sorting order is ascending. To specify
        #     descending order for a field, users append a " desc" suffix; for example:
        #     "foo desc, bar".
        #     Subfields are specified with a `.` character, such as foo.bar.
        #     see https://google.aip.dev/132#ordering for more details.
        class ListArtifactsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_artifacts MetadataService.ListArtifacts}.
        # @!attribute [rw] artifacts
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Artifact>]
        #     The Artifacts retrieved from the MetadataStore.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListArtifactsRequest#page_token ListArtifactsRequest.page_token}
        #     to retrieve the next page.
        #     If this field is not populated, there are no subsequent pages.
        class ListArtifactsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#update_artifact MetadataService.UpdateArtifact}.
        # @!attribute [rw] artifact
        #   @return [::Google::Cloud::AIPlatform::V1::Artifact]
        #     Required. The Artifact containing updates.
        #     The Artifact's {::Google::Cloud::AIPlatform::V1::Artifact#name Artifact.name}
        #     field is used to identify the Artifact to be updated. Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. A FieldMask indicating which fields should be updated.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If set to true, and the {::Google::Cloud::AIPlatform::V1::Artifact Artifact} is
        #     not found, a new {::Google::Cloud::AIPlatform::V1::Artifact Artifact} is
        #     created.
        class UpdateArtifactRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#delete_artifact MetadataService.DeleteArtifact}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Artifact to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag of the Artifact to delete.
        #     If this is provided, it must match the server's etag. Otherwise, the
        #     request will fail with a FAILED_PRECONDITION.
        class DeleteArtifactRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#purge_artifacts MetadataService.PurgeArtifacts}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The metadata store to purge Artifacts from.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Required. A required filter matching the Artifacts to be purged.
        #     E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. Flag to indicate to actually perform the purge.
        #     If `force` is set to false, the method will return a sample of
        #     Artifact names that would be deleted.
        class PurgeArtifactsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#purge_artifacts MetadataService.PurgeArtifacts}.
        # @!attribute [rw] purge_count
        #   @return [::Integer]
        #     The number of Artifacts that this request deleted (or, if `force` is false,
        #     the number of Artifacts that will be deleted). This can be an estimate.
        # @!attribute [rw] purge_sample
        #   @return [::Array<::String>]
        #     A sample of the Artifact names that will be deleted.
        #     Only populated if `force` is set to false. The maximum number of samples is
        #     100 (it is possible to return fewer).
        class PurgeArtifactsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#purge_artifacts MetadataService.PurgeArtifacts}.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for purging Artifacts.
        class PurgeArtifactsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#create_context MetadataService.CreateContext}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the MetadataStore where the Context should
        #     be created. Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
        # @!attribute [rw] context
        #   @return [::Google::Cloud::AIPlatform::V1::Context]
        #     Required. The Context to create.
        # @!attribute [rw] context_id
        #   @return [::String]
        #     The \\{context} portion of the resource name with the format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`.
        #     If not provided, the Context's ID will be a UUID generated by the service.
        #     Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
        #     Must be unique across all Contexts in the parent MetadataStore. (Otherwise
        #     the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED if the
        #     caller can't view the preexisting Context.)
        class CreateContextRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#get_context MetadataService.GetContext}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Context to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
        class GetContextRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_contexts MetadataService.ListContexts}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The MetadataStore whose Contexts should be listed.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of Contexts to return. The service may return fewer.
        #     Must be in range 1-1000, inclusive. Defaults to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_contexts MetadataService.ListContexts}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other provided parameters must match the call that
        #     provided the page token. (Otherwise the request will fail with
        #     INVALID_ARGUMENT error.)
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter specifying the boolean condition for the Contexts to satisfy in
        #     order to be part of the result set.
        #     The syntax to define filter query is based on https://google.aip.dev/160.
        #     Following are the supported set of filters:
        #
        #     *  **Attribute filtering**:
        #        For example: `display_name = "test"`.
        #        Supported fields include: `name`, `display_name`, `schema_title`,
        #        `create_time`, and `update_time`.
        #        Time fields, such as `create_time` and `update_time`, require values
        #        specified in RFC-3339 format.
        #        For example: `create_time = "2020-11-19T11:30:00-04:00"`.
        #     *  **Metadata field**:
        #        To filter on metadata fields use traversal operation as follows:
        #        `metadata.<field_name>.<type_value>`.
        #        For example: `metadata.field_1.number_value = 10.0`.
        #        In case the field name contains special characters (such as colon), one
        #        can embed it inside double quote.
        #        For example: `metadata."field:1".number_value = 10.0`
        #     *  **Parent Child filtering**:
        #        To filter Contexts based on parent-child relationship use the HAS
        #        operator as follows:
        #
        #        ```
        #        parent_contexts:
        #        "projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context_id>"
        #        child_contexts:
        #        "projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context_id>"
        #        ```
        #
        #     Each of the above supported filters can be combined together using
        #     logical operators (`AND` & `OR`). Maximum nested expression depth allowed
        #     is 5.
        #
        #     For example: `display_name = "test" AND metadata.field1.bool_value = true`.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     How the list of messages is ordered. Specify the values to order by and an
        #     ordering operation. The default sorting order is ascending. To specify
        #     descending order for a field, users append a " desc" suffix; for example:
        #     "foo desc, bar".
        #     Subfields are specified with a `.` character, such as foo.bar.
        #     see https://google.aip.dev/132#ordering for more details.
        class ListContextsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_contexts MetadataService.ListContexts}.
        # @!attribute [rw] contexts
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Context>]
        #     The Contexts retrieved from the MetadataStore.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListContextsRequest#page_token ListContextsRequest.page_token}
        #     to retrieve the next page.
        #     If this field is not populated, there are no subsequent pages.
        class ListContextsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#update_context MetadataService.UpdateContext}.
        # @!attribute [rw] context
        #   @return [::Google::Cloud::AIPlatform::V1::Context]
        #     Required. The Context containing updates.
        #     The Context's {::Google::Cloud::AIPlatform::V1::Context#name Context.name} field
        #     is used to identify the Context to be updated. Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. A FieldMask indicating which fields should be updated.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If set to true, and the {::Google::Cloud::AIPlatform::V1::Context Context} is
        #     not found, a new {::Google::Cloud::AIPlatform::V1::Context Context} is created.
        class UpdateContextRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#delete_context MetadataService.DeleteContext}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Context to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     The force deletion semantics is still undefined.
        #     Users should not use this field.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag of the Context to delete.
        #     If this is provided, it must match the server's etag. Otherwise, the
        #     request will fail with a FAILED_PRECONDITION.
        class DeleteContextRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#purge_contexts MetadataService.PurgeContexts}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The metadata store to purge Contexts from.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Required. A required filter matching the Contexts to be purged.
        #     E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. Flag to indicate to actually perform the purge.
        #     If `force` is set to false, the method will return a sample of
        #     Context names that would be deleted.
        class PurgeContextsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#purge_contexts MetadataService.PurgeContexts}.
        # @!attribute [rw] purge_count
        #   @return [::Integer]
        #     The number of Contexts that this request deleted (or, if `force` is false,
        #     the number of Contexts that will be deleted). This can be an estimate.
        # @!attribute [rw] purge_sample
        #   @return [::Array<::String>]
        #     A sample of the Context names that will be deleted.
        #     Only populated if `force` is set to false. The maximum number of samples is
        #     100 (it is possible to return fewer).
        class PurgeContextsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#purge_contexts MetadataService.PurgeContexts}.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for purging Contexts.
        class PurgeContextsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#add_context_artifacts_and_executions MetadataService.AddContextArtifactsAndExecutions}.
        # @!attribute [rw] context
        #   @return [::String]
        #     Required. The resource name of the Context that the Artifacts and
        #     Executions belong to. Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
        # @!attribute [rw] artifacts
        #   @return [::Array<::String>]
        #     The resource names of the Artifacts to attribute to the Context.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
        # @!attribute [rw] executions
        #   @return [::Array<::String>]
        #     The resource names of the Executions to associate with the
        #     Context.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
        class AddContextArtifactsAndExecutionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#add_context_artifacts_and_executions MetadataService.AddContextArtifactsAndExecutions}.
        class AddContextArtifactsAndExecutionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#add_context_children MetadataService.AddContextChildren}.
        # @!attribute [rw] context
        #   @return [::String]
        #     Required. The resource name of the parent Context.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
        # @!attribute [rw] child_contexts
        #   @return [::Array<::String>]
        #     The resource names of the child Contexts.
        class AddContextChildrenRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#add_context_children MetadataService.AddContextChildren}.
        class AddContextChildrenResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # [MetadataService.DeleteContextChildrenRequest][].
        # @!attribute [rw] context
        #   @return [::String]
        #     Required. The resource name of the parent Context.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
        # @!attribute [rw] child_contexts
        #   @return [::Array<::String>]
        #     The resource names of the child Contexts.
        class RemoveContextChildrenRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#remove_context_children MetadataService.RemoveContextChildren}.
        class RemoveContextChildrenResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#query_context_lineage_subgraph MetadataService.QueryContextLineageSubgraph}.
        # @!attribute [rw] context
        #   @return [::String]
        #     Required. The resource name of the Context whose Artifacts and Executions
        #     should be retrieved as a LineageSubgraph.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
        #
        #     The request may error with FAILED_PRECONDITION if the number of Artifacts,
        #     the number of Executions, or the number of Events that would be returned
        #     for the Context exceeds 1000.
        class QueryContextLineageSubgraphRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#create_execution MetadataService.CreateExecution}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the MetadataStore where the Execution should
        #     be created.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
        # @!attribute [rw] execution
        #   @return [::Google::Cloud::AIPlatform::V1::Execution]
        #     Required. The Execution to create.
        # @!attribute [rw] execution_id
        #   @return [::String]
        #     The \\{execution} portion of the resource name with the format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
        #     If not provided, the Execution's ID will be a UUID generated by the
        #     service.
        #     Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
        #     Must be unique across all Executions in the parent MetadataStore.
        #     (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
        #     if the caller can't view the preexisting Execution.)
        class CreateExecutionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#get_execution MetadataService.GetExecution}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Execution to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
        class GetExecutionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_executions MetadataService.ListExecutions}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The MetadataStore whose Executions should be listed.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of Executions to return. The service may return fewer.
        #     Must be in range 1-1000, inclusive. Defaults to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_executions MetadataService.ListExecutions}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other provided parameters must match the call that
        #     provided the page token. (Otherwise the request will fail with an
        #     INVALID_ARGUMENT error.)
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter specifying the boolean condition for the Executions to satisfy in
        #     order to be part of the result set.
        #     The syntax to define filter query is based on https://google.aip.dev/160.
        #     Following are the supported set of filters:
        #
        #     *  **Attribute filtering**:
        #        For example: `display_name = "test"`.
        #        Supported fields include: `name`, `display_name`, `state`,
        #        `schema_title`, `create_time`, and `update_time`.
        #        Time fields, such as `create_time` and `update_time`, require values
        #        specified in RFC-3339 format.
        #        For example: `create_time = "2020-11-19T11:30:00-04:00"`.
        #     *  **Metadata field**:
        #        To filter on metadata fields use traversal operation as follows:
        #        `metadata.<field_name>.<type_value>`
        #        For example: `metadata.field_1.number_value = 10.0`
        #        In case the field name contains special characters (such as colon), one
        #        can embed it inside double quote.
        #        For example: `metadata."field:1".number_value = 10.0`
        #     *  **Context based filtering**:
        #        To filter Executions based on the contexts to which they belong use
        #        the function operator with the full resource name:
        #        `in_context(<context-name>)`.
        #        For example:
        #        `in_context("projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context-id>")`
        #
        #     Each of the above supported filters can be combined together using
        #     logical operators (`AND` & `OR`). Maximum nested expression depth allowed
        #     is 5.
        #
        #     For example: `display_name = "test" AND metadata.field1.bool_value = true`.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     How the list of messages is ordered. Specify the values to order by and an
        #     ordering operation. The default sorting order is ascending. To specify
        #     descending order for a field, users append a " desc" suffix; for example:
        #     "foo desc, bar".
        #     Subfields are specified with a `.` character, such as foo.bar.
        #     see https://google.aip.dev/132#ordering for more details.
        class ListExecutionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_executions MetadataService.ListExecutions}.
        # @!attribute [rw] executions
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Execution>]
        #     The Executions retrieved from the MetadataStore.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListExecutionsRequest#page_token ListExecutionsRequest.page_token}
        #     to retrieve the next page.
        #     If this field is not populated, there are no subsequent pages.
        class ListExecutionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#update_execution MetadataService.UpdateExecution}.
        # @!attribute [rw] execution
        #   @return [::Google::Cloud::AIPlatform::V1::Execution]
        #     Required. The Execution containing updates.
        #     The Execution's {::Google::Cloud::AIPlatform::V1::Execution#name Execution.name}
        #     field is used to identify the Execution to be updated. Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. A FieldMask indicating which fields should be updated.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If set to true, and the {::Google::Cloud::AIPlatform::V1::Execution Execution}
        #     is not found, a new {::Google::Cloud::AIPlatform::V1::Execution Execution} is
        #     created.
        class UpdateExecutionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#delete_execution MetadataService.DeleteExecution}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Execution to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag of the Execution to delete.
        #     If this is provided, it must match the server's etag. Otherwise, the
        #     request will fail with a FAILED_PRECONDITION.
        class DeleteExecutionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#purge_executions MetadataService.PurgeExecutions}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The metadata store to purge Executions from.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Required. A required filter matching the Executions to be purged.
        #     E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. Flag to indicate to actually perform the purge.
        #     If `force` is set to false, the method will return a sample of
        #     Execution names that would be deleted.
        class PurgeExecutionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#purge_executions MetadataService.PurgeExecutions}.
        # @!attribute [rw] purge_count
        #   @return [::Integer]
        #     The number of Executions that this request deleted (or, if `force` is
        #     false, the number of Executions that will be deleted). This can be an
        #     estimate.
        # @!attribute [rw] purge_sample
        #   @return [::Array<::String>]
        #     A sample of the Execution names that will be deleted.
        #     Only populated if `force` is set to false. The maximum number of samples is
        #     100 (it is possible to return fewer).
        class PurgeExecutionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#purge_executions MetadataService.PurgeExecutions}.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for purging Executions.
        class PurgeExecutionsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#add_execution_events MetadataService.AddExecutionEvents}.
        # @!attribute [rw] execution
        #   @return [::String]
        #     Required. The resource name of the Execution that the Events connect
        #     Artifacts with.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
        # @!attribute [rw] events
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Event>]
        #     The Events to create and add.
        class AddExecutionEventsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#add_execution_events MetadataService.AddExecutionEvents}.
        class AddExecutionEventsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#query_execution_inputs_and_outputs MetadataService.QueryExecutionInputsAndOutputs}.
        # @!attribute [rw] execution
        #   @return [::String]
        #     Required. The resource name of the Execution whose input and output
        #     Artifacts should be retrieved as a LineageSubgraph. Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
        class QueryExecutionInputsAndOutputsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#create_metadata_schema MetadataService.CreateMetadataSchema}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the MetadataStore where the MetadataSchema
        #     should be created. Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
        # @!attribute [rw] metadata_schema
        #   @return [::Google::Cloud::AIPlatform::V1::MetadataSchema]
        #     Required. The MetadataSchema to create.
        # @!attribute [rw] metadata_schema_id
        #   @return [::String]
        #     The \\{metadata_schema} portion of the resource name with the format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/metadataSchemas/{metadataschema}`
        #     If not provided, the MetadataStore's ID will be a UUID generated by the
        #     service.
        #     Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
        #     Must be unique across all MetadataSchemas in the parent Location.
        #     (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
        #     if the caller can't view the preexisting MetadataSchema.)
        class CreateMetadataSchemaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#get_metadata_schema MetadataService.GetMetadataSchema}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the MetadataSchema to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/metadataSchemas/{metadataschema}`
        class GetMetadataSchemaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_metadata_schemas MetadataService.ListMetadataSchemas}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The MetadataStore whose MetadataSchemas should be listed.
        #     Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of MetadataSchemas to return. The service may return
        #     fewer.
        #     Must be in range 1-1000, inclusive. Defaults to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_metadata_schemas MetadataService.ListMetadataSchemas}
        #     call. Provide this to retrieve the next page.
        #
        #     When paginating, all other provided parameters must match the call that
        #     provided the page token. (Otherwise the request will fail with
        #     INVALID_ARGUMENT error.)
        # @!attribute [rw] filter
        #   @return [::String]
        #     A query to filter available MetadataSchemas for matching results.
        class ListMetadataSchemasRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_metadata_schemas MetadataService.ListMetadataSchemas}.
        # @!attribute [rw] metadata_schemas
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::MetadataSchema>]
        #     The MetadataSchemas found for the MetadataStore.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListMetadataSchemasRequest#page_token ListMetadataSchemasRequest.page_token}
        #     to retrieve the next page. If this field is not populated, there are no
        #     subsequent pages.
        class ListMetadataSchemasResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::MetadataService::Client#query_artifact_lineage_subgraph MetadataService.QueryArtifactLineageSubgraph}.
        # @!attribute [rw] artifact
        #   @return [::String]
        #     Required. The resource name of the Artifact whose Lineage needs to be
        #     retrieved as a LineageSubgraph. Format:
        #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
        #
        #     The request may error with FAILED_PRECONDITION if the number of Artifacts,
        #     the number of Executions, or the number of Events that would be returned
        #     for the Context exceeds 1000.
        # @!attribute [rw] max_hops
        #   @return [::Integer]
        #     Specifies the size of the lineage graph in terms of number of hops from the
        #     specified artifact.
        #     Negative Value: INVALID_ARGUMENT error is returned
        #     0: Only input artifact is returned.
        #     No value: Transitive closure is performed to return the complete graph.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter specifying the boolean condition for the Artifacts to satisfy in
        #     order to be part of the Lineage Subgraph.
        #     The syntax to define filter query is based on https://google.aip.dev/160.
        #     The supported set of filters include the following:
        #
        #     *  **Attribute filtering**:
        #        For example: `display_name = "test"`
        #        Supported fields include: `name`, `display_name`, `uri`, `state`,
        #        `schema_title`, `create_time`, and `update_time`.
        #        Time fields, such as `create_time` and `update_time`, require values
        #        specified in RFC-3339 format.
        #        For example: `create_time = "2020-11-19T11:30:00-04:00"`
        #     *  **Metadata field**:
        #        To filter on metadata fields use traversal operation as follows:
        #        `metadata.<field_name>.<type_value>`.
        #        For example: `metadata.field_1.number_value = 10.0`
        #        In case the field name contains special characters (such as colon), one
        #        can embed it inside double quote.
        #        For example: `metadata."field:1".number_value = 10.0`
        #
        #     Each of the above supported filter types can be combined together using
        #     logical operators (`AND` & `OR`). Maximum nested expression depth allowed
        #     is 5.
        #
        #     For example: `display_name = "test" AND metadata.field1.bool_value = true`.
        class QueryArtifactLineageSubgraphRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
