# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # The storage details for Avro input content.
        # @!attribute [rw] gcs_source
        #   @return [::Google::Cloud::AIPlatform::V1::GcsSource]
        #     Required. Google Cloud Storage location.
        class AvroSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The storage details for CSV input content.
        # @!attribute [rw] gcs_source
        #   @return [::Google::Cloud::AIPlatform::V1::GcsSource]
        #     Required. Google Cloud Storage location.
        class CsvSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The Google Cloud Storage location for the input content.
        # @!attribute [rw] uris
        #   @return [::Array<::String>]
        #     Required. Google Cloud Storage URI(-s) to the input file(s). May contain
        #     wildcards. For more information on wildcards, see
        #     https://cloud.google.com/storage/docs/wildcards.
        class GcsSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The Google Cloud Storage location where the output is to be written to.
        # @!attribute [rw] output_uri_prefix
        #   @return [::String]
        #     Required. Google Cloud Storage URI to output directory. If the uri doesn't
        #     end with
        #     '/', a '/' will be automatically appended. The directory is created if it
        #     doesn't exist.
        class GcsDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The BigQuery location for the input content.
        # @!attribute [rw] input_uri
        #   @return [::String]
        #     Required. BigQuery URI to a table, up to 2000 characters long.
        #     Accepted forms:
        #
        #     *  BigQuery path. For example: `bq://projectId.bqDatasetId.bqTableId`.
        class BigQuerySource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The BigQuery location for the output content.
        # @!attribute [rw] output_uri
        #   @return [::String]
        #     Required. BigQuery URI to a project or table, up to 2000 characters long.
        #
        #     When only the project is specified, the Dataset and Table is created.
        #     When the full table reference is specified, the Dataset must exist and
        #     table must not exist.
        #
        #     Accepted forms:
        #
        #     *  BigQuery path. For example:
        #     `bq://projectId` or `bq://projectId.bqDatasetId` or
        #     `bq://projectId.bqDatasetId.bqTableId`.
        class BigQueryDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The storage details for CSV output content.
        # @!attribute [rw] gcs_destination
        #   @return [::Google::Cloud::AIPlatform::V1::GcsDestination]
        #     Required. Google Cloud Storage location.
        class CsvDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The storage details for TFRecord output content.
        # @!attribute [rw] gcs_destination
        #   @return [::Google::Cloud::AIPlatform::V1::GcsDestination]
        #     Required. Google Cloud Storage location.
        class TFRecordDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The Container Registry location for the container image.
        # @!attribute [rw] output_uri
        #   @return [::String]
        #     Required. Container Registry URI of a container image.
        #     Only Google Container Registry and Artifact Registry are supported now.
        #     Accepted forms:
        #
        #     *  Google Container Registry path. For example:
        #        `gcr.io/projectId/imageName:tag`.
        #
        #     *  Artifact Registry path. For example:
        #        `us-central1-docker.pkg.dev/projectId/repoName/imageName:tag`.
        #
        #     If a tag is not specified, "latest" will be used as the default tag.
        class ContainerRegistryDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The Google Drive location for the input content.
        # @!attribute [rw] resource_ids
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::GoogleDriveSource::ResourceId>]
        #     Required. Google Drive resource IDs.
        class GoogleDriveSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type and ID of the Google Drive resource.
          # @!attribute [rw] resource_type
          #   @return [::Google::Cloud::AIPlatform::V1::GoogleDriveSource::ResourceId::ResourceType]
          #     Required. The type of the Google Drive resource.
          # @!attribute [rw] resource_id
          #   @return [::String]
          #     Required. The ID of the Google Drive resource.
          class ResourceId
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type of the Google Drive resource.
            module ResourceType
              # Unspecified resource type.
              RESOURCE_TYPE_UNSPECIFIED = 0

              # File resource type.
              RESOURCE_TYPE_FILE = 1

              # Folder resource type.
              RESOURCE_TYPE_FOLDER = 2
            end
          end
        end

        # The input content is encapsulated and uploaded in the request.
        class DirectUploadSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The Slack source for the ImportRagFilesRequest.
        # @!attribute [rw] channels
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::SlackSource::SlackChannels>]
        #     Required. The Slack channels.
        class SlackSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # SlackChannels contains the Slack channels and corresponding access token.
          # @!attribute [rw] channels
          #   @return [::Array<::Google::Cloud::AIPlatform::V1::SlackSource::SlackChannels::SlackChannel>]
          #     Required. The Slack channel IDs.
          # @!attribute [rw] api_key_config
          #   @return [::Google::Cloud::AIPlatform::V1::ApiAuth::ApiKeyConfig]
          #     Required. The SecretManager secret version resource name (e.g.
          #     projects/\\{project}/secrets/\\{secret}/versions/\\{version}) storing the
          #     Slack channel access token that has access to the slack channel IDs.
          #     See: https://api.slack.com/tutorials/tracks/getting-a-token.
          class SlackChannels
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # SlackChannel contains the Slack channel ID and the time range to import.
            # @!attribute [rw] channel_id
            #   @return [::String]
            #     Required. The Slack channel ID.
            # @!attribute [rw] start_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Optional. The starting timestamp for messages to import.
            # @!attribute [rw] end_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Optional. The ending timestamp for messages to import.
            class SlackChannel
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # The Jira source for the ImportRagFilesRequest.
        # @!attribute [rw] jira_queries
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::JiraSource::JiraQueries>]
        #     Required. The Jira queries.
        class JiraSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # JiraQueries contains the Jira queries and corresponding authentication.
          # @!attribute [rw] projects
          #   @return [::Array<::String>]
          #     A list of Jira projects to import in their entirety.
          # @!attribute [rw] custom_queries
          #   @return [::Array<::String>]
          #     A list of custom Jira queries to import. For information about JQL (Jira
          #     Query Language), see
          #     https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
          # @!attribute [rw] email
          #   @return [::String]
          #     Required. The Jira email address.
          # @!attribute [rw] server_uri
          #   @return [::String]
          #     Required. The Jira server URI.
          # @!attribute [rw] api_key_config
          #   @return [::Google::Cloud::AIPlatform::V1::ApiAuth::ApiKeyConfig]
          #     Required. The SecretManager secret version resource name (e.g.
          #     projects/\\{project}/secrets/\\{secret}/versions/\\{version}) storing the
          #     Jira API key. See [Manage API tokens for your Atlassian
          #     account](https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
          class JiraQueries
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The SharePointSources to pass to ImportRagFiles.
        # @!attribute [rw] share_point_sources
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::SharePointSources::SharePointSource>]
        #     The SharePoint sources.
        class SharePointSources
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An individual SharePointSource.
          # @!attribute [rw] sharepoint_folder_path
          #   @return [::String]
          #     The path of the SharePoint folder to download from.
          #
          #     Note: The following fields are mutually exclusive: `sharepoint_folder_path`, `sharepoint_folder_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] sharepoint_folder_id
          #   @return [::String]
          #     The ID of the SharePoint folder to download from.
          #
          #     Note: The following fields are mutually exclusive: `sharepoint_folder_id`, `sharepoint_folder_path`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] drive_name
          #   @return [::String]
          #     The name of the drive to download from.
          #
          #     Note: The following fields are mutually exclusive: `drive_name`, `drive_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] drive_id
          #   @return [::String]
          #     The ID of the drive to download from.
          #
          #     Note: The following fields are mutually exclusive: `drive_id`, `drive_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] client_id
          #   @return [::String]
          #     The Application ID for the app registered in Microsoft Azure Portal.
          #     The application must also be configured with MS Graph permissions
          #     "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
          # @!attribute [rw] client_secret
          #   @return [::Google::Cloud::AIPlatform::V1::ApiAuth::ApiKeyConfig]
          #     The application secret for the app registered in Azure.
          # @!attribute [rw] tenant_id
          #   @return [::String]
          #     Unique identifier of the Azure Active Directory Instance.
          # @!attribute [rw] sharepoint_site_name
          #   @return [::String]
          #     The name of the SharePoint site to download from. This can be the site
          #     name or the site id.
          # @!attribute [r] file_id
          #   @return [::String]
          #     Output only. The SharePoint file id. Output only.
          class SharePointSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
