# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::GenAiCacheService::Client#create_cached_content GenAiCacheService.CreateCachedContent}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where the cached content will be created
        # @!attribute [rw] cached_content
        #   @return [::Google::Cloud::AIPlatform::V1::CachedContent]
        #     Required. The cached content to create
        class CreateCachedContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::GenAiCacheService::Client#get_cached_content GenAiCacheService.GetCachedContent}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name referring to the cached content
        class GetCachedContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::GenAiCacheService::Client#update_cached_content GenAiCacheService.UpdateCachedContent}.
        # Only expire_time or ttl can be updated.
        # @!attribute [rw] cached_content
        #   @return [::Google::Cloud::AIPlatform::V1::CachedContent]
        #     Required. The cached content to update
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateCachedContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::GenAiCacheService::Client#delete_cached_content GenAiCacheService.DeleteCachedContent}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name referring to the cached content
        class DeleteCachedContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list CachedContents.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of cached contents.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of cached contents to return. The service may
        #     return fewer than this value. If unspecified, some default (under maximum)
        #     number of items will be returned. The maximum value is 1000; values above
        #     1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListCachedContents` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListCachedContents` must
        #     match the call that provided the page token.
        class ListCachedContentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response with a list of CachedContents.
        # @!attribute [rw] cached_contents
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::CachedContent>]
        #     List of cached contents.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListCachedContentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
