# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#create_featurestore FeaturestoreService.CreateFeaturestore}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to create Featurestores.
        #     Format:
        #     `projects/{project}/locations/{location}`
        # @!attribute [rw] featurestore
        #   @return [::Google::Cloud::AIPlatform::V1::Featurestore]
        #     Required. The Featurestore to create.
        # @!attribute [rw] featurestore_id
        #   @return [::String]
        #     Required. The ID to use for this Featurestore, which will become the final
        #     component of the Featurestore's resource name.
        #
        #     This value may be up to 60 characters, and valid characters are
        #     `[a-z0-9_]`. The first character cannot be a number.
        #
        #     The value must be unique within the project and location.
        class CreateFeaturestoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#get_featurestore FeaturestoreService.GetFeaturestore}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Featurestore resource.
        class GetFeaturestoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_featurestores FeaturestoreService.ListFeaturestores}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to list Featurestores.
        #     Format:
        #     `projects/{project}/locations/{location}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the featurestores that match the filter expression. The following
        #     fields are supported:
        #
        #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
        #     Values must be
        #       in RFC 3339 format.
        #     * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
        #     Values must be
        #       in RFC 3339 format.
        #     * `online_serving_config.fixed_node_count`: Supports `=`, `!=`, `<`, `>`,
        #     `<=`, and `>=` comparisons.
        #     * `labels`: Supports key-value equality and key presence.
        #
        #     Examples:
        #
        #     * `create_time > "2020-01-01" OR update_time > "2020-01-01"`
        #        Featurestores created or updated after 2020-01-01.
        #     * `labels.env = "prod"`
        #        Featurestores with label "env" set to "prod".
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of Featurestores to return. The service may return fewer
        #     than this value. If unspecified, at most 100 Featurestores will be
        #     returned. The maximum value is 100; any value greater than 100 will be
        #     coerced to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_featurestores FeaturestoreService.ListFeaturestores}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_featurestores FeaturestoreService.ListFeaturestores}
        #     must match the call that provided the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        #     Supported Fields:
        #
        #       * `create_time`
        #       * `update_time`
        #       * `online_serving_config.fixed_node_count`
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        class ListFeaturestoresRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_featurestores FeaturestoreService.ListFeaturestores}.
        # @!attribute [rw] featurestores
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Featurestore>]
        #     The Featurestores matching the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListFeaturestoresRequest#page_token ListFeaturestoresRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListFeaturestoresResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#update_featurestore FeaturestoreService.UpdateFeaturestore}.
        # @!attribute [rw] featurestore
        #   @return [::Google::Cloud::AIPlatform::V1::Featurestore]
        #     Required. The Featurestore's `name` field is used to identify the
        #     Featurestore to be updated. Format:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Field mask is used to specify the fields to be overwritten in the
        #     Featurestore resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then only the non-empty fields present in the
        #     request will be overwritten. Set the update_mask to `*` to override all
        #     fields.
        #
        #     Updatable fields:
        #
        #       * `labels`
        #       * `online_serving_config.fixed_node_count`
        #       * `online_serving_config.scaling`
        #       * `online_storage_ttl_days`
        class UpdateFeaturestoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#delete_featurestore FeaturestoreService.DeleteFeaturestore}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Featurestore to be deleted.
        #     Format:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}`
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     If set to true, any EntityTypes and Features for this Featurestore will
        #     also be deleted. (Otherwise, the request will only work if the Featurestore
        #     has no EntityTypes.)
        class DeleteFeaturestoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#import_feature_values FeaturestoreService.ImportFeatureValues}.
        # @!attribute [rw] avro_source
        #   @return [::Google::Cloud::AIPlatform::V1::AvroSource]
        #     Note: The following fields are mutually exclusive: `avro_source`, `bigquery_source`, `csv_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bigquery_source
        #   @return [::Google::Cloud::AIPlatform::V1::BigQuerySource]
        #     Note: The following fields are mutually exclusive: `bigquery_source`, `avro_source`, `csv_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] csv_source
        #   @return [::Google::Cloud::AIPlatform::V1::CsvSource]
        #     Note: The following fields are mutually exclusive: `csv_source`, `avro_source`, `bigquery_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] feature_time_field
        #   @return [::String]
        #     Source column that holds the Feature timestamp for all Feature
        #     values in each entity.
        #
        #     Note: The following fields are mutually exclusive: `feature_time_field`, `feature_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] feature_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Single Feature timestamp for all entities being imported. The
        #     timestamp must not have higher than millisecond precision.
        #
        #     Note: The following fields are mutually exclusive: `feature_time`, `feature_time_field`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] entity_type
        #   @return [::String]
        #     Required. The resource name of the EntityType grouping the Features for
        #     which values are being imported. Format:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
        # @!attribute [rw] entity_id_field
        #   @return [::String]
        #     Source column that holds entity IDs. If not provided, entity IDs are
        #     extracted from the column named entity_id.
        # @!attribute [rw] feature_specs
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ImportFeatureValuesRequest::FeatureSpec>]
        #     Required. Specifications defining which Feature values to import from the
        #     entity. The request fails if no feature_specs are provided, and having
        #     multiple feature_specs for one Feature is not allowed.
        # @!attribute [rw] disable_online_serving
        #   @return [::Boolean]
        #     If set, data will not be imported for online serving. This
        #     is typically used for backfilling, where Feature generation timestamps are
        #     not in the timestamp range needed for online serving.
        # @!attribute [rw] worker_count
        #   @return [::Integer]
        #     Specifies the number of workers that are used to write data to the
        #     Featurestore. Consider the online serving capacity that you require to
        #     achieve the desired import throughput without interfering with online
        #     serving. The value must be positive, and less than or equal to 100.
        #     If not set, defaults to using 1 worker. The low count ensures minimal
        #     impact on online serving performance.
        # @!attribute [rw] disable_ingestion_analysis
        #   @return [::Boolean]
        #     If true, API doesn't start ingestion analysis pipeline.
        class ImportFeatureValuesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines the Feature value(s) to import.
          # @!attribute [rw] id
          #   @return [::String]
          #     Required. ID of the Feature to import values of. This Feature must exist
          #     in the target EntityType, or the request will fail.
          # @!attribute [rw] source_field
          #   @return [::String]
          #     Source column to get the Feature values from. If not set, uses the column
          #     with the same name as the Feature ID.
          class FeatureSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#import_feature_values FeaturestoreService.ImportFeatureValues}.
        # @!attribute [rw] imported_entity_count
        #   @return [::Integer]
        #     Number of entities that have been imported by the operation.
        # @!attribute [rw] imported_feature_value_count
        #   @return [::Integer]
        #     Number of Feature values that have been imported by the operation.
        # @!attribute [rw] invalid_row_count
        #   @return [::Integer]
        #     The number of rows in input source that weren't imported due to either
        #     * Not having any featureValues.
        #     * Having a null entityId.
        #     * Having a null timestamp.
        #     * Not being parsable (applicable for CSV sources).
        # @!attribute [rw] timestamp_outside_retention_rows_count
        #   @return [::Integer]
        #     The number rows that weren't ingested due to having feature timestamps
        #     outside the retention boundary.
        class ImportFeatureValuesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#batch_read_feature_values FeaturestoreService.BatchReadFeatureValues}.
        # @!attribute [rw] csv_read_instances
        #   @return [::Google::Cloud::AIPlatform::V1::CsvSource]
        #     Each read instance consists of exactly one read timestamp and one or more
        #     entity IDs identifying entities of the corresponding EntityTypes whose
        #     Features are requested.
        #
        #     Each output instance contains Feature values of requested entities
        #     concatenated together as of the read time.
        #
        #     An example read instance may be `foo_entity_id, bar_entity_id,
        #     2020-01-01T10:00:00.123Z`.
        #
        #     An example output instance may be `foo_entity_id, bar_entity_id,
        #     2020-01-01T10:00:00.123Z, foo_entity_feature1_value,
        #     bar_entity_feature2_value`.
        #
        #     Timestamp in each read instance must be millisecond-aligned.
        #
        #     `csv_read_instances` are read instances stored in a plain-text CSV file.
        #     The header should be:
        #         [ENTITY_TYPE_ID1], [ENTITY_TYPE_ID2], ..., timestamp
        #
        #     The columns can be in any order.
        #
        #     Values in the timestamp column must use the RFC 3339 format, e.g.
        #     `2012-07-30T10:43:17.123Z`.
        #
        #     Note: The following fields are mutually exclusive: `csv_read_instances`, `bigquery_read_instances`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bigquery_read_instances
        #   @return [::Google::Cloud::AIPlatform::V1::BigQuerySource]
        #     Similar to csv_read_instances, but from BigQuery source.
        #
        #     Note: The following fields are mutually exclusive: `bigquery_read_instances`, `csv_read_instances`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] featurestore
        #   @return [::String]
        #     Required. The resource name of the Featurestore from which to query Feature
        #     values. Format:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}`
        # @!attribute [rw] destination
        #   @return [::Google::Cloud::AIPlatform::V1::FeatureValueDestination]
        #     Required. Specifies output location and format.
        # @!attribute [rw] pass_through_fields
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest::PassThroughField>]
        #     When not empty, the specified fields in the *_read_instances source will be
        #     joined as-is in the output, in addition to those fields from the
        #     Featurestore Entity.
        #
        #     For BigQuery source, the type of the pass-through values will be
        #     automatically inferred. For CSV source, the pass-through values will be
        #     passed as opaque bytes.
        # @!attribute [rw] entity_type_specs
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest::EntityTypeSpec>]
        #     Required. Specifies EntityType grouping Features to read values of and
        #     settings.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Excludes Feature values with feature generation timestamp before
        #     this timestamp. If not set, retrieve oldest values kept in Feature Store.
        #     Timestamp, if present, must not have higher than millisecond precision.
        class BatchReadFeatureValuesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describe pass-through fields in read_instance source.
          # @!attribute [rw] field_name
          #   @return [::String]
          #     Required. The name of the field in the CSV header or the name of the
          #     column in BigQuery table. The naming restriction is the same as
          #     {::Google::Cloud::AIPlatform::V1::Feature#name Feature.name}.
          class PassThroughField
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Selects Features of an EntityType to read values of and specifies read
          # settings.
          # @!attribute [rw] entity_type_id
          #   @return [::String]
          #     Required. ID of the EntityType to select Features. The EntityType id is
          #     the
          #     {::Google::Cloud::AIPlatform::V1::CreateEntityTypeRequest#entity_type_id entity_type_id}
          #     specified during EntityType creation.
          # @!attribute [rw] feature_selector
          #   @return [::Google::Cloud::AIPlatform::V1::FeatureSelector]
          #     Required. Selectors choosing which Feature values to read from the
          #     EntityType.
          # @!attribute [rw] settings
          #   @return [::Array<::Google::Cloud::AIPlatform::V1::DestinationFeatureSetting>]
          #     Per-Feature settings for the batch read.
          class EntityTypeSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#export_feature_values FeaturestoreService.ExportFeatureValues}.
        # @!attribute [rw] snapshot_export
        #   @return [::Google::Cloud::AIPlatform::V1::ExportFeatureValuesRequest::SnapshotExport]
        #     Exports the latest Feature values of all entities of the EntityType
        #     within a time range.
        #
        #     Note: The following fields are mutually exclusive: `snapshot_export`, `full_export`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] full_export
        #   @return [::Google::Cloud::AIPlatform::V1::ExportFeatureValuesRequest::FullExport]
        #     Exports all historical values of all entities of the EntityType within a
        #     time range
        #
        #     Note: The following fields are mutually exclusive: `full_export`, `snapshot_export`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] entity_type
        #   @return [::String]
        #     Required. The resource name of the EntityType from which to export Feature
        #     values. Format:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
        # @!attribute [rw] destination
        #   @return [::Google::Cloud::AIPlatform::V1::FeatureValueDestination]
        #     Required. Specifies destination location and format.
        # @!attribute [rw] feature_selector
        #   @return [::Google::Cloud::AIPlatform::V1::FeatureSelector]
        #     Required. Selects Features to export values of.
        # @!attribute [rw] settings
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::DestinationFeatureSetting>]
        #     Per-Feature export settings.
        class ExportFeatureValuesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes exporting the latest Feature values of all entities of the
          # EntityType between [start_time, snapshot_time].
          # @!attribute [rw] snapshot_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Exports Feature values as of this timestamp. If not set,
          #     retrieve values as of now. Timestamp, if present, must not have higher
          #     than millisecond precision.
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Excludes Feature values with feature generation timestamp before this
          #     timestamp. If not set, retrieve oldest values kept in Feature Store.
          #     Timestamp, if present, must not have higher than millisecond precision.
          class SnapshotExport
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Describes exporting all historical Feature values of all entities of the
          # EntityType between [start_time, end_time].
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Excludes Feature values with feature generation timestamp before this
          #     timestamp. If not set, retrieve oldest values kept in Feature Store.
          #     Timestamp, if present, must not have higher than millisecond precision.
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Exports Feature values as of this timestamp. If not set,
          #     retrieve values as of now. Timestamp, if present, must not have higher
          #     than millisecond precision.
          class FullExport
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] feature_id
        #   @return [::String]
        #     Required. The ID of the Feature to apply the setting to.
        # @!attribute [rw] destination_field
        #   @return [::String]
        #     Specify the field name in the export destination. If not specified,
        #     Feature ID is used.
        class DestinationFeatureSetting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A destination location for Feature values and format.
        # @!attribute [rw] bigquery_destination
        #   @return [::Google::Cloud::AIPlatform::V1::BigQueryDestination]
        #     Output in BigQuery format.
        #     {::Google::Cloud::AIPlatform::V1::BigQueryDestination#output_uri BigQueryDestination.output_uri}
        #     in
        #     {::Google::Cloud::AIPlatform::V1::FeatureValueDestination#bigquery_destination FeatureValueDestination.bigquery_destination}
        #     must refer to a table.
        #
        #     Note: The following fields are mutually exclusive: `bigquery_destination`, `tfrecord_destination`, `csv_destination`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tfrecord_destination
        #   @return [::Google::Cloud::AIPlatform::V1::TFRecordDestination]
        #     Output in TFRecord format.
        #
        #     Below are the mapping from Feature value type
        #     in Featurestore to Feature value type in TFRecord:
        #
        #         Value type in Featurestore                 | Value type in TFRecord
        #         DOUBLE, DOUBLE_ARRAY                       | FLOAT_LIST
        #         INT64, INT64_ARRAY                         | INT64_LIST
        #         STRING, STRING_ARRAY, BYTES                | BYTES_LIST
        #         true -> byte_string("true"), false -> byte_string("false")
        #         BOOL, BOOL_ARRAY (true, false)             | BYTES_LIST
        #
        #     Note: The following fields are mutually exclusive: `tfrecord_destination`, `bigquery_destination`, `csv_destination`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] csv_destination
        #   @return [::Google::Cloud::AIPlatform::V1::CsvDestination]
        #     Output in CSV format. Array Feature value types are not allowed in CSV
        #     format.
        #
        #     Note: The following fields are mutually exclusive: `csv_destination`, `bigquery_destination`, `tfrecord_destination`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class FeatureValueDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#export_feature_values FeaturestoreService.ExportFeatureValues}.
        class ExportFeatureValuesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#batch_read_feature_values FeaturestoreService.BatchReadFeatureValues}.
        class BatchReadFeatureValuesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#create_entity_type FeaturestoreService.CreateEntityType}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Featurestore to create EntityTypes.
        #     Format:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}`
        # @!attribute [rw] entity_type
        #   @return [::Google::Cloud::AIPlatform::V1::EntityType]
        #     The EntityType to create.
        # @!attribute [rw] entity_type_id
        #   @return [::String]
        #     Required. The ID to use for the EntityType, which will become the final
        #     component of the EntityType's resource name.
        #
        #     This value may be up to 60 characters, and valid characters are
        #     `[a-z0-9_]`. The first character cannot be a number.
        #
        #     The value must be unique within a featurestore.
        class CreateEntityTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#get_entity_type FeaturestoreService.GetEntityType}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the EntityType resource.
        #     Format:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
        class GetEntityTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_entity_types FeaturestoreService.ListEntityTypes}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Featurestore to list EntityTypes.
        #     Format:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the EntityTypes that match the filter expression. The following
        #     filters are supported:
        #
        #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
        #     Values must be in RFC 3339 format.
        #     * `update_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
        #     Values must be in RFC 3339 format.
        #     * `labels`: Supports key-value equality as well as key presence.
        #
        #     Examples:
        #
        #     * `create_time > \"2020-01-31T15:30:00.000000Z\" OR
        #          update_time > \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created
        #          or updated after 2020-01-31T15:30:00.000000Z.
        #     * `labels.active = yes AND labels.env = prod` --> EntityTypes having both
        #         (active: yes) and (env: prod) labels.
        #     * `labels.env: *` --> Any EntityType which has a label with 'env' as the
        #       key.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of EntityTypes to return. The service may return fewer
        #     than this value. If unspecified, at most 1000 EntityTypes will be returned.
        #     The maximum value is 1000; any value greater than 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_entity_types FeaturestoreService.ListEntityTypes}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_entity_types FeaturestoreService.ListEntityTypes}
        #     must match the call that provided the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        #
        #     Supported fields:
        #
        #       * `entity_type_id`
        #       * `create_time`
        #       * `update_time`
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        class ListEntityTypesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_entity_types FeaturestoreService.ListEntityTypes}.
        # @!attribute [rw] entity_types
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::EntityType>]
        #     The EntityTypes matching the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListEntityTypesRequest#page_token ListEntityTypesRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListEntityTypesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#update_entity_type FeaturestoreService.UpdateEntityType}.
        # @!attribute [rw] entity_type
        #   @return [::Google::Cloud::AIPlatform::V1::EntityType]
        #     Required. The EntityType's `name` field is used to identify the EntityType
        #     to be updated. Format:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Field mask is used to specify the fields to be overwritten in the
        #     EntityType resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then only the non-empty fields present in the
        #     request will be overwritten. Set the update_mask to `*` to override all
        #     fields.
        #
        #     Updatable fields:
        #
        #       * `description`
        #       * `labels`
        #       * `monitoring_config.snapshot_analysis.disabled`
        #       * `monitoring_config.snapshot_analysis.monitoring_interval_days`
        #       * `monitoring_config.snapshot_analysis.staleness_days`
        #       * `monitoring_config.import_features_analysis.state`
        #       * `monitoring_config.import_features_analysis.anomaly_detection_baseline`
        #       * `monitoring_config.numerical_threshold_config.value`
        #       * `monitoring_config.categorical_threshold_config.value`
        #       * `offline_storage_ttl_days`
        class UpdateEntityTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#delete_entity_type FeaturestoreService.DeleteEntityType}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the EntityType to be deleted.
        #     Format:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     If set to true, any Features for this EntityType will also be deleted.
        #     (Otherwise, the request will only work if the EntityType has no Features.)
        class DeleteEntityTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#create_feature FeaturestoreService.CreateFeature}.
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#create_feature FeatureRegistryService.CreateFeature}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the EntityType or FeatureGroup to create a
        #     Feature. Format for entity_type as parent:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
        #     Format for feature_group as parent:
        #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
        # @!attribute [rw] feature
        #   @return [::Google::Cloud::AIPlatform::V1::Feature]
        #     Required. The Feature to create.
        # @!attribute [rw] feature_id
        #   @return [::String]
        #     Required. The ID to use for the Feature, which will become the final
        #     component of the Feature's resource name.
        #
        #     This value may be up to 128 characters, and valid characters are
        #     `[a-z0-9_]`. The first character cannot be a number.
        #
        #     The value must be unique within an EntityType/FeatureGroup.
        class CreateFeatureRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#batch_create_features FeaturestoreService.BatchCreateFeatures}.
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#batch_create_features FeatureRegistryService.BatchCreateFeatures}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the EntityType/FeatureGroup to create the
        #     batch of Features under. Format:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
        #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::CreateFeatureRequest>]
        #     Required. The request message specifying the Features to create. All
        #     Features must be created under the same parent EntityType / FeatureGroup.
        #     The `parent` field in each child request message can be omitted. If
        #     `parent` is set in a child request, then the value must match the `parent`
        #     value in this request message.
        class BatchCreateFeaturesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#batch_create_features FeaturestoreService.BatchCreateFeatures}.
        # @!attribute [rw] features
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Feature>]
        #     The Features created.
        class BatchCreateFeaturesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#get_feature FeaturestoreService.GetFeature}.
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#get_feature FeatureRegistryService.GetFeature}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Feature resource.
        #     Format for entity_type as parent:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
        #     Format for feature_group as parent:
        #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
        class GetFeatureRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_features FeaturestoreService.ListFeatures}.
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#list_features FeatureRegistryService.ListFeatures}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to list Features.
        #     Format for entity_type as parent:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
        #     Format for feature_group as parent:
        #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the Features that match the filter expression. The following
        #     filters are supported:
        #
        #     * `value_type`: Supports = and != comparisons.
        #     * `create_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
        #     be in RFC 3339 format.
        #     * `update_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
        #     be in RFC 3339 format.
        #     * `labels`: Supports key-value equality as well as key presence.
        #
        #     Examples:
        #
        #     * `value_type = DOUBLE` --> Features whose type is DOUBLE.
        #     * `create_time > \"2020-01-31T15:30:00.000000Z\" OR
        #          update_time > \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created
        #          or updated after 2020-01-31T15:30:00.000000Z.
        #     * `labels.active = yes AND labels.env = prod` --> Features having both
        #         (active: yes) and (env: prod) labels.
        #     * `labels.env: *` --> Any Feature which has a label with 'env' as the
        #       key.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of Features to return. The service may return fewer
        #     than this value. If unspecified, at most 1000 Features will be returned.
        #     The maximum value is 1000; any value greater than 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_features FeaturestoreService.ListFeatures}
        #     call or
        #     {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#list_features FeatureRegistryService.ListFeatures}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_features FeaturestoreService.ListFeatures}
        #     or
        #     {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#list_features FeatureRegistryService.ListFeatures}
        #     must match the call that provided the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        #     Supported fields:
        #
        #       * `feature_id`
        #       * `value_type` (Not supported for FeatureRegistry Feature)
        #       * `create_time`
        #       * `update_time`
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        # @!attribute [rw] latest_stats_count
        #   @return [::Integer]
        #     Only applicable for Vertex AI Feature Store (Legacy).
        #     If set, return the most recent
        #     {::Google::Cloud::AIPlatform::V1::ListFeaturesRequest#latest_stats_count ListFeaturesRequest.latest_stats_count}
        #     of stats for each Feature in response. Valid value is [0, 10]. If number of
        #     stats exists <
        #     {::Google::Cloud::AIPlatform::V1::ListFeaturesRequest#latest_stats_count ListFeaturesRequest.latest_stats_count},
        #     return all existing stats.
        class ListFeaturesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_features FeaturestoreService.ListFeatures}.
        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#list_features FeatureRegistryService.ListFeatures}.
        # @!attribute [rw] features
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Feature>]
        #     The Features matching the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListFeaturesRequest#page_token ListFeaturesRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListFeaturesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#search_features FeaturestoreService.SearchFeatures}.
        # @!attribute [rw] location
        #   @return [::String]
        #     Required. The resource name of the Location to search Features.
        #     Format:
        #     `projects/{project}/locations/{location}`
        # @!attribute [rw] query
        #   @return [::String]
        #     Query string that is a conjunction of field-restricted queries and/or
        #     field-restricted filters.  Field-restricted queries and filters can be
        #     combined using `AND` to form a conjunction.
        #
        #     A field query is in the form FIELD:QUERY. This implicitly checks if QUERY
        #     exists as a substring within Feature's FIELD. The QUERY
        #     and the FIELD are converted to a sequence of words (i.e. tokens) for
        #     comparison. This is done by:
        #
        #       * Removing leading/trailing whitespace and tokenizing the search value.
        #       Characters that are not one of alphanumeric `[a-zA-Z0-9]`, underscore
        #       `_`, or asterisk `*` are treated as delimiters for tokens. `*` is treated
        #       as a wildcard that matches characters within a token.
        #       * Ignoring case.
        #       * Prepending an asterisk to the first and appending an asterisk to the
        #       last token in QUERY.
        #
        #     A QUERY must be either a singular token or a phrase. A phrase is one or
        #     multiple words enclosed in double quotation marks ("). With phrases, the
        #     order of the words is important. Words in the phrase must be matching in
        #     order and consecutively.
        #
        #     Supported FIELDs for field-restricted queries:
        #
        #     * `feature_id`
        #     * `description`
        #     * `entity_type_id`
        #
        #     Examples:
        #
        #     * `feature_id: foo` --> Matches a Feature with ID containing the substring
        #     `foo` (eg. `foo`, `foofeature`, `barfoo`).
        #     * `feature_id: foo*feature` --> Matches a Feature with ID containing the
        #     substring `foo*feature` (eg. `foobarfeature`).
        #     * `feature_id: foo AND description: bar` --> Matches a Feature with ID
        #     containing the substring `foo` and description containing the substring
        #     `bar`.
        #
        #     Besides field queries, the following exact-match filters are
        #     supported. The exact-match filters do not support wildcards. Unlike
        #     field-restricted queries, exact-match filters are case-sensitive.
        #
        #     * `feature_id`: Supports = comparisons.
        #     * `description`: Supports = comparisons. Multi-token filters should be
        #     enclosed in quotes.
        #     * `entity_type_id`: Supports = comparisons.
        #     * `value_type`: Supports = and != comparisons.
        #     * `labels`: Supports key-value equality as well as key presence.
        #     * `featurestore_id`: Supports = comparisons.
        #
        #     Examples:
        #
        #     * `description = "foo bar"` --> Any Feature with description exactly equal
        #     to `foo bar`
        #     * `value_type = DOUBLE` --> Features whose type is DOUBLE.
        #     * `labels.active = yes AND labels.env = prod` --> Features having both
        #         (active: yes) and (env: prod) labels.
        #     * `labels.env: *` --> Any Feature which has a label with `env` as the
        #       key.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of Features to return. The service may return fewer
        #     than this value. If unspecified, at most 100 Features will be returned.
        #     The maximum value is 100; any value greater than 100 will be coerced to
        #     100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#search_features FeaturestoreService.SearchFeatures}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#search_features FeaturestoreService.SearchFeatures},
        #     except `page_size`, must match the call that provided the page token.
        class SearchFeaturesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#search_features FeaturestoreService.SearchFeatures}.
        # @!attribute [rw] features
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Feature>]
        #     The Features matching the request.
        #
        #     Fields returned:
        #
        #      * `name`
        #      * `description`
        #      * `labels`
        #      * `create_time`
        #      * `update_time`
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::SearchFeaturesRequest#page_token SearchFeaturesRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class SearchFeaturesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#update_feature FeaturestoreService.UpdateFeature}.
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#update_feature FeatureRegistryService.UpdateFeature}.
        # @!attribute [rw] feature
        #   @return [::Google::Cloud::AIPlatform::V1::Feature]
        #     Required. The Feature's `name` field is used to identify the Feature to be
        #     updated.
        #     Format:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
        #     `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Field mask is used to specify the fields to be overwritten in the
        #     Features resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then only the non-empty fields present in the
        #     request will be overwritten. Set the update_mask to `*` to override all
        #     fields.
        #
        #     Updatable fields:
        #
        #       * `description`
        #       * `labels`
        #       * `disable_monitoring` (Not supported for FeatureRegistryService Feature)
        #       * `point_of_contact` (Not supported for FeaturestoreService FeatureStore)
        class UpdateFeatureRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#delete_feature FeaturestoreService.DeleteFeature}.
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#delete_feature FeatureRegistryService.DeleteFeature}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Features to be deleted.
        #     Format:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
        #     `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
        class DeleteFeatureRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform create Featurestore.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for Featurestore.
        class CreateFeaturestoreOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform update Featurestore.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for Featurestore.
        class UpdateFeaturestoreOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform import Feature values.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for Featurestore import Feature values.
        # @!attribute [rw] imported_entity_count
        #   @return [::Integer]
        #     Number of entities that have been imported by the operation.
        # @!attribute [rw] imported_feature_value_count
        #   @return [::Integer]
        #     Number of Feature values that have been imported by the operation.
        # @!attribute [rw] source_uris
        #   @return [::Array<::String>]
        #     The source URI from where Feature values are imported.
        # @!attribute [rw] invalid_row_count
        #   @return [::Integer]
        #     The number of rows in input source that weren't imported due to either
        #     * Not having any featureValues.
        #     * Having a null entityId.
        #     * Having a null timestamp.
        #     * Not being parsable (applicable for CSV sources).
        # @!attribute [rw] timestamp_outside_retention_rows_count
        #   @return [::Integer]
        #     The number rows that weren't ingested due to having timestamps outside the
        #     retention boundary.
        # @!attribute [rw] blocking_operation_ids
        #   @return [::Array<::Integer>]
        #     List of ImportFeatureValues operations running under a single EntityType
        #     that are blocking this operation.
        class ImportFeatureValuesOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that exports Features values.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for Featurestore export Feature values.
        class ExportFeatureValuesOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that batch reads Feature values.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for Featurestore batch read Features values.
        class BatchReadFeatureValuesOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that delete Feature values.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for Featurestore delete Features values.
        class DeleteFeatureValuesOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform create EntityType.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for EntityType.
        class CreateEntityTypeOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform create Feature.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for Feature.
        class CreateFeatureOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform batch create Features.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for Feature.
        class BatchCreateFeaturesOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#delete_feature_values FeaturestoreService.DeleteFeatureValues}.
        # @!attribute [rw] select_entity
        #   @return [::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesRequest::SelectEntity]
        #     Select feature values to be deleted by specifying entities.
        #
        #     Note: The following fields are mutually exclusive: `select_entity`, `select_time_range_and_feature`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] select_time_range_and_feature
        #   @return [::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesRequest::SelectTimeRangeAndFeature]
        #     Select feature values to be deleted by specifying time range and
        #     features.
        #
        #     Note: The following fields are mutually exclusive: `select_time_range_and_feature`, `select_entity`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] entity_type
        #   @return [::String]
        #     Required. The resource name of the EntityType grouping the Features for
        #     which values are being deleted from. Format:
        #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
        class DeleteFeatureValuesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Message to select entity.
          # If an entity id is selected, all the feature values corresponding to the
          # entity id will be deleted, including the entityId.
          # @!attribute [rw] entity_id_selector
          #   @return [::Google::Cloud::AIPlatform::V1::EntityIdSelector]
          #     Required. Selectors choosing feature values of which entity id to be
          #     deleted from the EntityType.
          class SelectEntity
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message to select time range and feature.
          # Values of the selected feature generated within an inclusive time range
          # will be deleted. Using this option permanently deletes the feature values
          # from the specified feature IDs within the specified time range.
          # This might include data from the online storage. If you want to retain
          # any deleted historical data in the online storage, you must re-ingest it.
          # @!attribute [rw] time_range
          #   @return [::Google::Type::Interval]
          #     Required. Select feature generated within a half-inclusive time range.
          #     The time range is lower inclusive and upper exclusive.
          # @!attribute [rw] feature_selector
          #   @return [::Google::Cloud::AIPlatform::V1::FeatureSelector]
          #     Required. Selectors choosing which feature values to be deleted from the
          #     EntityType.
          # @!attribute [rw] skip_online_storage_delete
          #   @return [::Boolean]
          #     If set, data will not be deleted from online storage.
          #     When time range is older than the data in online storage, setting this to
          #     be true will make the deletion have no impact on online serving.
          class SelectTimeRangeAndFeature
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#delete_feature_values FeaturestoreService.DeleteFeatureValues}.
        # @!attribute [rw] select_entity
        #   @return [::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesResponse::SelectEntity]
        #     Response for request specifying the entities to delete
        #
        #     Note: The following fields are mutually exclusive: `select_entity`, `select_time_range_and_feature`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] select_time_range_and_feature
        #   @return [::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesResponse::SelectTimeRangeAndFeature]
        #     Response for request specifying time range and feature
        #
        #     Note: The following fields are mutually exclusive: `select_time_range_and_feature`, `select_entity`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DeleteFeatureValuesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Response message if the request uses the SelectEntity option.
          # @!attribute [rw] offline_storage_deleted_entity_row_count
          #   @return [::Integer]
          #     The count of deleted entity rows in the offline storage.
          #     Each row corresponds to the combination of an entity ID and a timestamp.
          #     One entity ID can have multiple rows in the offline storage.
          # @!attribute [rw] online_storage_deleted_entity_count
          #   @return [::Integer]
          #     The count of deleted entities in the online storage.
          #     Each entity ID corresponds to one entity.
          class SelectEntity
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message if the request uses the SelectTimeRangeAndFeature option.
          # @!attribute [rw] impacted_feature_count
          #   @return [::Integer]
          #     The count of the features or columns impacted.
          #     This is the same as the feature count in the request.
          # @!attribute [rw] offline_storage_modified_entity_row_count
          #   @return [::Integer]
          #     The count of modified entity rows in the offline storage.
          #     Each row corresponds to the combination of an entity ID and a timestamp.
          #     One entity ID can have multiple rows in the offline storage.
          #     Within each row, only the features specified in the request are
          #     deleted.
          # @!attribute [rw] online_storage_modified_entity_count
          #   @return [::Integer]
          #     The count of modified entities in the online storage.
          #     Each entity ID corresponds to one entity.
          #     Within each entity, only the features specified in the request are
          #     deleted.
          class SelectTimeRangeAndFeature
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Selector for entityId. Getting ids from the given source.
        # @!attribute [rw] csv_source
        #   @return [::Google::Cloud::AIPlatform::V1::CsvSource]
        #     Source of Csv
        # @!attribute [rw] entity_id_field
        #   @return [::String]
        #     Source column that holds entity IDs. If not provided, entity IDs are
        #     extracted from the column named entity_id.
        class EntityIdSelector
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
