# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#create_feature_group FeatureRegistryService.CreateFeatureGroup}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to create FeatureGroups.
        #     Format:
        #     `projects/{project}/locations/{location}`
        # @!attribute [rw] feature_group
        #   @return [::Google::Cloud::AIPlatform::V1::FeatureGroup]
        #     Required. The FeatureGroup to create.
        # @!attribute [rw] feature_group_id
        #   @return [::String]
        #     Required. The ID to use for this FeatureGroup, which will become the final
        #     component of the FeatureGroup's resource name.
        #
        #     This value may be up to 128 characters, and valid characters are
        #     `[a-z0-9_]`. The first character cannot be a number.
        #
        #     The value must be unique within the project and location.
        class CreateFeatureGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#get_feature_group FeatureRegistryService.GetFeatureGroup}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the FeatureGroup resource.
        class GetFeatureGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#list_feature_groups FeatureRegistryService.ListFeatureGroups}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to list FeatureGroups.
        #     Format:
        #     `projects/{project}/locations/{location}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the FeatureGroups that match the filter expression. The
        #     following fields are supported:
        #
        #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
        #     Values must be
        #       in RFC 3339 format.
        #     * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
        #     Values must be
        #       in RFC 3339 format.
        #     * `labels`: Supports key-value equality and key presence.
        #
        #     Examples:
        #
        #     * `create_time > "2020-01-01" OR update_time > "2020-01-01"`
        #        FeatureGroups created or updated after 2020-01-01.
        #     * `labels.env = "prod"`
        #        FeatureGroups with label "env" set to "prod".
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of FeatureGroups to return. The service may return
        #     fewer than this value. If unspecified, at most 100 FeatureGroups will
        #     be returned. The maximum value is 100; any value greater than 100 will be
        #     coerced to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#list_feature_groups FeatureRegistryService.ListFeatureGroups}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#list_feature_groups FeatureRegistryService.ListFeatureGroups}
        #     must match the call that provided the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        #     Supported Fields:
        #
        #       * `create_time`
        #       * `update_time`
        class ListFeatureGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#list_feature_groups FeatureRegistryService.ListFeatureGroups}.
        # @!attribute [rw] feature_groups
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::FeatureGroup>]
        #     The FeatureGroups matching the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListFeatureGroupsRequest#page_token ListFeatureGroupsRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListFeatureGroupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#update_feature_group FeatureRegistryService.UpdateFeatureGroup}.
        # @!attribute [rw] feature_group
        #   @return [::Google::Cloud::AIPlatform::V1::FeatureGroup]
        #     Required. The FeatureGroup's `name` field is used to identify the
        #     FeatureGroup to be updated. Format:
        #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Field mask is used to specify the fields to be overwritten in the
        #     FeatureGroup resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then only the non-empty fields present in the
        #     request will be overwritten. Set the update_mask to `*` to override all
        #     fields.
        #
        #     Updatable fields:
        #
        #       * `labels`
        #       * `description`
        #       * `big_query`
        #       * `big_query.entity_id_columns`
        class UpdateFeatureGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#delete_feature_group FeatureRegistryService.DeleteFeatureGroup}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the FeatureGroup to be deleted.
        #     Format:
        #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     If set to true, any Features under this FeatureGroup
        #     will also be deleted. (Otherwise, the request will only work if the
        #     FeatureGroup has no Features.)
        class DeleteFeatureGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform create FeatureGroup.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for FeatureGroup.
        class CreateFeatureGroupOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform update FeatureGroup.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for FeatureGroup.
        class UpdateFeatureGroupOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform create FeatureGroup.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for Feature.
        class CreateRegistryFeatureOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform update Feature.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for Feature Update.
        class UpdateFeatureOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
