# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#create_feature_online_store FeatureOnlineStoreAdminService.CreateFeatureOnlineStore}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to create FeatureOnlineStores.
        #     Format:
        #     `projects/{project}/locations/{location}`
        # @!attribute [rw] feature_online_store
        #   @return [::Google::Cloud::AIPlatform::V1::FeatureOnlineStore]
        #     Required. The FeatureOnlineStore to create.
        # @!attribute [rw] feature_online_store_id
        #   @return [::String]
        #     Required. The ID to use for this FeatureOnlineStore, which will become the
        #     final component of the FeatureOnlineStore's resource name.
        #
        #     This value may be up to 60 characters, and valid characters are
        #     `[a-z0-9_]`. The first character cannot be a number.
        #
        #     The value must be unique within the project and location.
        class CreateFeatureOnlineStoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#get_feature_online_store FeatureOnlineStoreAdminService.GetFeatureOnlineStore}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the FeatureOnlineStore resource.
        class GetFeatureOnlineStoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_online_stores FeatureOnlineStoreAdminService.ListFeatureOnlineStores}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to list FeatureOnlineStores.
        #     Format:
        #     `projects/{project}/locations/{location}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the FeatureOnlineStores that match the filter expression. The
        #     following fields are supported:
        #
        #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
        #     Values must be
        #       in RFC 3339 format.
        #     * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
        #     Values must be
        #       in RFC 3339 format.
        #     * `labels`: Supports key-value equality and key presence.
        #
        #     Examples:
        #
        #     * `create_time > "2020-01-01" OR update_time > "2020-01-01"`
        #        FeatureOnlineStores created or updated after 2020-01-01.
        #     * `labels.env = "prod"`
        #        FeatureOnlineStores with label "env" set to "prod".
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of FeatureOnlineStores to return. The service may return
        #     fewer than this value. If unspecified, at most 100 FeatureOnlineStores will
        #     be returned. The maximum value is 100; any value greater than 100 will be
        #     coerced to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_online_stores FeatureOnlineStoreAdminService.ListFeatureOnlineStores}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_online_stores FeatureOnlineStoreAdminService.ListFeatureOnlineStores}
        #     must match the call that provided the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        #     Supported Fields:
        #
        #       * `create_time`
        #       * `update_time`
        class ListFeatureOnlineStoresRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_online_stores FeatureOnlineStoreAdminService.ListFeatureOnlineStores}.
        # @!attribute [rw] feature_online_stores
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::FeatureOnlineStore>]
        #     The FeatureOnlineStores matching the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListFeatureOnlineStoresRequest#page_token ListFeatureOnlineStoresRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListFeatureOnlineStoresResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#update_feature_online_store FeatureOnlineStoreAdminService.UpdateFeatureOnlineStore}.
        # @!attribute [rw] feature_online_store
        #   @return [::Google::Cloud::AIPlatform::V1::FeatureOnlineStore]
        #     Required. The FeatureOnlineStore's `name` field is used to identify the
        #     FeatureOnlineStore to be updated. Format:
        #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Field mask is used to specify the fields to be overwritten in the
        #     FeatureOnlineStore resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then only the non-empty fields present in the
        #     request will be overwritten. Set the update_mask to `*` to override all
        #     fields.
        #
        #     Updatable fields:
        #
        #       * `labels`
        #       * `description`
        #       * `bigtable`
        #       * `bigtable.auto_scaling`
        #       * `bigtable.enable_multi_region_replica`
        class UpdateFeatureOnlineStoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#delete_feature_online_store FeatureOnlineStoreAdminService.DeleteFeatureOnlineStore}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the FeatureOnlineStore to be deleted.
        #     Format:
        #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     If set to true, any FeatureViews and Features for this FeatureOnlineStore
        #     will also be deleted. (Otherwise, the request will only work if the
        #     FeatureOnlineStore has no FeatureViews.)
        class DeleteFeatureOnlineStoreRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#create_feature_view FeatureOnlineStoreAdminService.CreateFeatureView}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the FeatureOnlineStore to create
        #     FeatureViews. Format:
        #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
        # @!attribute [rw] feature_view
        #   @return [::Google::Cloud::AIPlatform::V1::FeatureView]
        #     Required. The FeatureView to create.
        # @!attribute [rw] feature_view_id
        #   @return [::String]
        #     Required. The ID to use for the FeatureView, which will become the final
        #     component of the FeatureView's resource name.
        #
        #     This value may be up to 60 characters, and valid characters are
        #     `[a-z0-9_]`. The first character cannot be a number.
        #
        #     The value must be unique within a FeatureOnlineStore.
        # @!attribute [rw] run_sync_immediately
        #   @return [::Boolean]
        #     Immutable. If set to true, one on demand sync will be run immediately,
        #     regardless whether the
        #     {::Google::Cloud::AIPlatform::V1::FeatureView#sync_config FeatureView.sync_config}
        #     is configured or not.
        class CreateFeatureViewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#get_feature_view FeatureOnlineStoreAdminService.GetFeatureView}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the FeatureView resource.
        #     Format:
        #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
        class GetFeatureViewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_views FeatureOnlineStoreAdminService.ListFeatureViews}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the FeatureOnlineStore to list FeatureViews.
        #     Format:
        #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the FeatureViews that match the filter expression. The following
        #     filters are supported:
        #
        #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
        #     Values must be in RFC 3339 format.
        #     * `update_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
        #     Values must be in RFC 3339 format.
        #     * `labels`: Supports key-value equality as well as key presence.
        #
        #     Examples:
        #
        #     * `create_time > \"2020-01-31T15:30:00.000000Z\" OR
        #          update_time > \"2020-01-31T15:30:00.000000Z\"` --> FeatureViews
        #          created or updated after 2020-01-31T15:30:00.000000Z.
        #     * `labels.active = yes AND labels.env = prod` --> FeatureViews having both
        #         (active: yes) and (env: prod) labels.
        #     * `labels.env: *` --> Any FeatureView which has a label with 'env' as the
        #       key.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of FeatureViews to return. The service may return fewer
        #     than this value. If unspecified, at most 1000 FeatureViews will be
        #     returned. The maximum value is 1000; any value greater than 1000 will be
        #     coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_views FeatureOnlineStoreAdminService.ListFeatureViews}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_views FeatureOnlineStoreAdminService.ListFeatureViews}
        #     must match the call that provided the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        #
        #     Supported fields:
        #
        #       * `feature_view_id`
        #       * `create_time`
        #       * `update_time`
        class ListFeatureViewsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_views FeatureOnlineStoreAdminService.ListFeatureViews}.
        # @!attribute [rw] feature_views
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::FeatureView>]
        #     The FeatureViews matching the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListFeatureViewsRequest#page_token ListFeatureViewsRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListFeatureViewsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#update_feature_view FeatureOnlineStoreAdminService.UpdateFeatureView}.
        # @!attribute [rw] feature_view
        #   @return [::Google::Cloud::AIPlatform::V1::FeatureView]
        #     Required. The FeatureView's `name` field is used to identify the
        #     FeatureView to be updated. Format:
        #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Field mask is used to specify the fields to be overwritten in the
        #     FeatureView resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then only the non-empty fields present in the
        #     request will be overwritten. Set the update_mask to `*` to override all
        #     fields.
        #
        #     Updatable fields:
        #
        #       * `labels`
        #       * `service_agent_type`
        #       * `big_query_source`
        #       * `big_query_source.uri`
        #       * `big_query_source.entity_id_columns`
        #       * `feature_registry_source`
        #       * `feature_registry_source.feature_groups`
        #       * `sync_config`
        #       * `sync_config.cron`
        #       * `optimized_config.automatic_resources`
        class UpdateFeatureViewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#delete_feature_view FeatureOnlineStoreAdminService.DeleteFeatureView}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the FeatureView to be deleted.
        #     Format:
        #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
        class DeleteFeatureViewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform create FeatureOnlineStore.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for FeatureOnlineStore.
        class CreateFeatureOnlineStoreOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform update FeatureOnlineStore.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for FeatureOnlineStore.
        class UpdateFeatureOnlineStoreOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform create FeatureView.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for FeatureView Create.
        class CreateFeatureViewOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform update FeatureView.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for FeatureView Update.
        class UpdateFeatureViewOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#sync_feature_view FeatureOnlineStoreAdminService.SyncFeatureView}.
        # @!attribute [rw] feature_view
        #   @return [::String]
        #     Required. Format:
        #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
        class SyncFeatureViewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#sync_feature_view FeatureOnlineStoreAdminService.SyncFeatureView}.
        # @!attribute [rw] feature_view_sync
        #   @return [::String]
        #     Format:
        #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
        class SyncFeatureViewResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#get_feature_view_sync FeatureOnlineStoreAdminService.GetFeatureViewSync}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the FeatureViewSync resource.
        #     Format:
        #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
        class GetFeatureViewSyncRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_view_syncs FeatureOnlineStoreAdminService.ListFeatureViewSyncs}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the FeatureView to list FeatureViewSyncs.
        #     Format:
        #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the FeatureViewSyncs that match the filter expression. The following
        #     filters are supported:
        #
        #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
        #     Values must be in RFC 3339 format.
        #
        #     Examples:
        #
        #     * `create_time > \"2020-01-31T15:30:00.000000Z\"` --> FeatureViewSyncs
        #          created after 2020-01-31T15:30:00.000000Z.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of FeatureViewSyncs to return. The service may return
        #     fewer than this value. If unspecified, at most 1000 FeatureViewSyncs will
        #     be returned. The maximum value is 1000; any value greater than 1000 will be
        #     coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_view_syncs FeatureOnlineStoreAdminService.ListFeatureViewSyncs}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_view_syncs FeatureOnlineStoreAdminService.ListFeatureViewSyncs}
        #     must match the call that provided the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        #
        #     Supported fields:
        #
        #       * `create_time`
        class ListFeatureViewSyncsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_view_syncs FeatureOnlineStoreAdminService.ListFeatureViewSyncs}.
        # @!attribute [rw] feature_view_syncs
        #   @return [::Array<::Google::Cloud::Aiplatform::V1::FeatureViewSync>]
        #     The FeatureViewSyncs matching the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListFeatureViewSyncsRequest#page_token ListFeatureViewSyncsRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListFeatureViewSyncsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
