# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # An edge describing the relationship between an Artifact and an Execution in
        # a lineage graph.
        # @!attribute [rw] artifact
        #   @return [::String]
        #     Required. The relative resource name of the Artifact in the Event.
        # @!attribute [r] execution
        #   @return [::String]
        #     Output only. The relative resource name of the Execution in the Event.
        # @!attribute [r] event_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the Event occurred.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::AIPlatform::V1::Event::Type]
        #     Required. The type of the Event.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels with user-defined metadata to annotate Events.
        #
        #     Label keys and values can be no longer than 64 characters
        #     (Unicode codepoints), can only contain lowercase letters, numeric
        #     characters, underscores and dashes. International characters are allowed.
        #     No more than 64 user labels can be associated with one Event (System
        #     labels are excluded).
        #
        #     See https://goo.gl/xmQnxf for more information and examples of labels.
        #     System reserved label keys are prefixed with "aiplatform.googleapis.com/"
        #     and are immutable.
        class Event
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Describes whether an Event's Artifact is the Execution's input or output.
          module Type
            # Unspecified whether input or output of the Execution.
            TYPE_UNSPECIFIED = 0

            # An input of the Execution.
            INPUT = 1

            # An output of the Execution.
            OUTPUT = 2
          end
        end
      end
    end
  end
end
