# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Request message for EvaluationService.EvaluateInstances.
        # @!attribute [rw] exact_match_input
        #   @return [::Google::Cloud::AIPlatform::V1::ExactMatchInput]
        #     Auto metric instances.
        #     Instances and metric spec for exact match metric.
        #
        #     Note: The following fields are mutually exclusive: `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bleu_input
        #   @return [::Google::Cloud::AIPlatform::V1::BleuInput]
        #     Instances and metric spec for bleu metric.
        #
        #     Note: The following fields are mutually exclusive: `bleu_input`, `exact_match_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] rouge_input
        #   @return [::Google::Cloud::AIPlatform::V1::RougeInput]
        #     Instances and metric spec for rouge metric.
        #
        #     Note: The following fields are mutually exclusive: `rouge_input`, `exact_match_input`, `bleu_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] fluency_input
        #   @return [::Google::Cloud::AIPlatform::V1::FluencyInput]
        #     LLM-based metric instance.
        #     General text generation metrics, applicable to other categories.
        #     Input for fluency metric.
        #
        #     Note: The following fields are mutually exclusive: `fluency_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] coherence_input
        #   @return [::Google::Cloud::AIPlatform::V1::CoherenceInput]
        #     Input for coherence metric.
        #
        #     Note: The following fields are mutually exclusive: `coherence_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] safety_input
        #   @return [::Google::Cloud::AIPlatform::V1::SafetyInput]
        #     Input for safety metric.
        #
        #     Note: The following fields are mutually exclusive: `safety_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] groundedness_input
        #   @return [::Google::Cloud::AIPlatform::V1::GroundednessInput]
        #     Input for groundedness metric.
        #
        #     Note: The following fields are mutually exclusive: `groundedness_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] fulfillment_input
        #   @return [::Google::Cloud::AIPlatform::V1::FulfillmentInput]
        #     Input for fulfillment metric.
        #
        #     Note: The following fields are mutually exclusive: `fulfillment_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] summarization_quality_input
        #   @return [::Google::Cloud::AIPlatform::V1::SummarizationQualityInput]
        #     Input for summarization quality metric.
        #
        #     Note: The following fields are mutually exclusive: `summarization_quality_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pairwise_summarization_quality_input
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseSummarizationQualityInput]
        #     Input for pairwise summarization quality metric.
        #
        #     Note: The following fields are mutually exclusive: `pairwise_summarization_quality_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] summarization_helpfulness_input
        #   @return [::Google::Cloud::AIPlatform::V1::SummarizationHelpfulnessInput]
        #     Input for summarization helpfulness metric.
        #
        #     Note: The following fields are mutually exclusive: `summarization_helpfulness_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] summarization_verbosity_input
        #   @return [::Google::Cloud::AIPlatform::V1::SummarizationVerbosityInput]
        #     Input for summarization verbosity metric.
        #
        #     Note: The following fields are mutually exclusive: `summarization_verbosity_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] question_answering_quality_input
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringQualityInput]
        #     Input for question answering quality metric.
        #
        #     Note: The following fields are mutually exclusive: `question_answering_quality_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pairwise_question_answering_quality_input
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseQuestionAnsweringQualityInput]
        #     Input for pairwise question answering quality metric.
        #
        #     Note: The following fields are mutually exclusive: `pairwise_question_answering_quality_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] question_answering_relevance_input
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringRelevanceInput]
        #     Input for question answering relevance metric.
        #
        #     Note: The following fields are mutually exclusive: `question_answering_relevance_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] question_answering_helpfulness_input
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringHelpfulnessInput]
        #     Input for question answering helpfulness
        #     metric.
        #
        #     Note: The following fields are mutually exclusive: `question_answering_helpfulness_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] question_answering_correctness_input
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringCorrectnessInput]
        #     Input for question answering correctness
        #     metric.
        #
        #     Note: The following fields are mutually exclusive: `question_answering_correctness_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pointwise_metric_input
        #   @return [::Google::Cloud::AIPlatform::V1::PointwiseMetricInput]
        #     Input for pointwise metric.
        #
        #     Note: The following fields are mutually exclusive: `pointwise_metric_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pairwise_metric_input
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseMetricInput]
        #     Input for pairwise metric.
        #
        #     Note: The following fields are mutually exclusive: `pairwise_metric_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tool_call_valid_input
        #   @return [::Google::Cloud::AIPlatform::V1::ToolCallValidInput]
        #     Tool call metric instances.
        #     Input for tool call valid metric.
        #
        #     Note: The following fields are mutually exclusive: `tool_call_valid_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tool_name_match_input
        #   @return [::Google::Cloud::AIPlatform::V1::ToolNameMatchInput]
        #     Input for tool name match metric.
        #
        #     Note: The following fields are mutually exclusive: `tool_name_match_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tool_parameter_key_match_input
        #   @return [::Google::Cloud::AIPlatform::V1::ToolParameterKeyMatchInput]
        #     Input for tool parameter key match metric.
        #
        #     Note: The following fields are mutually exclusive: `tool_parameter_key_match_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tool_parameter_kv_match_input
        #   @return [::Google::Cloud::AIPlatform::V1::ToolParameterKVMatchInput]
        #     Input for tool parameter key value match metric.
        #
        #     Note: The following fields are mutually exclusive: `tool_parameter_kv_match_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `comet_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] comet_input
        #   @return [::Google::Cloud::AIPlatform::V1::CometInput]
        #     Translation metrics.
        #     Input for Comet metric.
        #
        #     Note: The following fields are mutually exclusive: `comet_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `metricx_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] metricx_input
        #   @return [::Google::Cloud::AIPlatform::V1::MetricxInput]
        #     Input for Metricx metric.
        #
        #     Note: The following fields are mutually exclusive: `metricx_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] location
        #   @return [::String]
        #     Required. The resource name of the Location to evaluate the instances.
        #     Format: `projects/{project}/locations/{location}`
        class EvaluateInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for EvaluationService.EvaluateInstances.
        # @!attribute [rw] exact_match_results
        #   @return [::Google::Cloud::AIPlatform::V1::ExactMatchResults]
        #     Auto metric evaluation results.
        #     Results for exact match metric.
        #
        #     Note: The following fields are mutually exclusive: `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bleu_results
        #   @return [::Google::Cloud::AIPlatform::V1::BleuResults]
        #     Results for bleu metric.
        #
        #     Note: The following fields are mutually exclusive: `bleu_results`, `exact_match_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] rouge_results
        #   @return [::Google::Cloud::AIPlatform::V1::RougeResults]
        #     Results for rouge metric.
        #
        #     Note: The following fields are mutually exclusive: `rouge_results`, `exact_match_results`, `bleu_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] fluency_result
        #   @return [::Google::Cloud::AIPlatform::V1::FluencyResult]
        #     LLM-based metric evaluation result.
        #     General text generation metrics, applicable to other categories.
        #     Result for fluency metric.
        #
        #     Note: The following fields are mutually exclusive: `fluency_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] coherence_result
        #   @return [::Google::Cloud::AIPlatform::V1::CoherenceResult]
        #     Result for coherence metric.
        #
        #     Note: The following fields are mutually exclusive: `coherence_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] safety_result
        #   @return [::Google::Cloud::AIPlatform::V1::SafetyResult]
        #     Result for safety metric.
        #
        #     Note: The following fields are mutually exclusive: `safety_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] groundedness_result
        #   @return [::Google::Cloud::AIPlatform::V1::GroundednessResult]
        #     Result for groundedness metric.
        #
        #     Note: The following fields are mutually exclusive: `groundedness_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] fulfillment_result
        #   @return [::Google::Cloud::AIPlatform::V1::FulfillmentResult]
        #     Result for fulfillment metric.
        #
        #     Note: The following fields are mutually exclusive: `fulfillment_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] summarization_quality_result
        #   @return [::Google::Cloud::AIPlatform::V1::SummarizationQualityResult]
        #     Summarization only metrics.
        #     Result for summarization quality metric.
        #
        #     Note: The following fields are mutually exclusive: `summarization_quality_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pairwise_summarization_quality_result
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseSummarizationQualityResult]
        #     Result for pairwise summarization quality metric.
        #
        #     Note: The following fields are mutually exclusive: `pairwise_summarization_quality_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] summarization_helpfulness_result
        #   @return [::Google::Cloud::AIPlatform::V1::SummarizationHelpfulnessResult]
        #     Result for summarization helpfulness metric.
        #
        #     Note: The following fields are mutually exclusive: `summarization_helpfulness_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] summarization_verbosity_result
        #   @return [::Google::Cloud::AIPlatform::V1::SummarizationVerbosityResult]
        #     Result for summarization verbosity metric.
        #
        #     Note: The following fields are mutually exclusive: `summarization_verbosity_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] question_answering_quality_result
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringQualityResult]
        #     Question answering only metrics.
        #     Result for question answering quality metric.
        #
        #     Note: The following fields are mutually exclusive: `question_answering_quality_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pairwise_question_answering_quality_result
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseQuestionAnsweringQualityResult]
        #     Result for pairwise question answering quality metric.
        #
        #     Note: The following fields are mutually exclusive: `pairwise_question_answering_quality_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] question_answering_relevance_result
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringRelevanceResult]
        #     Result for question answering relevance metric.
        #
        #     Note: The following fields are mutually exclusive: `question_answering_relevance_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] question_answering_helpfulness_result
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringHelpfulnessResult]
        #     Result for question answering helpfulness metric.
        #
        #     Note: The following fields are mutually exclusive: `question_answering_helpfulness_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] question_answering_correctness_result
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringCorrectnessResult]
        #     Result for question answering correctness metric.
        #
        #     Note: The following fields are mutually exclusive: `question_answering_correctness_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pointwise_metric_result
        #   @return [::Google::Cloud::AIPlatform::V1::PointwiseMetricResult]
        #     Generic metrics.
        #     Result for pointwise metric.
        #
        #     Note: The following fields are mutually exclusive: `pointwise_metric_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pairwise_metric_result
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseMetricResult]
        #     Result for pairwise metric.
        #
        #     Note: The following fields are mutually exclusive: `pairwise_metric_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tool_call_valid_results
        #   @return [::Google::Cloud::AIPlatform::V1::ToolCallValidResults]
        #     Tool call metrics.
        #      Results for tool call valid metric.
        #
        #     Note: The following fields are mutually exclusive: `tool_call_valid_results`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tool_name_match_results
        #   @return [::Google::Cloud::AIPlatform::V1::ToolNameMatchResults]
        #     Results for tool name match metric.
        #
        #     Note: The following fields are mutually exclusive: `tool_name_match_results`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tool_parameter_key_match_results
        #   @return [::Google::Cloud::AIPlatform::V1::ToolParameterKeyMatchResults]
        #     Results for tool parameter key match  metric.
        #
        #     Note: The following fields are mutually exclusive: `tool_parameter_key_match_results`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_kv_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tool_parameter_kv_match_results
        #   @return [::Google::Cloud::AIPlatform::V1::ToolParameterKVMatchResults]
        #     Results for tool parameter key value match metric.
        #
        #     Note: The following fields are mutually exclusive: `tool_parameter_kv_match_results`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `comet_result`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] comet_result
        #   @return [::Google::Cloud::AIPlatform::V1::CometResult]
        #     Translation metrics.
        #     Result for Comet metric.
        #
        #     Note: The following fields are mutually exclusive: `comet_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `metricx_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] metricx_result
        #   @return [::Google::Cloud::AIPlatform::V1::MetricxResult]
        #     Result for Metricx metric.
        #
        #     Note: The following fields are mutually exclusive: `metricx_result`, `exact_match_results`, `bleu_results`, `rouge_results`, `fluency_result`, `coherence_result`, `safety_result`, `groundedness_result`, `fulfillment_result`, `summarization_quality_result`, `pairwise_summarization_quality_result`, `summarization_helpfulness_result`, `summarization_verbosity_result`, `question_answering_quality_result`, `pairwise_question_answering_quality_result`, `question_answering_relevance_result`, `question_answering_helpfulness_result`, `question_answering_correctness_result`, `pointwise_metric_result`, `pairwise_metric_result`, `tool_call_valid_results`, `tool_name_match_results`, `tool_parameter_key_match_results`, `tool_parameter_kv_match_results`, `comet_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class EvaluateInstancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for exact match metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::ExactMatchSpec]
        #     Required. Spec for exact match metric.
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ExactMatchInstance>]
        #     Required. Repeated exact match instances.
        class ExactMatchInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for exact match instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Required. Ground truth used to compare against the prediction.
        class ExactMatchInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for exact match metric - returns 1 if prediction and reference exactly
        # matches, otherwise 0.
        class ExactMatchSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Results for exact match metric.
        # @!attribute [r] exact_match_metric_values
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ExactMatchMetricValue>]
        #     Output only. Exact match metric values.
        class ExactMatchResults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Exact match metric value for an instance.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Exact match score.
        class ExactMatchMetricValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for bleu metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::BleuSpec]
        #     Required. Spec for bleu score metric.
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::BleuInstance>]
        #     Required. Repeated bleu instances.
        class BleuInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for bleu instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Required. Ground truth used to compare against the prediction.
        class BleuInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for bleu score metric - calculates the precision of n-grams in the
        # prediction as compared to reference - returns a score ranging between 0 to 1.
        # @!attribute [rw] use_effective_order
        #   @return [::Boolean]
        #     Optional. Whether to use_effective_order to compute bleu score.
        class BleuSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Results for bleu metric.
        # @!attribute [r] bleu_metric_values
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::BleuMetricValue>]
        #     Output only. Bleu metric values.
        class BleuResults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Bleu metric value for an instance.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Bleu score.
        class BleuMetricValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for rouge metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::RougeSpec]
        #     Required. Spec for rouge score metric.
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::RougeInstance>]
        #     Required. Repeated rouge instances.
        class RougeInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for rouge instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Required. Ground truth used to compare against the prediction.
        class RougeInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for rouge score metric - calculates the recall of n-grams in prediction
        # as compared to reference - returns a score ranging between 0 and 1.
        # @!attribute [rw] rouge_type
        #   @return [::String]
        #     Optional. Supported rouge types are rougen[1-9], rougeL, and rougeLsum.
        # @!attribute [rw] use_stemmer
        #   @return [::Boolean]
        #     Optional. Whether to use stemmer to compute rouge score.
        # @!attribute [rw] split_summaries
        #   @return [::Boolean]
        #     Optional. Whether to split summaries while using rougeLsum.
        class RougeSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Results for rouge metric.
        # @!attribute [r] rouge_metric_values
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::RougeMetricValue>]
        #     Output only. Rouge metric values.
        class RougeResults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Rouge metric value for an instance.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Rouge score.
        class RougeMetricValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for coherence metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::CoherenceSpec]
        #     Required. Spec for coherence score metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::CoherenceInstance]
        #     Required. Coherence instance.
        class CoherenceInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for coherence instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        class CoherenceInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for coherence score metric.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     Optional. Which version to use for evaluation.
        class CoherenceSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for coherence result.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Coherence score.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for coherence score.
        # @!attribute [r] confidence
        #   @return [::Float]
        #     Output only. Confidence for coherence score.
        class CoherenceResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for fluency metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::FluencySpec]
        #     Required. Spec for fluency score metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::FluencyInstance]
        #     Required. Fluency instance.
        class FluencyInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for fluency instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        class FluencyInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for fluency score metric.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     Optional. Which version to use for evaluation.
        class FluencySpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for fluency result.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Fluency score.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for fluency score.
        # @!attribute [r] confidence
        #   @return [::Float]
        #     Output only. Confidence for fluency score.
        class FluencyResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for safety metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::SafetySpec]
        #     Required. Spec for safety metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::SafetyInstance]
        #     Required. Safety instance.
        class SafetyInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for safety instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        class SafetyInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for safety metric.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     Optional. Which version to use for evaluation.
        class SafetySpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for safety result.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Safety score.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for safety score.
        # @!attribute [r] confidence
        #   @return [::Float]
        #     Output only. Confidence for safety score.
        class SafetyResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for groundedness metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::GroundednessSpec]
        #     Required. Spec for groundedness metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::GroundednessInstance]
        #     Required. Groundedness instance.
        class GroundednessInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for groundedness instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] context
        #   @return [::String]
        #     Required. Background information provided in context used to compare
        #     against the prediction.
        class GroundednessInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for groundedness metric.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     Optional. Which version to use for evaluation.
        class GroundednessSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for groundedness result.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Groundedness score.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for groundedness score.
        # @!attribute [r] confidence
        #   @return [::Float]
        #     Output only. Confidence for groundedness score.
        class GroundednessResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for fulfillment metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::FulfillmentSpec]
        #     Required. Spec for fulfillment score metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::FulfillmentInstance]
        #     Required. Fulfillment instance.
        class FulfillmentInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for fulfillment instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] instruction
        #   @return [::String]
        #     Required. Inference instruction prompt to compare prediction with.
        class FulfillmentInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for fulfillment metric.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     Optional. Which version to use for evaluation.
        class FulfillmentSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for fulfillment result.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Fulfillment score.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for fulfillment score.
        # @!attribute [r] confidence
        #   @return [::Float]
        #     Output only. Confidence for fulfillment score.
        class FulfillmentResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for summarization quality metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::SummarizationQualitySpec]
        #     Required. Spec for summarization quality score metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::SummarizationQualityInstance]
        #     Required. Summarization quality instance.
        class SummarizationQualityInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for summarization quality instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Optional. Ground truth used to compare against the prediction.
        # @!attribute [rw] context
        #   @return [::String]
        #     Required. Text to be summarized.
        # @!attribute [rw] instruction
        #   @return [::String]
        #     Required. Summarization prompt for LLM.
        class SummarizationQualityInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for summarization quality score metric.
        # @!attribute [rw] use_reference
        #   @return [::Boolean]
        #     Optional. Whether to use instance.reference to compute summarization
        #     quality.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     Optional. Which version to use for evaluation.
        class SummarizationQualitySpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for summarization quality result.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Summarization Quality score.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for summarization quality score.
        # @!attribute [r] confidence
        #   @return [::Float]
        #     Output only. Confidence for summarization quality score.
        class SummarizationQualityResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for pairwise summarization quality metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseSummarizationQualitySpec]
        #     Required. Spec for pairwise summarization quality score metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseSummarizationQualityInstance]
        #     Required. Pairwise summarization quality instance.
        class PairwiseSummarizationQualityInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for pairwise summarization quality instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the candidate model.
        # @!attribute [rw] baseline_prediction
        #   @return [::String]
        #     Required. Output of the baseline model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Optional. Ground truth used to compare against the prediction.
        # @!attribute [rw] context
        #   @return [::String]
        #     Required. Text to be summarized.
        # @!attribute [rw] instruction
        #   @return [::String]
        #     Required. Summarization prompt for LLM.
        class PairwiseSummarizationQualityInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for pairwise summarization quality score metric.
        # @!attribute [rw] use_reference
        #   @return [::Boolean]
        #     Optional. Whether to use instance.reference to compute pairwise
        #     summarization quality.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     Optional. Which version to use for evaluation.
        class PairwiseSummarizationQualitySpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for pairwise summarization quality result.
        # @!attribute [r] pairwise_choice
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseChoice]
        #     Output only. Pairwise summarization prediction choice.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for summarization quality score.
        # @!attribute [r] confidence
        #   @return [::Float]
        #     Output only. Confidence for summarization quality score.
        class PairwiseSummarizationQualityResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for summarization helpfulness metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::SummarizationHelpfulnessSpec]
        #     Required. Spec for summarization helpfulness score metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::SummarizationHelpfulnessInstance]
        #     Required. Summarization helpfulness instance.
        class SummarizationHelpfulnessInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for summarization helpfulness instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Optional. Ground truth used to compare against the prediction.
        # @!attribute [rw] context
        #   @return [::String]
        #     Required. Text to be summarized.
        # @!attribute [rw] instruction
        #   @return [::String]
        #     Optional. Summarization prompt for LLM.
        class SummarizationHelpfulnessInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for summarization helpfulness score metric.
        # @!attribute [rw] use_reference
        #   @return [::Boolean]
        #     Optional. Whether to use instance.reference to compute summarization
        #     helpfulness.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     Optional. Which version to use for evaluation.
        class SummarizationHelpfulnessSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for summarization helpfulness result.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Summarization Helpfulness score.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for summarization helpfulness score.
        # @!attribute [r] confidence
        #   @return [::Float]
        #     Output only. Confidence for summarization helpfulness score.
        class SummarizationHelpfulnessResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for summarization verbosity metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::SummarizationVerbositySpec]
        #     Required. Spec for summarization verbosity score metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::SummarizationVerbosityInstance]
        #     Required. Summarization verbosity instance.
        class SummarizationVerbosityInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for summarization verbosity instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Optional. Ground truth used to compare against the prediction.
        # @!attribute [rw] context
        #   @return [::String]
        #     Required. Text to be summarized.
        # @!attribute [rw] instruction
        #   @return [::String]
        #     Optional. Summarization prompt for LLM.
        class SummarizationVerbosityInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for summarization verbosity score metric.
        # @!attribute [rw] use_reference
        #   @return [::Boolean]
        #     Optional. Whether to use instance.reference to compute summarization
        #     verbosity.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     Optional. Which version to use for evaluation.
        class SummarizationVerbositySpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for summarization verbosity result.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Summarization Verbosity score.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for summarization verbosity score.
        # @!attribute [r] confidence
        #   @return [::Float]
        #     Output only. Confidence for summarization verbosity score.
        class SummarizationVerbosityResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for question answering quality metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringQualitySpec]
        #     Required. Spec for question answering quality score metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringQualityInstance]
        #     Required. Question answering quality instance.
        class QuestionAnsweringQualityInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for question answering quality instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Optional. Ground truth used to compare against the prediction.
        # @!attribute [rw] context
        #   @return [::String]
        #     Required. Text to answer the question.
        # @!attribute [rw] instruction
        #   @return [::String]
        #     Required. Question Answering prompt for LLM.
        class QuestionAnsweringQualityInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for question answering quality score metric.
        # @!attribute [rw] use_reference
        #   @return [::Boolean]
        #     Optional. Whether to use instance.reference to compute question answering
        #     quality.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     Optional. Which version to use for evaluation.
        class QuestionAnsweringQualitySpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for question answering quality result.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Question Answering Quality score.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for question answering quality score.
        # @!attribute [r] confidence
        #   @return [::Float]
        #     Output only. Confidence for question answering quality score.
        class QuestionAnsweringQualityResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for pairwise question answering quality metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseQuestionAnsweringQualitySpec]
        #     Required. Spec for pairwise question answering quality score metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseQuestionAnsweringQualityInstance]
        #     Required. Pairwise question answering quality instance.
        class PairwiseQuestionAnsweringQualityInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for pairwise question answering quality instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the candidate model.
        # @!attribute [rw] baseline_prediction
        #   @return [::String]
        #     Required. Output of the baseline model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Optional. Ground truth used to compare against the prediction.
        # @!attribute [rw] context
        #   @return [::String]
        #     Required. Text to answer the question.
        # @!attribute [rw] instruction
        #   @return [::String]
        #     Required. Question Answering prompt for LLM.
        class PairwiseQuestionAnsweringQualityInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for pairwise question answering quality score metric.
        # @!attribute [rw] use_reference
        #   @return [::Boolean]
        #     Optional. Whether to use instance.reference to compute question answering
        #     quality.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     Optional. Which version to use for evaluation.
        class PairwiseQuestionAnsweringQualitySpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for pairwise question answering quality result.
        # @!attribute [r] pairwise_choice
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseChoice]
        #     Output only. Pairwise question answering prediction choice.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for question answering quality score.
        # @!attribute [r] confidence
        #   @return [::Float]
        #     Output only. Confidence for question answering quality score.
        class PairwiseQuestionAnsweringQualityResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for question answering relevance metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringRelevanceSpec]
        #     Required. Spec for question answering relevance score metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringRelevanceInstance]
        #     Required. Question answering relevance instance.
        class QuestionAnsweringRelevanceInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for question answering relevance instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Optional. Ground truth used to compare against the prediction.
        # @!attribute [rw] context
        #   @return [::String]
        #     Optional. Text provided as context to answer the question.
        # @!attribute [rw] instruction
        #   @return [::String]
        #     Required. The question asked and other instruction in the inference prompt.
        class QuestionAnsweringRelevanceInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for question answering relevance metric.
        # @!attribute [rw] use_reference
        #   @return [::Boolean]
        #     Optional. Whether to use instance.reference to compute question answering
        #     relevance.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     Optional. Which version to use for evaluation.
        class QuestionAnsweringRelevanceSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for question answering relevance result.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Question Answering Relevance score.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for question answering relevance score.
        # @!attribute [r] confidence
        #   @return [::Float]
        #     Output only. Confidence for question answering relevance score.
        class QuestionAnsweringRelevanceResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for question answering helpfulness metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringHelpfulnessSpec]
        #     Required. Spec for question answering helpfulness score metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringHelpfulnessInstance]
        #     Required. Question answering helpfulness instance.
        class QuestionAnsweringHelpfulnessInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for question answering helpfulness instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Optional. Ground truth used to compare against the prediction.
        # @!attribute [rw] context
        #   @return [::String]
        #     Optional. Text provided as context to answer the question.
        # @!attribute [rw] instruction
        #   @return [::String]
        #     Required. The question asked and other instruction in the inference prompt.
        class QuestionAnsweringHelpfulnessInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for question answering helpfulness metric.
        # @!attribute [rw] use_reference
        #   @return [::Boolean]
        #     Optional. Whether to use instance.reference to compute question answering
        #     helpfulness.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     Optional. Which version to use for evaluation.
        class QuestionAnsweringHelpfulnessSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for question answering helpfulness result.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Question Answering Helpfulness score.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for question answering helpfulness score.
        # @!attribute [r] confidence
        #   @return [::Float]
        #     Output only. Confidence for question answering helpfulness score.
        class QuestionAnsweringHelpfulnessResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for question answering correctness metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringCorrectnessSpec]
        #     Required. Spec for question answering correctness score metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::QuestionAnsweringCorrectnessInstance]
        #     Required. Question answering correctness instance.
        class QuestionAnsweringCorrectnessInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for question answering correctness instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Optional. Ground truth used to compare against the prediction.
        # @!attribute [rw] context
        #   @return [::String]
        #     Optional. Text provided as context to answer the question.
        # @!attribute [rw] instruction
        #   @return [::String]
        #     Required. The question asked and other instruction in the inference prompt.
        class QuestionAnsweringCorrectnessInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for question answering correctness metric.
        # @!attribute [rw] use_reference
        #   @return [::Boolean]
        #     Optional. Whether to use instance.reference to compute question answering
        #     correctness.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     Optional. Which version to use for evaluation.
        class QuestionAnsweringCorrectnessSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for question answering correctness result.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Question Answering Correctness score.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for question answering correctness score.
        # @!attribute [r] confidence
        #   @return [::Float]
        #     Output only. Confidence for question answering correctness score.
        class QuestionAnsweringCorrectnessResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for pointwise metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::PointwiseMetricSpec]
        #     Required. Spec for pointwise metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::PointwiseMetricInstance]
        #     Required. Pointwise metric instance.
        class PointwiseMetricInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Pointwise metric instance. Usually one instance corresponds to one row in an
        # evaluation dataset.
        # @!attribute [rw] json_instance
        #   @return [::String]
        #     Instance specified as a json string. String key-value pairs are expected
        #     in the json_instance to render
        #     PointwiseMetricSpec.instance_prompt_template.
        class PointwiseMetricInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for pointwise metric.
        # @!attribute [rw] metric_prompt_template
        #   @return [::String]
        #     Required. Metric prompt template for pointwise metric.
        class PointwiseMetricSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for pointwise metric result.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Pointwise metric score.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for pointwise metric score.
        class PointwiseMetricResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for pairwise metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseMetricSpec]
        #     Required. Spec for pairwise metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseMetricInstance]
        #     Required. Pairwise metric instance.
        class PairwiseMetricInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Pairwise metric instance. Usually one instance corresponds to one row in an
        # evaluation dataset.
        # @!attribute [rw] json_instance
        #   @return [::String]
        #     Instance specified as a json string. String key-value pairs are expected
        #     in the json_instance to render
        #     PairwiseMetricSpec.instance_prompt_template.
        class PairwiseMetricInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for pairwise metric.
        # @!attribute [rw] metric_prompt_template
        #   @return [::String]
        #     Required. Metric prompt template for pairwise metric.
        class PairwiseMetricSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for pairwise metric result.
        # @!attribute [r] pairwise_choice
        #   @return [::Google::Cloud::AIPlatform::V1::PairwiseChoice]
        #     Output only. Pairwise metric choice.
        # @!attribute [r] explanation
        #   @return [::String]
        #     Output only. Explanation for pairwise metric score.
        class PairwiseMetricResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for tool call valid metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::ToolCallValidSpec]
        #     Required. Spec for tool call valid metric.
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ToolCallValidInstance>]
        #     Required. Repeated tool call valid instances.
        class ToolCallValidInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for tool call valid metric.
        class ToolCallValidSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for tool call valid instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Required. Ground truth used to compare against the prediction.
        class ToolCallValidInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Results for tool call valid metric.
        # @!attribute [r] tool_call_valid_metric_values
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ToolCallValidMetricValue>]
        #     Output only. Tool call valid metric values.
        class ToolCallValidResults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Tool call valid metric value for an instance.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Tool call valid score.
        class ToolCallValidMetricValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for tool name match metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::ToolNameMatchSpec]
        #     Required. Spec for tool name match metric.
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ToolNameMatchInstance>]
        #     Required. Repeated tool name match instances.
        class ToolNameMatchInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for tool name match metric.
        class ToolNameMatchSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for tool name match instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Required. Ground truth used to compare against the prediction.
        class ToolNameMatchInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Results for tool name match metric.
        # @!attribute [r] tool_name_match_metric_values
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ToolNameMatchMetricValue>]
        #     Output only. Tool name match metric values.
        class ToolNameMatchResults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Tool name match metric value for an instance.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Tool name match score.
        class ToolNameMatchMetricValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for tool parameter key match metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::ToolParameterKeyMatchSpec]
        #     Required. Spec for tool parameter key match metric.
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ToolParameterKeyMatchInstance>]
        #     Required. Repeated tool parameter key match instances.
        class ToolParameterKeyMatchInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for tool parameter key match metric.
        class ToolParameterKeyMatchSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for tool parameter key match instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Required. Ground truth used to compare against the prediction.
        class ToolParameterKeyMatchInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Results for tool parameter key match metric.
        # @!attribute [r] tool_parameter_key_match_metric_values
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ToolParameterKeyMatchMetricValue>]
        #     Output only. Tool parameter key match metric values.
        class ToolParameterKeyMatchResults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Tool parameter key match metric value for an instance.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Tool parameter key match score.
        class ToolParameterKeyMatchMetricValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for tool parameter key value match metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::ToolParameterKVMatchSpec]
        #     Required. Spec for tool parameter key value match metric.
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ToolParameterKVMatchInstance>]
        #     Required. Repeated tool parameter key value match instances.
        class ToolParameterKVMatchInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for tool parameter key value match metric.
        # @!attribute [rw] use_strict_string_match
        #   @return [::Boolean]
        #     Optional. Whether to use STRICT string match on parameter values.
        class ToolParameterKVMatchSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for tool parameter key value match instance.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Required. Ground truth used to compare against the prediction.
        class ToolParameterKVMatchInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Results for tool parameter key value match metric.
        # @!attribute [r] tool_parameter_kv_match_metric_values
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ToolParameterKVMatchMetricValue>]
        #     Output only. Tool parameter key value match metric values.
        class ToolParameterKVMatchResults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Tool parameter key value match metric value for an instance.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Tool parameter key value match score.
        class ToolParameterKVMatchMetricValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for Comet metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::CometSpec]
        #     Required. Spec for comet metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::CometInstance]
        #     Required. Comet instance.
        class CometInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for Comet metric.
        # @!attribute [rw] version
        #   @return [::Google::Cloud::AIPlatform::V1::CometSpec::CometVersion]
        #     Required. Which version to use for evaluation.
        # @!attribute [rw] source_language
        #   @return [::String]
        #     Optional. Source language in BCP-47 format.
        # @!attribute [rw] target_language
        #   @return [::String]
        #     Optional. Target language in BCP-47 format. Covers both prediction and
        #     reference.
        class CometSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Comet version options.
          module CometVersion
            # Comet version unspecified.
            COMET_VERSION_UNSPECIFIED = 0

            # Comet 22 for translation + source + reference
            # (source-reference-combined).
            COMET_22_SRC_REF = 2
          end
        end

        # Spec for Comet instance - The fields used for evaluation are dependent on the
        # comet version.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Optional. Ground truth used to compare against the prediction.
        # @!attribute [rw] source
        #   @return [::String]
        #     Optional. Source text in original language.
        class CometInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for Comet result - calculates the comet score for the given instance
        # using the version specified in the spec.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Comet score. Range depends on version.
        class CometResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for MetricX metric.
        # @!attribute [rw] metric_spec
        #   @return [::Google::Cloud::AIPlatform::V1::MetricxSpec]
        #     Required. Spec for Metricx metric.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AIPlatform::V1::MetricxInstance]
        #     Required. Metricx instance.
        class MetricxInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for MetricX metric.
        # @!attribute [rw] version
        #   @return [::Google::Cloud::AIPlatform::V1::MetricxSpec::MetricxVersion]
        #     Required. Which version to use for evaluation.
        # @!attribute [rw] source_language
        #   @return [::String]
        #     Optional. Source language in BCP-47 format.
        # @!attribute [rw] target_language
        #   @return [::String]
        #     Optional. Target language in BCP-47 format. Covers both prediction and
        #     reference.
        class MetricxSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # MetricX Version options.
          module MetricxVersion
            # MetricX version unspecified.
            METRICX_VERSION_UNSPECIFIED = 0

            # MetricX 2024 (2.6) for translation + reference (reference-based).
            METRICX_24_REF = 1

            # MetricX 2024 (2.6) for translation + source (QE).
            METRICX_24_SRC = 2

            # MetricX 2024 (2.6) for translation + source + reference
            # (source-reference-combined).
            METRICX_24_SRC_REF = 3
          end
        end

        # Spec for MetricX instance - The fields used for evaluation are dependent on
        # the MetricX version.
        # @!attribute [rw] prediction
        #   @return [::String]
        #     Required. Output of the evaluated model.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Optional. Ground truth used to compare against the prediction.
        # @!attribute [rw] source
        #   @return [::String]
        #     Optional. Source text in original language.
        class MetricxInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Spec for MetricX result - calculates the MetricX score for the given instance
        # using the version specified in the spec.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. MetricX score. Range depends on version.
        class MetricxResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Pairwise prediction autorater preference.
        module PairwiseChoice
          # Unspecified prediction choice.
          PAIRWISE_CHOICE_UNSPECIFIED = 0

          # Baseline prediction wins
          BASELINE = 1

          # Candidate prediction wins
          CANDIDATE = 2

          # Winner cannot be determined
          TIE = 3
        end
      end
    end
  end
end
