# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # True positive, false positive, or false negative.
        #
        # EvaluatedAnnotation is only available under ModelEvaluationSlice with slice
        # of `annotationSpec` dimension.
        # @!attribute [r] type
        #   @return [::Google::Cloud::AIPlatform::V1::EvaluatedAnnotation::EvaluatedAnnotationType]
        #     Output only. Type of the EvaluatedAnnotation.
        # @!attribute [r] predictions
        #   @return [::Array<::Google::Protobuf::Value>]
        #     Output only. The model predicted annotations.
        #
        #     For true positive, there is one and only one prediction, which matches the
        #     only one ground truth annotation in
        #     {::Google::Cloud::AIPlatform::V1::EvaluatedAnnotation#ground_truths ground_truths}.
        #
        #     For false positive, there is one and only one prediction, which doesn't
        #     match any ground truth annotation of the corresponding
        #     {::Google::Cloud::AIPlatform::V1::EvaluatedAnnotation#evaluated_data_item_view_id data_item_view_id}.
        #
        #     For false negative, there are zero or more predictions which are similar to
        #     the only ground truth annotation in
        #     {::Google::Cloud::AIPlatform::V1::EvaluatedAnnotation#ground_truths ground_truths}
        #     but not enough for a match.
        #
        #     The schema of the prediction is stored in
        #     {::Google::Cloud::AIPlatform::V1::ModelEvaluation#annotation_schema_uri ModelEvaluation.annotation_schema_uri}
        # @!attribute [r] ground_truths
        #   @return [::Array<::Google::Protobuf::Value>]
        #     Output only. The ground truth Annotations, i.e. the Annotations that exist
        #     in the test data the Model is evaluated on.
        #
        #     For true positive, there is one and only one ground truth annotation, which
        #     matches the only prediction in
        #     {::Google::Cloud::AIPlatform::V1::EvaluatedAnnotation#predictions predictions}.
        #
        #     For false positive, there are zero or more ground truth annotations that
        #     are similar to the only prediction in
        #     {::Google::Cloud::AIPlatform::V1::EvaluatedAnnotation#predictions predictions},
        #     but not enough for a match.
        #
        #     For false negative, there is one and only one ground truth annotation,
        #     which doesn't match any predictions created by the model.
        #
        #     The schema of the ground truth is stored in
        #     {::Google::Cloud::AIPlatform::V1::ModelEvaluation#annotation_schema_uri ModelEvaluation.annotation_schema_uri}
        # @!attribute [r] data_item_payload
        #   @return [::Google::Protobuf::Value]
        #     Output only. The data item payload that the Model predicted this
        #     EvaluatedAnnotation on.
        # @!attribute [r] evaluated_data_item_view_id
        #   @return [::String]
        #     Output only. ID of the EvaluatedDataItemView under the same ancestor
        #     ModelEvaluation. The EvaluatedDataItemView consists of all ground truths
        #     and predictions on
        #     {::Google::Cloud::AIPlatform::V1::EvaluatedAnnotation#data_item_payload data_item_payload}.
        # @!attribute [rw] explanations
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::EvaluatedAnnotationExplanation>]
        #     Explanations of
        #     {::Google::Cloud::AIPlatform::V1::EvaluatedAnnotation#predictions predictions}.
        #     Each element of the explanations indicates the explanation for one
        #     explanation Method.
        #
        #     The attributions list in the
        #     {::Google::Cloud::AIPlatform::V1::EvaluatedAnnotationExplanation#explanation EvaluatedAnnotationExplanation.explanation}
        #     object corresponds to the
        #     {::Google::Cloud::AIPlatform::V1::EvaluatedAnnotation#predictions predictions}
        #     list. For example, the second element in the attributions list explains the
        #     second element in the predictions list.
        # @!attribute [rw] error_analysis_annotations
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ErrorAnalysisAnnotation>]
        #     Annotations of model error analysis results.
        class EvaluatedAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes the type of the EvaluatedAnnotation. The type is determined
          module EvaluatedAnnotationType
            # Invalid value.
            EVALUATED_ANNOTATION_TYPE_UNSPECIFIED = 0

            # The EvaluatedAnnotation is a true positive. It has a prediction created
            # by the Model and a ground truth Annotation which the prediction matches.
            TRUE_POSITIVE = 1

            # The EvaluatedAnnotation is false positive. It has a prediction created by
            # the Model which does not match any ground truth annotation.
            FALSE_POSITIVE = 2

            # The EvaluatedAnnotation is false negative. It has a ground truth
            # annotation which is not matched by any of the model created predictions.
            FALSE_NEGATIVE = 3
          end
        end

        # Explanation result of the prediction produced by the Model.
        # @!attribute [rw] explanation_type
        #   @return [::String]
        #     Explanation type.
        #
        #     For AutoML Image Classification models, possible values are:
        #
        #       * `image-integrated-gradients`
        #       * `image-xrai`
        # @!attribute [rw] explanation
        #   @return [::Google::Cloud::AIPlatform::V1::Explanation]
        #     Explanation attribution response details.
        class EvaluatedAnnotationExplanation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Model error analysis for each annotation.
        # @!attribute [rw] attributed_items
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ErrorAnalysisAnnotation::AttributedItem>]
        #     Attributed items for a given annotation, typically representing neighbors
        #     from the training sets constrained by the query type.
        # @!attribute [rw] query_type
        #   @return [::Google::Cloud::AIPlatform::V1::ErrorAnalysisAnnotation::QueryType]
        #     The query type used for finding the attributed items.
        # @!attribute [rw] outlier_score
        #   @return [::Float]
        #     The outlier score of this annotated item. Usually defined as the min of all
        #     distances from attributed items.
        # @!attribute [rw] outlier_threshold
        #   @return [::Float]
        #     The threshold used to determine if this annotation is an outlier or not.
        class ErrorAnalysisAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Attributed items for a given annotation, typically representing neighbors
          # from the training sets constrained by the query type.
          # @!attribute [rw] annotation_resource_name
          #   @return [::String]
          #     The unique ID for each annotation. Used by FE to allocate the annotation
          #     in DB.
          # @!attribute [rw] distance
          #   @return [::Float]
          #     The distance of this item to the annotation.
          class AttributedItem
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The query type used for finding the attributed items.
          module QueryType
            # Unspecified query type for model error analysis.
            QUERY_TYPE_UNSPECIFIED = 0

            # Query similar samples across all classes in the dataset.
            ALL_SIMILAR = 1

            # Query similar samples from the same class of the input sample.
            SAME_CLASS_SIMILAR = 2

            # Query dissimilar samples from the same class of the input sample.
            SAME_CLASS_DISSIMILAR = 3
          end
        end
      end
    end
  end
end
