# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Represents an environment variable present in a Container or Python Module.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the environment variable. Must be a valid C identifier.
        # @!attribute [rw] value
        #   @return [::String]
        #     Required. Variables that reference a $(VAR_NAME) are expanded
        #     using the previous defined environment variables in the container and
        #     any service environment variables. If a variable cannot be resolved,
        #     the reference in the input string will be unchanged. The $(VAR_NAME)
        #     syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
        #     references will never be expanded, regardless of whether the variable
        #     exists or not.
        class EnvVar
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Reference to a secret stored in the Cloud Secret Manager that will
        # provide the value for this environment variable.
        # @!attribute [rw] secret
        #   @return [::String]
        #     Required. The name of the secret in Cloud Secret Manager.
        #     Format: \\{secret_name}.
        # @!attribute [rw] version
        #   @return [::String]
        #     The Cloud Secret Manager secret version.
        #     Can be 'latest' for the latest version, an integer for a specific
        #     version, or a version alias.
        class SecretRef
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an environment variable where the value is a secret in Cloud
        # Secret Manager.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the secret environment variable.
        # @!attribute [rw] secret_ref
        #   @return [::Google::Cloud::AIPlatform::V1::SecretRef]
        #     Required. Reference to a secret stored in the Cloud Secret Manager that
        #     will provide the value for this environment variable.
        class SecretEnvVar
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
