# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Request message for CreateDeploymentResourcePool method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent location resource where this DeploymentResourcePool
        #     will be created. Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] deployment_resource_pool
        #   @return [::Google::Cloud::AIPlatform::V1::DeploymentResourcePool]
        #     Required. The DeploymentResourcePool to create.
        # @!attribute [rw] deployment_resource_pool_id
        #   @return [::String]
        #     Required. The ID to use for the DeploymentResourcePool, which
        #     will become the final component of the DeploymentResourcePool's resource
        #     name.
        #
        #     The maximum length is 63 characters, and valid characters
        #     are `/^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$/`.
        class CreateDeploymentResourcePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Runtime operation information for CreateDeploymentResourcePool method.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     The operation generic information.
        class CreateDeploymentResourcePoolOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetDeploymentResourcePool method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DeploymentResourcePool to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
        class GetDeploymentResourcePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListDeploymentResourcePools method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent Location which owns this collection of
        #     DeploymentResourcePools. Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of DeploymentResourcePools to return. The service may
        #     return fewer than this value.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListDeploymentResourcePools` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListDeploymentResourcePools` must match the call that provided the page
        #     token.
        class ListDeploymentResourcePoolsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListDeploymentResourcePools method.
        # @!attribute [rw] deployment_resource_pools
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::DeploymentResourcePool>]
        #     The DeploymentResourcePools from the specified location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDeploymentResourcePoolsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateDeploymentResourcePool method.
        # @!attribute [rw] deployment_resource_pool
        #   @return [::Google::Cloud::AIPlatform::V1::DeploymentResourcePool]
        #     Required. The DeploymentResourcePool to update.
        #
        #     The DeploymentResourcePool's `name` field is used to identify the
        #     DeploymentResourcePool to update.
        #     Format:
        #     `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateDeploymentResourcePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Runtime operation information for UpdateDeploymentResourcePool method.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     The operation generic information.
        class UpdateDeploymentResourcePoolOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteDeploymentResourcePool method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DeploymentResourcePool to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
        class DeleteDeploymentResourcePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for QueryDeployedModels method.
        # @!attribute [rw] deployment_resource_pool
        #   @return [::String]
        #     Required. The name of the target DeploymentResourcePool to query.
        #     Format:
        #     `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of DeployedModels to return. The service may return
        #     fewer than this value.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `QueryDeployedModels` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `QueryDeployedModels` must match the call that provided the page
        #     token.
        class QueryDeployedModelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for QueryDeployedModels method.
        # @!attribute [rw] deployed_models
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::DeployedModel>]
        #     DEPRECATED Use deployed_model_refs instead.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] deployed_model_refs
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::DeployedModelRef>]
        #     References to the DeployedModels that share the specified
        #     deploymentResourcePool.
        # @!attribute [rw] total_deployed_model_count
        #   @return [::Integer]
        #     The total number of DeployedModels on this DeploymentResourcePool.
        # @!attribute [rw] total_endpoint_count
        #   @return [::Integer]
        #     The total number of Endpoints that have DeployedModels on this
        #     DeploymentResourcePool.
        class QueryDeployedModelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
