# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#create_dataset DatasetService.CreateDataset}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to create the Dataset in.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] dataset
        #   @return [::Google::Cloud::AIPlatform::V1::Dataset]
        #     Required. The Dataset to create.
        class CreateDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Runtime operation information for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#create_dataset DatasetService.CreateDataset}.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     The operation generic information.
        class CreateDatasetOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#get_dataset DatasetService.GetDataset}.
        # Next ID: 4
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Dataset resource.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        class GetDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#update_dataset DatasetService.UpdateDataset}.
        # @!attribute [rw] dataset
        #   @return [::Google::Cloud::AIPlatform::V1::Dataset]
        #     Required. The Dataset which replaces the resource on the server.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The update mask applies to the resource.
        #     For the `FieldMask` definition, see
        #     {::Google::Protobuf::FieldMask google.protobuf.FieldMask}. Updatable fields:
        #
        #       * `display_name`
        #       * `description`
        #       * `labels`
        class UpdateDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#update_dataset_version DatasetService.UpdateDatasetVersion}.
        # @!attribute [rw] dataset_version
        #   @return [::Google::Cloud::AIPlatform::V1::DatasetVersion]
        #     Required. The DatasetVersion which replaces the resource on the server.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The update mask applies to the resource.
        #     For the `FieldMask` definition, see
        #     {::Google::Protobuf::FieldMask google.protobuf.FieldMask}. Updatable fields:
        #
        #       * `display_name`
        class UpdateDatasetVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#list_datasets DatasetService.ListDatasets}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the Dataset's parent resource.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression for filtering the results of the request. For field names
        #     both snake_case and camelCase are supported.
        #
        #       * `display_name`: supports = and !=
        #       * `metadata_schema_uri`: supports = and !=
        #       * `labels` supports general map functions that is:
        #         * `labels.key=value` - key:value equality
        #         * `labels.key:* or labels:key - key existence
        #         * A key including a space must be quoted. `labels."a key"`.
        #
        #     Some examples:
        #
        #       * `displayName="myDisplayName"`
        #       * `labels.myKey="myValue"`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The standard list page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The standard list page token.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        #     Supported fields:
        #
        #       * `display_name`
        #       * `create_time`
        #       * `update_time`
        class ListDatasetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#list_datasets DatasetService.ListDatasets}.
        # @!attribute [rw] datasets
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Dataset>]
        #     A list of Datasets that matches the specified filter in the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The standard List next-page token.
        class ListDatasetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#delete_dataset DatasetService.DeleteDataset}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Dataset to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}`
        class DeleteDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#import_data DatasetService.ImportData}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Dataset resource.
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}`
        # @!attribute [rw] import_configs
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ImportDataConfig>]
        #     Required. The desired input locations. The contents of all input locations
        #     will be imported in one batch.
        class ImportDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#import_data DatasetService.ImportData}.
        class ImportDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Runtime operation information for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#import_data DatasetService.ImportData}.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     The common part of the operation metadata.
        class ImportDataOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#export_data DatasetService.ExportData}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Dataset resource.
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}`
        # @!attribute [rw] export_config
        #   @return [::Google::Cloud::AIPlatform::V1::ExportDataConfig]
        #     Required. The desired output location.
        class ExportDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#export_data DatasetService.ExportData}.
        # @!attribute [rw] exported_files
        #   @return [::Array<::String>]
        #     All of the files that are exported in this export operation. For custom
        #     code training export, only three (training, validation and test)
        #     Cloud Storage paths in wildcard format are populated
        #     (for example, gs://.../training-*).
        # @!attribute [rw] data_stats
        #   @return [::Google::Cloud::AIPlatform::V1::Model::DataStats]
        #     Only present for custom code training export use case. Records data stats,
        #     i.e., train/validation/test item/annotation counts calculated during
        #     the export operation.
        class ExportDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Runtime operation information for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#export_data DatasetService.ExportData}.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     The common part of the operation metadata.
        # @!attribute [rw] gcs_output_directory
        #   @return [::String]
        #     A Google Cloud Storage directory which path ends with '/'. The exported
        #     data is stored in the directory.
        class ExportDataOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#create_dataset_version DatasetService.CreateDatasetVersion}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the Dataset resource.
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}`
        # @!attribute [rw] dataset_version
        #   @return [::Google::Cloud::AIPlatform::V1::DatasetVersion]
        #     Required. The version to be created. The same CMEK policies with the
        #     original Dataset will be applied the dataset version. So here we don't need
        #     to specify the EncryptionSpecType here.
        class CreateDatasetVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Runtime operation information for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#create_dataset_version DatasetService.CreateDatasetVersion}.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     The common part of the operation metadata.
        class CreateDatasetVersionOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#delete_dataset_version DatasetService.DeleteDatasetVersion}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Dataset version to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}`
        class DeleteDatasetVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#get_dataset_version DatasetService.GetDatasetVersion}.
        # Next ID: 4
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Dataset version to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}`
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        class GetDatasetVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#list_dataset_versions DatasetService.ListDatasetVersions}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Dataset to list DatasetVersions from.
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The standard list filter.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The standard list page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The standard list page token.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Mask specifying which fields to read.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. A comma-separated list of fields to order by, sorted in ascending
        #     order. Use "desc" after a field name for descending.
        class ListDatasetVersionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#list_dataset_versions DatasetService.ListDatasetVersions}.
        # @!attribute [rw] dataset_versions
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::DatasetVersion>]
        #     A list of DatasetVersions that matches the specified filter in the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The standard List next-page token.
        class ListDatasetVersionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#restore_dataset_version DatasetService.RestoreDatasetVersion}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DatasetVersion resource.
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}`
        class RestoreDatasetVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Runtime operation information for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#restore_dataset_version DatasetService.RestoreDatasetVersion}.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     The common part of the operation metadata.
        class RestoreDatasetVersionOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#list_data_items DatasetService.ListDataItems}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Dataset to list DataItems from.
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     The standard list filter.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The standard list page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The standard list page token.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        class ListDataItemsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#list_data_items DatasetService.ListDataItems}.
        # @!attribute [rw] data_items
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::DataItem>]
        #     A list of DataItems that matches the specified filter in the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The standard List next-page token.
        class ListDataItemsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#search_data_items DatasetService.SearchDataItems}.
        # @!attribute [rw] order_by_data_item
        #   @return [::String]
        #     A comma-separated list of data item fields to order by, sorted in
        #     ascending order. Use "desc" after a field name for descending.
        #
        #     Note: The following fields are mutually exclusive: `order_by_data_item`, `order_by_annotation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] order_by_annotation
        #   @return [::Google::Cloud::AIPlatform::V1::SearchDataItemsRequest::OrderByAnnotation]
        #     Expression that allows ranking results based on annotation's property.
        #
        #     Note: The following fields are mutually exclusive: `order_by_annotation`, `order_by_data_item`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] dataset
        #   @return [::String]
        #     Required. The resource name of the Dataset from which to search DataItems.
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}`
        # @!attribute [rw] saved_query
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     The resource name of a SavedQuery(annotation set in UI).
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
        #     All of the search will be done in the context of this SavedQuery.
        # @!attribute [rw] data_labeling_job
        #   @return [::String]
        #     The resource name of a DataLabelingJob.
        #     Format:
        #     `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
        #     If this field is set, all of the search will be done in the context of
        #     this DataLabelingJob.
        # @!attribute [rw] data_item_filter
        #   @return [::String]
        #     An expression for filtering the DataItem that will be returned.
        #
        #       * `data_item_id` - for = or !=.
        #       * `labeled` - for = or !=.
        #       * `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that
        #         have at least one annotation with annotation_spec_id =
        #         `ANNOTATION_SPEC_ID` in the context of SavedQuery or DataLabelingJob.
        #
        #     For example:
        #
        #     * `data_item=1`
        #     * `has_annotation(5)`
        # @!attribute [rw] annotations_filter
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     An expression for filtering the Annotations that will be returned per
        #     DataItem.
        #       * `annotation_spec_id` - for = or !=.
        # @!attribute [rw] annotation_filters
        #   @return [::Array<::String>]
        #     An expression that specifies what Annotations will be returned per
        #     DataItem. Annotations satisfied either of the conditions will be returned.
        #       * `annotation_spec_id` - for = or !=.
        #     Must specify `saved_query_id=` - saved query id that annotations should
        #     belong to.
        # @!attribute [rw] field_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields of
        #     {::Google::Cloud::AIPlatform::V1::DataItemView DataItemView} to read.
        # @!attribute [rw] annotations_limit
        #   @return [::Integer]
        #     If set, only up to this many of Annotations will be returned per
        #     DataItemView. The maximum value is 1000. If not set, the maximum value will
        #     be used.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer results than requested.
        #     Default and maximum page size is 100.
        # @!attribute [rw] order_by
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results for the server to return
        #     Typically obtained via
        #     {::Google::Cloud::AIPlatform::V1::SearchDataItemsResponse#next_page_token SearchDataItemsResponse.next_page_token}
        #     of the previous
        #     {::Google::Cloud::AIPlatform::V1::DatasetService::Client#search_data_items DatasetService.SearchDataItems}
        #     call.
        class SearchDataItemsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Expression that allows ranking results based on annotation's property.
          # @!attribute [rw] saved_query
          #   @return [::String]
          #     Required. Saved query of the Annotation. Only Annotations belong to this
          #     saved query will be considered for ordering.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     A comma-separated list of annotation fields to order by, sorted in
          #     ascending order. Use "desc" after a field name for descending. Must also
          #     specify saved_query.
          class OrderByAnnotation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#search_data_items DatasetService.SearchDataItems}.
        # @!attribute [rw] data_item_views
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::DataItemView>]
        #     The DataItemViews read.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve next page of results.
        #     Pass to
        #     {::Google::Cloud::AIPlatform::V1::SearchDataItemsRequest#page_token SearchDataItemsRequest.page_token}
        #     to obtain that page.
        class SearchDataItemsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A container for a single DataItem and Annotations on it.
        # @!attribute [rw] data_item
        #   @return [::Google::Cloud::AIPlatform::V1::DataItem]
        #     The DataItem.
        # @!attribute [rw] annotations
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Annotation>]
        #     The Annotations on the DataItem. If too many Annotations should be returned
        #     for the DataItem, this field will be truncated per annotations_limit in
        #     request. If it was, then the has_truncated_annotations will be set to true.
        # @!attribute [rw] has_truncated_annotations
        #   @return [::Boolean]
        #     True if and only if the Annotations field has been truncated. It happens if
        #     more Annotations for this DataItem met the request's annotation_filter than
        #     are allowed to be returned by annotations_limit.
        #     Note that if Annotations field is not being returned due to field mask,
        #     then this field will not be set to true no matter how many Annotations are
        #     there.
        class DataItemView
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#list_saved_queries DatasetService.ListSavedQueries}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Dataset to list SavedQueries from.
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     The standard list filter.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The standard list page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The standard list page token.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        class ListSavedQueriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#list_saved_queries DatasetService.ListSavedQueries}.
        # @!attribute [rw] saved_queries
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::SavedQuery>]
        #     A list of SavedQueries that match the specified filter in the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The standard List next-page token.
        class ListSavedQueriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#delete_saved_query DatasetService.DeleteSavedQuery}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the SavedQuery to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
        class DeleteSavedQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#get_annotation_spec DatasetService.GetAnnotationSpec}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the AnnotationSpec resource.
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}/annotationSpecs/{annotation_spec}`
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        class GetAnnotationSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#list_annotations DatasetService.ListAnnotations}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the DataItem to list Annotations from.
        #     Format:
        #     `projects/{project}/locations/{location}/datasets/{dataset}/dataItems/{data_item}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     The standard list filter.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The standard list page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The standard list page token.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by, sorted in ascending order.
        #     Use "desc" after a field name for descending.
        class ListAnnotationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::DatasetService::Client#list_annotations DatasetService.ListAnnotations}.
        # @!attribute [rw] annotations
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Annotation>]
        #     A list of Annotations that matches the specified filter in the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The standard List next-page token.
        class ListAnnotationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
