# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Request message for DataFoundryService.GenerateSyntheticData.
        # @!attribute [rw] task_description
        #   @return [::Google::Cloud::AIPlatform::V1::TaskDescriptionStrategy]
        #     Generate data from a high-level task description.
        # @!attribute [rw] location
        #   @return [::String]
        #     Required. The resource name of the Location to run the job.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] count
        #   @return [::Integer]
        #     Required. The number of synthetic examples to generate.
        #     For this stateless API, the count is limited to a small number.
        # @!attribute [rw] output_field_specs
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::OutputFieldSpec>]
        #     Required. The schema of the desired output, defined by a list of fields.
        # @!attribute [rw] examples
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::SyntheticExample>]
        #     Optional. A list of few-shot examples to guide the model's output style
        #     and format.
        class GenerateSyntheticDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a single named field within a SyntheticExample.
        # @!attribute [rw] field_name
        #   @return [::String]
        #     Optional. The name of the field.
        # @!attribute [rw] content
        #   @return [::Google::Cloud::AIPlatform::V1::Content]
        #     Required. The content of the field.
        class SyntheticField
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a single synthetic example, composed of multiple fields.
        # Used for providing few-shot examples in the request and for returning
        # generated examples in the response.
        # @!attribute [rw] fields
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::SyntheticField>]
        #     Required. A list of fields that constitute an example.
        class SyntheticExample
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines a specification for a single output field.
        # @!attribute [rw] field_name
        #   @return [::String]
        #     Required. The name of the output field.
        # @!attribute [rw] guidance
        #   @return [::String]
        #     Optional. Optional, but recommended. Additional guidance specific to this
        #     field to provide targeted instructions for the LLM to generate the content
        #     of a single output field. While the LLM can sometimes infer content from
        #     the field name, providing explicit guidance is preferred.
        # @!attribute [rw] field_type
        #   @return [::Google::Cloud::AIPlatform::V1::OutputFieldSpec::FieldType]
        #     Optional. The data type of the field. Defaults to CONTENT if not set.
        class OutputFieldSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The data type of the field.
          module FieldType
            # Field type is unspecified.
            FIELD_TYPE_UNSPECIFIED = 0

            # Arbitrary content field type.
            CONTENT = 1

            # Text field type.
            TEXT = 2

            # Image field type.
            IMAGE = 3

            # Audio field type.
            AUDIO = 4
          end
        end

        # Defines a generation strategy based on a high-level task description.
        # @!attribute [rw] task_description
        #   @return [::String]
        #     Required. A high-level description of the synthetic data to be generated.
        class TaskDescriptionStrategy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response containing the generated data.
        # @!attribute [rw] synthetic_examples
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::SyntheticExample>]
        #     A list of generated synthetic examples.
        class GenerateSyntheticDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
