# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Instance of a general context.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The resource name of the Context.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User provided display name of the Context.
        #     May be up to 128 Unicode characters.
        # @!attribute [rw] etag
        #   @return [::String]
        #     An eTag used to perform consistent read-modify-write updates. If not set, a
        #     blind "overwrite" update happens.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels with user-defined metadata to organize your Contexts.
        #
        #     Label keys and values can be no longer than 64 characters
        #     (Unicode codepoints), can only contain lowercase letters, numeric
        #     characters, underscores and dashes. International characters are allowed.
        #     No more than 64 user labels can be associated with one Context (System
        #     labels are excluded).
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this Context was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this Context was last updated.
        # @!attribute [r] parent_contexts
        #   @return [::Array<::String>]
        #     Output only. A list of resource names of Contexts that are parents of this
        #     Context. A Context may have at most 10 parent_contexts.
        # @!attribute [rw] schema_title
        #   @return [::String]
        #     The title of the schema describing the metadata.
        #
        #     Schema title and version is expected to be registered in earlier Create
        #     Schema calls. And both are used together as unique identifiers to identify
        #     schemas within the local metadata store.
        # @!attribute [rw] schema_version
        #   @return [::String]
        #     The version of the schema in schema_name to use.
        #
        #     Schema title and version is expected to be registered in earlier Create
        #     Schema calls. And both are used together as unique identifiers to identify
        #     schemas within the local metadata store.
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Struct]
        #     Properties of the Context.
        #     Top level metadata keys' heading and trailing spaces will be trimmed.
        #     The size of this field should not exceed 200KB.
        # @!attribute [rw] description
        #   @return [::String]
        #     Description of the Context
        class Context
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
