# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # A resource used in LLM queries for users to explicitly specify what to cache
        # and how to cache.
        # @!attribute [rw] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp of when this resource is considered expired.
        #     This is *always* provided on output, regardless of what was sent
        #     on input.
        #
        #     Note: The following fields are mutually exclusive: `expire_time`, `ttl`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] ttl
        #   @return [::Google::Protobuf::Duration]
        #     Input only. The TTL for this resource. The expiration time is computed:
        #     now + TTL.
        #
        #     Note: The following fields are mutually exclusive: `ttl`, `expire_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. Identifier. The server-generated resource name of the cached
        #     content Format:
        #     projects/\\{project}/locations/\\{location}/cachedContents/\\{cached_content}
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Immutable. The user-generated meaningful display name of the
        #     cached content.
        # @!attribute [rw] model
        #   @return [::String]
        #     Immutable. The name of the `Model` to use for cached content. Currently,
        #     only the published Gemini base models are supported, in form of
        #     projects/\\{PROJECT}/locations/\\{LOCATION}/publishers/google/models/\\{MODEL}
        # @!attribute [rw] system_instruction
        #   @return [::Google::Cloud::AIPlatform::V1::Content]
        #     Optional. Input only. Immutable. Developer set system instruction.
        #     Currently, text only
        # @!attribute [rw] contents
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Content>]
        #     Optional. Input only. Immutable. The content to cache
        # @!attribute [rw] tools
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Tool>]
        #     Optional. Input only. Immutable. A list of `Tools` the model may use to
        #     generate the next response
        # @!attribute [rw] tool_config
        #   @return [::Google::Cloud::AIPlatform::V1::ToolConfig]
        #     Optional. Input only. Immutable. Tool config. This config is shared for all
        #     tools
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of the cache entry.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When the cache entry was last updated in UTC time.
        # @!attribute [r] usage_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::CachedContent::UsageMetadata]
        #     Output only. Metadata on the usage of the cached content.
        # @!attribute [rw] encryption_spec
        #   @return [::Google::Cloud::AIPlatform::V1::EncryptionSpec]
        #     Input only. Immutable. Customer-managed encryption key spec for a
        #     `CachedContent`. If set, this `CachedContent` and all its sub-resources
        #     will be secured by this key.
        class CachedContent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Metadata on the usage of the cached content.
          # @!attribute [rw] total_token_count
          #   @return [::Integer]
          #     Total number of tokens that the cached content consumes.
          # @!attribute [rw] text_count
          #   @return [::Integer]
          #     Number of text characters.
          # @!attribute [rw] image_count
          #   @return [::Integer]
          #     Number of images.
          # @!attribute [rw] video_duration_seconds
          #   @return [::Integer]
          #     Duration of video in seconds.
          # @!attribute [rw] audio_duration_seconds
          #   @return [::Integer]
          #     Duration of audio in seconds.
          class UsageMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
