# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/aiplatform/v1/vizier_service.proto for package 'Google.Cloud.AIPlatform.V1'
# Original file comments:
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/aiplatform/v1/vizier_service_pb'

module Google
  module Cloud
    module AIPlatform
      module V1
        module VizierService
          # Vertex AI Vizier API.
          #
          # Vertex AI Vizier is a service to solve blackbox optimization problems,
          # such as tuning machine learning hyperparameters and searching over deep
          # learning architectures.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.aiplatform.v1.VizierService'

            # Creates a Study. A resource name will be generated after creation of the
            # Study.
            rpc :CreateStudy, ::Google::Cloud::AIPlatform::V1::CreateStudyRequest, ::Google::Cloud::AIPlatform::V1::Study
            # Gets a Study by name.
            rpc :GetStudy, ::Google::Cloud::AIPlatform::V1::GetStudyRequest, ::Google::Cloud::AIPlatform::V1::Study
            # Lists all the studies in a region for an associated project.
            rpc :ListStudies, ::Google::Cloud::AIPlatform::V1::ListStudiesRequest, ::Google::Cloud::AIPlatform::V1::ListStudiesResponse
            # Deletes a Study.
            rpc :DeleteStudy, ::Google::Cloud::AIPlatform::V1::DeleteStudyRequest, ::Google::Protobuf::Empty
            # Looks a study up using the user-defined display_name field instead of the
            # fully qualified resource name.
            rpc :LookupStudy, ::Google::Cloud::AIPlatform::V1::LookupStudyRequest, ::Google::Cloud::AIPlatform::V1::Study
            # Adds one or more Trials to a Study, with parameter values
            # suggested by Vertex AI Vizier. Returns a long-running
            # operation associated with the generation of Trial suggestions.
            # When this long-running operation succeeds, it will contain
            # a
            # [SuggestTrialsResponse][google.cloud.aiplatform.v1.SuggestTrialsResponse].
            rpc :SuggestTrials, ::Google::Cloud::AIPlatform::V1::SuggestTrialsRequest, ::Google::Longrunning::Operation
            # Adds a user provided Trial to a Study.
            rpc :CreateTrial, ::Google::Cloud::AIPlatform::V1::CreateTrialRequest, ::Google::Cloud::AIPlatform::V1::Trial
            # Gets a Trial.
            rpc :GetTrial, ::Google::Cloud::AIPlatform::V1::GetTrialRequest, ::Google::Cloud::AIPlatform::V1::Trial
            # Lists the Trials associated with a Study.
            rpc :ListTrials, ::Google::Cloud::AIPlatform::V1::ListTrialsRequest, ::Google::Cloud::AIPlatform::V1::ListTrialsResponse
            # Adds a measurement of the objective metrics to a Trial. This measurement
            # is assumed to have been taken before the Trial is complete.
            rpc :AddTrialMeasurement, ::Google::Cloud::AIPlatform::V1::AddTrialMeasurementRequest, ::Google::Cloud::AIPlatform::V1::Trial
            # Marks a Trial as complete.
            rpc :CompleteTrial, ::Google::Cloud::AIPlatform::V1::CompleteTrialRequest, ::Google::Cloud::AIPlatform::V1::Trial
            # Deletes a Trial.
            rpc :DeleteTrial, ::Google::Cloud::AIPlatform::V1::DeleteTrialRequest, ::Google::Protobuf::Empty
            # Checks  whether a Trial should stop or not. Returns a
            # long-running operation. When the operation is successful,
            # it will contain a
            # [CheckTrialEarlyStoppingStateResponse][google.cloud.aiplatform.v1.CheckTrialEarlyStoppingStateResponse].
            rpc :CheckTrialEarlyStoppingState, ::Google::Cloud::AIPlatform::V1::CheckTrialEarlyStoppingStateRequest, ::Google::Longrunning::Operation
            # Stops a Trial.
            rpc :StopTrial, ::Google::Cloud::AIPlatform::V1::StopTrialRequest, ::Google::Cloud::AIPlatform::V1::Trial
            # Lists the pareto-optimal Trials for multi-objective Study or the
            # optimal Trials for single-objective Study. The definition of
            # pareto-optimal can be checked in wiki page.
            # https://en.wikipedia.org/wiki/Pareto_efficiency
            rpc :ListOptimalTrials, ::Google::Cloud::AIPlatform::V1::ListOptimalTrialsRequest, ::Google::Cloud::AIPlatform::V1::ListOptimalTrialsResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
