# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/vizier_service_pb"
require "google/cloud/ai_platform/v1/vizier_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module AIPlatform
      module V1
        module VizierService
          module Rest
            ##
            # REST client for the VizierService service.
            #
            # Vertex AI Vizier API.
            #
            # Vertex AI Vizier is a service to solve blackbox optimization problems,
            # such as tuning machine learning hyperparameters and searching over deep
            # learning architectures.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :vizier_service_stub

              ##
              # Configure the VizierService Client class.
              #
              # See {::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all VizierService clients
              #   ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the VizierService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @vizier_service_stub.universe_domain
              end

              ##
              # Create a new VizierService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the VizierService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @vizier_service_stub = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @vizier_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @vizier_service_stub.endpoint
                  config.universe_domain = @vizier_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @vizier_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @vizier_service_stub.endpoint
                  config.universe_domain = @vizier_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @vizier_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::AIPlatform::V1::VizierService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @vizier_service_stub.logger
              end

              # Service calls

              ##
              # Creates a Study. A resource name will be generated after creation of the
              # Study.
              #
              # @overload create_study(request, options = nil)
              #   Pass arguments to `create_study` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::CreateStudyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::CreateStudyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_study(parent: nil, study: nil)
              #   Pass arguments to `create_study` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Location to create the CustomJob in.
              #     Format: `projects/{project}/locations/{location}`
              #   @param study [::Google::Cloud::AIPlatform::V1::Study, ::Hash]
              #     Required. The Study configuration used to create the Study.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::Study]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::Study]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::CreateStudyRequest.new
              #
              #   # Call the create_study method.
              #   result = client.create_study request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::Study.
              #   p result
              #
              def create_study request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateStudyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_study.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_study.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_study.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.create_study request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a Study by name.
              #
              # @overload get_study(request, options = nil)
              #   Pass arguments to `get_study` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::GetStudyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::GetStudyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_study(name: nil)
              #   Pass arguments to `get_study` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Study resource.
              #     Format: `projects/{project}/locations/{location}/studies/{study}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::Study]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::Study]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::GetStudyRequest.new
              #
              #   # Call the get_study method.
              #   result = client.get_study request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::Study.
              #   p result
              #
              def get_study request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetStudyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_study.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_study.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_study.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.get_study request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the studies in a region for an associated project.
              #
              # @overload list_studies(request, options = nil)
              #   Pass arguments to `list_studies` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListStudiesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListStudiesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_studies(parent: nil, page_token: nil, page_size: nil)
              #   Pass arguments to `list_studies` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Location to list the Study from.
              #     Format: `projects/{project}/locations/{location}`
              #   @param page_token [::String]
              #     Optional. A page token to request the next page of results.
              #     If unspecified, there are no subsequent pages.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of studies to return per "page" of results.
              #     If unspecified, service will pick an appropriate default.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Study>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Study>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListStudiesRequest.new
              #
              #   # Call the list_studies method.
              #   result = client.list_studies request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Study.
              #     p item
              #   end
              #
              def list_studies request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListStudiesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_studies.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_studies.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_studies.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.list_studies request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vizier_service_stub, :list_studies, "studies", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a Study.
              #
              # @overload delete_study(request, options = nil)
              #   Pass arguments to `delete_study` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::DeleteStudyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::DeleteStudyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_study(name: nil)
              #   Pass arguments to `delete_study` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Study resource to be deleted.
              #     Format: `projects/{project}/locations/{location}/studies/{study}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::DeleteStudyRequest.new
              #
              #   # Call the delete_study method.
              #   result = client.delete_study request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_study request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteStudyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_study.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_study.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_study.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.delete_study request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Looks a study up using the user-defined display_name field instead of the
              # fully qualified resource name.
              #
              # @overload lookup_study(request, options = nil)
              #   Pass arguments to `lookup_study` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::LookupStudyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::LookupStudyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload lookup_study(parent: nil, display_name: nil)
              #   Pass arguments to `lookup_study` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Location to get the Study from.
              #     Format: `projects/{project}/locations/{location}`
              #   @param display_name [::String]
              #     Required. The user-defined display name of the Study
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::Study]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::Study]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::LookupStudyRequest.new
              #
              #   # Call the lookup_study method.
              #   result = client.lookup_study request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::Study.
              #   p result
              #
              def lookup_study request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::LookupStudyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.lookup_study.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.lookup_study.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.lookup_study.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.lookup_study request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Adds one or more Trials to a Study, with parameter values
              # suggested by Vertex AI Vizier. Returns a long-running
              # operation associated with the generation of Trial suggestions.
              # When this long-running operation succeeds, it will contain
              # a
              # {::Google::Cloud::AIPlatform::V1::SuggestTrialsResponse SuggestTrialsResponse}.
              #
              # @overload suggest_trials(request, options = nil)
              #   Pass arguments to `suggest_trials` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::SuggestTrialsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::SuggestTrialsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload suggest_trials(parent: nil, suggestion_count: nil, client_id: nil, contexts: nil)
              #   Pass arguments to `suggest_trials` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project and location that the Study belongs to.
              #     Format: `projects/{project}/locations/{location}/studies/{study}`
              #   @param suggestion_count [::Integer]
              #     Required. The number of suggestions requested. It must be positive.
              #   @param client_id [::String]
              #     Required. The identifier of the client that is requesting the suggestion.
              #
              #     If multiple SuggestTrialsRequests have the same `client_id`,
              #     the service will return the identical suggested Trial if the Trial is
              #     pending, and provide a new Trial if the last suggested Trial was completed.
              #   @param contexts [::Array<::Google::Cloud::AIPlatform::V1::TrialContext, ::Hash>]
              #     Optional. This allows you to specify the "context" for a Trial; a context
              #     is a slice (a subspace) of the search space.
              #
              #     Typical uses for contexts:
              #     1) You are using Vizier to tune a server for best performance, but there's
              #       a strong weekly cycle.  The context specifies the day-of-week.
              #       This allows Tuesday to generalize from Wednesday without assuming that
              #       everything is identical.
              #     2) Imagine you're optimizing some medical treatment for people.
              #       As they walk in the door, you know certain facts about them
              #       (e.g. sex, weight, height, blood-pressure).  Put that information in the
              #       context, and Vizier will adapt its suggestions to the patient.
              #     3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
              #       conditions as contexts, and Vizier will generalize between "A" and "B"
              #       conditions.  If they are similar, this will allow Vizier to converge
              #       to the optimum faster than if "A" and "B" were separate Studies.
              #       NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
              #       CreateTrial() RPC; that's the asynchronous option where you don't need a
              #       close association between contexts and suggestions.
              #
              #     NOTE: All the Parameters you set in a context MUST be defined in the
              #       Study.
              #     NOTE: You must supply 0 or $suggestion_count contexts.
              #       If you don't supply any contexts, Vizier will make suggestions
              #       from the full search space specified in the StudySpec; if you supply
              #       a full set of context, each suggestion will match the corresponding
              #       context.
              #     NOTE: A Context with no features set matches anything, and allows
              #       suggestions from the full search space.
              #     NOTE: Contexts MUST lie within the search space specified in the
              #       StudySpec.  It's an error if they don't.
              #     NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
              #       new suggestions are generated.
              #     NOTE: Generation of suggestions involves a match between a Context and
              #       (optionally) a REQUESTED trial; if that match is not fully specified, a
              #       suggestion will be geneated in the merged subspace.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::SuggestTrialsRequest.new
              #
              #   # Call the suggest_trials method.
              #   result = client.suggest_trials request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def suggest_trials request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::SuggestTrialsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.suggest_trials.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.suggest_trials.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.suggest_trials.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.suggest_trials request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Adds a user provided Trial to a Study.
              #
              # @overload create_trial(request, options = nil)
              #   Pass arguments to `create_trial` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::CreateTrialRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::CreateTrialRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_trial(parent: nil, trial: nil)
              #   Pass arguments to `create_trial` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Study to create the Trial in.
              #     Format: `projects/{project}/locations/{location}/studies/{study}`
              #   @param trial [::Google::Cloud::AIPlatform::V1::Trial, ::Hash]
              #     Required. The Trial to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::Trial]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::Trial]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::CreateTrialRequest.new
              #
              #   # Call the create_trial method.
              #   result = client.create_trial request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::Trial.
              #   p result
              #
              def create_trial request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateTrialRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_trial.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_trial.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_trial.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.create_trial request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a Trial.
              #
              # @overload get_trial(request, options = nil)
              #   Pass arguments to `get_trial` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::GetTrialRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::GetTrialRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_trial(name: nil)
              #   Pass arguments to `get_trial` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Trial resource.
              #     Format:
              #     `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::Trial]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::Trial]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::GetTrialRequest.new
              #
              #   # Call the get_trial method.
              #   result = client.get_trial request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::Trial.
              #   p result
              #
              def get_trial request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetTrialRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_trial.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_trial.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_trial.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.get_trial request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the Trials associated with a Study.
              #
              # @overload list_trials(request, options = nil)
              #   Pass arguments to `list_trials` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListTrialsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListTrialsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_trials(parent: nil, page_token: nil, page_size: nil)
              #   Pass arguments to `list_trials` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Study to list the Trial from.
              #     Format: `projects/{project}/locations/{location}/studies/{study}`
              #   @param page_token [::String]
              #     Optional. A page token to request the next page of results.
              #     If unspecified, there are no subsequent pages.
              #   @param page_size [::Integer]
              #     Optional. The number of Trials to retrieve per "page" of results.
              #     If unspecified, the service will pick an appropriate default.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Trial>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Trial>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListTrialsRequest.new
              #
              #   # Call the list_trials method.
              #   result = client.list_trials request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Trial.
              #     p item
              #   end
              #
              def list_trials request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListTrialsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_trials.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_trials.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_trials.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.list_trials request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vizier_service_stub, :list_trials, "trials", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Adds a measurement of the objective metrics to a Trial. This measurement
              # is assumed to have been taken before the Trial is complete.
              #
              # @overload add_trial_measurement(request, options = nil)
              #   Pass arguments to `add_trial_measurement` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::AddTrialMeasurementRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::AddTrialMeasurementRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload add_trial_measurement(trial_name: nil, measurement: nil)
              #   Pass arguments to `add_trial_measurement` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param trial_name [::String]
              #     Required. The name of the trial to add measurement.
              #     Format:
              #     `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
              #   @param measurement [::Google::Cloud::AIPlatform::V1::Measurement, ::Hash]
              #     Required. The measurement to be added to a Trial.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::Trial]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::Trial]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::AddTrialMeasurementRequest.new
              #
              #   # Call the add_trial_measurement method.
              #   result = client.add_trial_measurement request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::Trial.
              #   p result
              #
              def add_trial_measurement request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::AddTrialMeasurementRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.add_trial_measurement.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.add_trial_measurement.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.add_trial_measurement.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.add_trial_measurement request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Marks a Trial as complete.
              #
              # @overload complete_trial(request, options = nil)
              #   Pass arguments to `complete_trial` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::CompleteTrialRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::CompleteTrialRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload complete_trial(name: nil, final_measurement: nil, trial_infeasible: nil, infeasible_reason: nil)
              #   Pass arguments to `complete_trial` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The Trial's name.
              #     Format:
              #     `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
              #   @param final_measurement [::Google::Cloud::AIPlatform::V1::Measurement, ::Hash]
              #     Optional. If provided, it will be used as the completed Trial's
              #     final_measurement; Otherwise, the service will auto-select a
              #     previously reported measurement as the final-measurement
              #   @param trial_infeasible [::Boolean]
              #     Optional. True if the Trial cannot be run with the given Parameter, and
              #     final_measurement will be ignored.
              #   @param infeasible_reason [::String]
              #     Optional. A human readable reason why the trial was infeasible. This should
              #     only be provided if `trial_infeasible` is true.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::Trial]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::Trial]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::CompleteTrialRequest.new
              #
              #   # Call the complete_trial method.
              #   result = client.complete_trial request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::Trial.
              #   p result
              #
              def complete_trial request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CompleteTrialRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.complete_trial.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.complete_trial.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.complete_trial.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.complete_trial request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a Trial.
              #
              # @overload delete_trial(request, options = nil)
              #   Pass arguments to `delete_trial` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::DeleteTrialRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::DeleteTrialRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_trial(name: nil)
              #   Pass arguments to `delete_trial` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The Trial's name.
              #     Format:
              #     `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::DeleteTrialRequest.new
              #
              #   # Call the delete_trial method.
              #   result = client.delete_trial request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_trial request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteTrialRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_trial.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_trial.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_trial.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.delete_trial request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Checks  whether a Trial should stop or not. Returns a
              # long-running operation. When the operation is successful,
              # it will contain a
              # {::Google::Cloud::AIPlatform::V1::CheckTrialEarlyStoppingStateResponse CheckTrialEarlyStoppingStateResponse}.
              #
              # @overload check_trial_early_stopping_state(request, options = nil)
              #   Pass arguments to `check_trial_early_stopping_state` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::CheckTrialEarlyStoppingStateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::CheckTrialEarlyStoppingStateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload check_trial_early_stopping_state(trial_name: nil)
              #   Pass arguments to `check_trial_early_stopping_state` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param trial_name [::String]
              #     Required. The Trial's name.
              #     Format:
              #     `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::CheckTrialEarlyStoppingStateRequest.new
              #
              #   # Call the check_trial_early_stopping_state method.
              #   result = client.check_trial_early_stopping_state request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def check_trial_early_stopping_state request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CheckTrialEarlyStoppingStateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.check_trial_early_stopping_state.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.check_trial_early_stopping_state.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.check_trial_early_stopping_state.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.check_trial_early_stopping_state request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Stops a Trial.
              #
              # @overload stop_trial(request, options = nil)
              #   Pass arguments to `stop_trial` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::StopTrialRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::StopTrialRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload stop_trial(name: nil)
              #   Pass arguments to `stop_trial` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The Trial's name.
              #     Format:
              #     `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::Trial]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::Trial]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::StopTrialRequest.new
              #
              #   # Call the stop_trial method.
              #   result = client.stop_trial request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::Trial.
              #   p result
              #
              def stop_trial request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::StopTrialRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.stop_trial.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.stop_trial.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.stop_trial.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.stop_trial request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the pareto-optimal Trials for multi-objective Study or the
              # optimal Trials for single-objective Study. The definition of
              # pareto-optimal can be checked in wiki page.
              # https://en.wikipedia.org/wiki/Pareto_efficiency
              #
              # @overload list_optimal_trials(request, options = nil)
              #   Pass arguments to `list_optimal_trials` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListOptimalTrialsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListOptimalTrialsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_optimal_trials(parent: nil)
              #   Pass arguments to `list_optimal_trials` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the Study that the optimal Trial belongs to.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::ListOptimalTrialsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::ListOptimalTrialsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListOptimalTrialsRequest.new
              #
              #   # Call the list_optimal_trials method.
              #   result = client.list_optimal_trials request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::ListOptimalTrialsResponse.
              #   p result
              #
              def list_optimal_trials request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListOptimalTrialsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_optimal_trials.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_optimal_trials.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_optimal_trials.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vizier_service_stub.list_optimal_trials request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the VizierService REST API.
              #
              # This class represents the configuration for VizierService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_study to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_study.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_study.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the VizierService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_study`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_study
                  ##
                  # RPC-specific configuration for `get_study`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_study
                  ##
                  # RPC-specific configuration for `list_studies`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_studies
                  ##
                  # RPC-specific configuration for `delete_study`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_study
                  ##
                  # RPC-specific configuration for `lookup_study`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :lookup_study
                  ##
                  # RPC-specific configuration for `suggest_trials`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :suggest_trials
                  ##
                  # RPC-specific configuration for `create_trial`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_trial
                  ##
                  # RPC-specific configuration for `get_trial`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_trial
                  ##
                  # RPC-specific configuration for `list_trials`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_trials
                  ##
                  # RPC-specific configuration for `add_trial_measurement`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :add_trial_measurement
                  ##
                  # RPC-specific configuration for `complete_trial`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :complete_trial
                  ##
                  # RPC-specific configuration for `delete_trial`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_trial
                  ##
                  # RPC-specific configuration for `check_trial_early_stopping_state`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :check_trial_early_stopping_state
                  ##
                  # RPC-specific configuration for `stop_trial`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :stop_trial
                  ##
                  # RPC-specific configuration for `list_optimal_trials`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_optimal_trials

                  # @private
                  def initialize parent_rpcs = nil
                    create_study_config = parent_rpcs.create_study if parent_rpcs.respond_to? :create_study
                    @create_study = ::Gapic::Config::Method.new create_study_config
                    get_study_config = parent_rpcs.get_study if parent_rpcs.respond_to? :get_study
                    @get_study = ::Gapic::Config::Method.new get_study_config
                    list_studies_config = parent_rpcs.list_studies if parent_rpcs.respond_to? :list_studies
                    @list_studies = ::Gapic::Config::Method.new list_studies_config
                    delete_study_config = parent_rpcs.delete_study if parent_rpcs.respond_to? :delete_study
                    @delete_study = ::Gapic::Config::Method.new delete_study_config
                    lookup_study_config = parent_rpcs.lookup_study if parent_rpcs.respond_to? :lookup_study
                    @lookup_study = ::Gapic::Config::Method.new lookup_study_config
                    suggest_trials_config = parent_rpcs.suggest_trials if parent_rpcs.respond_to? :suggest_trials
                    @suggest_trials = ::Gapic::Config::Method.new suggest_trials_config
                    create_trial_config = parent_rpcs.create_trial if parent_rpcs.respond_to? :create_trial
                    @create_trial = ::Gapic::Config::Method.new create_trial_config
                    get_trial_config = parent_rpcs.get_trial if parent_rpcs.respond_to? :get_trial
                    @get_trial = ::Gapic::Config::Method.new get_trial_config
                    list_trials_config = parent_rpcs.list_trials if parent_rpcs.respond_to? :list_trials
                    @list_trials = ::Gapic::Config::Method.new list_trials_config
                    add_trial_measurement_config = parent_rpcs.add_trial_measurement if parent_rpcs.respond_to? :add_trial_measurement
                    @add_trial_measurement = ::Gapic::Config::Method.new add_trial_measurement_config
                    complete_trial_config = parent_rpcs.complete_trial if parent_rpcs.respond_to? :complete_trial
                    @complete_trial = ::Gapic::Config::Method.new complete_trial_config
                    delete_trial_config = parent_rpcs.delete_trial if parent_rpcs.respond_to? :delete_trial
                    @delete_trial = ::Gapic::Config::Method.new delete_trial_config
                    check_trial_early_stopping_state_config = parent_rpcs.check_trial_early_stopping_state if parent_rpcs.respond_to? :check_trial_early_stopping_state
                    @check_trial_early_stopping_state = ::Gapic::Config::Method.new check_trial_early_stopping_state_config
                    stop_trial_config = parent_rpcs.stop_trial if parent_rpcs.respond_to? :stop_trial
                    @stop_trial = ::Gapic::Config::Method.new stop_trial_config
                    list_optimal_trials_config = parent_rpcs.list_optimal_trials if parent_rpcs.respond_to? :list_optimal_trials
                    @list_optimal_trials = ::Gapic::Config::Method.new list_optimal_trials_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
