# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        module VizierService
          # Path helper methods for the VizierService API.
          module Paths
            ##
            # Create a fully-qualified CustomJob resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/customJobs/{custom_job}`
            #
            # @param project [String]
            # @param location [String]
            # @param custom_job [String]
            #
            # @return [::String]
            def custom_job_path project:, location:, custom_job:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/customJobs/#{custom_job}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Study resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/studies/{study}`
            #
            # @param project [String]
            # @param location [String]
            # @param study [String]
            #
            # @return [::String]
            def study_path project:, location:, study:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/studies/#{study}"
            end

            ##
            # Create a fully-qualified Trial resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
            #
            # @param project [String]
            # @param location [String]
            # @param study [String]
            # @param trial [String]
            #
            # @return [::String]
            def trial_path project:, location:, study:, trial:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "study cannot contain /" if study.to_s.include? "/"

              "projects/#{project}/locations/#{location}/studies/#{study}/trials/#{trial}"
            end

            extend self
          end
        end
      end
    end
  end
end
