# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        module VertexRagDataService
          # Path helper methods for the VertexRagDataService API.
          module Paths
            ##
            # Create a fully-qualified Endpoint resource string.
            #
            # @overload endpoint_path(project:, location:, endpoint:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param endpoint [String]
            #
            # @overload endpoint_path(project:, location:, publisher:, model:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param publisher [String]
            #   @param model [String]
            #
            # @return [::String]
            def endpoint_path **args
              resources = {
                "endpoint:location:project" => (proc do |project:, location:, endpoint:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/endpoints/#{endpoint}"
                end),
                "location:model:project:publisher" => (proc do |project:, location:, publisher:, model:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "publisher cannot contain /" if publisher.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/publishers/#{publisher}/models/#{model}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Model resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/models/{model}`
            #
            # @param project [String]
            # @param location [String]
            # @param model [String]
            #
            # @return [::String]
            def model_path project:, location:, model:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/models/#{model}"
            end

            ##
            # Create a fully-qualified RagCorpus resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
            #
            # @param project [String]
            # @param location [String]
            # @param rag_corpus [String]
            #
            # @return [::String]
            def rag_corpus_path project:, location:, rag_corpus:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/ragCorpora/#{rag_corpus}"
            end

            ##
            # Create a fully-qualified RagEngineConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/ragEngineConfig`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def rag_engine_config_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}/ragEngineConfig"
            end

            ##
            # Create a fully-qualified RagFile resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}/ragFiles/{rag_file}`
            #
            # @param project [String]
            # @param location [String]
            # @param rag_corpus [String]
            # @param rag_file [String]
            #
            # @return [::String]
            def rag_file_path project:, location:, rag_corpus:, rag_file:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "rag_corpus cannot contain /" if rag_corpus.to_s.include? "/"

              "projects/#{project}/locations/#{location}/ragCorpora/#{rag_corpus}/ragFiles/#{rag_file}"
            end

            ##
            # Create a fully-qualified SecretVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/secrets/{secret}/versions/{secret_version}`
            #
            # @param project [String]
            # @param secret [String]
            # @param secret_version [String]
            #
            # @return [::String]
            def secret_version_path project:, secret:, secret_version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "secret cannot contain /" if secret.to_s.include? "/"

              "projects/#{project}/secrets/#{secret}/versions/#{secret_version}"
            end

            extend self
          end
        end
      end
    end
  end
end
