# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/tensorboard_service_pb"
require "google/cloud/ai_platform/v1/tensorboard_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module AIPlatform
      module V1
        module TensorboardService
          module Rest
            ##
            # REST client for the TensorboardService service.
            #
            # TensorboardService
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :tensorboard_service_stub

              ##
              # Configure the TensorboardService Client class.
              #
              # See {::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all TensorboardService clients
              #   ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the TensorboardService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @tensorboard_service_stub.universe_domain
              end

              ##
              # Create a new TensorboardService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the TensorboardService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @tensorboard_service_stub = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @tensorboard_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @tensorboard_service_stub.endpoint
                  config.universe_domain = @tensorboard_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @tensorboard_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @tensorboard_service_stub.endpoint
                  config.universe_domain = @tensorboard_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @tensorboard_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @tensorboard_service_stub.logger
              end

              # Service calls

              ##
              # Creates a Tensorboard.
              #
              # @overload create_tensorboard(request, options = nil)
              #   Pass arguments to `create_tensorboard` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::CreateTensorboardRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::CreateTensorboardRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_tensorboard(parent: nil, tensorboard: nil)
              #   Pass arguments to `create_tensorboard` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Location to create the Tensorboard in.
              #     Format: `projects/{project}/locations/{location}`
              #   @param tensorboard [::Google::Cloud::AIPlatform::V1::Tensorboard, ::Hash]
              #     Required. The Tensorboard to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::CreateTensorboardRequest.new
              #
              #   # Call the create_tensorboard method.
              #   result = client.create_tensorboard request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_tensorboard request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateTensorboardRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_tensorboard.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_tensorboard.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_tensorboard.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.create_tensorboard request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a Tensorboard.
              #
              # @overload get_tensorboard(request, options = nil)
              #   Pass arguments to `get_tensorboard` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::GetTensorboardRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::GetTensorboardRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_tensorboard(name: nil)
              #   Pass arguments to `get_tensorboard` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Tensorboard resource.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::Tensorboard]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::Tensorboard]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::GetTensorboardRequest.new
              #
              #   # Call the get_tensorboard method.
              #   result = client.get_tensorboard request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::Tensorboard.
              #   p result
              #
              def get_tensorboard request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetTensorboardRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_tensorboard.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_tensorboard.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_tensorboard.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.get_tensorboard request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a Tensorboard.
              #
              # @overload update_tensorboard(request, options = nil)
              #   Pass arguments to `update_tensorboard` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::UpdateTensorboardRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::UpdateTensorboardRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_tensorboard(update_mask: nil, tensorboard: nil)
              #   Pass arguments to `update_tensorboard` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     Tensorboard resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field is overwritten if it's in the mask. If the
              #     user does not provide a mask then all fields are overwritten if new
              #     values are specified.
              #   @param tensorboard [::Google::Cloud::AIPlatform::V1::Tensorboard, ::Hash]
              #     Required. The Tensorboard's `name` field is used to identify the
              #     Tensorboard to be updated. Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::UpdateTensorboardRequest.new
              #
              #   # Call the update_tensorboard method.
              #   result = client.update_tensorboard request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_tensorboard request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateTensorboardRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_tensorboard.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_tensorboard.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_tensorboard.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.update_tensorboard request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Tensorboards in a Location.
              #
              # @overload list_tensorboards(request, options = nil)
              #   Pass arguments to `list_tensorboards` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListTensorboardsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListTensorboardsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_tensorboards(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil, read_mask: nil)
              #   Pass arguments to `list_tensorboards` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Location to list Tensorboards.
              #     Format:
              #     `projects/{project}/locations/{location}`
              #   @param filter [::String]
              #     Lists the Tensorboards that match the filter expression.
              #   @param page_size [::Integer]
              #     The maximum number of Tensorboards to return. The service may return
              #     fewer than this value. If unspecified, at most 100 Tensorboards are
              #     returned. The maximum value is 100; values above 100 are coerced to
              #     100.
              #   @param page_token [::String]
              #     A page token, received from a previous
              #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client#list_tensorboards TensorboardService.ListTensorboards}
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client#list_tensorboards TensorboardService.ListTensorboards}
              #     must match the call that provided the page token.
              #   @param order_by [::String]
              #     Field to use to sort the list.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask specifying which fields to read.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Tensorboard>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Tensorboard>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListTensorboardsRequest.new
              #
              #   # Call the list_tensorboards method.
              #   result = client.list_tensorboards request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Tensorboard.
              #     p item
              #   end
              #
              def list_tensorboards request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListTensorboardsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_tensorboards.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_tensorboards.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_tensorboards.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.list_tensorboards request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @tensorboard_service_stub, :list_tensorboards, "tensorboards", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a Tensorboard.
              #
              # @overload delete_tensorboard(request, options = nil)
              #   Pass arguments to `delete_tensorboard` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::DeleteTensorboardRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::DeleteTensorboardRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_tensorboard(name: nil)
              #   Pass arguments to `delete_tensorboard` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Tensorboard to be deleted.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::DeleteTensorboardRequest.new
              #
              #   # Call the delete_tensorboard method.
              #   result = client.delete_tensorboard request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_tensorboard request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteTensorboardRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_tensorboard.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_tensorboard.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_tensorboard.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.delete_tensorboard request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of monthly active users for a given TensorBoard instance.
              #
              # @overload read_tensorboard_usage(request, options = nil)
              #   Pass arguments to `read_tensorboard_usage` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload read_tensorboard_usage(tensorboard: nil)
              #   Pass arguments to `read_tensorboard_usage` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param tensorboard [::String]
              #     Required. The name of the Tensorboard resource.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ReadTensorboardUsageRequest.new
              #
              #   # Call the read_tensorboard_usage method.
              #   result = client.read_tensorboard_usage request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::ReadTensorboardUsageResponse.
              #   p result
              #
              def read_tensorboard_usage request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.read_tensorboard_usage.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.read_tensorboard_usage.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.read_tensorboard_usage.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.read_tensorboard_usage request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the storage size for a given TensorBoard instance.
              #
              # @overload read_tensorboard_size(request, options = nil)
              #   Pass arguments to `read_tensorboard_size` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ReadTensorboardSizeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ReadTensorboardSizeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload read_tensorboard_size(tensorboard: nil)
              #   Pass arguments to `read_tensorboard_size` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param tensorboard [::String]
              #     Required. The name of the Tensorboard resource.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::ReadTensorboardSizeResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::ReadTensorboardSizeResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ReadTensorboardSizeRequest.new
              #
              #   # Call the read_tensorboard_size method.
              #   result = client.read_tensorboard_size request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::ReadTensorboardSizeResponse.
              #   p result
              #
              def read_tensorboard_size request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ReadTensorboardSizeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.read_tensorboard_size.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.read_tensorboard_size.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.read_tensorboard_size.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.read_tensorboard_size request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a TensorboardExperiment.
              #
              # @overload create_tensorboard_experiment(request, options = nil)
              #   Pass arguments to `create_tensorboard_experiment` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::CreateTensorboardExperimentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::CreateTensorboardExperimentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_tensorboard_experiment(parent: nil, tensorboard_experiment: nil, tensorboard_experiment_id: nil)
              #   Pass arguments to `create_tensorboard_experiment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Tensorboard to create the
              #     TensorboardExperiment in. Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
              #   @param tensorboard_experiment [::Google::Cloud::AIPlatform::V1::TensorboardExperiment, ::Hash]
              #     The TensorboardExperiment to create.
              #   @param tensorboard_experiment_id [::String]
              #     Required. The ID to use for the Tensorboard experiment, which becomes the
              #     final component of the Tensorboard experiment's resource name.
              #
              #     This value should be 1-128 characters, and valid characters
              #     are `/[a-z][0-9]-/`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::TensorboardExperiment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::TensorboardExperiment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::CreateTensorboardExperimentRequest.new
              #
              #   # Call the create_tensorboard_experiment method.
              #   result = client.create_tensorboard_experiment request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::TensorboardExperiment.
              #   p result
              #
              def create_tensorboard_experiment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateTensorboardExperimentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_tensorboard_experiment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_tensorboard_experiment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_tensorboard_experiment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.create_tensorboard_experiment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a TensorboardExperiment.
              #
              # @overload get_tensorboard_experiment(request, options = nil)
              #   Pass arguments to `get_tensorboard_experiment` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::GetTensorboardExperimentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::GetTensorboardExperimentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_tensorboard_experiment(name: nil)
              #   Pass arguments to `get_tensorboard_experiment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the TensorboardExperiment resource.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::TensorboardExperiment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::TensorboardExperiment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::GetTensorboardExperimentRequest.new
              #
              #   # Call the get_tensorboard_experiment method.
              #   result = client.get_tensorboard_experiment request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::TensorboardExperiment.
              #   p result
              #
              def get_tensorboard_experiment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetTensorboardExperimentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_tensorboard_experiment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_tensorboard_experiment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_tensorboard_experiment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.get_tensorboard_experiment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a TensorboardExperiment.
              #
              # @overload update_tensorboard_experiment(request, options = nil)
              #   Pass arguments to `update_tensorboard_experiment` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::UpdateTensorboardExperimentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::UpdateTensorboardExperimentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_tensorboard_experiment(update_mask: nil, tensorboard_experiment: nil)
              #   Pass arguments to `update_tensorboard_experiment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     TensorboardExperiment resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field is overwritten if it's in the mask. If the
              #     user does not provide a mask then all fields are overwritten if new
              #     values are specified.
              #   @param tensorboard_experiment [::Google::Cloud::AIPlatform::V1::TensorboardExperiment, ::Hash]
              #     Required. The TensorboardExperiment's `name` field is used to identify the
              #     TensorboardExperiment to be updated. Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::TensorboardExperiment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::TensorboardExperiment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::UpdateTensorboardExperimentRequest.new
              #
              #   # Call the update_tensorboard_experiment method.
              #   result = client.update_tensorboard_experiment request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::TensorboardExperiment.
              #   p result
              #
              def update_tensorboard_experiment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateTensorboardExperimentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_tensorboard_experiment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_tensorboard_experiment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_tensorboard_experiment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.update_tensorboard_experiment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists TensorboardExperiments in a Location.
              #
              # @overload list_tensorboard_experiments(request, options = nil)
              #   Pass arguments to `list_tensorboard_experiments` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListTensorboardExperimentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListTensorboardExperimentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_tensorboard_experiments(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil, read_mask: nil)
              #   Pass arguments to `list_tensorboard_experiments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Tensorboard to list
              #     TensorboardExperiments. Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
              #   @param filter [::String]
              #     Lists the TensorboardExperiments that match the filter expression.
              #   @param page_size [::Integer]
              #     The maximum number of TensorboardExperiments to return. The service may
              #     return fewer than this value. If unspecified, at most 50
              #     TensorboardExperiments are returned. The maximum value is 1000; values
              #     above 1000 are coerced to 1000.
              #   @param page_token [::String]
              #     A page token, received from a previous
              #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client#list_tensorboard_experiments TensorboardService.ListTensorboardExperiments}
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client#list_tensorboard_experiments TensorboardService.ListTensorboardExperiments}
              #     must match the call that provided the page token.
              #   @param order_by [::String]
              #     Field to use to sort the list.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask specifying which fields to read.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::TensorboardExperiment>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::TensorboardExperiment>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListTensorboardExperimentsRequest.new
              #
              #   # Call the list_tensorboard_experiments method.
              #   result = client.list_tensorboard_experiments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::TensorboardExperiment.
              #     p item
              #   end
              #
              def list_tensorboard_experiments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListTensorboardExperimentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_tensorboard_experiments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_tensorboard_experiments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_tensorboard_experiments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.list_tensorboard_experiments request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @tensorboard_service_stub, :list_tensorboard_experiments, "tensorboard_experiments", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a TensorboardExperiment.
              #
              # @overload delete_tensorboard_experiment(request, options = nil)
              #   Pass arguments to `delete_tensorboard_experiment` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::DeleteTensorboardExperimentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::DeleteTensorboardExperimentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_tensorboard_experiment(name: nil)
              #   Pass arguments to `delete_tensorboard_experiment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the TensorboardExperiment to be deleted.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::DeleteTensorboardExperimentRequest.new
              #
              #   # Call the delete_tensorboard_experiment method.
              #   result = client.delete_tensorboard_experiment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_tensorboard_experiment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteTensorboardExperimentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_tensorboard_experiment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_tensorboard_experiment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_tensorboard_experiment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.delete_tensorboard_experiment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a TensorboardRun.
              #
              # @overload create_tensorboard_run(request, options = nil)
              #   Pass arguments to `create_tensorboard_run` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::CreateTensorboardRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::CreateTensorboardRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_tensorboard_run(parent: nil, tensorboard_run: nil, tensorboard_run_id: nil)
              #   Pass arguments to `create_tensorboard_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the TensorboardExperiment to create the
              #     TensorboardRun in. Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
              #   @param tensorboard_run [::Google::Cloud::AIPlatform::V1::TensorboardRun, ::Hash]
              #     Required. The TensorboardRun to create.
              #   @param tensorboard_run_id [::String]
              #     Required. The ID to use for the Tensorboard run, which becomes the final
              #     component of the Tensorboard run's resource name.
              #
              #     This value should be 1-128 characters, and valid characters
              #     are `/[a-z][0-9]-/`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::TensorboardRun]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::TensorboardRun]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::CreateTensorboardRunRequest.new
              #
              #   # Call the create_tensorboard_run method.
              #   result = client.create_tensorboard_run request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::TensorboardRun.
              #   p result
              #
              def create_tensorboard_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateTensorboardRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_tensorboard_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_tensorboard_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_tensorboard_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.create_tensorboard_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Batch create TensorboardRuns.
              #
              # @overload batch_create_tensorboard_runs(request, options = nil)
              #   Pass arguments to `batch_create_tensorboard_runs` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardRunsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardRunsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_create_tensorboard_runs(parent: nil, requests: nil)
              #   Pass arguments to `batch_create_tensorboard_runs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the TensorboardExperiment to create the
              #     TensorboardRuns in. Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
              #     The parent field in the CreateTensorboardRunRequest messages must match
              #     this field.
              #   @param requests [::Array<::Google::Cloud::AIPlatform::V1::CreateTensorboardRunRequest, ::Hash>]
              #     Required. The request message specifying the TensorboardRuns to create.
              #     A maximum of 1000 TensorboardRuns can be created in a batch.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardRunsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardRunsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::BatchCreateTensorboardRunsRequest.new
              #
              #   # Call the batch_create_tensorboard_runs method.
              #   result = client.batch_create_tensorboard_runs request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::BatchCreateTensorboardRunsResponse.
              #   p result
              #
              def batch_create_tensorboard_runs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardRunsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_create_tensorboard_runs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_create_tensorboard_runs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_create_tensorboard_runs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.batch_create_tensorboard_runs request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a TensorboardRun.
              #
              # @overload get_tensorboard_run(request, options = nil)
              #   Pass arguments to `get_tensorboard_run` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::GetTensorboardRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::GetTensorboardRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_tensorboard_run(name: nil)
              #   Pass arguments to `get_tensorboard_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the TensorboardRun resource.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::TensorboardRun]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::TensorboardRun]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::GetTensorboardRunRequest.new
              #
              #   # Call the get_tensorboard_run method.
              #   result = client.get_tensorboard_run request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::TensorboardRun.
              #   p result
              #
              def get_tensorboard_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetTensorboardRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_tensorboard_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_tensorboard_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_tensorboard_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.get_tensorboard_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a TensorboardRun.
              #
              # @overload update_tensorboard_run(request, options = nil)
              #   Pass arguments to `update_tensorboard_run` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::UpdateTensorboardRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::UpdateTensorboardRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_tensorboard_run(update_mask: nil, tensorboard_run: nil)
              #   Pass arguments to `update_tensorboard_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     TensorboardRun resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field is overwritten if it's in the mask. If the
              #     user does not provide a mask then all fields are overwritten if new
              #     values are specified.
              #   @param tensorboard_run [::Google::Cloud::AIPlatform::V1::TensorboardRun, ::Hash]
              #     Required. The TensorboardRun's `name` field is used to identify the
              #     TensorboardRun to be updated. Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::TensorboardRun]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::TensorboardRun]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::UpdateTensorboardRunRequest.new
              #
              #   # Call the update_tensorboard_run method.
              #   result = client.update_tensorboard_run request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::TensorboardRun.
              #   p result
              #
              def update_tensorboard_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateTensorboardRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_tensorboard_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_tensorboard_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_tensorboard_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.update_tensorboard_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists TensorboardRuns in a Location.
              #
              # @overload list_tensorboard_runs(request, options = nil)
              #   Pass arguments to `list_tensorboard_runs` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListTensorboardRunsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListTensorboardRunsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_tensorboard_runs(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil, read_mask: nil)
              #   Pass arguments to `list_tensorboard_runs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the TensorboardExperiment to list
              #     TensorboardRuns. Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
              #   @param filter [::String]
              #     Lists the TensorboardRuns that match the filter expression.
              #   @param page_size [::Integer]
              #     The maximum number of TensorboardRuns to return. The service may return
              #     fewer than this value. If unspecified, at most 50 TensorboardRuns are
              #     returned. The maximum value is 1000; values above 1000 are coerced to
              #     1000.
              #   @param page_token [::String]
              #     A page token, received from a previous
              #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client#list_tensorboard_runs TensorboardService.ListTensorboardRuns}
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client#list_tensorboard_runs TensorboardService.ListTensorboardRuns}
              #     must match the call that provided the page token.
              #   @param order_by [::String]
              #     Field to use to sort the list.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask specifying which fields to read.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::TensorboardRun>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::TensorboardRun>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListTensorboardRunsRequest.new
              #
              #   # Call the list_tensorboard_runs method.
              #   result = client.list_tensorboard_runs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::TensorboardRun.
              #     p item
              #   end
              #
              def list_tensorboard_runs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListTensorboardRunsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_tensorboard_runs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_tensorboard_runs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_tensorboard_runs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.list_tensorboard_runs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @tensorboard_service_stub, :list_tensorboard_runs, "tensorboard_runs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a TensorboardRun.
              #
              # @overload delete_tensorboard_run(request, options = nil)
              #   Pass arguments to `delete_tensorboard_run` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::DeleteTensorboardRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::DeleteTensorboardRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_tensorboard_run(name: nil)
              #   Pass arguments to `delete_tensorboard_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the TensorboardRun to be deleted.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::DeleteTensorboardRunRequest.new
              #
              #   # Call the delete_tensorboard_run method.
              #   result = client.delete_tensorboard_run request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_tensorboard_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteTensorboardRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_tensorboard_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_tensorboard_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_tensorboard_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.delete_tensorboard_run request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Batch create TensorboardTimeSeries that belong to a TensorboardExperiment.
              #
              # @overload batch_create_tensorboard_time_series(request, options = nil)
              #   Pass arguments to `batch_create_tensorboard_time_series` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardTimeSeriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardTimeSeriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_create_tensorboard_time_series(parent: nil, requests: nil)
              #   Pass arguments to `batch_create_tensorboard_time_series` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the TensorboardExperiment to create the
              #     TensorboardTimeSeries in.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
              #     The TensorboardRuns referenced by the parent fields in the
              #     CreateTensorboardTimeSeriesRequest messages must be sub resources of this
              #     TensorboardExperiment.
              #   @param requests [::Array<::Google::Cloud::AIPlatform::V1::CreateTensorboardTimeSeriesRequest, ::Hash>]
              #     Required. The request message specifying the TensorboardTimeSeries to
              #     create. A maximum of 1000 TensorboardTimeSeries can be created in a batch.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardTimeSeriesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardTimeSeriesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::BatchCreateTensorboardTimeSeriesRequest.new
              #
              #   # Call the batch_create_tensorboard_time_series method.
              #   result = client.batch_create_tensorboard_time_series request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::BatchCreateTensorboardTimeSeriesResponse.
              #   p result
              #
              def batch_create_tensorboard_time_series request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardTimeSeriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_create_tensorboard_time_series.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_create_tensorboard_time_series.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_create_tensorboard_time_series.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.batch_create_tensorboard_time_series request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a TensorboardTimeSeries.
              #
              # @overload create_tensorboard_time_series(request, options = nil)
              #   Pass arguments to `create_tensorboard_time_series` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::CreateTensorboardTimeSeriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::CreateTensorboardTimeSeriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_tensorboard_time_series(parent: nil, tensorboard_time_series_id: nil, tensorboard_time_series: nil)
              #   Pass arguments to `create_tensorboard_time_series` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the TensorboardRun to create the
              #     TensorboardTimeSeries in.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
              #   @param tensorboard_time_series_id [::String]
              #     Optional. The user specified unique ID to use for the
              #     TensorboardTimeSeries, which becomes the final component of the
              #     TensorboardTimeSeries's resource name. This value should match
              #     "[a-z0-9][a-z0-9-]\\{0, 127}"
              #   @param tensorboard_time_series [::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries, ::Hash]
              #     Required. The TensorboardTimeSeries to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::CreateTensorboardTimeSeriesRequest.new
              #
              #   # Call the create_tensorboard_time_series method.
              #   result = client.create_tensorboard_time_series request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::TensorboardTimeSeries.
              #   p result
              #
              def create_tensorboard_time_series request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateTensorboardTimeSeriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_tensorboard_time_series.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_tensorboard_time_series.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_tensorboard_time_series.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.create_tensorboard_time_series request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a TensorboardTimeSeries.
              #
              # @overload get_tensorboard_time_series(request, options = nil)
              #   Pass arguments to `get_tensorboard_time_series` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::GetTensorboardTimeSeriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::GetTensorboardTimeSeriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_tensorboard_time_series(name: nil)
              #   Pass arguments to `get_tensorboard_time_series` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the TensorboardTimeSeries resource.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::GetTensorboardTimeSeriesRequest.new
              #
              #   # Call the get_tensorboard_time_series method.
              #   result = client.get_tensorboard_time_series request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::TensorboardTimeSeries.
              #   p result
              #
              def get_tensorboard_time_series request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetTensorboardTimeSeriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_tensorboard_time_series.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_tensorboard_time_series.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_tensorboard_time_series.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.get_tensorboard_time_series request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a TensorboardTimeSeries.
              #
              # @overload update_tensorboard_time_series(request, options = nil)
              #   Pass arguments to `update_tensorboard_time_series` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::UpdateTensorboardTimeSeriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::UpdateTensorboardTimeSeriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_tensorboard_time_series(update_mask: nil, tensorboard_time_series: nil)
              #   Pass arguments to `update_tensorboard_time_series` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     TensorboardTimeSeries resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field is overwritten if it's in the mask. If the
              #     user does not provide a mask then all fields are overwritten if new
              #     values are specified.
              #   @param tensorboard_time_series [::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries, ::Hash]
              #     Required. The TensorboardTimeSeries' `name` field is used to identify the
              #     TensorboardTimeSeries to be updated.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::UpdateTensorboardTimeSeriesRequest.new
              #
              #   # Call the update_tensorboard_time_series method.
              #   result = client.update_tensorboard_time_series request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::TensorboardTimeSeries.
              #   p result
              #
              def update_tensorboard_time_series request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateTensorboardTimeSeriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_tensorboard_time_series.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_tensorboard_time_series.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_tensorboard_time_series.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.update_tensorboard_time_series request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists TensorboardTimeSeries in a Location.
              #
              # @overload list_tensorboard_time_series(request, options = nil)
              #   Pass arguments to `list_tensorboard_time_series` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListTensorboardTimeSeriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListTensorboardTimeSeriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_tensorboard_time_series(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil, read_mask: nil)
              #   Pass arguments to `list_tensorboard_time_series` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the TensorboardRun to list
              #     TensorboardTimeSeries. Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
              #   @param filter [::String]
              #     Lists the TensorboardTimeSeries that match the filter expression.
              #   @param page_size [::Integer]
              #     The maximum number of TensorboardTimeSeries to return. The service may
              #     return fewer than this value. If unspecified, at most 50
              #     TensorboardTimeSeries are returned. The maximum value is 1000; values
              #     above 1000 are coerced to 1000.
              #   @param page_token [::String]
              #     A page token, received from a previous
              #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client#list_tensorboard_time_series TensorboardService.ListTensorboardTimeSeries}
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client#list_tensorboard_time_series TensorboardService.ListTensorboardTimeSeries}
              #     must match the call that provided the page token.
              #   @param order_by [::String]
              #     Field to use to sort the list.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask specifying which fields to read.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListTensorboardTimeSeriesRequest.new
              #
              #   # Call the list_tensorboard_time_series method.
              #   result = client.list_tensorboard_time_series request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries.
              #     p item
              #   end
              #
              def list_tensorboard_time_series request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListTensorboardTimeSeriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_tensorboard_time_series.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_tensorboard_time_series.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_tensorboard_time_series.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.list_tensorboard_time_series request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @tensorboard_service_stub, :list_tensorboard_time_series, "tensorboard_time_series", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a TensorboardTimeSeries.
              #
              # @overload delete_tensorboard_time_series(request, options = nil)
              #   Pass arguments to `delete_tensorboard_time_series` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::DeleteTensorboardTimeSeriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::DeleteTensorboardTimeSeriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_tensorboard_time_series(name: nil)
              #   Pass arguments to `delete_tensorboard_time_series` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the TensorboardTimeSeries to be deleted.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::DeleteTensorboardTimeSeriesRequest.new
              #
              #   # Call the delete_tensorboard_time_series method.
              #   result = client.delete_tensorboard_time_series request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_tensorboard_time_series request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteTensorboardTimeSeriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_tensorboard_time_series.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_tensorboard_time_series.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_tensorboard_time_series.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.delete_tensorboard_time_series request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Reads multiple TensorboardTimeSeries' data. The data point number limit is
              # 1000 for scalars, 100 for tensors and blob references. If the number of
              # data points stored is less than the limit, all data is returned.
              # Otherwise, the number limit of data points is randomly selected from
              # this time series and returned.
              #
              # @overload batch_read_tensorboard_time_series_data(request, options = nil)
              #   Pass arguments to `batch_read_tensorboard_time_series_data` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_read_tensorboard_time_series_data(tensorboard: nil, time_series: nil)
              #   Pass arguments to `batch_read_tensorboard_time_series_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param tensorboard [::String]
              #     Required. The resource name of the Tensorboard containing
              #     TensorboardTimeSeries to read data from. Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`.
              #     The TensorboardTimeSeries referenced by
              #     {::Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataRequest#time_series time_series}
              #     must be sub resources of this Tensorboard.
              #   @param time_series [::Array<::String>]
              #     Required. The resource names of the TensorboardTimeSeries to read data
              #     from. Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataRequest.new
              #
              #   # Call the batch_read_tensorboard_time_series_data method.
              #   result = client.batch_read_tensorboard_time_series_data request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataResponse.
              #   p result
              #
              def batch_read_tensorboard_time_series_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_read_tensorboard_time_series_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_read_tensorboard_time_series_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_read_tensorboard_time_series_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.batch_read_tensorboard_time_series_data request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Reads a TensorboardTimeSeries' data. By default, if the number of data
              # points stored is less than 1000, all data is returned. Otherwise, 1000
              # data points is randomly selected from this time series and returned.
              # This value can be changed by changing max_data_points, which can't be
              # greater than 10k.
              #
              # @overload read_tensorboard_time_series_data(request, options = nil)
              #   Pass arguments to `read_tensorboard_time_series_data` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ReadTensorboardTimeSeriesDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ReadTensorboardTimeSeriesDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload read_tensorboard_time_series_data(tensorboard_time_series: nil, max_data_points: nil, filter: nil)
              #   Pass arguments to `read_tensorboard_time_series_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param tensorboard_time_series [::String]
              #     Required. The resource name of the TensorboardTimeSeries to read data from.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
              #   @param max_data_points [::Integer]
              #     The maximum number of TensorboardTimeSeries' data to return.
              #
              #     This value should be a positive integer.
              #     This value can be set to -1 to return all data.
              #   @param filter [::String]
              #     Reads the TensorboardTimeSeries' data that match the filter expression.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::ReadTensorboardTimeSeriesDataResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::ReadTensorboardTimeSeriesDataResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ReadTensorboardTimeSeriesDataRequest.new
              #
              #   # Call the read_tensorboard_time_series_data method.
              #   result = client.read_tensorboard_time_series_data request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::ReadTensorboardTimeSeriesDataResponse.
              #   p result
              #
              def read_tensorboard_time_series_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ReadTensorboardTimeSeriesDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.read_tensorboard_time_series_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.read_tensorboard_time_series_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.read_tensorboard_time_series_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.read_tensorboard_time_series_data request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets bytes of TensorboardBlobs.
              # This is to allow reading blob data stored in consumer project's Cloud
              # Storage bucket without users having to obtain Cloud Storage access
              # permission.
              #
              # @overload read_tensorboard_blob_data(request, options = nil)
              #   Pass arguments to `read_tensorboard_blob_data` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload read_tensorboard_blob_data(time_series: nil, blob_ids: nil)
              #   Pass arguments to `read_tensorboard_blob_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param time_series [::String]
              #     Required. The resource name of the TensorboardTimeSeries to list Blobs.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
              #   @param blob_ids [::Array<::String>]
              #     IDs of the blobs to read.
              # @return [::Enumerable<::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataResponse>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataRequest.new
              #
              #   # Call the read_tensorboard_blob_data method to start streaming.
              #   output = client.read_tensorboard_blob_data request
              #
              #   # The returned object is a streamed enumerable yielding elements of type
              #   # ::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataResponse
              #   output.each do |current_response|
              #     p current_response
              #   end
              #
              def read_tensorboard_blob_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.read_tensorboard_blob_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.read_tensorboard_blob_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.read_tensorboard_blob_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                ::Gapic::Rest::ServerStream.new(
                  ::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataResponse,
                  ::Gapic::Rest::ThreadedEnumerator.new do |in_q, out_q|
                    @tensorboard_service_stub.read_tensorboard_blob_data request, options do |chunk|
                      in_q.deq
                      out_q.enq chunk
                    end
                  end
                )
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Write time series data points of multiple TensorboardTimeSeries in multiple
              # TensorboardRun's. If any data fail to be ingested, an error is returned.
              #
              # @overload write_tensorboard_experiment_data(request, options = nil)
              #   Pass arguments to `write_tensorboard_experiment_data` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::WriteTensorboardExperimentDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::WriteTensorboardExperimentDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload write_tensorboard_experiment_data(tensorboard_experiment: nil, write_run_data_requests: nil)
              #   Pass arguments to `write_tensorboard_experiment_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param tensorboard_experiment [::String]
              #     Required. The resource name of the TensorboardExperiment to write data to.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
              #   @param write_run_data_requests [::Array<::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataRequest, ::Hash>]
              #     Required. Requests containing per-run TensorboardTimeSeries data to write.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::WriteTensorboardExperimentDataResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::WriteTensorboardExperimentDataResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::WriteTensorboardExperimentDataRequest.new
              #
              #   # Call the write_tensorboard_experiment_data method.
              #   result = client.write_tensorboard_experiment_data request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::WriteTensorboardExperimentDataResponse.
              #   p result
              #
              def write_tensorboard_experiment_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::WriteTensorboardExperimentDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.write_tensorboard_experiment_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.write_tensorboard_experiment_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.write_tensorboard_experiment_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.write_tensorboard_experiment_data request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Write time series data points into multiple TensorboardTimeSeries under
              # a TensorboardRun. If any data fail to be ingested, an error is returned.
              #
              # @overload write_tensorboard_run_data(request, options = nil)
              #   Pass arguments to `write_tensorboard_run_data` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload write_tensorboard_run_data(tensorboard_run: nil, time_series_data: nil)
              #   Pass arguments to `write_tensorboard_run_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param tensorboard_run [::String]
              #     Required. The resource name of the TensorboardRun to write data to.
              #     Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
              #   @param time_series_data [::Array<::Google::Cloud::AIPlatform::V1::TimeSeriesData, ::Hash>]
              #     Required. The TensorboardTimeSeries data to write.
              #     Values with in a time series are indexed by their step value.
              #     Repeated writes to the same step will overwrite the existing value for that
              #     step.
              #     The upper limit of data points per write request is 5000.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataRequest.new
              #
              #   # Call the write_tensorboard_run_data method.
              #   result = client.write_tensorboard_run_data request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataResponse.
              #   p result
              #
              def write_tensorboard_run_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.write_tensorboard_run_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.write_tensorboard_run_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.write_tensorboard_run_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.write_tensorboard_run_data request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports a TensorboardTimeSeries' data. Data is returned in paginated
              # responses.
              #
              # @overload export_tensorboard_time_series_data(request, options = nil)
              #   Pass arguments to `export_tensorboard_time_series_data` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ExportTensorboardTimeSeriesDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ExportTensorboardTimeSeriesDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_tensorboard_time_series_data(tensorboard_time_series: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil)
              #   Pass arguments to `export_tensorboard_time_series_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param tensorboard_time_series [::String]
              #     Required. The resource name of the TensorboardTimeSeries to export data
              #     from. Format:
              #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
              #   @param filter [::String]
              #     Exports the TensorboardTimeSeries' data that match the filter expression.
              #   @param page_size [::Integer]
              #     The maximum number of data points to return per page.
              #     The default page_size is 1000. Values must be between 1 and 10000.
              #     Values above 10000 are coerced to 10000.
              #   @param page_token [::String]
              #     A page token, received from a previous
              #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client#export_tensorboard_time_series_data ExportTensorboardTimeSeriesData}
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client#export_tensorboard_time_series_data ExportTensorboardTimeSeriesData}
              #     must match the call that provided the page token.
              #   @param order_by [::String]
              #     Field to use to sort the TensorboardTimeSeries' data.
              #     By default, TensorboardTimeSeries' data is returned in a pseudo random
              #     order.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::TimeSeriesDataPoint>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::TimeSeriesDataPoint>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ExportTensorboardTimeSeriesDataRequest.new
              #
              #   # Call the export_tensorboard_time_series_data method.
              #   result = client.export_tensorboard_time_series_data request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::TimeSeriesDataPoint.
              #     p item
              #   end
              #
              def export_tensorboard_time_series_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ExportTensorboardTimeSeriesDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_tensorboard_time_series_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_tensorboard_time_series_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_tensorboard_time_series_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tensorboard_service_stub.export_tensorboard_time_series_data request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @tensorboard_service_stub, :export_tensorboard_time_series_data, "time_series_data_points", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the TensorboardService REST API.
              #
              # This class represents the configuration for TensorboardService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_tensorboard to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_tensorboard.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_tensorboard.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the TensorboardService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_tensorboard`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_tensorboard
                  ##
                  # RPC-specific configuration for `get_tensorboard`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_tensorboard
                  ##
                  # RPC-specific configuration for `update_tensorboard`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_tensorboard
                  ##
                  # RPC-specific configuration for `list_tensorboards`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_tensorboards
                  ##
                  # RPC-specific configuration for `delete_tensorboard`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_tensorboard
                  ##
                  # RPC-specific configuration for `read_tensorboard_usage`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :read_tensorboard_usage
                  ##
                  # RPC-specific configuration for `read_tensorboard_size`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :read_tensorboard_size
                  ##
                  # RPC-specific configuration for `create_tensorboard_experiment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_tensorboard_experiment
                  ##
                  # RPC-specific configuration for `get_tensorboard_experiment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_tensorboard_experiment
                  ##
                  # RPC-specific configuration for `update_tensorboard_experiment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_tensorboard_experiment
                  ##
                  # RPC-specific configuration for `list_tensorboard_experiments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_tensorboard_experiments
                  ##
                  # RPC-specific configuration for `delete_tensorboard_experiment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_tensorboard_experiment
                  ##
                  # RPC-specific configuration for `create_tensorboard_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_tensorboard_run
                  ##
                  # RPC-specific configuration for `batch_create_tensorboard_runs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_create_tensorboard_runs
                  ##
                  # RPC-specific configuration for `get_tensorboard_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_tensorboard_run
                  ##
                  # RPC-specific configuration for `update_tensorboard_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_tensorboard_run
                  ##
                  # RPC-specific configuration for `list_tensorboard_runs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_tensorboard_runs
                  ##
                  # RPC-specific configuration for `delete_tensorboard_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_tensorboard_run
                  ##
                  # RPC-specific configuration for `batch_create_tensorboard_time_series`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_create_tensorboard_time_series
                  ##
                  # RPC-specific configuration for `create_tensorboard_time_series`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_tensorboard_time_series
                  ##
                  # RPC-specific configuration for `get_tensorboard_time_series`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_tensorboard_time_series
                  ##
                  # RPC-specific configuration for `update_tensorboard_time_series`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_tensorboard_time_series
                  ##
                  # RPC-specific configuration for `list_tensorboard_time_series`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_tensorboard_time_series
                  ##
                  # RPC-specific configuration for `delete_tensorboard_time_series`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_tensorboard_time_series
                  ##
                  # RPC-specific configuration for `batch_read_tensorboard_time_series_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_read_tensorboard_time_series_data
                  ##
                  # RPC-specific configuration for `read_tensorboard_time_series_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :read_tensorboard_time_series_data
                  ##
                  # RPC-specific configuration for `read_tensorboard_blob_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :read_tensorboard_blob_data
                  ##
                  # RPC-specific configuration for `write_tensorboard_experiment_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :write_tensorboard_experiment_data
                  ##
                  # RPC-specific configuration for `write_tensorboard_run_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :write_tensorboard_run_data
                  ##
                  # RPC-specific configuration for `export_tensorboard_time_series_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_tensorboard_time_series_data

                  # @private
                  def initialize parent_rpcs = nil
                    create_tensorboard_config = parent_rpcs.create_tensorboard if parent_rpcs.respond_to? :create_tensorboard
                    @create_tensorboard = ::Gapic::Config::Method.new create_tensorboard_config
                    get_tensorboard_config = parent_rpcs.get_tensorboard if parent_rpcs.respond_to? :get_tensorboard
                    @get_tensorboard = ::Gapic::Config::Method.new get_tensorboard_config
                    update_tensorboard_config = parent_rpcs.update_tensorboard if parent_rpcs.respond_to? :update_tensorboard
                    @update_tensorboard = ::Gapic::Config::Method.new update_tensorboard_config
                    list_tensorboards_config = parent_rpcs.list_tensorboards if parent_rpcs.respond_to? :list_tensorboards
                    @list_tensorboards = ::Gapic::Config::Method.new list_tensorboards_config
                    delete_tensorboard_config = parent_rpcs.delete_tensorboard if parent_rpcs.respond_to? :delete_tensorboard
                    @delete_tensorboard = ::Gapic::Config::Method.new delete_tensorboard_config
                    read_tensorboard_usage_config = parent_rpcs.read_tensorboard_usage if parent_rpcs.respond_to? :read_tensorboard_usage
                    @read_tensorboard_usage = ::Gapic::Config::Method.new read_tensorboard_usage_config
                    read_tensorboard_size_config = parent_rpcs.read_tensorboard_size if parent_rpcs.respond_to? :read_tensorboard_size
                    @read_tensorboard_size = ::Gapic::Config::Method.new read_tensorboard_size_config
                    create_tensorboard_experiment_config = parent_rpcs.create_tensorboard_experiment if parent_rpcs.respond_to? :create_tensorboard_experiment
                    @create_tensorboard_experiment = ::Gapic::Config::Method.new create_tensorboard_experiment_config
                    get_tensorboard_experiment_config = parent_rpcs.get_tensorboard_experiment if parent_rpcs.respond_to? :get_tensorboard_experiment
                    @get_tensorboard_experiment = ::Gapic::Config::Method.new get_tensorboard_experiment_config
                    update_tensorboard_experiment_config = parent_rpcs.update_tensorboard_experiment if parent_rpcs.respond_to? :update_tensorboard_experiment
                    @update_tensorboard_experiment = ::Gapic::Config::Method.new update_tensorboard_experiment_config
                    list_tensorboard_experiments_config = parent_rpcs.list_tensorboard_experiments if parent_rpcs.respond_to? :list_tensorboard_experiments
                    @list_tensorboard_experiments = ::Gapic::Config::Method.new list_tensorboard_experiments_config
                    delete_tensorboard_experiment_config = parent_rpcs.delete_tensorboard_experiment if parent_rpcs.respond_to? :delete_tensorboard_experiment
                    @delete_tensorboard_experiment = ::Gapic::Config::Method.new delete_tensorboard_experiment_config
                    create_tensorboard_run_config = parent_rpcs.create_tensorboard_run if parent_rpcs.respond_to? :create_tensorboard_run
                    @create_tensorboard_run = ::Gapic::Config::Method.new create_tensorboard_run_config
                    batch_create_tensorboard_runs_config = parent_rpcs.batch_create_tensorboard_runs if parent_rpcs.respond_to? :batch_create_tensorboard_runs
                    @batch_create_tensorboard_runs = ::Gapic::Config::Method.new batch_create_tensorboard_runs_config
                    get_tensorboard_run_config = parent_rpcs.get_tensorboard_run if parent_rpcs.respond_to? :get_tensorboard_run
                    @get_tensorboard_run = ::Gapic::Config::Method.new get_tensorboard_run_config
                    update_tensorboard_run_config = parent_rpcs.update_tensorboard_run if parent_rpcs.respond_to? :update_tensorboard_run
                    @update_tensorboard_run = ::Gapic::Config::Method.new update_tensorboard_run_config
                    list_tensorboard_runs_config = parent_rpcs.list_tensorboard_runs if parent_rpcs.respond_to? :list_tensorboard_runs
                    @list_tensorboard_runs = ::Gapic::Config::Method.new list_tensorboard_runs_config
                    delete_tensorboard_run_config = parent_rpcs.delete_tensorboard_run if parent_rpcs.respond_to? :delete_tensorboard_run
                    @delete_tensorboard_run = ::Gapic::Config::Method.new delete_tensorboard_run_config
                    batch_create_tensorboard_time_series_config = parent_rpcs.batch_create_tensorboard_time_series if parent_rpcs.respond_to? :batch_create_tensorboard_time_series
                    @batch_create_tensorboard_time_series = ::Gapic::Config::Method.new batch_create_tensorboard_time_series_config
                    create_tensorboard_time_series_config = parent_rpcs.create_tensorboard_time_series if parent_rpcs.respond_to? :create_tensorboard_time_series
                    @create_tensorboard_time_series = ::Gapic::Config::Method.new create_tensorboard_time_series_config
                    get_tensorboard_time_series_config = parent_rpcs.get_tensorboard_time_series if parent_rpcs.respond_to? :get_tensorboard_time_series
                    @get_tensorboard_time_series = ::Gapic::Config::Method.new get_tensorboard_time_series_config
                    update_tensorboard_time_series_config = parent_rpcs.update_tensorboard_time_series if parent_rpcs.respond_to? :update_tensorboard_time_series
                    @update_tensorboard_time_series = ::Gapic::Config::Method.new update_tensorboard_time_series_config
                    list_tensorboard_time_series_config = parent_rpcs.list_tensorboard_time_series if parent_rpcs.respond_to? :list_tensorboard_time_series
                    @list_tensorboard_time_series = ::Gapic::Config::Method.new list_tensorboard_time_series_config
                    delete_tensorboard_time_series_config = parent_rpcs.delete_tensorboard_time_series if parent_rpcs.respond_to? :delete_tensorboard_time_series
                    @delete_tensorboard_time_series = ::Gapic::Config::Method.new delete_tensorboard_time_series_config
                    batch_read_tensorboard_time_series_data_config = parent_rpcs.batch_read_tensorboard_time_series_data if parent_rpcs.respond_to? :batch_read_tensorboard_time_series_data
                    @batch_read_tensorboard_time_series_data = ::Gapic::Config::Method.new batch_read_tensorboard_time_series_data_config
                    read_tensorboard_time_series_data_config = parent_rpcs.read_tensorboard_time_series_data if parent_rpcs.respond_to? :read_tensorboard_time_series_data
                    @read_tensorboard_time_series_data = ::Gapic::Config::Method.new read_tensorboard_time_series_data_config
                    read_tensorboard_blob_data_config = parent_rpcs.read_tensorboard_blob_data if parent_rpcs.respond_to? :read_tensorboard_blob_data
                    @read_tensorboard_blob_data = ::Gapic::Config::Method.new read_tensorboard_blob_data_config
                    write_tensorboard_experiment_data_config = parent_rpcs.write_tensorboard_experiment_data if parent_rpcs.respond_to? :write_tensorboard_experiment_data
                    @write_tensorboard_experiment_data = ::Gapic::Config::Method.new write_tensorboard_experiment_data_config
                    write_tensorboard_run_data_config = parent_rpcs.write_tensorboard_run_data if parent_rpcs.respond_to? :write_tensorboard_run_data
                    @write_tensorboard_run_data = ::Gapic::Config::Method.new write_tensorboard_run_data_config
                    export_tensorboard_time_series_data_config = parent_rpcs.export_tensorboard_time_series_data if parent_rpcs.respond_to? :export_tensorboard_time_series_data
                    @export_tensorboard_time_series_data = ::Gapic::Config::Method.new export_tensorboard_time_series_data_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
