# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        module TensorboardService
          # Path helper methods for the TensorboardService API.
          module Paths
            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Tensorboard resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
            #
            # @param project [String]
            # @param location [String]
            # @param tensorboard [String]
            #
            # @return [::String]
            def tensorboard_path project:, location:, tensorboard:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/tensorboards/#{tensorboard}"
            end

            ##
            # Create a fully-qualified TensorboardExperiment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
            #
            # @param project [String]
            # @param location [String]
            # @param tensorboard [String]
            # @param experiment [String]
            #
            # @return [::String]
            def tensorboard_experiment_path project:, location:, tensorboard:, experiment:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "tensorboard cannot contain /" if tensorboard.to_s.include? "/"

              "projects/#{project}/locations/#{location}/tensorboards/#{tensorboard}/experiments/#{experiment}"
            end

            ##
            # Create a fully-qualified TensorboardRun resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
            #
            # @param project [String]
            # @param location [String]
            # @param tensorboard [String]
            # @param experiment [String]
            # @param run [String]
            #
            # @return [::String]
            def tensorboard_run_path project:, location:, tensorboard:, experiment:, run:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "tensorboard cannot contain /" if tensorboard.to_s.include? "/"
              raise ::ArgumentError, "experiment cannot contain /" if experiment.to_s.include? "/"

              "projects/#{project}/locations/#{location}/tensorboards/#{tensorboard}/experiments/#{experiment}/runs/#{run}"
            end

            ##
            # Create a fully-qualified TensorboardTimeSeries resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
            #
            # @param project [String]
            # @param location [String]
            # @param tensorboard [String]
            # @param experiment [String]
            # @param run [String]
            # @param time_series [String]
            #
            # @return [::String]
            def tensorboard_time_series_path project:, location:, tensorboard:, experiment:, run:, time_series:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "tensorboard cannot contain /" if tensorboard.to_s.include? "/"
              raise ::ArgumentError, "experiment cannot contain /" if experiment.to_s.include? "/"
              raise ::ArgumentError, "run cannot contain /" if run.to_s.include? "/"

              "projects/#{project}/locations/#{location}/tensorboards/#{tensorboard}/experiments/#{experiment}/runs/#{run}/timeSeries/#{time_series}"
            end

            extend self
          end
        end
      end
    end
  end
end
