# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/schedule_service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module AIPlatform
      module V1
        module ScheduleService
          ##
          # Client for the ScheduleService service.
          #
          # A service for creating and managing Vertex AI's Schedule resources to
          # periodically launch shceudled runs to make API calls.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :schedule_service_stub

            ##
            # Configure the ScheduleService Client class.
            #
            # See {::Google::Cloud::AIPlatform::V1::ScheduleService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all ScheduleService clients
            #   ::Google::Cloud::AIPlatform::V1::ScheduleService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the ScheduleService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::AIPlatform::V1::ScheduleService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @schedule_service_stub.universe_domain
            end

            ##
            # Create a new ScheduleService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::AIPlatform::V1::ScheduleService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::AIPlatform::V1::ScheduleService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the ScheduleService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/aiplatform/v1/schedule_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @schedule_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::AIPlatform::V1::ScheduleService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @schedule_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @schedule_service_stub.endpoint
                config.universe_domain = @schedule_service_stub.universe_domain
                config.logger = @schedule_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @schedule_service_stub.endpoint
                config.universe_domain = @schedule_service_stub.universe_domain
                config.logger = @schedule_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::AIPlatform::V1::ScheduleService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @schedule_service_stub.logger
            end

            # Service calls

            ##
            # Creates a Schedule.
            #
            # @overload create_schedule(request, options = nil)
            #   Pass arguments to `create_schedule` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateScheduleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateScheduleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_schedule(parent: nil, schedule: nil)
            #   Pass arguments to `create_schedule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to create the Schedule in.
            #     Format: `projects/{project}/locations/{location}`
            #   @param schedule [::Google::Cloud::AIPlatform::V1::Schedule, ::Hash]
            #     Required. The Schedule to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Schedule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Schedule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ScheduleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateScheduleRequest.new
            #
            #   # Call the create_schedule method.
            #   result = client.create_schedule request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Schedule.
            #   p result
            #
            def create_schedule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateScheduleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_schedule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_schedule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_schedule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schedule_service_stub.call_rpc :create_schedule, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a Schedule.
            #
            # @overload delete_schedule(request, options = nil)
            #   Pass arguments to `delete_schedule` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteScheduleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteScheduleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_schedule(name: nil)
            #   Pass arguments to `delete_schedule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Schedule resource to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/schedules/{schedule}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ScheduleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteScheduleRequest.new
            #
            #   # Call the delete_schedule method.
            #   result = client.delete_schedule request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_schedule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteScheduleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_schedule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_schedule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_schedule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schedule_service_stub.call_rpc :delete_schedule, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a Schedule.
            #
            # @overload get_schedule(request, options = nil)
            #   Pass arguments to `get_schedule` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetScheduleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetScheduleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_schedule(name: nil)
            #   Pass arguments to `get_schedule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Schedule resource.
            #     Format:
            #     `projects/{project}/locations/{location}/schedules/{schedule}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Schedule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Schedule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ScheduleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetScheduleRequest.new
            #
            #   # Call the get_schedule method.
            #   result = client.get_schedule request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Schedule.
            #   p result
            #
            def get_schedule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetScheduleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_schedule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_schedule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_schedule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schedule_service_stub.call_rpc :get_schedule, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Schedules in a Location.
            #
            # @overload list_schedules(request, options = nil)
            #   Pass arguments to `list_schedules` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListSchedulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListSchedulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_schedules(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil)
            #   Pass arguments to `list_schedules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to list the Schedules from.
            #     Format: `projects/{project}/locations/{location}`
            #   @param filter [::String]
            #     Lists the Schedules that match the filter expression. The following
            #     fields are supported:
            #
            #     * `display_name`: Supports `=`, `!=` comparisons, and `:` wildcard.
            #     * `state`: Supports `=` and `!=` comparisons.
            #     * `request`: Supports existence of the <request_type> check.
            #           (e.g. `create_pipeline_job_request:*` --> Schedule has
            #           create_pipeline_job_request).
            #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
            #           Values must be in RFC 3339 format.
            #     * `start_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
            #           Values must be in RFC 3339 format.
            #     * `end_time`: Supports `=`, `!=`, `<`, `>`, `<=`, `>=` comparisons and `:*`
            #           existence check. Values must be in RFC 3339 format.
            #     * `next_run_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=`
            #           comparisons. Values must be in RFC 3339 format.
            #
            #
            #     Filter expressions can be combined together using logical operators
            #     (`NOT`, `AND` & `OR`).
            #     The syntax to define filter expression is based on
            #     https://google.aip.dev/160.
            #
            #     Examples:
            #
            #     * `state="ACTIVE" AND display_name:"my_schedule_*"`
            #     * `NOT display_name="my_schedule"`
            #     * `create_time>"2021-05-18T00:00:00Z"`
            #     * `end_time>"2021-05-18T00:00:00Z" OR NOT end_time:*`
            #     * `create_pipeline_job_request:*`
            #   @param page_size [::Integer]
            #     The standard list page size.
            #     Default to 100 if not specified.
            #   @param page_token [::String]
            #     The standard list page token.
            #     Typically obtained via
            #     {::Google::Cloud::AIPlatform::V1::ListSchedulesResponse#next_page_token ListSchedulesResponse.next_page_token}
            #     of the previous
            #     {::Google::Cloud::AIPlatform::V1::ScheduleService::Client#list_schedules ScheduleService.ListSchedules}
            #     call.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order by. The default sort order is in
            #     ascending order. Use "desc" after a field name for descending. You can have
            #     multiple order_by fields provided.
            #
            #     For example, using "create_time desc, end_time" will order results by
            #     create time in descending order, and if there are multiple schedules having
            #     the same create time, order them by the end time in ascending order.
            #
            #     If order_by is not specified, it will order by default with create_time in
            #     descending order.
            #
            #     Supported fields:
            #
            #       * `create_time`
            #       * `start_time`
            #       * `end_time`
            #       * `next_run_time`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Schedule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Schedule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ScheduleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListSchedulesRequest.new
            #
            #   # Call the list_schedules method.
            #   result = client.list_schedules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Schedule.
            #     p item
            #   end
            #
            def list_schedules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListSchedulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_schedules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_schedules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_schedules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schedule_service_stub.call_rpc :list_schedules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @schedule_service_stub, :list_schedules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Pauses a Schedule. Will mark
            # {::Google::Cloud::AIPlatform::V1::Schedule#state Schedule.state} to 'PAUSED'. If
            # the schedule is paused, no new runs will be created. Already created runs
            # will NOT be paused or canceled.
            #
            # @overload pause_schedule(request, options = nil)
            #   Pass arguments to `pause_schedule` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::PauseScheduleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::PauseScheduleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload pause_schedule(name: nil)
            #   Pass arguments to `pause_schedule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Schedule resource to be paused.
            #     Format:
            #     `projects/{project}/locations/{location}/schedules/{schedule}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ScheduleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::PauseScheduleRequest.new
            #
            #   # Call the pause_schedule method.
            #   result = client.pause_schedule request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def pause_schedule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::PauseScheduleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.pause_schedule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.pause_schedule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.pause_schedule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schedule_service_stub.call_rpc :pause_schedule, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Resumes a paused Schedule to start scheduling new runs. Will mark
            # {::Google::Cloud::AIPlatform::V1::Schedule#state Schedule.state} to 'ACTIVE'.
            # Only paused Schedule can be resumed.
            #
            # When the Schedule is resumed, new runs will be scheduled starting from the
            # next execution time after the current time based on the time_specification
            # in the Schedule. If
            # {::Google::Cloud::AIPlatform::V1::Schedule#catch_up Schedule.catch_up} is set up
            # true, all missed runs will be scheduled for backfill first.
            #
            # @overload resume_schedule(request, options = nil)
            #   Pass arguments to `resume_schedule` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ResumeScheduleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ResumeScheduleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload resume_schedule(name: nil, catch_up: nil)
            #   Pass arguments to `resume_schedule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Schedule resource to be resumed.
            #     Format:
            #     `projects/{project}/locations/{location}/schedules/{schedule}`
            #   @param catch_up [::Boolean]
            #     Optional. Whether to backfill missed runs when the schedule is resumed from
            #     PAUSED state. If set to true, all missed runs will be scheduled. New runs
            #     will be scheduled after the backfill is complete. This will also update
            #     {::Google::Cloud::AIPlatform::V1::Schedule#catch_up Schedule.catch_up} field.
            #     Default to false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ScheduleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ResumeScheduleRequest.new
            #
            #   # Call the resume_schedule method.
            #   result = client.resume_schedule request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def resume_schedule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ResumeScheduleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.resume_schedule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.resume_schedule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.resume_schedule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schedule_service_stub.call_rpc :resume_schedule, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an active or paused Schedule.
            #
            # When the Schedule is updated, new runs will be scheduled starting from the
            # updated next execution time after the update time based on the
            # time_specification in the updated Schedule. All unstarted runs before the
            # update time will be skipped while already created runs will NOT be paused
            # or canceled.
            #
            # @overload update_schedule(request, options = nil)
            #   Pass arguments to `update_schedule` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateScheduleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateScheduleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_schedule(schedule: nil, update_mask: nil)
            #   Pass arguments to `update_schedule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param schedule [::Google::Cloud::AIPlatform::V1::Schedule, ::Hash]
            #     Required. The Schedule which replaces the resource on the server.
            #     The following restrictions will be applied:
            #
            #       * The scheduled request type cannot be changed.
            #       * The non-empty fields cannot be unset.
            #       * The output_only fields will be ignored if specified.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The update mask applies to the resource. See
            #     {::Google::Protobuf::FieldMask google.protobuf.FieldMask}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Schedule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Schedule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ScheduleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateScheduleRequest.new
            #
            #   # Call the update_schedule method.
            #   result = client.update_schedule request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Schedule.
            #   p result
            #
            def update_schedule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateScheduleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_schedule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.schedule&.name
                header_params["schedule.name"] = request.schedule.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_schedule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_schedule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schedule_service_stub.call_rpc :update_schedule, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the ScheduleService API.
            #
            # This class represents the configuration for ScheduleService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::AIPlatform::V1::ScheduleService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_schedule to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::AIPlatform::V1::ScheduleService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_schedule.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::AIPlatform::V1::ScheduleService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_schedule.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::AIPlatform::V1::ScheduleService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the ScheduleService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_schedule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_schedule
                ##
                # RPC-specific configuration for `delete_schedule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_schedule
                ##
                # RPC-specific configuration for `get_schedule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_schedule
                ##
                # RPC-specific configuration for `list_schedules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_schedules
                ##
                # RPC-specific configuration for `pause_schedule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :pause_schedule
                ##
                # RPC-specific configuration for `resume_schedule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :resume_schedule
                ##
                # RPC-specific configuration for `update_schedule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_schedule

                # @private
                def initialize parent_rpcs = nil
                  create_schedule_config = parent_rpcs.create_schedule if parent_rpcs.respond_to? :create_schedule
                  @create_schedule = ::Gapic::Config::Method.new create_schedule_config
                  delete_schedule_config = parent_rpcs.delete_schedule if parent_rpcs.respond_to? :delete_schedule
                  @delete_schedule = ::Gapic::Config::Method.new delete_schedule_config
                  get_schedule_config = parent_rpcs.get_schedule if parent_rpcs.respond_to? :get_schedule
                  @get_schedule = ::Gapic::Config::Method.new get_schedule_config
                  list_schedules_config = parent_rpcs.list_schedules if parent_rpcs.respond_to? :list_schedules
                  @list_schedules = ::Gapic::Config::Method.new list_schedules_config
                  pause_schedule_config = parent_rpcs.pause_schedule if parent_rpcs.respond_to? :pause_schedule
                  @pause_schedule = ::Gapic::Config::Method.new pause_schedule_config
                  resume_schedule_config = parent_rpcs.resume_schedule if parent_rpcs.respond_to? :resume_schedule
                  @resume_schedule = ::Gapic::Config::Method.new resume_schedule_config
                  update_schedule_config = parent_rpcs.update_schedule if parent_rpcs.respond_to? :update_schedule
                  @update_schedule = ::Gapic::Config::Method.new update_schedule_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
