# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/prediction_service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module AIPlatform
      module V1
        module PredictionService
          ##
          # Client for the PredictionService service.
          #
          # A service for online predictions and explanations.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :prediction_service_stub

            ##
            # Configure the PredictionService Client class.
            #
            # See {::Google::Cloud::AIPlatform::V1::PredictionService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all PredictionService clients
            #   ::Google::Cloud::AIPlatform::V1::PredictionService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the PredictionService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::AIPlatform::V1::PredictionService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @prediction_service_stub.universe_domain
            end

            ##
            # Create a new PredictionService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the PredictionService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/aiplatform/v1/prediction_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @prediction_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::AIPlatform::V1::PredictionService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @prediction_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @prediction_service_stub.endpoint
                config.universe_domain = @prediction_service_stub.universe_domain
                config.logger = @prediction_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @prediction_service_stub.endpoint
                config.universe_domain = @prediction_service_stub.universe_domain
                config.logger = @prediction_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @prediction_service_stub.logger
            end

            # Service calls

            ##
            # Perform an online prediction.
            #
            # @overload predict(request, options = nil)
            #   Pass arguments to `predict` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::PredictRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::PredictRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload predict(endpoint: nil, instances: nil, parameters: nil, labels: nil)
            #   Pass arguments to `predict` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param endpoint [::String]
            #     Required. The name of the Endpoint requested to serve the prediction.
            #     Format:
            #     `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #   @param instances [::Array<::Google::Protobuf::Value, ::Hash>]
            #     Required. The instances that are the input to the prediction call.
            #     A DeployedModel may have an upper limit on the number of instances it
            #     supports per request, and when it is exceeded the prediction call errors
            #     in case of AutoML Models, or, in case of customer created Models, the
            #     behaviour is as documented by that Model.
            #     The schema of any single instance may be specified via Endpoint's
            #     DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
            #     [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
            #     {::Google::Cloud::AIPlatform::V1::PredictSchemata#instance_schema_uri instance_schema_uri}.
            #   @param parameters [::Google::Protobuf::Value, ::Hash]
            #     The parameters that govern the prediction. The schema of the parameters may
            #     be specified via Endpoint's DeployedModels' [Model's
            #     ][google.cloud.aiplatform.v1.DeployedModel.model]
            #     [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
            #     {::Google::Cloud::AIPlatform::V1::PredictSchemata#parameters_schema_uri parameters_schema_uri}.
            #   @param labels [::Hash{::String => ::String}]
            #     Optional. The user labels for Imagen billing usage only. Only Imagen
            #     supports labels. For other use cases, it will be ignored.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::PredictResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::PredictResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::PredictRequest.new
            #
            #   # Call the predict method.
            #   result = client.predict request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::PredictResponse.
            #   p result
            #
            def predict request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::PredictRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.predict.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.endpoint
                header_params["endpoint"] = request.endpoint
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.predict.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.predict.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @prediction_service_stub.call_rpc :predict, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Perform an online prediction with an arbitrary HTTP payload.
            #
            # The response includes the following HTTP headers:
            #
            # * `X-Vertex-AI-Endpoint-Id`: ID of the
            # {::Google::Cloud::AIPlatform::V1::Endpoint Endpoint} that served this
            # prediction.
            #
            # * `X-Vertex-AI-Deployed-Model-Id`: ID of the Endpoint's
            # {::Google::Cloud::AIPlatform::V1::DeployedModel DeployedModel} that served this
            # prediction.
            #
            # @overload raw_predict(request, options = nil)
            #   Pass arguments to `raw_predict` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::RawPredictRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::RawPredictRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload raw_predict(endpoint: nil, http_body: nil)
            #   Pass arguments to `raw_predict` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param endpoint [::String]
            #     Required. The name of the Endpoint requested to serve the prediction.
            #     Format:
            #     `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #   @param http_body [::Google::Api::HttpBody, ::Hash]
            #     The prediction input. Supports HTTP headers and arbitrary data payload.
            #
            #     A {::Google::Cloud::AIPlatform::V1::DeployedModel DeployedModel} may have an
            #     upper limit on the number of instances it supports per request. When this
            #     limit it is exceeded for an AutoML model, the
            #     {::Google::Cloud::AIPlatform::V1::PredictionService::Client#raw_predict RawPredict}
            #     method returns an error. When this limit is exceeded for a custom-trained
            #     model, the behavior varies depending on the model.
            #
            #     You can specify the schema for each instance in the
            #     {::Google::Cloud::AIPlatform::V1::PredictSchemata#instance_schema_uri predict_schemata.instance_schema_uri}
            #     field when you create a {::Google::Cloud::AIPlatform::V1::Model Model}. This
            #     schema applies when you deploy the `Model` as a `DeployedModel` to an
            #     {::Google::Cloud::AIPlatform::V1::Endpoint Endpoint} and use the `RawPredict`
            #     method.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Api::HttpBody]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Api::HttpBody]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::RawPredictRequest.new
            #
            #   # Call the raw_predict method.
            #   result = client.raw_predict request
            #
            #   # The returned object is of type Google::Api::HttpBody.
            #   p result
            #
            def raw_predict request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::RawPredictRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.raw_predict.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.endpoint
                header_params["endpoint"] = request.endpoint
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.raw_predict.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.raw_predict.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @prediction_service_stub.call_rpc :raw_predict, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Perform a streaming online prediction with an arbitrary HTTP payload.
            #
            # @overload stream_raw_predict(request, options = nil)
            #   Pass arguments to `stream_raw_predict` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::StreamRawPredictRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::StreamRawPredictRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload stream_raw_predict(endpoint: nil, http_body: nil)
            #   Pass arguments to `stream_raw_predict` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param endpoint [::String]
            #     Required. The name of the Endpoint requested to serve the prediction.
            #     Format:
            #     `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #   @param http_body [::Google::Api::HttpBody, ::Hash]
            #     The prediction input. Supports HTTP headers and arbitrary data payload.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Api::HttpBody>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Api::HttpBody>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::StreamRawPredictRequest.new
            #
            #   # Call the stream_raw_predict method to start streaming.
            #   output = client.stream_raw_predict request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Api::HttpBody
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def stream_raw_predict request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::StreamRawPredictRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.stream_raw_predict.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.endpoint
                header_params["endpoint"] = request.endpoint
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.stream_raw_predict.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.stream_raw_predict.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @prediction_service_stub.call_rpc :stream_raw_predict, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Perform an unary online prediction request to a gRPC model server for
            # Vertex first-party products and frameworks.
            #
            # @overload direct_predict(request, options = nil)
            #   Pass arguments to `direct_predict` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DirectPredictRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DirectPredictRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload direct_predict(endpoint: nil, inputs: nil, parameters: nil)
            #   Pass arguments to `direct_predict` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param endpoint [::String]
            #     Required. The name of the Endpoint requested to serve the prediction.
            #     Format:
            #     `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #   @param inputs [::Array<::Google::Cloud::AIPlatform::V1::Tensor, ::Hash>]
            #     The prediction input.
            #   @param parameters [::Google::Cloud::AIPlatform::V1::Tensor, ::Hash]
            #     The parameters that govern the prediction.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::DirectPredictResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::DirectPredictResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DirectPredictRequest.new
            #
            #   # Call the direct_predict method.
            #   result = client.direct_predict request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::DirectPredictResponse.
            #   p result
            #
            def direct_predict request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DirectPredictRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.direct_predict.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.endpoint
                header_params["endpoint"] = request.endpoint
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.direct_predict.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.direct_predict.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @prediction_service_stub.call_rpc :direct_predict, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Perform an unary online prediction request to a gRPC model server for
            # custom containers.
            #
            # @overload direct_raw_predict(request, options = nil)
            #   Pass arguments to `direct_raw_predict` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DirectRawPredictRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DirectRawPredictRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload direct_raw_predict(endpoint: nil, method_name: nil, input: nil)
            #   Pass arguments to `direct_raw_predict` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param endpoint [::String]
            #     Required. The name of the Endpoint requested to serve the prediction.
            #     Format:
            #     `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #   @param method_name [::String]
            #     Fully qualified name of the API method being invoked to perform
            #     predictions.
            #
            #     Format:
            #     `/namespace.Service/Method/`
            #     Example:
            #     `/tensorflow.serving.PredictionService/Predict`
            #   @param input [::String]
            #     The prediction input.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::DirectRawPredictResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::DirectRawPredictResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DirectRawPredictRequest.new
            #
            #   # Call the direct_raw_predict method.
            #   result = client.direct_raw_predict request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::DirectRawPredictResponse.
            #   p result
            #
            def direct_raw_predict request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DirectRawPredictRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.direct_raw_predict.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.endpoint
                header_params["endpoint"] = request.endpoint
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.direct_raw_predict.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.direct_raw_predict.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @prediction_service_stub.call_rpc :direct_raw_predict, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Perform a streaming online prediction request to a gRPC model server for
            # Vertex first-party products and frameworks.
            #
            # @param request [::Gapic::StreamInput, ::Enumerable<::Google::Cloud::AIPlatform::V1::StreamDirectPredictRequest, ::Hash>]
            #   An enumerable of {::Google::Cloud::AIPlatform::V1::StreamDirectPredictRequest} instances.
            # @param options [::Gapic::CallOptions, ::Hash]
            #   Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::AIPlatform::V1::StreamDirectPredictResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::AIPlatform::V1::StreamDirectPredictResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create an input stream.
            #   input = Gapic::StreamInput.new
            #
            #   # Call the stream_direct_predict method to start streaming.
            #   output = client.stream_direct_predict input
            #
            #   # Send requests on the stream. For each request object, set fields by
            #   # passing keyword arguments. Be sure to close the stream when done.
            #   input << Google::Cloud::AIPlatform::V1::StreamDirectPredictRequest.new
            #   input << Google::Cloud::AIPlatform::V1::StreamDirectPredictRequest.new
            #   input.close
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::AIPlatform::V1::StreamDirectPredictResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def stream_direct_predict request, options = nil
              unless request.is_a? ::Enumerable
                raise ::ArgumentError, "request must be an Enumerable" unless request.respond_to? :to_enum
                request = request.to_enum
              end

              request = request.lazy.map do |req|
                ::Gapic::Protobuf.coerce req, to: ::Google::Cloud::AIPlatform::V1::StreamDirectPredictRequest
              end

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.stream_direct_predict.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.stream_direct_predict.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.stream_direct_predict.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @prediction_service_stub.call_rpc :stream_direct_predict, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Perform a streaming online prediction request to a gRPC model server for
            # custom containers.
            #
            # @param request [::Gapic::StreamInput, ::Enumerable<::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictRequest, ::Hash>]
            #   An enumerable of {::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictRequest} instances.
            # @param options [::Gapic::CallOptions, ::Hash]
            #   Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create an input stream.
            #   input = Gapic::StreamInput.new
            #
            #   # Call the stream_direct_raw_predict method to start streaming.
            #   output = client.stream_direct_raw_predict input
            #
            #   # Send requests on the stream. For each request object, set fields by
            #   # passing keyword arguments. Be sure to close the stream when done.
            #   input << Google::Cloud::AIPlatform::V1::StreamDirectRawPredictRequest.new
            #   input << Google::Cloud::AIPlatform::V1::StreamDirectRawPredictRequest.new
            #   input.close
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def stream_direct_raw_predict request, options = nil
              unless request.is_a? ::Enumerable
                raise ::ArgumentError, "request must be an Enumerable" unless request.respond_to? :to_enum
                request = request.to_enum
              end

              request = request.lazy.map do |req|
                ::Gapic::Protobuf.coerce req, to: ::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictRequest
              end

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.stream_direct_raw_predict.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.stream_direct_raw_predict.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.stream_direct_raw_predict.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @prediction_service_stub.call_rpc :stream_direct_raw_predict, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Perform a streaming online prediction request for Vertex first-party
            # products and frameworks.
            #
            # @param request [::Gapic::StreamInput, ::Enumerable<::Google::Cloud::AIPlatform::V1::StreamingPredictRequest, ::Hash>]
            #   An enumerable of {::Google::Cloud::AIPlatform::V1::StreamingPredictRequest} instances.
            # @param options [::Gapic::CallOptions, ::Hash]
            #   Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::AIPlatform::V1::StreamingPredictResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::AIPlatform::V1::StreamingPredictResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create an input stream.
            #   input = Gapic::StreamInput.new
            #
            #   # Call the streaming_predict method to start streaming.
            #   output = client.streaming_predict input
            #
            #   # Send requests on the stream. For each request object, set fields by
            #   # passing keyword arguments. Be sure to close the stream when done.
            #   input << Google::Cloud::AIPlatform::V1::StreamingPredictRequest.new
            #   input << Google::Cloud::AIPlatform::V1::StreamingPredictRequest.new
            #   input.close
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::AIPlatform::V1::StreamingPredictResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def streaming_predict request, options = nil
              unless request.is_a? ::Enumerable
                raise ::ArgumentError, "request must be an Enumerable" unless request.respond_to? :to_enum
                request = request.to_enum
              end

              request = request.lazy.map do |req|
                ::Gapic::Protobuf.coerce req, to: ::Google::Cloud::AIPlatform::V1::StreamingPredictRequest
              end

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.streaming_predict.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.streaming_predict.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.streaming_predict.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @prediction_service_stub.call_rpc :streaming_predict, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Perform a server-side streaming online prediction request for Vertex
            # LLM streaming.
            #
            # @overload server_streaming_predict(request, options = nil)
            #   Pass arguments to `server_streaming_predict` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::StreamingPredictRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::StreamingPredictRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload server_streaming_predict(endpoint: nil, inputs: nil, parameters: nil)
            #   Pass arguments to `server_streaming_predict` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param endpoint [::String]
            #     Required. The name of the Endpoint requested to serve the prediction.
            #     Format:
            #     `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #   @param inputs [::Array<::Google::Cloud::AIPlatform::V1::Tensor, ::Hash>]
            #     The prediction input.
            #   @param parameters [::Google::Cloud::AIPlatform::V1::Tensor, ::Hash]
            #     The parameters that govern the prediction.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::AIPlatform::V1::StreamingPredictResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::AIPlatform::V1::StreamingPredictResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::StreamingPredictRequest.new
            #
            #   # Call the server_streaming_predict method to start streaming.
            #   output = client.server_streaming_predict request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::AIPlatform::V1::StreamingPredictResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def server_streaming_predict request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::StreamingPredictRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.server_streaming_predict.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.endpoint
                header_params["endpoint"] = request.endpoint
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.server_streaming_predict.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.server_streaming_predict.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @prediction_service_stub.call_rpc :server_streaming_predict, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Perform a streaming online prediction request through gRPC.
            #
            # @param request [::Gapic::StreamInput, ::Enumerable<::Google::Cloud::AIPlatform::V1::StreamingRawPredictRequest, ::Hash>]
            #   An enumerable of {::Google::Cloud::AIPlatform::V1::StreamingRawPredictRequest} instances.
            # @param options [::Gapic::CallOptions, ::Hash]
            #   Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::AIPlatform::V1::StreamingRawPredictResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::AIPlatform::V1::StreamingRawPredictResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create an input stream.
            #   input = Gapic::StreamInput.new
            #
            #   # Call the streaming_raw_predict method to start streaming.
            #   output = client.streaming_raw_predict input
            #
            #   # Send requests on the stream. For each request object, set fields by
            #   # passing keyword arguments. Be sure to close the stream when done.
            #   input << Google::Cloud::AIPlatform::V1::StreamingRawPredictRequest.new
            #   input << Google::Cloud::AIPlatform::V1::StreamingRawPredictRequest.new
            #   input.close
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::AIPlatform::V1::StreamingRawPredictResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def streaming_raw_predict request, options = nil
              unless request.is_a? ::Enumerable
                raise ::ArgumentError, "request must be an Enumerable" unless request.respond_to? :to_enum
                request = request.to_enum
              end

              request = request.lazy.map do |req|
                ::Gapic::Protobuf.coerce req, to: ::Google::Cloud::AIPlatform::V1::StreamingRawPredictRequest
              end

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.streaming_raw_predict.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.streaming_raw_predict.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.streaming_raw_predict.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @prediction_service_stub.call_rpc :streaming_raw_predict, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Perform an online explanation.
            #
            # If
            # {::Google::Cloud::AIPlatform::V1::ExplainRequest#deployed_model_id deployed_model_id}
            # is specified, the corresponding DeployModel must have
            # {::Google::Cloud::AIPlatform::V1::DeployedModel#explanation_spec explanation_spec}
            # populated. If
            # {::Google::Cloud::AIPlatform::V1::ExplainRequest#deployed_model_id deployed_model_id}
            # is not specified, all DeployedModels must have
            # {::Google::Cloud::AIPlatform::V1::DeployedModel#explanation_spec explanation_spec}
            # populated.
            #
            # @overload explain(request, options = nil)
            #   Pass arguments to `explain` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ExplainRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ExplainRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload explain(endpoint: nil, instances: nil, parameters: nil, explanation_spec_override: nil, deployed_model_id: nil)
            #   Pass arguments to `explain` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param endpoint [::String]
            #     Required. The name of the Endpoint requested to serve the explanation.
            #     Format:
            #     `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #   @param instances [::Array<::Google::Protobuf::Value, ::Hash>]
            #     Required. The instances that are the input to the explanation call.
            #     A DeployedModel may have an upper limit on the number of instances it
            #     supports per request, and when it is exceeded the explanation call errors
            #     in case of AutoML Models, or, in case of customer created Models, the
            #     behaviour is as documented by that Model.
            #     The schema of any single instance may be specified via Endpoint's
            #     DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
            #     [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
            #     {::Google::Cloud::AIPlatform::V1::PredictSchemata#instance_schema_uri instance_schema_uri}.
            #   @param parameters [::Google::Protobuf::Value, ::Hash]
            #     The parameters that govern the prediction. The schema of the parameters may
            #     be specified via Endpoint's DeployedModels' [Model's
            #     ][google.cloud.aiplatform.v1.DeployedModel.model]
            #     [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
            #     {::Google::Cloud::AIPlatform::V1::PredictSchemata#parameters_schema_uri parameters_schema_uri}.
            #   @param explanation_spec_override [::Google::Cloud::AIPlatform::V1::ExplanationSpecOverride, ::Hash]
            #     If specified, overrides the
            #     {::Google::Cloud::AIPlatform::V1::DeployedModel#explanation_spec explanation_spec}
            #     of the DeployedModel. Can be used for explaining prediction results with
            #     different configurations, such as:
            #      - Explaining top-5 predictions results as opposed to top-1;
            #      - Increasing path count or step count of the attribution methods to reduce
            #        approximate errors;
            #      - Using different baselines for explaining the prediction results.
            #   @param deployed_model_id [::String]
            #     If specified, this ExplainRequest will be served by the chosen
            #     DeployedModel, overriding
            #     {::Google::Cloud::AIPlatform::V1::Endpoint#traffic_split Endpoint.traffic_split}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::ExplainResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::ExplainResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ExplainRequest.new
            #
            #   # Call the explain method.
            #   result = client.explain request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::ExplainResponse.
            #   p result
            #
            def explain request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ExplainRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.explain.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.endpoint
                header_params["endpoint"] = request.endpoint
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.explain.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.explain.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @prediction_service_stub.call_rpc :explain, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Generate content with multimodal inputs.
            #
            # @overload generate_content(request, options = nil)
            #   Pass arguments to `generate_content` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GenerateContentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GenerateContentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_content(model: nil, contents: nil, system_instruction: nil, cached_content: nil, tools: nil, tool_config: nil, labels: nil, safety_settings: nil, model_armor_config: nil, generation_config: nil)
            #   Pass arguments to `generate_content` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param model [::String]
            #     Required. The fully qualified name of the publisher model or tuned model
            #     endpoint to use.
            #
            #     Publisher model format:
            #     `projects/{project}/locations/{location}/publishers/*/models/*`
            #
            #     Tuned model endpoint format:
            #     `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #   @param contents [::Array<::Google::Cloud::AIPlatform::V1::Content, ::Hash>]
            #     Required. The content of the current conversation with the model.
            #
            #     For single-turn queries, this is a single instance. For multi-turn queries,
            #     this is a repeated field that contains conversation history + latest
            #     request.
            #   @param system_instruction [::Google::Cloud::AIPlatform::V1::Content, ::Hash]
            #     Optional. The user provided system instructions for the model.
            #     Note: only text should be used in parts and content in each part will be in
            #     a separate paragraph.
            #   @param cached_content [::String]
            #     Optional. The name of the cached content used as context to serve the
            #     prediction. Note: only used in explicit caching, where users can have
            #     control over caching (e.g. what content to cache) and enjoy guaranteed cost
            #     savings. Format:
            #     `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
            #   @param tools [::Array<::Google::Cloud::AIPlatform::V1::Tool, ::Hash>]
            #     Optional. A list of `Tools` the model may use to generate the next
            #     response.
            #
            #     A `Tool` is a piece of code that enables the system to interact with
            #     external systems to perform an action, or set of actions, outside of
            #     knowledge and scope of the model.
            #   @param tool_config [::Google::Cloud::AIPlatform::V1::ToolConfig, ::Hash]
            #     Optional. Tool config. This config is shared for all tools provided in the
            #     request.
            #   @param labels [::Hash{::String => ::String}]
            #     Optional. The labels with user-defined metadata for the request. It is used
            #     for billing and reporting only.
            #
            #     Label keys and values can be no longer than 63 characters
            #     (Unicode codepoints) and can only contain lowercase letters, numeric
            #     characters, underscores, and dashes. International characters are allowed.
            #     Label values are optional. Label keys must start with a letter.
            #   @param safety_settings [::Array<::Google::Cloud::AIPlatform::V1::SafetySetting, ::Hash>]
            #     Optional. Per request settings for blocking unsafe content.
            #     Enforced on GenerateContentResponse.candidates.
            #   @param model_armor_config [::Google::Cloud::AIPlatform::V1::ModelArmorConfig, ::Hash]
            #     Optional. Settings for prompt and response sanitization using the Model
            #     Armor service. If supplied, safety_settings must not be supplied.
            #   @param generation_config [::Google::Cloud::AIPlatform::V1::GenerationConfig, ::Hash]
            #     Optional. Generation config.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::GenerateContentResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::GenerateContentResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GenerateContentRequest.new
            #
            #   # Call the generate_content method.
            #   result = client.generate_content request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::GenerateContentResponse.
            #   p result
            #
            def generate_content request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GenerateContentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_content.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.model
                header_params["model"] = request.model
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_content.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_content.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @prediction_service_stub.call_rpc :generate_content, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Generate content with multimodal inputs with streaming support.
            #
            # @overload stream_generate_content(request, options = nil)
            #   Pass arguments to `stream_generate_content` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GenerateContentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GenerateContentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload stream_generate_content(model: nil, contents: nil, system_instruction: nil, cached_content: nil, tools: nil, tool_config: nil, labels: nil, safety_settings: nil, model_armor_config: nil, generation_config: nil)
            #   Pass arguments to `stream_generate_content` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param model [::String]
            #     Required. The fully qualified name of the publisher model or tuned model
            #     endpoint to use.
            #
            #     Publisher model format:
            #     `projects/{project}/locations/{location}/publishers/*/models/*`
            #
            #     Tuned model endpoint format:
            #     `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #   @param contents [::Array<::Google::Cloud::AIPlatform::V1::Content, ::Hash>]
            #     Required. The content of the current conversation with the model.
            #
            #     For single-turn queries, this is a single instance. For multi-turn queries,
            #     this is a repeated field that contains conversation history + latest
            #     request.
            #   @param system_instruction [::Google::Cloud::AIPlatform::V1::Content, ::Hash]
            #     Optional. The user provided system instructions for the model.
            #     Note: only text should be used in parts and content in each part will be in
            #     a separate paragraph.
            #   @param cached_content [::String]
            #     Optional. The name of the cached content used as context to serve the
            #     prediction. Note: only used in explicit caching, where users can have
            #     control over caching (e.g. what content to cache) and enjoy guaranteed cost
            #     savings. Format:
            #     `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
            #   @param tools [::Array<::Google::Cloud::AIPlatform::V1::Tool, ::Hash>]
            #     Optional. A list of `Tools` the model may use to generate the next
            #     response.
            #
            #     A `Tool` is a piece of code that enables the system to interact with
            #     external systems to perform an action, or set of actions, outside of
            #     knowledge and scope of the model.
            #   @param tool_config [::Google::Cloud::AIPlatform::V1::ToolConfig, ::Hash]
            #     Optional. Tool config. This config is shared for all tools provided in the
            #     request.
            #   @param labels [::Hash{::String => ::String}]
            #     Optional. The labels with user-defined metadata for the request. It is used
            #     for billing and reporting only.
            #
            #     Label keys and values can be no longer than 63 characters
            #     (Unicode codepoints) and can only contain lowercase letters, numeric
            #     characters, underscores, and dashes. International characters are allowed.
            #     Label values are optional. Label keys must start with a letter.
            #   @param safety_settings [::Array<::Google::Cloud::AIPlatform::V1::SafetySetting, ::Hash>]
            #     Optional. Per request settings for blocking unsafe content.
            #     Enforced on GenerateContentResponse.candidates.
            #   @param model_armor_config [::Google::Cloud::AIPlatform::V1::ModelArmorConfig, ::Hash]
            #     Optional. Settings for prompt and response sanitization using the Model
            #     Armor service. If supplied, safety_settings must not be supplied.
            #   @param generation_config [::Google::Cloud::AIPlatform::V1::GenerationConfig, ::Hash]
            #     Optional. Generation config.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::AIPlatform::V1::GenerateContentResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::AIPlatform::V1::GenerateContentResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GenerateContentRequest.new
            #
            #   # Call the stream_generate_content method to start streaming.
            #   output = client.stream_generate_content request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::AIPlatform::V1::GenerateContentResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def stream_generate_content request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GenerateContentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.stream_generate_content.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.model
                header_params["model"] = request.model
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.stream_generate_content.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.stream_generate_content.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @prediction_service_stub.call_rpc :stream_generate_content, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Embed content with multimodal inputs.
            #
            # @overload embed_content(request, options = nil)
            #   Pass arguments to `embed_content` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::EmbedContentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::EmbedContentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload embed_content(model: nil, content: nil, title: nil, task_type: nil, output_dimensionality: nil, auto_truncate: nil)
            #   Pass arguments to `embed_content` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param model [::String]
            #     Required. The name of the publisher model requested to serve the
            #     prediction. Format:
            #     `projects/{project}/locations/{location}/publishers/*/models/*`
            #   @param content [::Google::Cloud::AIPlatform::V1::Content, ::Hash]
            #     Required. Input content to be embedded. Required.
            #   @param title [::String]
            #     Optional. An optional title for the text.
            #   @param task_type [::Google::Cloud::AIPlatform::V1::EmbedContentRequest::EmbeddingTaskType]
            #     Optional. The task type of the embedding.
            #   @param output_dimensionality [::Integer]
            #     Optional. Optional reduced dimension for the output embedding. If set,
            #     excessive values in the output embedding are truncated from the end.
            #   @param auto_truncate [::Boolean]
            #     Optional. Whether to silently truncate the input content if it's longer
            #     than the maximum sequence length.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::EmbedContentResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::EmbedContentResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::EmbedContentRequest.new
            #
            #   # Call the embed_content method.
            #   result = client.embed_content request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::EmbedContentResponse.
            #   p result
            #
            def embed_content request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::EmbedContentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.embed_content.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.model
                header_params["model"] = request.model
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.embed_content.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.embed_content.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @prediction_service_stub.call_rpc :embed_content, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the PredictionService API.
            #
            # This class represents the configuration for PredictionService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::AIPlatform::V1::PredictionService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # predict to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::AIPlatform::V1::PredictionService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.predict.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.predict.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the PredictionService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `predict`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :predict
                ##
                # RPC-specific configuration for `raw_predict`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :raw_predict
                ##
                # RPC-specific configuration for `stream_raw_predict`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :stream_raw_predict
                ##
                # RPC-specific configuration for `direct_predict`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :direct_predict
                ##
                # RPC-specific configuration for `direct_raw_predict`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :direct_raw_predict
                ##
                # RPC-specific configuration for `stream_direct_predict`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :stream_direct_predict
                ##
                # RPC-specific configuration for `stream_direct_raw_predict`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :stream_direct_raw_predict
                ##
                # RPC-specific configuration for `streaming_predict`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :streaming_predict
                ##
                # RPC-specific configuration for `server_streaming_predict`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :server_streaming_predict
                ##
                # RPC-specific configuration for `streaming_raw_predict`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :streaming_raw_predict
                ##
                # RPC-specific configuration for `explain`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :explain
                ##
                # RPC-specific configuration for `generate_content`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_content
                ##
                # RPC-specific configuration for `stream_generate_content`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :stream_generate_content
                ##
                # RPC-specific configuration for `embed_content`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :embed_content

                # @private
                def initialize parent_rpcs = nil
                  predict_config = parent_rpcs.predict if parent_rpcs.respond_to? :predict
                  @predict = ::Gapic::Config::Method.new predict_config
                  raw_predict_config = parent_rpcs.raw_predict if parent_rpcs.respond_to? :raw_predict
                  @raw_predict = ::Gapic::Config::Method.new raw_predict_config
                  stream_raw_predict_config = parent_rpcs.stream_raw_predict if parent_rpcs.respond_to? :stream_raw_predict
                  @stream_raw_predict = ::Gapic::Config::Method.new stream_raw_predict_config
                  direct_predict_config = parent_rpcs.direct_predict if parent_rpcs.respond_to? :direct_predict
                  @direct_predict = ::Gapic::Config::Method.new direct_predict_config
                  direct_raw_predict_config = parent_rpcs.direct_raw_predict if parent_rpcs.respond_to? :direct_raw_predict
                  @direct_raw_predict = ::Gapic::Config::Method.new direct_raw_predict_config
                  stream_direct_predict_config = parent_rpcs.stream_direct_predict if parent_rpcs.respond_to? :stream_direct_predict
                  @stream_direct_predict = ::Gapic::Config::Method.new stream_direct_predict_config
                  stream_direct_raw_predict_config = parent_rpcs.stream_direct_raw_predict if parent_rpcs.respond_to? :stream_direct_raw_predict
                  @stream_direct_raw_predict = ::Gapic::Config::Method.new stream_direct_raw_predict_config
                  streaming_predict_config = parent_rpcs.streaming_predict if parent_rpcs.respond_to? :streaming_predict
                  @streaming_predict = ::Gapic::Config::Method.new streaming_predict_config
                  server_streaming_predict_config = parent_rpcs.server_streaming_predict if parent_rpcs.respond_to? :server_streaming_predict
                  @server_streaming_predict = ::Gapic::Config::Method.new server_streaming_predict_config
                  streaming_raw_predict_config = parent_rpcs.streaming_raw_predict if parent_rpcs.respond_to? :streaming_raw_predict
                  @streaming_raw_predict = ::Gapic::Config::Method.new streaming_raw_predict_config
                  explain_config = parent_rpcs.explain if parent_rpcs.respond_to? :explain
                  @explain = ::Gapic::Config::Method.new explain_config
                  generate_content_config = parent_rpcs.generate_content if parent_rpcs.respond_to? :generate_content
                  @generate_content = ::Gapic::Config::Method.new generate_content_config
                  stream_generate_content_config = parent_rpcs.stream_generate_content if parent_rpcs.respond_to? :stream_generate_content
                  @stream_generate_content = ::Gapic::Config::Method.new stream_generate_content_config
                  embed_content_config = parent_rpcs.embed_content if parent_rpcs.respond_to? :embed_content
                  @embed_content = ::Gapic::Config::Method.new embed_content_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
