# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/pipeline_service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module AIPlatform
      module V1
        module PipelineService
          ##
          # Client for the PipelineService service.
          #
          # A service for creating and managing Vertex AI's pipelines. This includes both
          # `TrainingPipeline` resources (used for AutoML and custom training) and
          # `PipelineJob` resources (used for Vertex AI Pipelines).
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :pipeline_service_stub

            ##
            # Configure the PipelineService Client class.
            #
            # See {::Google::Cloud::AIPlatform::V1::PipelineService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all PipelineService clients
            #   ::Google::Cloud::AIPlatform::V1::PipelineService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the PipelineService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::AIPlatform::V1::PipelineService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @pipeline_service_stub.universe_domain
            end

            ##
            # Create a new PipelineService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::AIPlatform::V1::PipelineService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::AIPlatform::V1::PipelineService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the PipelineService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/aiplatform/v1/pipeline_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @pipeline_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::AIPlatform::V1::PipelineService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @pipeline_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @pipeline_service_stub.endpoint
                config.universe_domain = @pipeline_service_stub.universe_domain
                config.logger = @pipeline_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @pipeline_service_stub.endpoint
                config.universe_domain = @pipeline_service_stub.universe_domain
                config.logger = @pipeline_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::AIPlatform::V1::PipelineService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @pipeline_service_stub.logger
            end

            # Service calls

            ##
            # Creates a TrainingPipeline. A created TrainingPipeline right away will be
            # attempted to be run.
            #
            # @overload create_training_pipeline(request, options = nil)
            #   Pass arguments to `create_training_pipeline` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateTrainingPipelineRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateTrainingPipelineRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_training_pipeline(parent: nil, training_pipeline: nil)
            #   Pass arguments to `create_training_pipeline` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to create the TrainingPipeline
            #     in. Format: `projects/{project}/locations/{location}`
            #   @param training_pipeline [::Google::Cloud::AIPlatform::V1::TrainingPipeline, ::Hash]
            #     Required. The TrainingPipeline to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::TrainingPipeline]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::TrainingPipeline]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PipelineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateTrainingPipelineRequest.new
            #
            #   # Call the create_training_pipeline method.
            #   result = client.create_training_pipeline request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::TrainingPipeline.
            #   p result
            #
            def create_training_pipeline request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateTrainingPipelineRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_training_pipeline.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_training_pipeline.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_training_pipeline.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @pipeline_service_stub.call_rpc :create_training_pipeline, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a TrainingPipeline.
            #
            # @overload get_training_pipeline(request, options = nil)
            #   Pass arguments to `get_training_pipeline` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetTrainingPipelineRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetTrainingPipelineRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_training_pipeline(name: nil)
            #   Pass arguments to `get_training_pipeline` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the TrainingPipeline resource.
            #     Format:
            #     `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::TrainingPipeline]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::TrainingPipeline]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PipelineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetTrainingPipelineRequest.new
            #
            #   # Call the get_training_pipeline method.
            #   result = client.get_training_pipeline request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::TrainingPipeline.
            #   p result
            #
            def get_training_pipeline request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetTrainingPipelineRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_training_pipeline.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_training_pipeline.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_training_pipeline.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @pipeline_service_stub.call_rpc :get_training_pipeline, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists TrainingPipelines in a Location.
            #
            # @overload list_training_pipelines(request, options = nil)
            #   Pass arguments to `list_training_pipelines` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListTrainingPipelinesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListTrainingPipelinesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_training_pipelines(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil)
            #   Pass arguments to `list_training_pipelines` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to list the TrainingPipelines
            #     from. Format: `projects/{project}/locations/{location}`
            #   @param filter [::String]
            #     The standard list filter.
            #
            #     Supported fields:
            #
            #       * `display_name` supports `=`, `!=` comparisons, and `:` wildcard.
            #       * `state` supports `=`, `!=` comparisons.
            #       * `training_task_definition` `=`, `!=` comparisons, and `:` wildcard.
            #       * `create_time` supports `=`, `!=`,`<`, `<=`,`>`, `>=` comparisons.
            #         `create_time` must be in RFC 3339 format.
            #       * `labels` supports general map functions that is:
            #         `labels.key=value` - key:value equality
            #         `labels.key:* - key existence
            #
            #     Some examples of using the filter are:
            #
            #       * `state="PIPELINE_STATE_SUCCEEDED" AND display_name:"my_pipeline_*"`
            #       * `state!="PIPELINE_STATE_FAILED" OR display_name="my_pipeline"`
            #       * `NOT display_name="my_pipeline"`
            #       * `create_time>"2021-05-18T00:00:00Z"`
            #       * `training_task_definition:"*automl_text_classification*"`
            #   @param page_size [::Integer]
            #     The standard list page size.
            #   @param page_token [::String]
            #     The standard list page token.
            #     Typically obtained via
            #     {::Google::Cloud::AIPlatform::V1::ListTrainingPipelinesResponse#next_page_token ListTrainingPipelinesResponse.next_page_token}
            #     of the previous
            #     {::Google::Cloud::AIPlatform::V1::PipelineService::Client#list_training_pipelines PipelineService.ListTrainingPipelines}
            #     call.
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::TrainingPipeline>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::TrainingPipeline>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PipelineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListTrainingPipelinesRequest.new
            #
            #   # Call the list_training_pipelines method.
            #   result = client.list_training_pipelines request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::TrainingPipeline.
            #     p item
            #   end
            #
            def list_training_pipelines request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListTrainingPipelinesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_training_pipelines.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_training_pipelines.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_training_pipelines.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @pipeline_service_stub.call_rpc :list_training_pipelines, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @pipeline_service_stub, :list_training_pipelines, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a TrainingPipeline.
            #
            # @overload delete_training_pipeline(request, options = nil)
            #   Pass arguments to `delete_training_pipeline` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteTrainingPipelineRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteTrainingPipelineRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_training_pipeline(name: nil)
            #   Pass arguments to `delete_training_pipeline` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the TrainingPipeline resource to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PipelineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteTrainingPipelineRequest.new
            #
            #   # Call the delete_training_pipeline method.
            #   result = client.delete_training_pipeline request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_training_pipeline request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteTrainingPipelineRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_training_pipeline.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_training_pipeline.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_training_pipeline.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @pipeline_service_stub.call_rpc :delete_training_pipeline, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Cancels a TrainingPipeline.
            # Starts asynchronous cancellation on the TrainingPipeline. The server
            # makes a best effort to cancel the pipeline, but success is not
            # guaranteed. Clients can use
            # {::Google::Cloud::AIPlatform::V1::PipelineService::Client#get_training_pipeline PipelineService.GetTrainingPipeline}
            # or other methods to check whether the cancellation succeeded or whether the
            # pipeline completed despite cancellation. On successful cancellation,
            # the TrainingPipeline is not deleted; instead it becomes a pipeline with
            # a
            # {::Google::Cloud::AIPlatform::V1::TrainingPipeline#error TrainingPipeline.error}
            # value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
            # corresponding to `Code.CANCELLED`, and
            # {::Google::Cloud::AIPlatform::V1::TrainingPipeline#state TrainingPipeline.state}
            # is set to `CANCELLED`.
            #
            # @overload cancel_training_pipeline(request, options = nil)
            #   Pass arguments to `cancel_training_pipeline` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CancelTrainingPipelineRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CancelTrainingPipelineRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload cancel_training_pipeline(name: nil)
            #   Pass arguments to `cancel_training_pipeline` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the TrainingPipeline to cancel.
            #     Format:
            #     `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PipelineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CancelTrainingPipelineRequest.new
            #
            #   # Call the cancel_training_pipeline method.
            #   result = client.cancel_training_pipeline request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def cancel_training_pipeline request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CancelTrainingPipelineRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.cancel_training_pipeline.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.cancel_training_pipeline.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.cancel_training_pipeline.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @pipeline_service_stub.call_rpc :cancel_training_pipeline, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a PipelineJob. A PipelineJob will run immediately when created.
            #
            # @overload create_pipeline_job(request, options = nil)
            #   Pass arguments to `create_pipeline_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreatePipelineJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreatePipelineJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_pipeline_job(parent: nil, pipeline_job: nil, pipeline_job_id: nil)
            #   Pass arguments to `create_pipeline_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to create the PipelineJob in.
            #     Format: `projects/{project}/locations/{location}`
            #   @param pipeline_job [::Google::Cloud::AIPlatform::V1::PipelineJob, ::Hash]
            #     Required. The PipelineJob to create.
            #   @param pipeline_job_id [::String]
            #     The ID to use for the PipelineJob, which will become the final component of
            #     the PipelineJob name. If not provided, an ID will be automatically
            #     generated.
            #
            #     This value should be less than 128 characters, and valid characters
            #     are `/[a-z][0-9]-/`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::PipelineJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::PipelineJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PipelineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreatePipelineJobRequest.new
            #
            #   # Call the create_pipeline_job method.
            #   result = client.create_pipeline_job request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::PipelineJob.
            #   p result
            #
            def create_pipeline_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreatePipelineJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_pipeline_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_pipeline_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_pipeline_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @pipeline_service_stub.call_rpc :create_pipeline_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a PipelineJob.
            #
            # @overload get_pipeline_job(request, options = nil)
            #   Pass arguments to `get_pipeline_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetPipelineJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetPipelineJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_pipeline_job(name: nil)
            #   Pass arguments to `get_pipeline_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the PipelineJob resource.
            #     Format:
            #     `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::PipelineJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::PipelineJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PipelineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetPipelineJobRequest.new
            #
            #   # Call the get_pipeline_job method.
            #   result = client.get_pipeline_job request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::PipelineJob.
            #   p result
            #
            def get_pipeline_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetPipelineJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_pipeline_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_pipeline_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_pipeline_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @pipeline_service_stub.call_rpc :get_pipeline_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists PipelineJobs in a Location.
            #
            # @overload list_pipeline_jobs(request, options = nil)
            #   Pass arguments to `list_pipeline_jobs` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListPipelineJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListPipelineJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_pipeline_jobs(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil, read_mask: nil)
            #   Pass arguments to `list_pipeline_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to list the PipelineJobs from.
            #     Format: `projects/{project}/locations/{location}`
            #   @param filter [::String]
            #     Lists the PipelineJobs that match the filter expression. The following
            #     fields are supported:
            #
            #     * `pipeline_name`: Supports `=` and `!=` comparisons.
            #     * `display_name`: Supports `=`, `!=` comparisons, and `:` wildcard.
            #     * `pipeline_job_user_id`: Supports `=`, `!=` comparisons, and `:` wildcard.
            #       for example, can check if pipeline's display_name contains *step* by
            #       doing display_name:\"*step*\"
            #     * `state`: Supports `=` and `!=` comparisons.
            #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
            #       Values must be in RFC 3339 format.
            #     * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
            #       Values must be in RFC 3339 format.
            #     * `end_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
            #       Values must be in RFC 3339 format.
            #     * `labels`: Supports key-value equality and key presence.
            #     * `template_uri`: Supports `=`, `!=` comparisons, and `:` wildcard.
            #     * `template_metadata.version`: Supports `=`, `!=` comparisons, and `:`
            #       wildcard.
            #
            #     Filter expressions can be combined together using logical operators
            #     (`AND` & `OR`).
            #     For example: `pipeline_name="test" AND create_time>"2020-05-18T13:30:00Z"`.
            #
            #     The syntax to define filter expression is based on
            #     https://google.aip.dev/160.
            #
            #     Examples:
            #
            #     * `create_time>"2021-05-18T00:00:00Z" OR
            #       update_time>"2020-05-18T00:00:00Z"` PipelineJobs created or updated
            #       after 2020-05-18 00:00:00 UTC.
            #     * `labels.env = "prod"`
            #       PipelineJobs with label "env" set to "prod".
            #   @param page_size [::Integer]
            #     The standard list page size.
            #   @param page_token [::String]
            #     The standard list page token.
            #     Typically obtained via
            #     {::Google::Cloud::AIPlatform::V1::ListPipelineJobsResponse#next_page_token ListPipelineJobsResponse.next_page_token}
            #     of the previous
            #     {::Google::Cloud::AIPlatform::V1::PipelineService::Client#list_pipeline_jobs PipelineService.ListPipelineJobs}
            #     call.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order by. The default sort order is in
            #     ascending order. Use "desc" after a field name for descending. You can have
            #     multiple order_by fields provided e.g. "create_time desc, end_time",
            #     "end_time, start_time, update_time" For example, using "create_time desc,
            #     end_time" will order results by create time in descending order, and if
            #     there are multiple jobs having the same create time, order them by the end
            #     time in ascending order. if order_by is not specified, it will order by
            #     default order is create time in descending order. Supported fields:
            #
            #       * `create_time`
            #       * `update_time`
            #       * `end_time`
            #       * `start_time`
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::PipelineJob>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::PipelineJob>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PipelineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListPipelineJobsRequest.new
            #
            #   # Call the list_pipeline_jobs method.
            #   result = client.list_pipeline_jobs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::PipelineJob.
            #     p item
            #   end
            #
            def list_pipeline_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListPipelineJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_pipeline_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_pipeline_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_pipeline_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @pipeline_service_stub.call_rpc :list_pipeline_jobs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @pipeline_service_stub, :list_pipeline_jobs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a PipelineJob.
            #
            # @overload delete_pipeline_job(request, options = nil)
            #   Pass arguments to `delete_pipeline_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeletePipelineJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeletePipelineJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_pipeline_job(name: nil)
            #   Pass arguments to `delete_pipeline_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the PipelineJob resource to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PipelineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeletePipelineJobRequest.new
            #
            #   # Call the delete_pipeline_job method.
            #   result = client.delete_pipeline_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_pipeline_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeletePipelineJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_pipeline_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_pipeline_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_pipeline_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @pipeline_service_stub.call_rpc :delete_pipeline_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Batch deletes PipelineJobs
            # The Operation is atomic. If it fails, none of the PipelineJobs are deleted.
            # If it succeeds, all of the PipelineJobs are deleted.
            #
            # @overload batch_delete_pipeline_jobs(request, options = nil)
            #   Pass arguments to `batch_delete_pipeline_jobs` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::BatchDeletePipelineJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::BatchDeletePipelineJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_delete_pipeline_jobs(parent: nil, names: nil)
            #   Pass arguments to `batch_delete_pipeline_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the PipelineJobs' parent resource.
            #     Format: `projects/{project}/locations/{location}`
            #   @param names [::Array<::String>]
            #     Required. The names of the PipelineJobs to delete.
            #     A maximum of 32 PipelineJobs can be deleted in a batch.
            #     Format:
            #     `projects/{project}/locations/{location}/pipelineJobs/{pipelineJob}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PipelineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::BatchDeletePipelineJobsRequest.new
            #
            #   # Call the batch_delete_pipeline_jobs method.
            #   result = client.batch_delete_pipeline_jobs request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def batch_delete_pipeline_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::BatchDeletePipelineJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_delete_pipeline_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_delete_pipeline_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_delete_pipeline_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @pipeline_service_stub.call_rpc :batch_delete_pipeline_jobs, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Cancels a PipelineJob.
            # Starts asynchronous cancellation on the PipelineJob. The server
            # makes a best effort to cancel the pipeline, but success is not
            # guaranteed. Clients can use
            # {::Google::Cloud::AIPlatform::V1::PipelineService::Client#get_pipeline_job PipelineService.GetPipelineJob}
            # or other methods to check whether the cancellation succeeded or whether the
            # pipeline completed despite cancellation. On successful cancellation,
            # the PipelineJob is not deleted; instead it becomes a pipeline with
            # a {::Google::Cloud::AIPlatform::V1::PipelineJob#error PipelineJob.error} value
            # with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding
            # to `Code.CANCELLED`, and
            # {::Google::Cloud::AIPlatform::V1::PipelineJob#state PipelineJob.state} is set to
            # `CANCELLED`.
            #
            # @overload cancel_pipeline_job(request, options = nil)
            #   Pass arguments to `cancel_pipeline_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CancelPipelineJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CancelPipelineJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload cancel_pipeline_job(name: nil)
            #   Pass arguments to `cancel_pipeline_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the PipelineJob to cancel.
            #     Format:
            #     `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PipelineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CancelPipelineJobRequest.new
            #
            #   # Call the cancel_pipeline_job method.
            #   result = client.cancel_pipeline_job request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def cancel_pipeline_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CancelPipelineJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.cancel_pipeline_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.cancel_pipeline_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.cancel_pipeline_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @pipeline_service_stub.call_rpc :cancel_pipeline_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Batch cancel PipelineJobs.
            # Firstly the server will check if all the jobs are in non-terminal states,
            # and skip the jobs that are already terminated.
            # If the operation failed, none of the pipeline jobs are cancelled.
            # The server will poll the states of all the pipeline jobs periodically
            # to check the cancellation status.
            # This operation will return an LRO.
            #
            # @overload batch_cancel_pipeline_jobs(request, options = nil)
            #   Pass arguments to `batch_cancel_pipeline_jobs` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::BatchCancelPipelineJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::BatchCancelPipelineJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_cancel_pipeline_jobs(parent: nil, names: nil)
            #   Pass arguments to `batch_cancel_pipeline_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the PipelineJobs' parent resource.
            #     Format: `projects/{project}/locations/{location}`
            #   @param names [::Array<::String>]
            #     Required. The names of the PipelineJobs to cancel.
            #     A maximum of 32 PipelineJobs can be cancelled in a batch.
            #     Format:
            #     `projects/{project}/locations/{location}/pipelineJobs/{pipelineJob}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::PipelineService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::BatchCancelPipelineJobsRequest.new
            #
            #   # Call the batch_cancel_pipeline_jobs method.
            #   result = client.batch_cancel_pipeline_jobs request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def batch_cancel_pipeline_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::BatchCancelPipelineJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_cancel_pipeline_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_cancel_pipeline_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_cancel_pipeline_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @pipeline_service_stub.call_rpc :batch_cancel_pipeline_jobs, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the PipelineService API.
            #
            # This class represents the configuration for PipelineService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::AIPlatform::V1::PipelineService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_training_pipeline to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::AIPlatform::V1::PipelineService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_training_pipeline.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::AIPlatform::V1::PipelineService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_training_pipeline.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::AIPlatform::V1::PipelineService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the PipelineService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_training_pipeline`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_training_pipeline
                ##
                # RPC-specific configuration for `get_training_pipeline`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_training_pipeline
                ##
                # RPC-specific configuration for `list_training_pipelines`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_training_pipelines
                ##
                # RPC-specific configuration for `delete_training_pipeline`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_training_pipeline
                ##
                # RPC-specific configuration for `cancel_training_pipeline`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :cancel_training_pipeline
                ##
                # RPC-specific configuration for `create_pipeline_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_pipeline_job
                ##
                # RPC-specific configuration for `get_pipeline_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_pipeline_job
                ##
                # RPC-specific configuration for `list_pipeline_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_pipeline_jobs
                ##
                # RPC-specific configuration for `delete_pipeline_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_pipeline_job
                ##
                # RPC-specific configuration for `batch_delete_pipeline_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_delete_pipeline_jobs
                ##
                # RPC-specific configuration for `cancel_pipeline_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :cancel_pipeline_job
                ##
                # RPC-specific configuration for `batch_cancel_pipeline_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_cancel_pipeline_jobs

                # @private
                def initialize parent_rpcs = nil
                  create_training_pipeline_config = parent_rpcs.create_training_pipeline if parent_rpcs.respond_to? :create_training_pipeline
                  @create_training_pipeline = ::Gapic::Config::Method.new create_training_pipeline_config
                  get_training_pipeline_config = parent_rpcs.get_training_pipeline if parent_rpcs.respond_to? :get_training_pipeline
                  @get_training_pipeline = ::Gapic::Config::Method.new get_training_pipeline_config
                  list_training_pipelines_config = parent_rpcs.list_training_pipelines if parent_rpcs.respond_to? :list_training_pipelines
                  @list_training_pipelines = ::Gapic::Config::Method.new list_training_pipelines_config
                  delete_training_pipeline_config = parent_rpcs.delete_training_pipeline if parent_rpcs.respond_to? :delete_training_pipeline
                  @delete_training_pipeline = ::Gapic::Config::Method.new delete_training_pipeline_config
                  cancel_training_pipeline_config = parent_rpcs.cancel_training_pipeline if parent_rpcs.respond_to? :cancel_training_pipeline
                  @cancel_training_pipeline = ::Gapic::Config::Method.new cancel_training_pipeline_config
                  create_pipeline_job_config = parent_rpcs.create_pipeline_job if parent_rpcs.respond_to? :create_pipeline_job
                  @create_pipeline_job = ::Gapic::Config::Method.new create_pipeline_job_config
                  get_pipeline_job_config = parent_rpcs.get_pipeline_job if parent_rpcs.respond_to? :get_pipeline_job
                  @get_pipeline_job = ::Gapic::Config::Method.new get_pipeline_job_config
                  list_pipeline_jobs_config = parent_rpcs.list_pipeline_jobs if parent_rpcs.respond_to? :list_pipeline_jobs
                  @list_pipeline_jobs = ::Gapic::Config::Method.new list_pipeline_jobs_config
                  delete_pipeline_job_config = parent_rpcs.delete_pipeline_job if parent_rpcs.respond_to? :delete_pipeline_job
                  @delete_pipeline_job = ::Gapic::Config::Method.new delete_pipeline_job_config
                  batch_delete_pipeline_jobs_config = parent_rpcs.batch_delete_pipeline_jobs if parent_rpcs.respond_to? :batch_delete_pipeline_jobs
                  @batch_delete_pipeline_jobs = ::Gapic::Config::Method.new batch_delete_pipeline_jobs_config
                  cancel_pipeline_job_config = parent_rpcs.cancel_pipeline_job if parent_rpcs.respond_to? :cancel_pipeline_job
                  @cancel_pipeline_job = ::Gapic::Config::Method.new cancel_pipeline_job_config
                  batch_cancel_pipeline_jobs_config = parent_rpcs.batch_cancel_pipeline_jobs if parent_rpcs.respond_to? :batch_cancel_pipeline_jobs
                  @batch_cancel_pipeline_jobs = ::Gapic::Config::Method.new batch_cancel_pipeline_jobs_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
