# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/notebook_service_pb"
require "google/cloud/ai_platform/v1/notebook_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module AIPlatform
      module V1
        module NotebookService
          module Rest
            ##
            # REST client for the NotebookService service.
            #
            # The interface for Vertex Notebook service (a.k.a. Colab on Workbench).
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :notebook_service_stub

              ##
              # Configure the NotebookService Client class.
              #
              # See {::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all NotebookService clients
              #   ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the NotebookService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @notebook_service_stub.universe_domain
              end

              ##
              # Create a new NotebookService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the NotebookService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @notebook_service_stub = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @notebook_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @notebook_service_stub.endpoint
                  config.universe_domain = @notebook_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @notebook_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @notebook_service_stub.endpoint
                  config.universe_domain = @notebook_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @notebook_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @notebook_service_stub.logger
              end

              # Service calls

              ##
              # Creates a NotebookRuntimeTemplate.
              #
              # @overload create_notebook_runtime_template(request, options = nil)
              #   Pass arguments to `create_notebook_runtime_template` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::CreateNotebookRuntimeTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::CreateNotebookRuntimeTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_notebook_runtime_template(parent: nil, notebook_runtime_template: nil, notebook_runtime_template_id: nil)
              #   Pass arguments to `create_notebook_runtime_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Location to create the
              #     NotebookRuntimeTemplate. Format: `projects/{project}/locations/{location}`
              #   @param notebook_runtime_template [::Google::Cloud::AIPlatform::V1::NotebookRuntimeTemplate, ::Hash]
              #     Required. The NotebookRuntimeTemplate to create.
              #   @param notebook_runtime_template_id [::String]
              #     Optional. User specified ID for the notebook runtime template.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::CreateNotebookRuntimeTemplateRequest.new
              #
              #   # Call the create_notebook_runtime_template method.
              #   result = client.create_notebook_runtime_template request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_notebook_runtime_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateNotebookRuntimeTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_notebook_runtime_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_notebook_runtime_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_notebook_runtime_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.create_notebook_runtime_template request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a NotebookRuntimeTemplate.
              #
              # @overload get_notebook_runtime_template(request, options = nil)
              #   Pass arguments to `get_notebook_runtime_template` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::GetNotebookRuntimeTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::GetNotebookRuntimeTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_notebook_runtime_template(name: nil)
              #   Pass arguments to `get_notebook_runtime_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the NotebookRuntimeTemplate resource.
              #     Format:
              #     `projects/{project}/locations/{location}/notebookRuntimeTemplates/{notebook_runtime_template}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::NotebookRuntimeTemplate]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::NotebookRuntimeTemplate]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::GetNotebookRuntimeTemplateRequest.new
              #
              #   # Call the get_notebook_runtime_template method.
              #   result = client.get_notebook_runtime_template request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::NotebookRuntimeTemplate.
              #   p result
              #
              def get_notebook_runtime_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetNotebookRuntimeTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_notebook_runtime_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_notebook_runtime_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_notebook_runtime_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.get_notebook_runtime_template request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists NotebookRuntimeTemplates in a Location.
              #
              # @overload list_notebook_runtime_templates(request, options = nil)
              #   Pass arguments to `list_notebook_runtime_templates` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListNotebookRuntimeTemplatesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListNotebookRuntimeTemplatesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_notebook_runtime_templates(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil, order_by: nil)
              #   Pass arguments to `list_notebook_runtime_templates` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Location from which to list the
              #     NotebookRuntimeTemplates.
              #     Format: `projects/{project}/locations/{location}`
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request. For field
              #     names both snake_case and camelCase are supported.
              #
              #       * `notebookRuntimeTemplate` supports = and !=. `notebookRuntimeTemplate`
              #         represents the NotebookRuntimeTemplate ID,
              #         i.e. the last segment of the NotebookRuntimeTemplate's [resource name]
              #         [google.cloud.aiplatform.v1.NotebookRuntimeTemplate.name].
              #       * `display_name` supports = and !=
              #       * `labels` supports general map functions that is:
              #         * `labels.key=value` - key:value equality
              #         * `labels.key:* or labels:key - key existence
              #         * A key including a space must be quoted. `labels."a key"`.
              #       * `notebookRuntimeType` supports = and !=. notebookRuntimeType enum:
              #       [USER_DEFINED, ONE_CLICK].
              #       * `machineType` supports = and !=.
              #       * `acceleratorType` supports = and !=.
              #
              #     Some examples:
              #
              #       * `notebookRuntimeTemplate=notebookRuntimeTemplate123`
              #       * `displayName="myDisplayName"`
              #       * `labels.myKey="myValue"`
              #       * `notebookRuntimeType=USER_DEFINED`
              #       * `machineType=e2-standard-4`
              #       * `acceleratorType=NVIDIA_TESLA_T4`
              #   @param page_size [::Integer]
              #     Optional. The standard list page size.
              #   @param page_token [::String]
              #     Optional. The standard list page token.
              #     Typically obtained via
              #     {::Google::Cloud::AIPlatform::V1::ListNotebookRuntimeTemplatesResponse#next_page_token ListNotebookRuntimeTemplatesResponse.next_page_token}
              #     of the previous
              #     {::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client#list_notebook_runtime_templates NotebookService.ListNotebookRuntimeTemplates}
              #     call.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Mask specifying which fields to read.
              #   @param order_by [::String]
              #     Optional. A comma-separated list of fields to order by, sorted in ascending
              #     order. Use "desc" after a field name for descending. Supported fields:
              #
              #       * `display_name`
              #       * `create_time`
              #       * `update_time`
              #
              #     Example: `display_name, create_time desc`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::NotebookRuntimeTemplate>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::NotebookRuntimeTemplate>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListNotebookRuntimeTemplatesRequest.new
              #
              #   # Call the list_notebook_runtime_templates method.
              #   result = client.list_notebook_runtime_templates request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::NotebookRuntimeTemplate.
              #     p item
              #   end
              #
              def list_notebook_runtime_templates request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListNotebookRuntimeTemplatesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_notebook_runtime_templates.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_notebook_runtime_templates.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_notebook_runtime_templates.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.list_notebook_runtime_templates request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @notebook_service_stub, :list_notebook_runtime_templates, "notebook_runtime_templates", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a NotebookRuntimeTemplate.
              #
              # @overload delete_notebook_runtime_template(request, options = nil)
              #   Pass arguments to `delete_notebook_runtime_template` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::DeleteNotebookRuntimeTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::DeleteNotebookRuntimeTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_notebook_runtime_template(name: nil)
              #   Pass arguments to `delete_notebook_runtime_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the NotebookRuntimeTemplate resource to be deleted.
              #     Format:
              #     `projects/{project}/locations/{location}/notebookRuntimeTemplates/{notebook_runtime_template}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::DeleteNotebookRuntimeTemplateRequest.new
              #
              #   # Call the delete_notebook_runtime_template method.
              #   result = client.delete_notebook_runtime_template request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_notebook_runtime_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteNotebookRuntimeTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_notebook_runtime_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_notebook_runtime_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_notebook_runtime_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.delete_notebook_runtime_template request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a NotebookRuntimeTemplate.
              #
              # @overload update_notebook_runtime_template(request, options = nil)
              #   Pass arguments to `update_notebook_runtime_template` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::UpdateNotebookRuntimeTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::UpdateNotebookRuntimeTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_notebook_runtime_template(notebook_runtime_template: nil, update_mask: nil)
              #   Pass arguments to `update_notebook_runtime_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param notebook_runtime_template [::Google::Cloud::AIPlatform::V1::NotebookRuntimeTemplate, ::Hash]
              #     Required. The NotebookRuntimeTemplate to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The update mask applies to the resource.
              #     For the `FieldMask` definition, see
              #     {::Google::Protobuf::FieldMask google.protobuf.FieldMask}. Input format:
              #     `{paths: "${updated_filed}"}` Updatable fields:
              #
              #       * `encryption_spec.kms_key_name`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::NotebookRuntimeTemplate]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::NotebookRuntimeTemplate]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::UpdateNotebookRuntimeTemplateRequest.new
              #
              #   # Call the update_notebook_runtime_template method.
              #   result = client.update_notebook_runtime_template request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::NotebookRuntimeTemplate.
              #   p result
              #
              def update_notebook_runtime_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateNotebookRuntimeTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_notebook_runtime_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_notebook_runtime_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_notebook_runtime_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.update_notebook_runtime_template request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Assigns a NotebookRuntime to a user for a particular Notebook file. This
              # method will either returns an existing assignment or generates a new one.
              #
              # @overload assign_notebook_runtime(request, options = nil)
              #   Pass arguments to `assign_notebook_runtime` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::AssignNotebookRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::AssignNotebookRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload assign_notebook_runtime(parent: nil, notebook_runtime_template: nil, notebook_runtime: nil, notebook_runtime_id: nil)
              #   Pass arguments to `assign_notebook_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Location to get the NotebookRuntime
              #     assignment. Format: `projects/{project}/locations/{location}`
              #   @param notebook_runtime_template [::String]
              #     Required. The resource name of the NotebookRuntimeTemplate based on which a
              #     NotebookRuntime will be assigned (reuse or create a new one).
              #   @param notebook_runtime [::Google::Cloud::AIPlatform::V1::NotebookRuntime, ::Hash]
              #     Required. Provide runtime specific information (e.g. runtime owner,
              #     notebook id) used for NotebookRuntime assignment.
              #   @param notebook_runtime_id [::String]
              #     Optional. User specified ID for the notebook runtime.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::AssignNotebookRuntimeRequest.new
              #
              #   # Call the assign_notebook_runtime method.
              #   result = client.assign_notebook_runtime request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def assign_notebook_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::AssignNotebookRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.assign_notebook_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.assign_notebook_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.assign_notebook_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.assign_notebook_runtime request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a NotebookRuntime.
              #
              # @overload get_notebook_runtime(request, options = nil)
              #   Pass arguments to `get_notebook_runtime` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::GetNotebookRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::GetNotebookRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_notebook_runtime(name: nil)
              #   Pass arguments to `get_notebook_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the NotebookRuntime resource.
              #     Instead of checking whether the name is in valid NotebookRuntime resource
              #     name format, directly throw NotFound exception if there is no such
              #     NotebookRuntime in spanner.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::NotebookRuntime]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::NotebookRuntime]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::GetNotebookRuntimeRequest.new
              #
              #   # Call the get_notebook_runtime method.
              #   result = client.get_notebook_runtime request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::NotebookRuntime.
              #   p result
              #
              def get_notebook_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetNotebookRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_notebook_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_notebook_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_notebook_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.get_notebook_runtime request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists NotebookRuntimes in a Location.
              #
              # @overload list_notebook_runtimes(request, options = nil)
              #   Pass arguments to `list_notebook_runtimes` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListNotebookRuntimesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListNotebookRuntimesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_notebook_runtimes(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil, order_by: nil)
              #   Pass arguments to `list_notebook_runtimes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Location from which to list the
              #     NotebookRuntimes.
              #     Format: `projects/{project}/locations/{location}`
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request. For field
              #     names both snake_case and camelCase are supported.
              #
              #       * `notebookRuntime` supports = and !=. `notebookRuntime` represents the
              #         NotebookRuntime ID,
              #         i.e. the last segment of the NotebookRuntime's [resource name]
              #         [google.cloud.aiplatform.v1.NotebookRuntime.name].
              #       * `displayName` supports = and != and regex.
              #       * `notebookRuntimeTemplate` supports = and !=. `notebookRuntimeTemplate`
              #         represents the NotebookRuntimeTemplate ID,
              #         i.e. the last segment of the NotebookRuntimeTemplate's [resource name]
              #         [google.cloud.aiplatform.v1.NotebookRuntimeTemplate.name].
              #       * `healthState` supports = and !=. healthState enum: [HEALTHY, UNHEALTHY,
              #       HEALTH_STATE_UNSPECIFIED].
              #       * `runtimeState` supports = and !=. runtimeState enum:
              #       [RUNTIME_STATE_UNSPECIFIED, RUNNING, BEING_STARTED, BEING_STOPPED,
              #       STOPPED, BEING_UPGRADED, ERROR, INVALID].
              #       * `runtimeUser` supports = and !=.
              #       * API version is UI only: `uiState` supports = and !=. uiState enum:
              #       [UI_RESOURCE_STATE_UNSPECIFIED, UI_RESOURCE_STATE_BEING_CREATED,
              #       UI_RESOURCE_STATE_ACTIVE, UI_RESOURCE_STATE_BEING_DELETED,
              #       UI_RESOURCE_STATE_CREATION_FAILED].
              #       * `notebookRuntimeType` supports = and !=. notebookRuntimeType enum:
              #       [USER_DEFINED, ONE_CLICK].
              #       * `machineType` supports = and !=.
              #       * `acceleratorType` supports = and !=.
              #
              #     Some examples:
              #
              #       * `notebookRuntime="notebookRuntime123"`
              #       * `displayName="myDisplayName"` and `displayName=~"myDisplayNameRegex"`
              #       * `notebookRuntimeTemplate="notebookRuntimeTemplate321"`
              #       * `healthState=HEALTHY`
              #       * `runtimeState=RUNNING`
              #       * `runtimeUser="test@google.com"`
              #       * `uiState=UI_RESOURCE_STATE_BEING_DELETED`
              #       * `notebookRuntimeType=USER_DEFINED`
              #       * `machineType=e2-standard-4`
              #       * `acceleratorType=NVIDIA_TESLA_T4`
              #   @param page_size [::Integer]
              #     Optional. The standard list page size.
              #   @param page_token [::String]
              #     Optional. The standard list page token.
              #     Typically obtained via
              #     {::Google::Cloud::AIPlatform::V1::ListNotebookRuntimesResponse#next_page_token ListNotebookRuntimesResponse.next_page_token}
              #     of the previous
              #     {::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client#list_notebook_runtimes NotebookService.ListNotebookRuntimes}
              #     call.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Mask specifying which fields to read.
              #   @param order_by [::String]
              #     Optional. A comma-separated list of fields to order by, sorted in ascending
              #     order. Use "desc" after a field name for descending. Supported fields:
              #
              #       * `display_name`
              #       * `create_time`
              #       * `update_time`
              #
              #     Example: `display_name, create_time desc`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::NotebookRuntime>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::NotebookRuntime>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListNotebookRuntimesRequest.new
              #
              #   # Call the list_notebook_runtimes method.
              #   result = client.list_notebook_runtimes request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::NotebookRuntime.
              #     p item
              #   end
              #
              def list_notebook_runtimes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListNotebookRuntimesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_notebook_runtimes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_notebook_runtimes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_notebook_runtimes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.list_notebook_runtimes request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @notebook_service_stub, :list_notebook_runtimes, "notebook_runtimes", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a NotebookRuntime.
              #
              # @overload delete_notebook_runtime(request, options = nil)
              #   Pass arguments to `delete_notebook_runtime` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::DeleteNotebookRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::DeleteNotebookRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_notebook_runtime(name: nil)
              #   Pass arguments to `delete_notebook_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the NotebookRuntime resource to be deleted.
              #     Instead of checking whether the name is in valid NotebookRuntime resource
              #     name format, directly throw NotFound exception if there is no such
              #     NotebookRuntime in spanner.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::DeleteNotebookRuntimeRequest.new
              #
              #   # Call the delete_notebook_runtime method.
              #   result = client.delete_notebook_runtime request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_notebook_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteNotebookRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_notebook_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_notebook_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_notebook_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.delete_notebook_runtime request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Upgrades a NotebookRuntime.
              #
              # @overload upgrade_notebook_runtime(request, options = nil)
              #   Pass arguments to `upgrade_notebook_runtime` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::UpgradeNotebookRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::UpgradeNotebookRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload upgrade_notebook_runtime(name: nil)
              #   Pass arguments to `upgrade_notebook_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the NotebookRuntime resource to be upgrade.
              #     Instead of checking whether the name is in valid NotebookRuntime resource
              #     name format, directly throw NotFound exception if there is no such
              #     NotebookRuntime in spanner.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::UpgradeNotebookRuntimeRequest.new
              #
              #   # Call the upgrade_notebook_runtime method.
              #   result = client.upgrade_notebook_runtime request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def upgrade_notebook_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpgradeNotebookRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.upgrade_notebook_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.upgrade_notebook_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.upgrade_notebook_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.upgrade_notebook_runtime request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts a NotebookRuntime.
              #
              # @overload start_notebook_runtime(request, options = nil)
              #   Pass arguments to `start_notebook_runtime` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::StartNotebookRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::StartNotebookRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload start_notebook_runtime(name: nil)
              #   Pass arguments to `start_notebook_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the NotebookRuntime resource to be started.
              #     Instead of checking whether the name is in valid NotebookRuntime resource
              #     name format, directly throw NotFound exception if there is no such
              #     NotebookRuntime in spanner.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::StartNotebookRuntimeRequest.new
              #
              #   # Call the start_notebook_runtime method.
              #   result = client.start_notebook_runtime request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def start_notebook_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::StartNotebookRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.start_notebook_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.start_notebook_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.start_notebook_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.start_notebook_runtime request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Stops a NotebookRuntime.
              #
              # @overload stop_notebook_runtime(request, options = nil)
              #   Pass arguments to `stop_notebook_runtime` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::StopNotebookRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::StopNotebookRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload stop_notebook_runtime(name: nil)
              #   Pass arguments to `stop_notebook_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the NotebookRuntime resource to be stopped.
              #     Instead of checking whether the name is in valid NotebookRuntime resource
              #     name format, directly throw NotFound exception if there is no such
              #     NotebookRuntime in spanner.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::StopNotebookRuntimeRequest.new
              #
              #   # Call the stop_notebook_runtime method.
              #   result = client.stop_notebook_runtime request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def stop_notebook_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::StopNotebookRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.stop_notebook_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.stop_notebook_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.stop_notebook_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.stop_notebook_runtime request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a NotebookExecutionJob.
              #
              # @overload create_notebook_execution_job(request, options = nil)
              #   Pass arguments to `create_notebook_execution_job` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::CreateNotebookExecutionJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::CreateNotebookExecutionJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_notebook_execution_job(parent: nil, notebook_execution_job: nil, notebook_execution_job_id: nil)
              #   Pass arguments to `create_notebook_execution_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Location to create the
              #     NotebookExecutionJob. Format: `projects/{project}/locations/{location}`
              #   @param notebook_execution_job [::Google::Cloud::AIPlatform::V1::NotebookExecutionJob, ::Hash]
              #     Required. The NotebookExecutionJob to create.
              #   @param notebook_execution_job_id [::String]
              #     Optional. User specified ID for the NotebookExecutionJob.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::CreateNotebookExecutionJobRequest.new
              #
              #   # Call the create_notebook_execution_job method.
              #   result = client.create_notebook_execution_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_notebook_execution_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateNotebookExecutionJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_notebook_execution_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_notebook_execution_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_notebook_execution_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.create_notebook_execution_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a NotebookExecutionJob.
              #
              # @overload get_notebook_execution_job(request, options = nil)
              #   Pass arguments to `get_notebook_execution_job` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::GetNotebookExecutionJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::GetNotebookExecutionJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_notebook_execution_job(name: nil, view: nil)
              #   Pass arguments to `get_notebook_execution_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the NotebookExecutionJob resource.
              #   @param view [::Google::Cloud::AIPlatform::V1::NotebookExecutionJobView]
              #     Optional. The NotebookExecutionJob view. Defaults to BASIC.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::NotebookExecutionJob]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::NotebookExecutionJob]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::GetNotebookExecutionJobRequest.new
              #
              #   # Call the get_notebook_execution_job method.
              #   result = client.get_notebook_execution_job request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::NotebookExecutionJob.
              #   p result
              #
              def get_notebook_execution_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetNotebookExecutionJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_notebook_execution_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_notebook_execution_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_notebook_execution_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.get_notebook_execution_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists NotebookExecutionJobs in a Location.
              #
              # @overload list_notebook_execution_jobs(request, options = nil)
              #   Pass arguments to `list_notebook_execution_jobs` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListNotebookExecutionJobsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListNotebookExecutionJobsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_notebook_execution_jobs(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil, view: nil)
              #   Pass arguments to `list_notebook_execution_jobs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Location from which to list the
              #     NotebookExecutionJobs.
              #     Format: `projects/{project}/locations/{location}`
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request. For field
              #     names both snake_case and camelCase are supported.
              #
              #       * `notebookExecutionJob` supports = and !=. `notebookExecutionJob`
              #       represents the NotebookExecutionJob ID.
              #       * `displayName` supports = and != and regex.
              #       * `schedule` supports = and != and regex.
              #
              #     Some examples:
              #       * `notebookExecutionJob="123"`
              #       * `notebookExecutionJob="my-execution-job"`
              #       * `displayName="myDisplayName"` and `displayName=~"myDisplayNameRegex"`
              #   @param page_size [::Integer]
              #     Optional. The standard list page size.
              #   @param page_token [::String]
              #     Optional. The standard list page token.
              #     Typically obtained via
              #     {::Google::Cloud::AIPlatform::V1::ListNotebookExecutionJobsResponse#next_page_token ListNotebookExecutionJobsResponse.next_page_token}
              #     of the previous
              #     {::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client#list_notebook_execution_jobs NotebookService.ListNotebookExecutionJobs}
              #     call.
              #   @param order_by [::String]
              #     Optional. A comma-separated list of fields to order by, sorted in ascending
              #     order. Use "desc" after a field name for descending. Supported fields:
              #
              #       * `display_name`
              #       * `create_time`
              #       * `update_time`
              #
              #     Example: `display_name, create_time desc`.
              #   @param view [::Google::Cloud::AIPlatform::V1::NotebookExecutionJobView]
              #     Optional. The NotebookExecutionJob view. Defaults to BASIC.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::NotebookExecutionJob>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::NotebookExecutionJob>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListNotebookExecutionJobsRequest.new
              #
              #   # Call the list_notebook_execution_jobs method.
              #   result = client.list_notebook_execution_jobs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::NotebookExecutionJob.
              #     p item
              #   end
              #
              def list_notebook_execution_jobs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListNotebookExecutionJobsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_notebook_execution_jobs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_notebook_execution_jobs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_notebook_execution_jobs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.list_notebook_execution_jobs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @notebook_service_stub, :list_notebook_execution_jobs, "notebook_execution_jobs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a NotebookExecutionJob.
              #
              # @overload delete_notebook_execution_job(request, options = nil)
              #   Pass arguments to `delete_notebook_execution_job` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::DeleteNotebookExecutionJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::DeleteNotebookExecutionJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_notebook_execution_job(name: nil)
              #   Pass arguments to `delete_notebook_execution_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the NotebookExecutionJob resource to be deleted.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::DeleteNotebookExecutionJobRequest.new
              #
              #   # Call the delete_notebook_execution_job method.
              #   result = client.delete_notebook_execution_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_notebook_execution_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteNotebookExecutionJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_notebook_execution_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_notebook_execution_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_notebook_execution_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.delete_notebook_execution_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the NotebookService REST API.
              #
              # This class represents the configuration for NotebookService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_notebook_runtime_template to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_notebook_runtime_template.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_notebook_runtime_template.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the NotebookService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_notebook_runtime_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_notebook_runtime_template
                  ##
                  # RPC-specific configuration for `get_notebook_runtime_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_notebook_runtime_template
                  ##
                  # RPC-specific configuration for `list_notebook_runtime_templates`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_notebook_runtime_templates
                  ##
                  # RPC-specific configuration for `delete_notebook_runtime_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_notebook_runtime_template
                  ##
                  # RPC-specific configuration for `update_notebook_runtime_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_notebook_runtime_template
                  ##
                  # RPC-specific configuration for `assign_notebook_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :assign_notebook_runtime
                  ##
                  # RPC-specific configuration for `get_notebook_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_notebook_runtime
                  ##
                  # RPC-specific configuration for `list_notebook_runtimes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_notebook_runtimes
                  ##
                  # RPC-specific configuration for `delete_notebook_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_notebook_runtime
                  ##
                  # RPC-specific configuration for `upgrade_notebook_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :upgrade_notebook_runtime
                  ##
                  # RPC-specific configuration for `start_notebook_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :start_notebook_runtime
                  ##
                  # RPC-specific configuration for `stop_notebook_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :stop_notebook_runtime
                  ##
                  # RPC-specific configuration for `create_notebook_execution_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_notebook_execution_job
                  ##
                  # RPC-specific configuration for `get_notebook_execution_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_notebook_execution_job
                  ##
                  # RPC-specific configuration for `list_notebook_execution_jobs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_notebook_execution_jobs
                  ##
                  # RPC-specific configuration for `delete_notebook_execution_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_notebook_execution_job

                  # @private
                  def initialize parent_rpcs = nil
                    create_notebook_runtime_template_config = parent_rpcs.create_notebook_runtime_template if parent_rpcs.respond_to? :create_notebook_runtime_template
                    @create_notebook_runtime_template = ::Gapic::Config::Method.new create_notebook_runtime_template_config
                    get_notebook_runtime_template_config = parent_rpcs.get_notebook_runtime_template if parent_rpcs.respond_to? :get_notebook_runtime_template
                    @get_notebook_runtime_template = ::Gapic::Config::Method.new get_notebook_runtime_template_config
                    list_notebook_runtime_templates_config = parent_rpcs.list_notebook_runtime_templates if parent_rpcs.respond_to? :list_notebook_runtime_templates
                    @list_notebook_runtime_templates = ::Gapic::Config::Method.new list_notebook_runtime_templates_config
                    delete_notebook_runtime_template_config = parent_rpcs.delete_notebook_runtime_template if parent_rpcs.respond_to? :delete_notebook_runtime_template
                    @delete_notebook_runtime_template = ::Gapic::Config::Method.new delete_notebook_runtime_template_config
                    update_notebook_runtime_template_config = parent_rpcs.update_notebook_runtime_template if parent_rpcs.respond_to? :update_notebook_runtime_template
                    @update_notebook_runtime_template = ::Gapic::Config::Method.new update_notebook_runtime_template_config
                    assign_notebook_runtime_config = parent_rpcs.assign_notebook_runtime if parent_rpcs.respond_to? :assign_notebook_runtime
                    @assign_notebook_runtime = ::Gapic::Config::Method.new assign_notebook_runtime_config
                    get_notebook_runtime_config = parent_rpcs.get_notebook_runtime if parent_rpcs.respond_to? :get_notebook_runtime
                    @get_notebook_runtime = ::Gapic::Config::Method.new get_notebook_runtime_config
                    list_notebook_runtimes_config = parent_rpcs.list_notebook_runtimes if parent_rpcs.respond_to? :list_notebook_runtimes
                    @list_notebook_runtimes = ::Gapic::Config::Method.new list_notebook_runtimes_config
                    delete_notebook_runtime_config = parent_rpcs.delete_notebook_runtime if parent_rpcs.respond_to? :delete_notebook_runtime
                    @delete_notebook_runtime = ::Gapic::Config::Method.new delete_notebook_runtime_config
                    upgrade_notebook_runtime_config = parent_rpcs.upgrade_notebook_runtime if parent_rpcs.respond_to? :upgrade_notebook_runtime
                    @upgrade_notebook_runtime = ::Gapic::Config::Method.new upgrade_notebook_runtime_config
                    start_notebook_runtime_config = parent_rpcs.start_notebook_runtime if parent_rpcs.respond_to? :start_notebook_runtime
                    @start_notebook_runtime = ::Gapic::Config::Method.new start_notebook_runtime_config
                    stop_notebook_runtime_config = parent_rpcs.stop_notebook_runtime if parent_rpcs.respond_to? :stop_notebook_runtime
                    @stop_notebook_runtime = ::Gapic::Config::Method.new stop_notebook_runtime_config
                    create_notebook_execution_job_config = parent_rpcs.create_notebook_execution_job if parent_rpcs.respond_to? :create_notebook_execution_job
                    @create_notebook_execution_job = ::Gapic::Config::Method.new create_notebook_execution_job_config
                    get_notebook_execution_job_config = parent_rpcs.get_notebook_execution_job if parent_rpcs.respond_to? :get_notebook_execution_job
                    @get_notebook_execution_job = ::Gapic::Config::Method.new get_notebook_execution_job_config
                    list_notebook_execution_jobs_config = parent_rpcs.list_notebook_execution_jobs if parent_rpcs.respond_to? :list_notebook_execution_jobs
                    @list_notebook_execution_jobs = ::Gapic::Config::Method.new list_notebook_execution_jobs_config
                    delete_notebook_execution_job_config = parent_rpcs.delete_notebook_execution_job if parent_rpcs.respond_to? :delete_notebook_execution_job
                    @delete_notebook_execution_job = ::Gapic::Config::Method.new delete_notebook_execution_job_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
