# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        module NotebookService
          # Path helper methods for the NotebookService API.
          module Paths
            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Network resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/global/networks/{network}`
            #
            # @param project [String]
            # @param network [String]
            #
            # @return [::String]
            def network_path project:, network:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/global/networks/#{network}"
            end

            ##
            # Create a fully-qualified NotebookExecutionJob resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/notebookExecutionJobs/{notebook_execution_job}`
            #
            # @param project [String]
            # @param location [String]
            # @param notebook_execution_job [String]
            #
            # @return [::String]
            def notebook_execution_job_path project:, location:, notebook_execution_job:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/notebookExecutionJobs/#{notebook_execution_job}"
            end

            ##
            # Create a fully-qualified NotebookRuntime resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/notebookRuntimes/{notebook_runtime}`
            #
            # @param project [String]
            # @param location [String]
            # @param notebook_runtime [String]
            #
            # @return [::String]
            def notebook_runtime_path project:, location:, notebook_runtime:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/notebookRuntimes/#{notebook_runtime}"
            end

            ##
            # Create a fully-qualified NotebookRuntimeTemplate resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/notebookRuntimeTemplates/{notebook_runtime_template}`
            #
            # @param project [String]
            # @param location [String]
            # @param notebook_runtime_template [String]
            #
            # @return [::String]
            def notebook_runtime_template_path project:, location:, notebook_runtime_template:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/notebookRuntimeTemplates/#{notebook_runtime_template}"
            end

            ##
            # Create a fully-qualified Reservation resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project_id_or_number}/zones/{zone}/reservations/{reservation_name}`
            #
            # @param project_id_or_number [String]
            # @param zone [String]
            # @param reservation_name [String]
            #
            # @return [::String]
            def reservation_path project_id_or_number:, zone:, reservation_name:
              raise ::ArgumentError, "project_id_or_number cannot contain /" if project_id_or_number.to_s.include? "/"
              raise ::ArgumentError, "zone cannot contain /" if zone.to_s.include? "/"

              "projects/#{project_id_or_number}/zones/#{zone}/reservations/#{reservation_name}"
            end

            ##
            # Create a fully-qualified Schedule resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/schedules/{schedule}`
            #
            # @param project [String]
            # @param location [String]
            # @param schedule [String]
            #
            # @return [::String]
            def schedule_path project:, location:, schedule:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/schedules/#{schedule}"
            end

            ##
            # Create a fully-qualified Subnetwork resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/regions/{region}/subnetworks/{subnetwork}`
            #
            # @param project [String]
            # @param region [String]
            # @param subnetwork [String]
            #
            # @return [::String]
            def subnetwork_path project:, region:, subnetwork:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "region cannot contain /" if region.to_s.include? "/"

              "projects/#{project}/regions/#{region}/subnetworks/#{subnetwork}"
            end

            extend self
          end
        end
      end
    end
  end
end
