# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/model_service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module AIPlatform
      module V1
        module ModelService
          ##
          # Client for the ModelService service.
          #
          # A service for managing Vertex AI's machine learning Models.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :model_service_stub

            ##
            # Configure the ModelService Client class.
            #
            # See {::Google::Cloud::AIPlatform::V1::ModelService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all ModelService clients
            #   ::Google::Cloud::AIPlatform::V1::ModelService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the ModelService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::AIPlatform::V1::ModelService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @model_service_stub.universe_domain
            end

            ##
            # Create a new ModelService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the ModelService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/aiplatform/v1/model_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @model_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::AIPlatform::V1::ModelService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @model_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @model_service_stub.endpoint
                config.universe_domain = @model_service_stub.universe_domain
                config.logger = @model_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @model_service_stub.endpoint
                config.universe_domain = @model_service_stub.universe_domain
                config.logger = @model_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::AIPlatform::V1::ModelService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @model_service_stub.logger
            end

            # Service calls

            ##
            # Uploads a Model artifact into Vertex AI.
            #
            # @overload upload_model(request, options = nil)
            #   Pass arguments to `upload_model` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UploadModelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UploadModelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload upload_model(parent: nil, parent_model: nil, model_id: nil, model: nil, service_account: nil)
            #   Pass arguments to `upload_model` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location into which to upload the Model.
            #     Format: `projects/{project}/locations/{location}`
            #   @param parent_model [::String]
            #     Optional. The resource name of the model into which to upload the version.
            #     Only specify this field when uploading a new version.
            #   @param model_id [::String]
            #     Optional. The ID to use for the uploaded Model, which will become the final
            #     component of the model resource name.
            #
            #     This value may be up to 63 characters, and valid characters are
            #     `[a-z0-9_-]`. The first character cannot be a number or hyphen.
            #   @param model [::Google::Cloud::AIPlatform::V1::Model, ::Hash]
            #     Required. The Model to create.
            #   @param service_account [::String]
            #     Optional. The user-provided custom service account to use to do the model
            #     upload. If empty, [Vertex AI Service
            #     Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
            #     will be used to access resources needed to upload the model. This account
            #     must belong to the target project where the model is uploaded to, i.e., the
            #     project specified in the `parent` field of this request and have necessary
            #     read permissions (to Google Cloud Storage, Artifact Registry, etc.).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UploadModelRequest.new
            #
            #   # Call the upload_model method.
            #   result = client.upload_model request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def upload_model request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UploadModelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.upload_model.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.upload_model.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.upload_model.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :upload_model, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a Model.
            #
            # @overload get_model(request, options = nil)
            #   Pass arguments to `get_model` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetModelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetModelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_model(name: nil)
            #   Pass arguments to `get_model` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Model resource.
            #     Format: `projects/{project}/locations/{location}/models/{model}`
            #
            #     In order to retrieve a specific version of the model, also provide
            #     the version ID or version alias.
            #       Example: `projects/{project}/locations/{location}/models/{model}@2`
            #                  or
            #                `projects/{project}/locations/{location}/models/{model}@golden`
            #     If no version ID or alias is specified, the "default" version will be
            #     returned. The "default" version alias is created for the first version of
            #     the model, and can be moved to other versions later on. There will be
            #     exactly one default version.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Model]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Model]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetModelRequest.new
            #
            #   # Call the get_model method.
            #   result = client.get_model request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Model.
            #   p result
            #
            def get_model request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetModelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_model.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_model.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_model.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :get_model, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Models in a Location.
            #
            # @overload list_models(request, options = nil)
            #   Pass arguments to `list_models` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListModelsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListModelsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_models(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil, order_by: nil)
            #   Pass arguments to `list_models` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to list the Models from.
            #     Format: `projects/{project}/locations/{location}`
            #   @param filter [::String]
            #     An expression for filtering the results of the request. For field names
            #     both snake_case and camelCase are supported.
            #
            #       * `model` supports = and !=. `model` represents the Model ID,
            #         i.e. the last segment of the Model's [resource
            #         name][google.cloud.aiplatform.v1.Model.name].
            #       * `display_name` supports = and !=
            #       * `labels` supports general map functions that is:
            #         * `labels.key=value` - key:value equality
            #         * `labels.key:* or labels:key - key existence
            #         * A key including a space must be quoted. `labels."a key"`.
            #       * `base_model_name` only supports =
            #
            #     Some examples:
            #
            #       * `model=1234`
            #       * `displayName="myDisplayName"`
            #       * `labels.myKey="myValue"`
            #       * `baseModelName="text-bison"`
            #   @param page_size [::Integer]
            #     The standard list page size.
            #   @param page_token [::String]
            #     The standard list page token.
            #     Typically obtained via
            #     {::Google::Cloud::AIPlatform::V1::ListModelsResponse#next_page_token ListModelsResponse.next_page_token}
            #     of the previous
            #     {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_models ModelService.ListModels}
            #     call.
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order by, sorted in ascending order.
            #     Use "desc" after a field name for descending.
            #     Supported fields:
            #
            #       * `display_name`
            #       * `create_time`
            #       * `update_time`
            #
            #     Example: `display_name, create_time desc`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Model>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Model>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListModelsRequest.new
            #
            #   # Call the list_models method.
            #   result = client.list_models request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Model.
            #     p item
            #   end
            #
            def list_models request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListModelsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_models.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_models.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_models.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :list_models, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @model_service_stub, :list_models, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists versions of the specified model.
            #
            # @overload list_model_versions(request, options = nil)
            #   Pass arguments to `list_model_versions` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListModelVersionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListModelVersionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_model_versions(name: nil, page_size: nil, page_token: nil, filter: nil, read_mask: nil, order_by: nil)
            #   Pass arguments to `list_model_versions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the model to list versions for.
            #   @param page_size [::Integer]
            #     The standard list page size.
            #   @param page_token [::String]
            #     The standard list page token.
            #     Typically obtained via
            #     {::Google::Cloud::AIPlatform::V1::ListModelVersionsResponse#next_page_token next_page_token}
            #     of the previous
            #     {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_versions ListModelVersions}
            #     call.
            #   @param filter [::String]
            #     An expression for filtering the results of the request. For field names
            #     both snake_case and camelCase are supported.
            #
            #       * `labels` supports general map functions that is:
            #         * `labels.key=value` - key:value equality
            #         * `labels.key:* or labels:key - key existence
            #         * A key including a space must be quoted. `labels."a key"`.
            #
            #     Some examples:
            #
            #       * `labels.myKey="myValue"`
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order by, sorted in ascending order.
            #     Use "desc" after a field name for descending.
            #     Supported fields:
            #
            #       * `create_time`
            #       * `update_time`
            #
            #     Example: `update_time asc, create_time desc`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Model>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Model>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListModelVersionsRequest.new
            #
            #   # Call the list_model_versions method.
            #   result = client.list_model_versions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Model.
            #     p item
            #   end
            #
            def list_model_versions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListModelVersionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_model_versions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_model_versions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_model_versions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :list_model_versions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @model_service_stub, :list_model_versions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists checkpoints of the specified model version.
            #
            # @overload list_model_version_checkpoints(request, options = nil)
            #   Pass arguments to `list_model_version_checkpoints` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListModelVersionCheckpointsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListModelVersionCheckpointsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_model_version_checkpoints(name: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_model_version_checkpoints` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the model version to list checkpoints for.
            #     `projects/{project}/locations/{location}/models/{model}@{version}`
            #     Example: `projects/{project}/locations/{location}/models/{model}@2`
            #     or
            #     `projects/{project}/locations/{location}/models/{model}@golden`
            #     If no version ID or alias is specified, the latest version will be
            #     used.
            #   @param page_size [::Integer]
            #     Optional. The standard list page size.
            #   @param page_token [::String]
            #     Optional. The standard list page token.
            #     Typically obtained via
            #     {::Google::Cloud::AIPlatform::V1::ListModelVersionCheckpointsResponse#next_page_token next_page_token}
            #     of the previous
            #     {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_version_checkpoints ListModelVersionCheckpoints}
            #     call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::ModelVersionCheckpoint>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::ModelVersionCheckpoint>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListModelVersionCheckpointsRequest.new
            #
            #   # Call the list_model_version_checkpoints method.
            #   result = client.list_model_version_checkpoints request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::ModelVersionCheckpoint.
            #     p item
            #   end
            #
            def list_model_version_checkpoints request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListModelVersionCheckpointsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_model_version_checkpoints.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_model_version_checkpoints.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_model_version_checkpoints.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :list_model_version_checkpoints, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @model_service_stub, :list_model_version_checkpoints, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a Model.
            #
            # @overload update_model(request, options = nil)
            #   Pass arguments to `update_model` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateModelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateModelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_model(model: nil, update_mask: nil)
            #   Pass arguments to `update_model` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param model [::Google::Cloud::AIPlatform::V1::Model, ::Hash]
            #     Required. The Model which replaces the resource on the server.
            #     When Model Versioning is enabled, the model.name will be used to determine
            #     whether to update the model or model version.
            #     1. model.name with the @ value, e.g. models/123@1, refers to a version
            #     specific update.
            #     2. model.name without the @ value, e.g. models/123, refers to a model
            #     update.
            #     3. model.name with @-, e.g. models/123@-, refers to a model update.
            #     4. Supported model fields: display_name, description; supported
            #     version-specific fields: version_description. Labels are supported in both
            #     scenarios. Both the model labels and the version labels are merged when a
            #     model is returned. When updating labels, if the request is for
            #     model-specific update, model label gets updated. Otherwise, version labels
            #     get updated.
            #     5. A model name or model version name fields update mismatch will cause a
            #     precondition error.
            #     6. One request cannot update both the model and the version fields. You
            #     must update them separately.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The update mask applies to the resource.
            #     For the `FieldMask` definition, see
            #     {::Google::Protobuf::FieldMask google.protobuf.FieldMask}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Model]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Model]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateModelRequest.new
            #
            #   # Call the update_model method.
            #   result = client.update_model request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Model.
            #   p result
            #
            def update_model request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateModelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_model.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.model&.name
                header_params["model.name"] = request.model.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_model.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_model.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :update_model, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Incrementally update the dataset used for an examples model.
            #
            # @overload update_explanation_dataset(request, options = nil)
            #   Pass arguments to `update_explanation_dataset` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateExplanationDatasetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateExplanationDatasetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_explanation_dataset(model: nil, examples: nil)
            #   Pass arguments to `update_explanation_dataset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param model [::String]
            #     Required. The resource name of the Model to update.
            #     Format: `projects/{project}/locations/{location}/models/{model}`
            #   @param examples [::Google::Cloud::AIPlatform::V1::Examples, ::Hash]
            #     The example config containing the location of the dataset.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateExplanationDatasetRequest.new
            #
            #   # Call the update_explanation_dataset method.
            #   result = client.update_explanation_dataset request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_explanation_dataset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateExplanationDatasetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_explanation_dataset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.model
                header_params["model"] = request.model
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_explanation_dataset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_explanation_dataset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :update_explanation_dataset, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a Model.
            #
            # A model cannot be deleted if any
            # {::Google::Cloud::AIPlatform::V1::Endpoint Endpoint} resource has a
            # {::Google::Cloud::AIPlatform::V1::DeployedModel DeployedModel} based on the
            # model in its
            # {::Google::Cloud::AIPlatform::V1::Endpoint#deployed_models deployed_models}
            # field.
            #
            # @overload delete_model(request, options = nil)
            #   Pass arguments to `delete_model` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteModelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteModelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_model(name: nil)
            #   Pass arguments to `delete_model` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Model resource to be deleted.
            #     Format: `projects/{project}/locations/{location}/models/{model}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteModelRequest.new
            #
            #   # Call the delete_model method.
            #   result = client.delete_model request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_model request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteModelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_model.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_model.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_model.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :delete_model, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a Model version.
            #
            # Model version can only be deleted if there are no
            # {::Google::Cloud::AIPlatform::V1::DeployedModel DeployedModels} created from it.
            # Deleting the only version in the Model is not allowed. Use
            # {::Google::Cloud::AIPlatform::V1::ModelService::Client#delete_model DeleteModel} for
            # deleting the Model instead.
            #
            # @overload delete_model_version(request, options = nil)
            #   Pass arguments to `delete_model_version` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteModelVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteModelVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_model_version(name: nil)
            #   Pass arguments to `delete_model_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the model version to be deleted, with a version ID
            #     explicitly included.
            #
            #     Example: `projects/{project}/locations/{location}/models/{model}@1234`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteModelVersionRequest.new
            #
            #   # Call the delete_model_version method.
            #   result = client.delete_model_version request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_model_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteModelVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_model_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_model_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_model_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :delete_model_version, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Merges a set of aliases for a Model version.
            #
            # @overload merge_version_aliases(request, options = nil)
            #   Pass arguments to `merge_version_aliases` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::MergeVersionAliasesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::MergeVersionAliasesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload merge_version_aliases(name: nil, version_aliases: nil)
            #   Pass arguments to `merge_version_aliases` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the model version to merge aliases, with a version ID
            #     explicitly included.
            #
            #     Example: `projects/{project}/locations/{location}/models/{model}@1234`
            #   @param version_aliases [::Array<::String>]
            #     Required. The set of version aliases to merge.
            #     The alias should be at most 128 characters, and match
            #     `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
            #     Add the `-` prefix to an alias means removing that alias from the version.
            #     `-` is NOT counted in the 128 characters. Example: `-golden` means removing
            #     the `golden` alias from the version.
            #
            #     There is NO ordering in aliases, which means
            #     1) The aliases returned from GetModel API might not have the exactly same
            #     order from this MergeVersionAliases API. 2) Adding and deleting the same
            #     alias in the request is not recommended, and the 2 operations will be
            #     cancelled out.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Model]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Model]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::MergeVersionAliasesRequest.new
            #
            #   # Call the merge_version_aliases method.
            #   result = client.merge_version_aliases request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Model.
            #   p result
            #
            def merge_version_aliases request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::MergeVersionAliasesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.merge_version_aliases.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.merge_version_aliases.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.merge_version_aliases.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :merge_version_aliases, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Exports a trained, exportable Model to a location specified by the
            # user. A Model is considered to be exportable if it has at least one
            # [supported export
            # format][google.cloud.aiplatform.v1.Model.supported_export_formats].
            #
            # @overload export_model(request, options = nil)
            #   Pass arguments to `export_model` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ExportModelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ExportModelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload export_model(name: nil, output_config: nil)
            #   Pass arguments to `export_model` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Model to export.
            #     The resource name may contain version id or version alias to specify the
            #     version, if no version is specified, the default version will be exported.
            #   @param output_config [::Google::Cloud::AIPlatform::V1::ExportModelRequest::OutputConfig, ::Hash]
            #     Required. The desired output location and configuration.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ExportModelRequest.new
            #
            #   # Call the export_model method.
            #   result = client.export_model request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def export_model request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ExportModelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.export_model.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.export_model.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.export_model.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :export_model, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Copies an already existing Vertex AI Model into the specified Location.
            # The source Model must exist in the same Project.
            # When copying custom Models, the users themselves are responsible for
            # {::Google::Cloud::AIPlatform::V1::Model#metadata Model.metadata} content to be
            # region-agnostic, as well as making sure that any resources (e.g. files) it
            # depends on remain accessible.
            #
            # @overload copy_model(request, options = nil)
            #   Pass arguments to `copy_model` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CopyModelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CopyModelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload copy_model(model_id: nil, parent_model: nil, parent: nil, source_model: nil, encryption_spec: nil)
            #   Pass arguments to `copy_model` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param model_id [::String]
            #     Optional. Copy source_model into a new Model with this ID. The ID will
            #     become the final component of the model resource name.
            #
            #     This value may be up to 63 characters, and valid characters are
            #     `[a-z0-9_-]`. The first character cannot be a number or hyphen.
            #
            #     Note: The following parameters are mutually exclusive: `model_id`, `parent_model`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param parent_model [::String]
            #     Optional. Specify this field to copy source_model into this existing
            #     Model as a new version. Format:
            #     `projects/{project}/locations/{location}/models/{model}`
            #
            #     Note: The following parameters are mutually exclusive: `parent_model`, `model_id`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param parent [::String]
            #     Required. The resource name of the Location into which to copy the Model.
            #     Format: `projects/{project}/locations/{location}`
            #   @param source_model [::String]
            #     Required. The resource name of the Model to copy. That Model must be in the
            #     same Project. Format:
            #     `projects/{project}/locations/{location}/models/{model}`
            #   @param encryption_spec [::Google::Cloud::AIPlatform::V1::EncryptionSpec, ::Hash]
            #     Customer-managed encryption key options. If this is set,
            #     then the Model copy will be encrypted with the provided encryption key.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CopyModelRequest.new
            #
            #   # Call the copy_model method.
            #   result = client.copy_model request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def copy_model request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CopyModelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.copy_model.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.copy_model.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.copy_model.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :copy_model, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Imports an externally generated ModelEvaluation.
            #
            # @overload import_model_evaluation(request, options = nil)
            #   Pass arguments to `import_model_evaluation` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ImportModelEvaluationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ImportModelEvaluationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload import_model_evaluation(parent: nil, model_evaluation: nil)
            #   Pass arguments to `import_model_evaluation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent model resource.
            #     Format: `projects/{project}/locations/{location}/models/{model}`
            #   @param model_evaluation [::Google::Cloud::AIPlatform::V1::ModelEvaluation, ::Hash]
            #     Required. Model evaluation resource to be imported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::ModelEvaluation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::ModelEvaluation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ImportModelEvaluationRequest.new
            #
            #   # Call the import_model_evaluation method.
            #   result = client.import_model_evaluation request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::ModelEvaluation.
            #   p result
            #
            def import_model_evaluation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ImportModelEvaluationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.import_model_evaluation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.import_model_evaluation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.import_model_evaluation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :import_model_evaluation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Imports a list of externally generated ModelEvaluationSlice.
            #
            # @overload batch_import_model_evaluation_slices(request, options = nil)
            #   Pass arguments to `batch_import_model_evaluation_slices` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::BatchImportModelEvaluationSlicesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::BatchImportModelEvaluationSlicesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_import_model_evaluation_slices(parent: nil, model_evaluation_slices: nil)
            #   Pass arguments to `batch_import_model_evaluation_slices` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent ModelEvaluation resource.
            #     Format:
            #     `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}`
            #   @param model_evaluation_slices [::Array<::Google::Cloud::AIPlatform::V1::ModelEvaluationSlice, ::Hash>]
            #     Required. Model evaluation slice resource to be imported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::BatchImportModelEvaluationSlicesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::BatchImportModelEvaluationSlicesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::BatchImportModelEvaluationSlicesRequest.new
            #
            #   # Call the batch_import_model_evaluation_slices method.
            #   result = client.batch_import_model_evaluation_slices request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::BatchImportModelEvaluationSlicesResponse.
            #   p result
            #
            def batch_import_model_evaluation_slices request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::BatchImportModelEvaluationSlicesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_import_model_evaluation_slices.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_import_model_evaluation_slices.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_import_model_evaluation_slices.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :batch_import_model_evaluation_slices, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Imports a list of externally generated EvaluatedAnnotations.
            #
            # @overload batch_import_evaluated_annotations(request, options = nil)
            #   Pass arguments to `batch_import_evaluated_annotations` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::BatchImportEvaluatedAnnotationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::BatchImportEvaluatedAnnotationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_import_evaluated_annotations(parent: nil, evaluated_annotations: nil)
            #   Pass arguments to `batch_import_evaluated_annotations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent ModelEvaluationSlice resource.
            #     Format:
            #     `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}/slices/{slice}`
            #   @param evaluated_annotations [::Array<::Google::Cloud::AIPlatform::V1::EvaluatedAnnotation, ::Hash>]
            #     Required. Evaluated annotations resource to be imported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::BatchImportEvaluatedAnnotationsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::BatchImportEvaluatedAnnotationsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::BatchImportEvaluatedAnnotationsRequest.new
            #
            #   # Call the batch_import_evaluated_annotations method.
            #   result = client.batch_import_evaluated_annotations request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::BatchImportEvaluatedAnnotationsResponse.
            #   p result
            #
            def batch_import_evaluated_annotations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::BatchImportEvaluatedAnnotationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_import_evaluated_annotations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_import_evaluated_annotations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_import_evaluated_annotations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :batch_import_evaluated_annotations, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a ModelEvaluation.
            #
            # @overload get_model_evaluation(request, options = nil)
            #   Pass arguments to `get_model_evaluation` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetModelEvaluationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetModelEvaluationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_model_evaluation(name: nil)
            #   Pass arguments to `get_model_evaluation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the ModelEvaluation resource.
            #     Format:
            #     `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::ModelEvaluation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::ModelEvaluation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetModelEvaluationRequest.new
            #
            #   # Call the get_model_evaluation method.
            #   result = client.get_model_evaluation request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::ModelEvaluation.
            #   p result
            #
            def get_model_evaluation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetModelEvaluationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_model_evaluation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_model_evaluation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_model_evaluation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :get_model_evaluation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists ModelEvaluations in a Model.
            #
            # @overload list_model_evaluations(request, options = nil)
            #   Pass arguments to `list_model_evaluations` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListModelEvaluationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListModelEvaluationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_model_evaluations(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil)
            #   Pass arguments to `list_model_evaluations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Model to list the ModelEvaluations from.
            #     Format: `projects/{project}/locations/{location}/models/{model}`
            #   @param filter [::String]
            #     The standard list filter.
            #   @param page_size [::Integer]
            #     The standard list page size.
            #   @param page_token [::String]
            #     The standard list page token.
            #     Typically obtained via
            #     {::Google::Cloud::AIPlatform::V1::ListModelEvaluationsResponse#next_page_token ListModelEvaluationsResponse.next_page_token}
            #     of the previous
            #     {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_evaluations ModelService.ListModelEvaluations}
            #     call.
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::ModelEvaluation>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::ModelEvaluation>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListModelEvaluationsRequest.new
            #
            #   # Call the list_model_evaluations method.
            #   result = client.list_model_evaluations request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::ModelEvaluation.
            #     p item
            #   end
            #
            def list_model_evaluations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListModelEvaluationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_model_evaluations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_model_evaluations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_model_evaluations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :list_model_evaluations, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @model_service_stub, :list_model_evaluations, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a ModelEvaluationSlice.
            #
            # @overload get_model_evaluation_slice(request, options = nil)
            #   Pass arguments to `get_model_evaluation_slice` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetModelEvaluationSliceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetModelEvaluationSliceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_model_evaluation_slice(name: nil)
            #   Pass arguments to `get_model_evaluation_slice` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the ModelEvaluationSlice resource.
            #     Format:
            #     `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}/slices/{slice}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::ModelEvaluationSlice]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::ModelEvaluationSlice]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetModelEvaluationSliceRequest.new
            #
            #   # Call the get_model_evaluation_slice method.
            #   result = client.get_model_evaluation_slice request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::ModelEvaluationSlice.
            #   p result
            #
            def get_model_evaluation_slice request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetModelEvaluationSliceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_model_evaluation_slice.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_model_evaluation_slice.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_model_evaluation_slice.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :get_model_evaluation_slice, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists ModelEvaluationSlices in a ModelEvaluation.
            #
            # @overload list_model_evaluation_slices(request, options = nil)
            #   Pass arguments to `list_model_evaluation_slices` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListModelEvaluationSlicesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListModelEvaluationSlicesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_model_evaluation_slices(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil)
            #   Pass arguments to `list_model_evaluation_slices` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the ModelEvaluation to list the
            #     ModelEvaluationSlices from. Format:
            #     `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}`
            #   @param filter [::String]
            #     The standard list filter.
            #
            #       * `slice.dimension` - for =.
            #   @param page_size [::Integer]
            #     The standard list page size.
            #   @param page_token [::String]
            #     The standard list page token.
            #     Typically obtained via
            #     {::Google::Cloud::AIPlatform::V1::ListModelEvaluationSlicesResponse#next_page_token ListModelEvaluationSlicesResponse.next_page_token}
            #     of the previous
            #     {::Google::Cloud::AIPlatform::V1::ModelService::Client#list_model_evaluation_slices ModelService.ListModelEvaluationSlices}
            #     call.
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::ModelEvaluationSlice>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::ModelEvaluationSlice>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::ModelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListModelEvaluationSlicesRequest.new
            #
            #   # Call the list_model_evaluation_slices method.
            #   result = client.list_model_evaluation_slices request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::ModelEvaluationSlice.
            #     p item
            #   end
            #
            def list_model_evaluation_slices request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListModelEvaluationSlicesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_model_evaluation_slices.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_model_evaluation_slices.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_model_evaluation_slices.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @model_service_stub.call_rpc :list_model_evaluation_slices, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @model_service_stub, :list_model_evaluation_slices, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the ModelService API.
            #
            # This class represents the configuration for ModelService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::AIPlatform::V1::ModelService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # upload_model to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::AIPlatform::V1::ModelService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.upload_model.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.upload_model.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the ModelService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `upload_model`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :upload_model
                ##
                # RPC-specific configuration for `get_model`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_model
                ##
                # RPC-specific configuration for `list_models`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_models
                ##
                # RPC-specific configuration for `list_model_versions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_model_versions
                ##
                # RPC-specific configuration for `list_model_version_checkpoints`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_model_version_checkpoints
                ##
                # RPC-specific configuration for `update_model`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_model
                ##
                # RPC-specific configuration for `update_explanation_dataset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_explanation_dataset
                ##
                # RPC-specific configuration for `delete_model`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_model
                ##
                # RPC-specific configuration for `delete_model_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_model_version
                ##
                # RPC-specific configuration for `merge_version_aliases`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :merge_version_aliases
                ##
                # RPC-specific configuration for `export_model`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :export_model
                ##
                # RPC-specific configuration for `copy_model`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :copy_model
                ##
                # RPC-specific configuration for `import_model_evaluation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :import_model_evaluation
                ##
                # RPC-specific configuration for `batch_import_model_evaluation_slices`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_import_model_evaluation_slices
                ##
                # RPC-specific configuration for `batch_import_evaluated_annotations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_import_evaluated_annotations
                ##
                # RPC-specific configuration for `get_model_evaluation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_model_evaluation
                ##
                # RPC-specific configuration for `list_model_evaluations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_model_evaluations
                ##
                # RPC-specific configuration for `get_model_evaluation_slice`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_model_evaluation_slice
                ##
                # RPC-specific configuration for `list_model_evaluation_slices`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_model_evaluation_slices

                # @private
                def initialize parent_rpcs = nil
                  upload_model_config = parent_rpcs.upload_model if parent_rpcs.respond_to? :upload_model
                  @upload_model = ::Gapic::Config::Method.new upload_model_config
                  get_model_config = parent_rpcs.get_model if parent_rpcs.respond_to? :get_model
                  @get_model = ::Gapic::Config::Method.new get_model_config
                  list_models_config = parent_rpcs.list_models if parent_rpcs.respond_to? :list_models
                  @list_models = ::Gapic::Config::Method.new list_models_config
                  list_model_versions_config = parent_rpcs.list_model_versions if parent_rpcs.respond_to? :list_model_versions
                  @list_model_versions = ::Gapic::Config::Method.new list_model_versions_config
                  list_model_version_checkpoints_config = parent_rpcs.list_model_version_checkpoints if parent_rpcs.respond_to? :list_model_version_checkpoints
                  @list_model_version_checkpoints = ::Gapic::Config::Method.new list_model_version_checkpoints_config
                  update_model_config = parent_rpcs.update_model if parent_rpcs.respond_to? :update_model
                  @update_model = ::Gapic::Config::Method.new update_model_config
                  update_explanation_dataset_config = parent_rpcs.update_explanation_dataset if parent_rpcs.respond_to? :update_explanation_dataset
                  @update_explanation_dataset = ::Gapic::Config::Method.new update_explanation_dataset_config
                  delete_model_config = parent_rpcs.delete_model if parent_rpcs.respond_to? :delete_model
                  @delete_model = ::Gapic::Config::Method.new delete_model_config
                  delete_model_version_config = parent_rpcs.delete_model_version if parent_rpcs.respond_to? :delete_model_version
                  @delete_model_version = ::Gapic::Config::Method.new delete_model_version_config
                  merge_version_aliases_config = parent_rpcs.merge_version_aliases if parent_rpcs.respond_to? :merge_version_aliases
                  @merge_version_aliases = ::Gapic::Config::Method.new merge_version_aliases_config
                  export_model_config = parent_rpcs.export_model if parent_rpcs.respond_to? :export_model
                  @export_model = ::Gapic::Config::Method.new export_model_config
                  copy_model_config = parent_rpcs.copy_model if parent_rpcs.respond_to? :copy_model
                  @copy_model = ::Gapic::Config::Method.new copy_model_config
                  import_model_evaluation_config = parent_rpcs.import_model_evaluation if parent_rpcs.respond_to? :import_model_evaluation
                  @import_model_evaluation = ::Gapic::Config::Method.new import_model_evaluation_config
                  batch_import_model_evaluation_slices_config = parent_rpcs.batch_import_model_evaluation_slices if parent_rpcs.respond_to? :batch_import_model_evaluation_slices
                  @batch_import_model_evaluation_slices = ::Gapic::Config::Method.new batch_import_model_evaluation_slices_config
                  batch_import_evaluated_annotations_config = parent_rpcs.batch_import_evaluated_annotations if parent_rpcs.respond_to? :batch_import_evaluated_annotations
                  @batch_import_evaluated_annotations = ::Gapic::Config::Method.new batch_import_evaluated_annotations_config
                  get_model_evaluation_config = parent_rpcs.get_model_evaluation if parent_rpcs.respond_to? :get_model_evaluation
                  @get_model_evaluation = ::Gapic::Config::Method.new get_model_evaluation_config
                  list_model_evaluations_config = parent_rpcs.list_model_evaluations if parent_rpcs.respond_to? :list_model_evaluations
                  @list_model_evaluations = ::Gapic::Config::Method.new list_model_evaluations_config
                  get_model_evaluation_slice_config = parent_rpcs.get_model_evaluation_slice if parent_rpcs.respond_to? :get_model_evaluation_slice
                  @get_model_evaluation_slice = ::Gapic::Config::Method.new get_model_evaluation_slice_config
                  list_model_evaluation_slices_config = parent_rpcs.list_model_evaluation_slices if parent_rpcs.respond_to? :list_model_evaluation_slices
                  @list_model_evaluation_slices = ::Gapic::Config::Method.new list_model_evaluation_slices_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
