# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/ai_platform/v1/version"

require "google/cloud/ai_platform/v1/migration_service/credentials"
require "google/cloud/ai_platform/v1/migration_service/paths"
require "google/cloud/ai_platform/v1/migration_service/operations"
require "google/cloud/ai_platform/v1/migration_service/client"
require "google/cloud/ai_platform/v1/migration_service/rest"

module Google
  module Cloud
    module AIPlatform
      module V1
        ##
        # A service that migrates resources from automl.googleapis.com,
        # datalabeling.googleapis.com and ml.googleapis.com to Vertex AI.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/ai_platform/v1/migration_service"
        #     client = ::Google::Cloud::AIPlatform::V1::MigrationService::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/ai_platform/v1/migration_service/rest"
        #     client = ::Google::Cloud::AIPlatform::V1::MigrationService::Rest::Client.new
        #
        module MigrationService
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "migration_service", "helpers.rb"
require "google/cloud/ai_platform/v1/migration_service/helpers" if ::File.file? helper_path
