# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        module MetadataService
          # Path helper methods for the MetadataService API.
          module Paths
            ##
            # Create a fully-qualified Artifact resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`
            #
            # @param project [String]
            # @param location [String]
            # @param metadata_store [String]
            # @param artifact [String]
            #
            # @return [::String]
            def artifact_path project:, location:, metadata_store:, artifact:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "metadata_store cannot contain /" if metadata_store.to_s.include? "/"

              "projects/#{project}/locations/#{location}/metadataStores/#{metadata_store}/artifacts/#{artifact}"
            end

            ##
            # Create a fully-qualified Context resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/metadataStores/{metadata_store}/contexts/{context}`
            #
            # @param project [String]
            # @param location [String]
            # @param metadata_store [String]
            # @param context [String]
            #
            # @return [::String]
            def context_path project:, location:, metadata_store:, context:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "metadata_store cannot contain /" if metadata_store.to_s.include? "/"

              "projects/#{project}/locations/#{location}/metadataStores/#{metadata_store}/contexts/#{context}"
            end

            ##
            # Create a fully-qualified Execution resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/metadataStores/{metadata_store}/executions/{execution}`
            #
            # @param project [String]
            # @param location [String]
            # @param metadata_store [String]
            # @param execution [String]
            #
            # @return [::String]
            def execution_path project:, location:, metadata_store:, execution:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "metadata_store cannot contain /" if metadata_store.to_s.include? "/"

              "projects/#{project}/locations/#{location}/metadataStores/#{metadata_store}/executions/#{execution}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified MetadataSchema resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/metadataStores/{metadata_store}/metadataSchemas/{metadata_schema}`
            #
            # @param project [String]
            # @param location [String]
            # @param metadata_store [String]
            # @param metadata_schema [String]
            #
            # @return [::String]
            def metadata_schema_path project:, location:, metadata_store:, metadata_schema:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "metadata_store cannot contain /" if metadata_store.to_s.include? "/"

              "projects/#{project}/locations/#{location}/metadataStores/#{metadata_store}/metadataSchemas/#{metadata_schema}"
            end

            ##
            # Create a fully-qualified MetadataStore resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/metadataStores/{metadata_store}`
            #
            # @param project [String]
            # @param location [String]
            # @param metadata_store [String]
            #
            # @return [::String]
            def metadata_store_path project:, location:, metadata_store:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/metadataStores/#{metadata_store}"
            end

            extend self
          end
        end
      end
    end
  end
end
