# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/metadata_service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module AIPlatform
      module V1
        module MetadataService
          ##
          # Client for the MetadataService service.
          #
          # Service for reading and writing metadata entries.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :metadata_service_stub

            ##
            # Configure the MetadataService Client class.
            #
            # See {::Google::Cloud::AIPlatform::V1::MetadataService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all MetadataService clients
            #   ::Google::Cloud::AIPlatform::V1::MetadataService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the MetadataService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::AIPlatform::V1::MetadataService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @metadata_service_stub.universe_domain
            end

            ##
            # Create a new MetadataService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the MetadataService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/aiplatform/v1/metadata_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @metadata_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::AIPlatform::V1::MetadataService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @metadata_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @metadata_service_stub.endpoint
                config.universe_domain = @metadata_service_stub.universe_domain
                config.logger = @metadata_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @metadata_service_stub.endpoint
                config.universe_domain = @metadata_service_stub.universe_domain
                config.logger = @metadata_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::AIPlatform::V1::MetadataService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @metadata_service_stub.logger
            end

            # Service calls

            ##
            # Initializes a MetadataStore, including allocation of resources.
            #
            # @overload create_metadata_store(request, options = nil)
            #   Pass arguments to `create_metadata_store` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateMetadataStoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateMetadataStoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_metadata_store(parent: nil, metadata_store: nil, metadata_store_id: nil)
            #   Pass arguments to `create_metadata_store` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location where the MetadataStore should
            #     be created.
            #     Format: `projects/{project}/locations/{location}/`
            #   @param metadata_store [::Google::Cloud::AIPlatform::V1::MetadataStore, ::Hash]
            #     Required. The MetadataStore to create.
            #   @param metadata_store_id [::String]
            #     The \\{metadatastore} portion of the resource name with the format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
            #     If not provided, the MetadataStore's ID will be a UUID generated by the
            #     service.
            #     Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
            #     Must be unique across all MetadataStores in the parent Location.
            #     (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
            #     if the caller can't view the preexisting MetadataStore.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateMetadataStoreRequest.new
            #
            #   # Call the create_metadata_store method.
            #   result = client.create_metadata_store request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_metadata_store request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateMetadataStoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_metadata_store.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_metadata_store.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_metadata_store.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :create_metadata_store, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a specific MetadataStore.
            #
            # @overload get_metadata_store(request, options = nil)
            #   Pass arguments to `get_metadata_store` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetMetadataStoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetMetadataStoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_metadata_store(name: nil)
            #   Pass arguments to `get_metadata_store` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the MetadataStore to retrieve.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::MetadataStore]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::MetadataStore]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetMetadataStoreRequest.new
            #
            #   # Call the get_metadata_store method.
            #   result = client.get_metadata_store request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::MetadataStore.
            #   p result
            #
            def get_metadata_store request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetMetadataStoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_metadata_store.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_metadata_store.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_metadata_store.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :get_metadata_store, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists MetadataStores for a Location.
            #
            # @overload list_metadata_stores(request, options = nil)
            #   Pass arguments to `list_metadata_stores` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListMetadataStoresRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListMetadataStoresRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_metadata_stores(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_metadata_stores` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The Location whose MetadataStores should be listed.
            #     Format:
            #     `projects/{project}/locations/{location}`
            #   @param page_size [::Integer]
            #     The maximum number of Metadata Stores to return. The service may return
            #     fewer.
            #     Must be in range 1-1000, inclusive. Defaults to 100.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_metadata_stores MetadataService.ListMetadataStores}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other provided parameters must match the call that
            #     provided the page token. (Otherwise the request will fail with
            #     INVALID_ARGUMENT error.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::MetadataStore>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::MetadataStore>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListMetadataStoresRequest.new
            #
            #   # Call the list_metadata_stores method.
            #   result = client.list_metadata_stores request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::MetadataStore.
            #     p item
            #   end
            #
            def list_metadata_stores request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListMetadataStoresRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_metadata_stores.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_metadata_stores.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_metadata_stores.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :list_metadata_stores, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @metadata_service_stub, :list_metadata_stores, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single MetadataStore and all its child resources (Artifacts,
            # Executions, and Contexts).
            #
            # @overload delete_metadata_store(request, options = nil)
            #   Pass arguments to `delete_metadata_store` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteMetadataStoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteMetadataStoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_metadata_store(name: nil, force: nil)
            #   Pass arguments to `delete_metadata_store` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the MetadataStore to delete.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
            #   @param force [::Boolean]
            #     Deprecated: Field is no longer supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteMetadataStoreRequest.new
            #
            #   # Call the delete_metadata_store method.
            #   result = client.delete_metadata_store request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_metadata_store request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteMetadataStoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_metadata_store.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_metadata_store.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_metadata_store.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :delete_metadata_store, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an Artifact associated with a MetadataStore.
            #
            # @overload create_artifact(request, options = nil)
            #   Pass arguments to `create_artifact` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateArtifactRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateArtifactRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_artifact(parent: nil, artifact: nil, artifact_id: nil)
            #   Pass arguments to `create_artifact` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the MetadataStore where the Artifact should
            #     be created.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
            #   @param artifact [::Google::Cloud::AIPlatform::V1::Artifact, ::Hash]
            #     Required. The Artifact to create.
            #   @param artifact_id [::String]
            #     The \\{artifact} portion of the resource name with the format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
            #     If not provided, the Artifact's ID will be a UUID generated by the service.
            #     Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
            #     Must be unique across all Artifacts in the parent MetadataStore. (Otherwise
            #     the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED if the
            #     caller can't view the preexisting Artifact.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Artifact]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Artifact]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateArtifactRequest.new
            #
            #   # Call the create_artifact method.
            #   result = client.create_artifact request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Artifact.
            #   p result
            #
            def create_artifact request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateArtifactRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_artifact.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_artifact.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_artifact.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :create_artifact, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a specific Artifact.
            #
            # @overload get_artifact(request, options = nil)
            #   Pass arguments to `get_artifact` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetArtifactRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetArtifactRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_artifact(name: nil)
            #   Pass arguments to `get_artifact` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Artifact to retrieve.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Artifact]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Artifact]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetArtifactRequest.new
            #
            #   # Call the get_artifact method.
            #   result = client.get_artifact request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Artifact.
            #   p result
            #
            def get_artifact request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetArtifactRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_artifact.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_artifact.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_artifact.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :get_artifact, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Artifacts in the MetadataStore.
            #
            # @overload list_artifacts(request, options = nil)
            #   Pass arguments to `list_artifacts` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListArtifactsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListArtifactsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_artifacts(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_artifacts` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The MetadataStore whose Artifacts should be listed.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
            #   @param page_size [::Integer]
            #     The maximum number of Artifacts to return. The service may return fewer.
            #     Must be in range 1-1000, inclusive. Defaults to 100.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_artifacts MetadataService.ListArtifacts}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other provided parameters must match the call that
            #     provided the page token. (Otherwise the request will fail with
            #     INVALID_ARGUMENT error.)
            #   @param filter [::String]
            #     Filter specifying the boolean condition for the Artifacts to satisfy in
            #     order to be part of the result set.
            #     The syntax to define filter query is based on https://google.aip.dev/160.
            #     The supported set of filters include the following:
            #
            #     *   **Attribute filtering**:
            #         For example: `display_name = "test"`.
            #         Supported fields include: `name`, `display_name`, `uri`, `state`,
            #         `schema_title`, `create_time`, and `update_time`.
            #         Time fields, such as `create_time` and `update_time`, require values
            #         specified in RFC-3339 format.
            #         For example: `create_time = "2020-11-19T11:30:00-04:00"`
            #     *   **Metadata field**:
            #         To filter on metadata fields use traversal operation as follows:
            #         `metadata.<field_name>.<type_value>`.
            #         For example: `metadata.field_1.number_value = 10.0`
            #         In case the field name contains special characters (such as colon), one
            #         can embed it inside double quote.
            #         For example: `metadata."field:1".number_value = 10.0`
            #     *   **Context based filtering**:
            #         To filter Artifacts based on the contexts to which they belong, use the
            #         function operator with the full resource name
            #         `in_context(<context-name>)`.
            #         For example:
            #         `in_context("projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context-id>")`
            #
            #     Each of the above supported filter types can be combined together using
            #     logical operators (`AND` & `OR`). Maximum nested expression depth allowed
            #     is 5.
            #
            #     For example: `display_name = "test" AND metadata.field1.bool_value = true`.
            #   @param order_by [::String]
            #     How the list of messages is ordered. Specify the values to order by and an
            #     ordering operation. The default sorting order is ascending. To specify
            #     descending order for a field, users append a " desc" suffix; for example:
            #     "foo desc, bar".
            #     Subfields are specified with a `.` character, such as foo.bar.
            #     see https://google.aip.dev/132#ordering for more details.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Artifact>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Artifact>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListArtifactsRequest.new
            #
            #   # Call the list_artifacts method.
            #   result = client.list_artifacts request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Artifact.
            #     p item
            #   end
            #
            def list_artifacts request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListArtifactsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_artifacts.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_artifacts.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_artifacts.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :list_artifacts, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @metadata_service_stub, :list_artifacts, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a stored Artifact.
            #
            # @overload update_artifact(request, options = nil)
            #   Pass arguments to `update_artifact` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateArtifactRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateArtifactRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_artifact(artifact: nil, update_mask: nil, allow_missing: nil)
            #   Pass arguments to `update_artifact` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param artifact [::Google::Cloud::AIPlatform::V1::Artifact, ::Hash]
            #     Required. The Artifact containing updates.
            #     The Artifact's {::Google::Cloud::AIPlatform::V1::Artifact#name Artifact.name}
            #     field is used to identify the Artifact to be updated. Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. A FieldMask indicating which fields should be updated.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the {::Google::Cloud::AIPlatform::V1::Artifact Artifact} is
            #     not found, a new {::Google::Cloud::AIPlatform::V1::Artifact Artifact} is
            #     created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Artifact]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Artifact]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateArtifactRequest.new
            #
            #   # Call the update_artifact method.
            #   result = client.update_artifact request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Artifact.
            #   p result
            #
            def update_artifact request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateArtifactRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_artifact.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.artifact&.name
                header_params["artifact.name"] = request.artifact.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_artifact.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_artifact.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :update_artifact, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an Artifact.
            #
            # @overload delete_artifact(request, options = nil)
            #   Pass arguments to `delete_artifact` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteArtifactRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteArtifactRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_artifact(name: nil, etag: nil)
            #   Pass arguments to `delete_artifact` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Artifact to delete.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
            #   @param etag [::String]
            #     Optional. The etag of the Artifact to delete.
            #     If this is provided, it must match the server's etag. Otherwise, the
            #     request will fail with a FAILED_PRECONDITION.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteArtifactRequest.new
            #
            #   # Call the delete_artifact method.
            #   result = client.delete_artifact request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_artifact request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteArtifactRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_artifact.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_artifact.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_artifact.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :delete_artifact, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Purges Artifacts.
            #
            # @overload purge_artifacts(request, options = nil)
            #   Pass arguments to `purge_artifacts` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::PurgeArtifactsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::PurgeArtifactsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload purge_artifacts(parent: nil, filter: nil, force: nil)
            #   Pass arguments to `purge_artifacts` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The metadata store to purge Artifacts from.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
            #   @param filter [::String]
            #     Required. A required filter matching the Artifacts to be purged.
            #     E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
            #   @param force [::Boolean]
            #     Optional. Flag to indicate to actually perform the purge.
            #     If `force` is set to false, the method will return a sample of
            #     Artifact names that would be deleted.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::PurgeArtifactsRequest.new
            #
            #   # Call the purge_artifacts method.
            #   result = client.purge_artifacts request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def purge_artifacts request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::PurgeArtifactsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.purge_artifacts.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.purge_artifacts.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.purge_artifacts.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :purge_artifacts, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a Context associated with a MetadataStore.
            #
            # @overload create_context(request, options = nil)
            #   Pass arguments to `create_context` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateContextRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateContextRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_context(parent: nil, context: nil, context_id: nil)
            #   Pass arguments to `create_context` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the MetadataStore where the Context should
            #     be created. Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
            #   @param context [::Google::Cloud::AIPlatform::V1::Context, ::Hash]
            #     Required. The Context to create.
            #   @param context_id [::String]
            #     The \\{context} portion of the resource name with the format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`.
            #     If not provided, the Context's ID will be a UUID generated by the service.
            #     Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
            #     Must be unique across all Contexts in the parent MetadataStore. (Otherwise
            #     the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED if the
            #     caller can't view the preexisting Context.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Context]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Context]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateContextRequest.new
            #
            #   # Call the create_context method.
            #   result = client.create_context request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Context.
            #   p result
            #
            def create_context request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateContextRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_context.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_context.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_context.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :create_context, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a specific Context.
            #
            # @overload get_context(request, options = nil)
            #   Pass arguments to `get_context` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetContextRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetContextRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_context(name: nil)
            #   Pass arguments to `get_context` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Context to retrieve.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Context]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Context]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetContextRequest.new
            #
            #   # Call the get_context method.
            #   result = client.get_context request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Context.
            #   p result
            #
            def get_context request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetContextRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_context.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_context.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_context.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :get_context, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Contexts on the MetadataStore.
            #
            # @overload list_contexts(request, options = nil)
            #   Pass arguments to `list_contexts` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListContextsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListContextsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_contexts(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_contexts` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The MetadataStore whose Contexts should be listed.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
            #   @param page_size [::Integer]
            #     The maximum number of Contexts to return. The service may return fewer.
            #     Must be in range 1-1000, inclusive. Defaults to 100.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_contexts MetadataService.ListContexts}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other provided parameters must match the call that
            #     provided the page token. (Otherwise the request will fail with
            #     INVALID_ARGUMENT error.)
            #   @param filter [::String]
            #     Filter specifying the boolean condition for the Contexts to satisfy in
            #     order to be part of the result set.
            #     The syntax to define filter query is based on https://google.aip.dev/160.
            #     Following are the supported set of filters:
            #
            #     *  **Attribute filtering**:
            #        For example: `display_name = "test"`.
            #        Supported fields include: `name`, `display_name`, `schema_title`,
            #        `create_time`, and `update_time`.
            #        Time fields, such as `create_time` and `update_time`, require values
            #        specified in RFC-3339 format.
            #        For example: `create_time = "2020-11-19T11:30:00-04:00"`.
            #     *  **Metadata field**:
            #        To filter on metadata fields use traversal operation as follows:
            #        `metadata.<field_name>.<type_value>`.
            #        For example: `metadata.field_1.number_value = 10.0`.
            #        In case the field name contains special characters (such as colon), one
            #        can embed it inside double quote.
            #        For example: `metadata."field:1".number_value = 10.0`
            #     *  **Parent Child filtering**:
            #        To filter Contexts based on parent-child relationship use the HAS
            #        operator as follows:
            #
            #        ```
            #        parent_contexts:
            #        "projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context_id>"
            #        child_contexts:
            #        "projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context_id>"
            #        ```
            #
            #     Each of the above supported filters can be combined together using
            #     logical operators (`AND` & `OR`). Maximum nested expression depth allowed
            #     is 5.
            #
            #     For example: `display_name = "test" AND metadata.field1.bool_value = true`.
            #   @param order_by [::String]
            #     How the list of messages is ordered. Specify the values to order by and an
            #     ordering operation. The default sorting order is ascending. To specify
            #     descending order for a field, users append a " desc" suffix; for example:
            #     "foo desc, bar".
            #     Subfields are specified with a `.` character, such as foo.bar.
            #     see https://google.aip.dev/132#ordering for more details.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Context>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Context>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListContextsRequest.new
            #
            #   # Call the list_contexts method.
            #   result = client.list_contexts request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Context.
            #     p item
            #   end
            #
            def list_contexts request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListContextsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_contexts.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_contexts.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_contexts.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :list_contexts, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @metadata_service_stub, :list_contexts, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a stored Context.
            #
            # @overload update_context(request, options = nil)
            #   Pass arguments to `update_context` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateContextRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateContextRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_context(context: nil, update_mask: nil, allow_missing: nil)
            #   Pass arguments to `update_context` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param context [::Google::Cloud::AIPlatform::V1::Context, ::Hash]
            #     Required. The Context containing updates.
            #     The Context's {::Google::Cloud::AIPlatform::V1::Context#name Context.name} field
            #     is used to identify the Context to be updated. Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. A FieldMask indicating which fields should be updated.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the {::Google::Cloud::AIPlatform::V1::Context Context} is
            #     not found, a new {::Google::Cloud::AIPlatform::V1::Context Context} is created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Context]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Context]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateContextRequest.new
            #
            #   # Call the update_context method.
            #   result = client.update_context request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Context.
            #   p result
            #
            def update_context request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateContextRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_context.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.context&.name
                header_params["context.name"] = request.context.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_context.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_context.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :update_context, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a stored Context.
            #
            # @overload delete_context(request, options = nil)
            #   Pass arguments to `delete_context` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteContextRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteContextRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_context(name: nil, force: nil, etag: nil)
            #   Pass arguments to `delete_context` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Context to delete.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
            #   @param force [::Boolean]
            #     The force deletion semantics is still undefined.
            #     Users should not use this field.
            #   @param etag [::String]
            #     Optional. The etag of the Context to delete.
            #     If this is provided, it must match the server's etag. Otherwise, the
            #     request will fail with a FAILED_PRECONDITION.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteContextRequest.new
            #
            #   # Call the delete_context method.
            #   result = client.delete_context request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_context request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteContextRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_context.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_context.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_context.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :delete_context, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Purges Contexts.
            #
            # @overload purge_contexts(request, options = nil)
            #   Pass arguments to `purge_contexts` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::PurgeContextsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::PurgeContextsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload purge_contexts(parent: nil, filter: nil, force: nil)
            #   Pass arguments to `purge_contexts` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The metadata store to purge Contexts from.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
            #   @param filter [::String]
            #     Required. A required filter matching the Contexts to be purged.
            #     E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
            #   @param force [::Boolean]
            #     Optional. Flag to indicate to actually perform the purge.
            #     If `force` is set to false, the method will return a sample of
            #     Context names that would be deleted.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::PurgeContextsRequest.new
            #
            #   # Call the purge_contexts method.
            #   result = client.purge_contexts request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def purge_contexts request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::PurgeContextsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.purge_contexts.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.purge_contexts.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.purge_contexts.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :purge_contexts, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Adds a set of Artifacts and Executions to a Context. If any of the
            # Artifacts or Executions have already been added to a Context, they are
            # simply skipped.
            #
            # @overload add_context_artifacts_and_executions(request, options = nil)
            #   Pass arguments to `add_context_artifacts_and_executions` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::AddContextArtifactsAndExecutionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::AddContextArtifactsAndExecutionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload add_context_artifacts_and_executions(context: nil, artifacts: nil, executions: nil)
            #   Pass arguments to `add_context_artifacts_and_executions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param context [::String]
            #     Required. The resource name of the Context that the Artifacts and
            #     Executions belong to. Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
            #   @param artifacts [::Array<::String>]
            #     The resource names of the Artifacts to attribute to the Context.
            #
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
            #   @param executions [::Array<::String>]
            #     The resource names of the Executions to associate with the
            #     Context.
            #
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::AddContextArtifactsAndExecutionsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::AddContextArtifactsAndExecutionsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::AddContextArtifactsAndExecutionsRequest.new
            #
            #   # Call the add_context_artifacts_and_executions method.
            #   result = client.add_context_artifacts_and_executions request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::AddContextArtifactsAndExecutionsResponse.
            #   p result
            #
            def add_context_artifacts_and_executions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::AddContextArtifactsAndExecutionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.add_context_artifacts_and_executions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.context
                header_params["context"] = request.context
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.add_context_artifacts_and_executions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.add_context_artifacts_and_executions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :add_context_artifacts_and_executions, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Adds a set of Contexts as children to a parent Context. If any of the
            # child Contexts have already been added to the parent Context, they are
            # simply skipped. If this call would create a cycle or cause any Context to
            # have more than 10 parents, the request will fail with an INVALID_ARGUMENT
            # error.
            #
            # @overload add_context_children(request, options = nil)
            #   Pass arguments to `add_context_children` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::AddContextChildrenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::AddContextChildrenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload add_context_children(context: nil, child_contexts: nil)
            #   Pass arguments to `add_context_children` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param context [::String]
            #     Required. The resource name of the parent Context.
            #
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
            #   @param child_contexts [::Array<::String>]
            #     The resource names of the child Contexts.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::AddContextChildrenResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::AddContextChildrenResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::AddContextChildrenRequest.new
            #
            #   # Call the add_context_children method.
            #   result = client.add_context_children request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::AddContextChildrenResponse.
            #   p result
            #
            def add_context_children request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::AddContextChildrenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.add_context_children.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.context
                header_params["context"] = request.context
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.add_context_children.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.add_context_children.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :add_context_children, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Remove a set of children contexts from a parent Context. If any of the
            # child Contexts were NOT added to the parent Context, they are
            # simply skipped.
            #
            # @overload remove_context_children(request, options = nil)
            #   Pass arguments to `remove_context_children` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::RemoveContextChildrenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::RemoveContextChildrenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload remove_context_children(context: nil, child_contexts: nil)
            #   Pass arguments to `remove_context_children` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param context [::String]
            #     Required. The resource name of the parent Context.
            #
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
            #   @param child_contexts [::Array<::String>]
            #     The resource names of the child Contexts.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::RemoveContextChildrenResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::RemoveContextChildrenResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::RemoveContextChildrenRequest.new
            #
            #   # Call the remove_context_children method.
            #   result = client.remove_context_children request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::RemoveContextChildrenResponse.
            #   p result
            #
            def remove_context_children request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::RemoveContextChildrenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.remove_context_children.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.context
                header_params["context"] = request.context
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.remove_context_children.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.remove_context_children.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :remove_context_children, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves Artifacts and Executions within the specified Context, connected
            # by Event edges and returned as a LineageSubgraph.
            #
            # @overload query_context_lineage_subgraph(request, options = nil)
            #   Pass arguments to `query_context_lineage_subgraph` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::QueryContextLineageSubgraphRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::QueryContextLineageSubgraphRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload query_context_lineage_subgraph(context: nil)
            #   Pass arguments to `query_context_lineage_subgraph` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param context [::String]
            #     Required. The resource name of the Context whose Artifacts and Executions
            #     should be retrieved as a LineageSubgraph.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
            #
            #     The request may error with FAILED_PRECONDITION if the number of Artifacts,
            #     the number of Executions, or the number of Events that would be returned
            #     for the Context exceeds 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::LineageSubgraph]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::LineageSubgraph]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::QueryContextLineageSubgraphRequest.new
            #
            #   # Call the query_context_lineage_subgraph method.
            #   result = client.query_context_lineage_subgraph request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::LineageSubgraph.
            #   p result
            #
            def query_context_lineage_subgraph request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::QueryContextLineageSubgraphRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.query_context_lineage_subgraph.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.context
                header_params["context"] = request.context
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.query_context_lineage_subgraph.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.query_context_lineage_subgraph.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :query_context_lineage_subgraph, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an Execution associated with a MetadataStore.
            #
            # @overload create_execution(request, options = nil)
            #   Pass arguments to `create_execution` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateExecutionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateExecutionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_execution(parent: nil, execution: nil, execution_id: nil)
            #   Pass arguments to `create_execution` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the MetadataStore where the Execution should
            #     be created.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
            #   @param execution [::Google::Cloud::AIPlatform::V1::Execution, ::Hash]
            #     Required. The Execution to create.
            #   @param execution_id [::String]
            #     The \\{execution} portion of the resource name with the format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
            #     If not provided, the Execution's ID will be a UUID generated by the
            #     service.
            #     Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
            #     Must be unique across all Executions in the parent MetadataStore.
            #     (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
            #     if the caller can't view the preexisting Execution.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Execution]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Execution]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateExecutionRequest.new
            #
            #   # Call the create_execution method.
            #   result = client.create_execution request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Execution.
            #   p result
            #
            def create_execution request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateExecutionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_execution.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_execution.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_execution.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :create_execution, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a specific Execution.
            #
            # @overload get_execution(request, options = nil)
            #   Pass arguments to `get_execution` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetExecutionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetExecutionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_execution(name: nil)
            #   Pass arguments to `get_execution` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Execution to retrieve.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Execution]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Execution]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetExecutionRequest.new
            #
            #   # Call the get_execution method.
            #   result = client.get_execution request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Execution.
            #   p result
            #
            def get_execution request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetExecutionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_execution.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_execution.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_execution.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :get_execution, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Executions in the MetadataStore.
            #
            # @overload list_executions(request, options = nil)
            #   Pass arguments to `list_executions` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListExecutionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListExecutionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_executions(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_executions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The MetadataStore whose Executions should be listed.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
            #   @param page_size [::Integer]
            #     The maximum number of Executions to return. The service may return fewer.
            #     Must be in range 1-1000, inclusive. Defaults to 100.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_executions MetadataService.ListExecutions}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other provided parameters must match the call that
            #     provided the page token. (Otherwise the request will fail with an
            #     INVALID_ARGUMENT error.)
            #   @param filter [::String]
            #     Filter specifying the boolean condition for the Executions to satisfy in
            #     order to be part of the result set.
            #     The syntax to define filter query is based on https://google.aip.dev/160.
            #     Following are the supported set of filters:
            #
            #     *  **Attribute filtering**:
            #        For example: `display_name = "test"`.
            #        Supported fields include: `name`, `display_name`, `state`,
            #        `schema_title`, `create_time`, and `update_time`.
            #        Time fields, such as `create_time` and `update_time`, require values
            #        specified in RFC-3339 format.
            #        For example: `create_time = "2020-11-19T11:30:00-04:00"`.
            #     *  **Metadata field**:
            #        To filter on metadata fields use traversal operation as follows:
            #        `metadata.<field_name>.<type_value>`
            #        For example: `metadata.field_1.number_value = 10.0`
            #        In case the field name contains special characters (such as colon), one
            #        can embed it inside double quote.
            #        For example: `metadata."field:1".number_value = 10.0`
            #     *  **Context based filtering**:
            #        To filter Executions based on the contexts to which they belong use
            #        the function operator with the full resource name:
            #        `in_context(<context-name>)`.
            #        For example:
            #        `in_context("projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context-id>")`
            #
            #     Each of the above supported filters can be combined together using
            #     logical operators (`AND` & `OR`). Maximum nested expression depth allowed
            #     is 5.
            #
            #     For example: `display_name = "test" AND metadata.field1.bool_value = true`.
            #   @param order_by [::String]
            #     How the list of messages is ordered. Specify the values to order by and an
            #     ordering operation. The default sorting order is ascending. To specify
            #     descending order for a field, users append a " desc" suffix; for example:
            #     "foo desc, bar".
            #     Subfields are specified with a `.` character, such as foo.bar.
            #     see https://google.aip.dev/132#ordering for more details.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Execution>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Execution>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListExecutionsRequest.new
            #
            #   # Call the list_executions method.
            #   result = client.list_executions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Execution.
            #     p item
            #   end
            #
            def list_executions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListExecutionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_executions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_executions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_executions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :list_executions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @metadata_service_stub, :list_executions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a stored Execution.
            #
            # @overload update_execution(request, options = nil)
            #   Pass arguments to `update_execution` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateExecutionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateExecutionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_execution(execution: nil, update_mask: nil, allow_missing: nil)
            #   Pass arguments to `update_execution` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param execution [::Google::Cloud::AIPlatform::V1::Execution, ::Hash]
            #     Required. The Execution containing updates.
            #     The Execution's {::Google::Cloud::AIPlatform::V1::Execution#name Execution.name}
            #     field is used to identify the Execution to be updated. Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. A FieldMask indicating which fields should be updated.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the {::Google::Cloud::AIPlatform::V1::Execution Execution}
            #     is not found, a new {::Google::Cloud::AIPlatform::V1::Execution Execution} is
            #     created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Execution]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Execution]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateExecutionRequest.new
            #
            #   # Call the update_execution method.
            #   result = client.update_execution request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Execution.
            #   p result
            #
            def update_execution request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateExecutionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_execution.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.execution&.name
                header_params["execution.name"] = request.execution.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_execution.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_execution.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :update_execution, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an Execution.
            #
            # @overload delete_execution(request, options = nil)
            #   Pass arguments to `delete_execution` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteExecutionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteExecutionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_execution(name: nil, etag: nil)
            #   Pass arguments to `delete_execution` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Execution to delete.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
            #   @param etag [::String]
            #     Optional. The etag of the Execution to delete.
            #     If this is provided, it must match the server's etag. Otherwise, the
            #     request will fail with a FAILED_PRECONDITION.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteExecutionRequest.new
            #
            #   # Call the delete_execution method.
            #   result = client.delete_execution request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_execution request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteExecutionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_execution.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_execution.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_execution.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :delete_execution, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Purges Executions.
            #
            # @overload purge_executions(request, options = nil)
            #   Pass arguments to `purge_executions` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::PurgeExecutionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::PurgeExecutionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload purge_executions(parent: nil, filter: nil, force: nil)
            #   Pass arguments to `purge_executions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The metadata store to purge Executions from.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
            #   @param filter [::String]
            #     Required. A required filter matching the Executions to be purged.
            #     E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
            #   @param force [::Boolean]
            #     Optional. Flag to indicate to actually perform the purge.
            #     If `force` is set to false, the method will return a sample of
            #     Execution names that would be deleted.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::PurgeExecutionsRequest.new
            #
            #   # Call the purge_executions method.
            #   result = client.purge_executions request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def purge_executions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::PurgeExecutionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.purge_executions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.purge_executions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.purge_executions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :purge_executions, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Adds Events to the specified Execution. An Event indicates whether an
            # Artifact was used as an input or output for an Execution. If an Event
            # already exists between the Execution and the Artifact, the Event is
            # skipped.
            #
            # @overload add_execution_events(request, options = nil)
            #   Pass arguments to `add_execution_events` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::AddExecutionEventsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::AddExecutionEventsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload add_execution_events(execution: nil, events: nil)
            #   Pass arguments to `add_execution_events` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param execution [::String]
            #     Required. The resource name of the Execution that the Events connect
            #     Artifacts with.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
            #   @param events [::Array<::Google::Cloud::AIPlatform::V1::Event, ::Hash>]
            #     The Events to create and add.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::AddExecutionEventsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::AddExecutionEventsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::AddExecutionEventsRequest.new
            #
            #   # Call the add_execution_events method.
            #   result = client.add_execution_events request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::AddExecutionEventsResponse.
            #   p result
            #
            def add_execution_events request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::AddExecutionEventsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.add_execution_events.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.execution
                header_params["execution"] = request.execution
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.add_execution_events.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.add_execution_events.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :add_execution_events, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Obtains the set of input and output Artifacts for this Execution, in the
            # form of LineageSubgraph that also contains the Execution and connecting
            # Events.
            #
            # @overload query_execution_inputs_and_outputs(request, options = nil)
            #   Pass arguments to `query_execution_inputs_and_outputs` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::QueryExecutionInputsAndOutputsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::QueryExecutionInputsAndOutputsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload query_execution_inputs_and_outputs(execution: nil)
            #   Pass arguments to `query_execution_inputs_and_outputs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param execution [::String]
            #     Required. The resource name of the Execution whose input and output
            #     Artifacts should be retrieved as a LineageSubgraph. Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::LineageSubgraph]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::LineageSubgraph]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::QueryExecutionInputsAndOutputsRequest.new
            #
            #   # Call the query_execution_inputs_and_outputs method.
            #   result = client.query_execution_inputs_and_outputs request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::LineageSubgraph.
            #   p result
            #
            def query_execution_inputs_and_outputs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::QueryExecutionInputsAndOutputsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.query_execution_inputs_and_outputs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.execution
                header_params["execution"] = request.execution
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.query_execution_inputs_and_outputs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.query_execution_inputs_and_outputs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :query_execution_inputs_and_outputs, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a MetadataSchema.
            #
            # @overload create_metadata_schema(request, options = nil)
            #   Pass arguments to `create_metadata_schema` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateMetadataSchemaRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateMetadataSchemaRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_metadata_schema(parent: nil, metadata_schema: nil, metadata_schema_id: nil)
            #   Pass arguments to `create_metadata_schema` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the MetadataStore where the MetadataSchema
            #     should be created. Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
            #   @param metadata_schema [::Google::Cloud::AIPlatform::V1::MetadataSchema, ::Hash]
            #     Required. The MetadataSchema to create.
            #   @param metadata_schema_id [::String]
            #     The \\{metadata_schema} portion of the resource name with the format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/metadataSchemas/{metadataschema}`
            #     If not provided, the MetadataStore's ID will be a UUID generated by the
            #     service.
            #     Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
            #     Must be unique across all MetadataSchemas in the parent Location.
            #     (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
            #     if the caller can't view the preexisting MetadataSchema.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::MetadataSchema]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::MetadataSchema]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateMetadataSchemaRequest.new
            #
            #   # Call the create_metadata_schema method.
            #   result = client.create_metadata_schema request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::MetadataSchema.
            #   p result
            #
            def create_metadata_schema request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateMetadataSchemaRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_metadata_schema.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_metadata_schema.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_metadata_schema.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :create_metadata_schema, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a specific MetadataSchema.
            #
            # @overload get_metadata_schema(request, options = nil)
            #   Pass arguments to `get_metadata_schema` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetMetadataSchemaRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetMetadataSchemaRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_metadata_schema(name: nil)
            #   Pass arguments to `get_metadata_schema` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the MetadataSchema to retrieve.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/metadataSchemas/{metadataschema}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::MetadataSchema]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::MetadataSchema]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetMetadataSchemaRequest.new
            #
            #   # Call the get_metadata_schema method.
            #   result = client.get_metadata_schema request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::MetadataSchema.
            #   p result
            #
            def get_metadata_schema request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetMetadataSchemaRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_metadata_schema.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_metadata_schema.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_metadata_schema.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :get_metadata_schema, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists MetadataSchemas.
            #
            # @overload list_metadata_schemas(request, options = nil)
            #   Pass arguments to `list_metadata_schemas` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListMetadataSchemasRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListMetadataSchemasRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_metadata_schemas(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_metadata_schemas` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The MetadataStore whose MetadataSchemas should be listed.
            #     Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
            #   @param page_size [::Integer]
            #     The maximum number of MetadataSchemas to return. The service may return
            #     fewer.
            #     Must be in range 1-1000, inclusive. Defaults to 100.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::AIPlatform::V1::MetadataService::Client#list_metadata_schemas MetadataService.ListMetadataSchemas}
            #     call. Provide this to retrieve the next page.
            #
            #     When paginating, all other provided parameters must match the call that
            #     provided the page token. (Otherwise the request will fail with
            #     INVALID_ARGUMENT error.)
            #   @param filter [::String]
            #     A query to filter available MetadataSchemas for matching results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::MetadataSchema>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::MetadataSchema>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListMetadataSchemasRequest.new
            #
            #   # Call the list_metadata_schemas method.
            #   result = client.list_metadata_schemas request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::MetadataSchema.
            #     p item
            #   end
            #
            def list_metadata_schemas request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListMetadataSchemasRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_metadata_schemas.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_metadata_schemas.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_metadata_schemas.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :list_metadata_schemas, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @metadata_service_stub, :list_metadata_schemas, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves lineage of an Artifact represented through Artifacts and
            # Executions connected by Event edges and returned as a LineageSubgraph.
            #
            # @overload query_artifact_lineage_subgraph(request, options = nil)
            #   Pass arguments to `query_artifact_lineage_subgraph` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::QueryArtifactLineageSubgraphRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::QueryArtifactLineageSubgraphRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload query_artifact_lineage_subgraph(artifact: nil, max_hops: nil, filter: nil)
            #   Pass arguments to `query_artifact_lineage_subgraph` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param artifact [::String]
            #     Required. The resource name of the Artifact whose Lineage needs to be
            #     retrieved as a LineageSubgraph. Format:
            #     `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
            #
            #     The request may error with FAILED_PRECONDITION if the number of Artifacts,
            #     the number of Executions, or the number of Events that would be returned
            #     for the Context exceeds 1000.
            #   @param max_hops [::Integer]
            #     Specifies the size of the lineage graph in terms of number of hops from the
            #     specified artifact.
            #     Negative Value: INVALID_ARGUMENT error is returned
            #     0: Only input artifact is returned.
            #     No value: Transitive closure is performed to return the complete graph.
            #   @param filter [::String]
            #     Filter specifying the boolean condition for the Artifacts to satisfy in
            #     order to be part of the Lineage Subgraph.
            #     The syntax to define filter query is based on https://google.aip.dev/160.
            #     The supported set of filters include the following:
            #
            #     *  **Attribute filtering**:
            #        For example: `display_name = "test"`
            #        Supported fields include: `name`, `display_name`, `uri`, `state`,
            #        `schema_title`, `create_time`, and `update_time`.
            #        Time fields, such as `create_time` and `update_time`, require values
            #        specified in RFC-3339 format.
            #        For example: `create_time = "2020-11-19T11:30:00-04:00"`
            #     *  **Metadata field**:
            #        To filter on metadata fields use traversal operation as follows:
            #        `metadata.<field_name>.<type_value>`.
            #        For example: `metadata.field_1.number_value = 10.0`
            #        In case the field name contains special characters (such as colon), one
            #        can embed it inside double quote.
            #        For example: `metadata."field:1".number_value = 10.0`
            #
            #     Each of the above supported filter types can be combined together using
            #     logical operators (`AND` & `OR`). Maximum nested expression depth allowed
            #     is 5.
            #
            #     For example: `display_name = "test" AND metadata.field1.bool_value = true`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::LineageSubgraph]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::LineageSubgraph]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::QueryArtifactLineageSubgraphRequest.new
            #
            #   # Call the query_artifact_lineage_subgraph method.
            #   result = client.query_artifact_lineage_subgraph request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::LineageSubgraph.
            #   p result
            #
            def query_artifact_lineage_subgraph request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::QueryArtifactLineageSubgraphRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.query_artifact_lineage_subgraph.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.artifact
                header_params["artifact"] = request.artifact
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.query_artifact_lineage_subgraph.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.query_artifact_lineage_subgraph.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :query_artifact_lineage_subgraph, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the MetadataService API.
            #
            # This class represents the configuration for MetadataService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::AIPlatform::V1::MetadataService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_metadata_store to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::AIPlatform::V1::MetadataService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_metadata_store.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_metadata_store.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the MetadataService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_metadata_store`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_metadata_store
                ##
                # RPC-specific configuration for `get_metadata_store`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_metadata_store
                ##
                # RPC-specific configuration for `list_metadata_stores`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_metadata_stores
                ##
                # RPC-specific configuration for `delete_metadata_store`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_metadata_store
                ##
                # RPC-specific configuration for `create_artifact`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_artifact
                ##
                # RPC-specific configuration for `get_artifact`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_artifact
                ##
                # RPC-specific configuration for `list_artifacts`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_artifacts
                ##
                # RPC-specific configuration for `update_artifact`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_artifact
                ##
                # RPC-specific configuration for `delete_artifact`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_artifact
                ##
                # RPC-specific configuration for `purge_artifacts`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :purge_artifacts
                ##
                # RPC-specific configuration for `create_context`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_context
                ##
                # RPC-specific configuration for `get_context`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_context
                ##
                # RPC-specific configuration for `list_contexts`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_contexts
                ##
                # RPC-specific configuration for `update_context`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_context
                ##
                # RPC-specific configuration for `delete_context`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_context
                ##
                # RPC-specific configuration for `purge_contexts`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :purge_contexts
                ##
                # RPC-specific configuration for `add_context_artifacts_and_executions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :add_context_artifacts_and_executions
                ##
                # RPC-specific configuration for `add_context_children`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :add_context_children
                ##
                # RPC-specific configuration for `remove_context_children`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :remove_context_children
                ##
                # RPC-specific configuration for `query_context_lineage_subgraph`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :query_context_lineage_subgraph
                ##
                # RPC-specific configuration for `create_execution`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_execution
                ##
                # RPC-specific configuration for `get_execution`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_execution
                ##
                # RPC-specific configuration for `list_executions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_executions
                ##
                # RPC-specific configuration for `update_execution`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_execution
                ##
                # RPC-specific configuration for `delete_execution`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_execution
                ##
                # RPC-specific configuration for `purge_executions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :purge_executions
                ##
                # RPC-specific configuration for `add_execution_events`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :add_execution_events
                ##
                # RPC-specific configuration for `query_execution_inputs_and_outputs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :query_execution_inputs_and_outputs
                ##
                # RPC-specific configuration for `create_metadata_schema`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_metadata_schema
                ##
                # RPC-specific configuration for `get_metadata_schema`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_metadata_schema
                ##
                # RPC-specific configuration for `list_metadata_schemas`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_metadata_schemas
                ##
                # RPC-specific configuration for `query_artifact_lineage_subgraph`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :query_artifact_lineage_subgraph

                # @private
                def initialize parent_rpcs = nil
                  create_metadata_store_config = parent_rpcs.create_metadata_store if parent_rpcs.respond_to? :create_metadata_store
                  @create_metadata_store = ::Gapic::Config::Method.new create_metadata_store_config
                  get_metadata_store_config = parent_rpcs.get_metadata_store if parent_rpcs.respond_to? :get_metadata_store
                  @get_metadata_store = ::Gapic::Config::Method.new get_metadata_store_config
                  list_metadata_stores_config = parent_rpcs.list_metadata_stores if parent_rpcs.respond_to? :list_metadata_stores
                  @list_metadata_stores = ::Gapic::Config::Method.new list_metadata_stores_config
                  delete_metadata_store_config = parent_rpcs.delete_metadata_store if parent_rpcs.respond_to? :delete_metadata_store
                  @delete_metadata_store = ::Gapic::Config::Method.new delete_metadata_store_config
                  create_artifact_config = parent_rpcs.create_artifact if parent_rpcs.respond_to? :create_artifact
                  @create_artifact = ::Gapic::Config::Method.new create_artifact_config
                  get_artifact_config = parent_rpcs.get_artifact if parent_rpcs.respond_to? :get_artifact
                  @get_artifact = ::Gapic::Config::Method.new get_artifact_config
                  list_artifacts_config = parent_rpcs.list_artifacts if parent_rpcs.respond_to? :list_artifacts
                  @list_artifacts = ::Gapic::Config::Method.new list_artifacts_config
                  update_artifact_config = parent_rpcs.update_artifact if parent_rpcs.respond_to? :update_artifact
                  @update_artifact = ::Gapic::Config::Method.new update_artifact_config
                  delete_artifact_config = parent_rpcs.delete_artifact if parent_rpcs.respond_to? :delete_artifact
                  @delete_artifact = ::Gapic::Config::Method.new delete_artifact_config
                  purge_artifacts_config = parent_rpcs.purge_artifacts if parent_rpcs.respond_to? :purge_artifacts
                  @purge_artifacts = ::Gapic::Config::Method.new purge_artifacts_config
                  create_context_config = parent_rpcs.create_context if parent_rpcs.respond_to? :create_context
                  @create_context = ::Gapic::Config::Method.new create_context_config
                  get_context_config = parent_rpcs.get_context if parent_rpcs.respond_to? :get_context
                  @get_context = ::Gapic::Config::Method.new get_context_config
                  list_contexts_config = parent_rpcs.list_contexts if parent_rpcs.respond_to? :list_contexts
                  @list_contexts = ::Gapic::Config::Method.new list_contexts_config
                  update_context_config = parent_rpcs.update_context if parent_rpcs.respond_to? :update_context
                  @update_context = ::Gapic::Config::Method.new update_context_config
                  delete_context_config = parent_rpcs.delete_context if parent_rpcs.respond_to? :delete_context
                  @delete_context = ::Gapic::Config::Method.new delete_context_config
                  purge_contexts_config = parent_rpcs.purge_contexts if parent_rpcs.respond_to? :purge_contexts
                  @purge_contexts = ::Gapic::Config::Method.new purge_contexts_config
                  add_context_artifacts_and_executions_config = parent_rpcs.add_context_artifacts_and_executions if parent_rpcs.respond_to? :add_context_artifacts_and_executions
                  @add_context_artifacts_and_executions = ::Gapic::Config::Method.new add_context_artifacts_and_executions_config
                  add_context_children_config = parent_rpcs.add_context_children if parent_rpcs.respond_to? :add_context_children
                  @add_context_children = ::Gapic::Config::Method.new add_context_children_config
                  remove_context_children_config = parent_rpcs.remove_context_children if parent_rpcs.respond_to? :remove_context_children
                  @remove_context_children = ::Gapic::Config::Method.new remove_context_children_config
                  query_context_lineage_subgraph_config = parent_rpcs.query_context_lineage_subgraph if parent_rpcs.respond_to? :query_context_lineage_subgraph
                  @query_context_lineage_subgraph = ::Gapic::Config::Method.new query_context_lineage_subgraph_config
                  create_execution_config = parent_rpcs.create_execution if parent_rpcs.respond_to? :create_execution
                  @create_execution = ::Gapic::Config::Method.new create_execution_config
                  get_execution_config = parent_rpcs.get_execution if parent_rpcs.respond_to? :get_execution
                  @get_execution = ::Gapic::Config::Method.new get_execution_config
                  list_executions_config = parent_rpcs.list_executions if parent_rpcs.respond_to? :list_executions
                  @list_executions = ::Gapic::Config::Method.new list_executions_config
                  update_execution_config = parent_rpcs.update_execution if parent_rpcs.respond_to? :update_execution
                  @update_execution = ::Gapic::Config::Method.new update_execution_config
                  delete_execution_config = parent_rpcs.delete_execution if parent_rpcs.respond_to? :delete_execution
                  @delete_execution = ::Gapic::Config::Method.new delete_execution_config
                  purge_executions_config = parent_rpcs.purge_executions if parent_rpcs.respond_to? :purge_executions
                  @purge_executions = ::Gapic::Config::Method.new purge_executions_config
                  add_execution_events_config = parent_rpcs.add_execution_events if parent_rpcs.respond_to? :add_execution_events
                  @add_execution_events = ::Gapic::Config::Method.new add_execution_events_config
                  query_execution_inputs_and_outputs_config = parent_rpcs.query_execution_inputs_and_outputs if parent_rpcs.respond_to? :query_execution_inputs_and_outputs
                  @query_execution_inputs_and_outputs = ::Gapic::Config::Method.new query_execution_inputs_and_outputs_config
                  create_metadata_schema_config = parent_rpcs.create_metadata_schema if parent_rpcs.respond_to? :create_metadata_schema
                  @create_metadata_schema = ::Gapic::Config::Method.new create_metadata_schema_config
                  get_metadata_schema_config = parent_rpcs.get_metadata_schema if parent_rpcs.respond_to? :get_metadata_schema
                  @get_metadata_schema = ::Gapic::Config::Method.new get_metadata_schema_config
                  list_metadata_schemas_config = parent_rpcs.list_metadata_schemas if parent_rpcs.respond_to? :list_metadata_schemas
                  @list_metadata_schemas = ::Gapic::Config::Method.new list_metadata_schemas_config
                  query_artifact_lineage_subgraph_config = parent_rpcs.query_artifact_lineage_subgraph if parent_rpcs.respond_to? :query_artifact_lineage_subgraph
                  @query_artifact_lineage_subgraph = ::Gapic::Config::Method.new query_artifact_lineage_subgraph_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
