# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/job_service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module AIPlatform
      module V1
        module JobService
          ##
          # Client for the JobService service.
          #
          # A service for creating and managing Vertex AI's jobs.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :job_service_stub

            ##
            # Configure the JobService Client class.
            #
            # See {::Google::Cloud::AIPlatform::V1::JobService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all JobService clients
            #   ::Google::Cloud::AIPlatform::V1::JobService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the JobService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::AIPlatform::V1::JobService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @job_service_stub.universe_domain
            end

            ##
            # Create a new JobService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the JobService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/aiplatform/v1/job_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @job_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::AIPlatform::V1::JobService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @job_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @job_service_stub.endpoint
                config.universe_domain = @job_service_stub.universe_domain
                config.logger = @job_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @job_service_stub.endpoint
                config.universe_domain = @job_service_stub.universe_domain
                config.logger = @job_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::AIPlatform::V1::JobService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @job_service_stub.logger
            end

            # Service calls

            ##
            # Creates a CustomJob. A created CustomJob right away
            # will be attempted to be run.
            #
            # @overload create_custom_job(request, options = nil)
            #   Pass arguments to `create_custom_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateCustomJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateCustomJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_custom_job(parent: nil, custom_job: nil)
            #   Pass arguments to `create_custom_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to create the CustomJob in.
            #     Format: `projects/{project}/locations/{location}`
            #   @param custom_job [::Google::Cloud::AIPlatform::V1::CustomJob, ::Hash]
            #     Required. The CustomJob to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::CustomJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::CustomJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateCustomJobRequest.new
            #
            #   # Call the create_custom_job method.
            #   result = client.create_custom_job request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::CustomJob.
            #   p result
            #
            def create_custom_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateCustomJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_custom_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_custom_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_custom_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :create_custom_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a CustomJob.
            #
            # @overload get_custom_job(request, options = nil)
            #   Pass arguments to `get_custom_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetCustomJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetCustomJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_custom_job(name: nil)
            #   Pass arguments to `get_custom_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the CustomJob resource.
            #     Format:
            #     `projects/{project}/locations/{location}/customJobs/{custom_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::CustomJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::CustomJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetCustomJobRequest.new
            #
            #   # Call the get_custom_job method.
            #   result = client.get_custom_job request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::CustomJob.
            #   p result
            #
            def get_custom_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetCustomJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_custom_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_custom_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_custom_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :get_custom_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists CustomJobs in a Location.
            #
            # @overload list_custom_jobs(request, options = nil)
            #   Pass arguments to `list_custom_jobs` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListCustomJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListCustomJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_custom_jobs(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil)
            #   Pass arguments to `list_custom_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to list the CustomJobs from.
            #     Format: `projects/{project}/locations/{location}`
            #   @param filter [::String]
            #     The standard list filter.
            #
            #     Supported fields:
            #
            #       * `display_name` supports `=`, `!=` comparisons, and `:` wildcard.
            #       * `state` supports `=`, `!=` comparisons.
            #       * `create_time` supports `=`, `!=`,`<`, `<=`,`>`, `>=` comparisons.
            #         `create_time` must be in RFC 3339 format.
            #       * `labels` supports general map functions that is:
            #         `labels.key=value` - key:value equality
            #         `labels.key:* - key existence
            #
            #     Some examples of using the filter are:
            #
            #       * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"`
            #       * `state!="JOB_STATE_FAILED" OR display_name="my_job"`
            #       * `NOT display_name="my_job"`
            #       * `create_time>"2021-05-18T00:00:00Z"`
            #       * `labels.keyA=valueA`
            #       * `labels.keyB:*`
            #   @param page_size [::Integer]
            #     The standard list page size.
            #   @param page_token [::String]
            #     The standard list page token.
            #     Typically obtained via
            #     {::Google::Cloud::AIPlatform::V1::ListCustomJobsResponse#next_page_token ListCustomJobsResponse.next_page_token}
            #     of the previous
            #     {::Google::Cloud::AIPlatform::V1::JobService::Client#list_custom_jobs JobService.ListCustomJobs}
            #     call.
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::CustomJob>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::CustomJob>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListCustomJobsRequest.new
            #
            #   # Call the list_custom_jobs method.
            #   result = client.list_custom_jobs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::CustomJob.
            #     p item
            #   end
            #
            def list_custom_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListCustomJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_custom_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_custom_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_custom_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :list_custom_jobs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @job_service_stub, :list_custom_jobs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a CustomJob.
            #
            # @overload delete_custom_job(request, options = nil)
            #   Pass arguments to `delete_custom_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteCustomJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteCustomJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_custom_job(name: nil)
            #   Pass arguments to `delete_custom_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the CustomJob resource to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/customJobs/{custom_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteCustomJobRequest.new
            #
            #   # Call the delete_custom_job method.
            #   result = client.delete_custom_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_custom_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteCustomJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_custom_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_custom_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_custom_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :delete_custom_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Cancels a CustomJob.
            # Starts asynchronous cancellation on the CustomJob. The server
            # makes a best effort to cancel the job, but success is not
            # guaranteed. Clients can use
            # {::Google::Cloud::AIPlatform::V1::JobService::Client#get_custom_job JobService.GetCustomJob}
            # or other methods to check whether the cancellation succeeded or whether the
            # job completed despite cancellation. On successful cancellation,
            # the CustomJob is not deleted; instead it becomes a job with
            # a {::Google::Cloud::AIPlatform::V1::CustomJob#error CustomJob.error} value with
            # a {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
            # `Code.CANCELLED`, and
            # {::Google::Cloud::AIPlatform::V1::CustomJob#state CustomJob.state} is set to
            # `CANCELLED`.
            #
            # @overload cancel_custom_job(request, options = nil)
            #   Pass arguments to `cancel_custom_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CancelCustomJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CancelCustomJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload cancel_custom_job(name: nil)
            #   Pass arguments to `cancel_custom_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the CustomJob to cancel.
            #     Format:
            #     `projects/{project}/locations/{location}/customJobs/{custom_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CancelCustomJobRequest.new
            #
            #   # Call the cancel_custom_job method.
            #   result = client.cancel_custom_job request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def cancel_custom_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CancelCustomJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.cancel_custom_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.cancel_custom_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.cancel_custom_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :cancel_custom_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a DataLabelingJob.
            #
            # @overload create_data_labeling_job(request, options = nil)
            #   Pass arguments to `create_data_labeling_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateDataLabelingJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateDataLabelingJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_data_labeling_job(parent: nil, data_labeling_job: nil)
            #   Pass arguments to `create_data_labeling_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent of the DataLabelingJob.
            #     Format: `projects/{project}/locations/{location}`
            #   @param data_labeling_job [::Google::Cloud::AIPlatform::V1::DataLabelingJob, ::Hash]
            #     Required. The DataLabelingJob to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::DataLabelingJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::DataLabelingJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateDataLabelingJobRequest.new
            #
            #   # Call the create_data_labeling_job method.
            #   result = client.create_data_labeling_job request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::DataLabelingJob.
            #   p result
            #
            def create_data_labeling_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateDataLabelingJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_data_labeling_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_data_labeling_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_data_labeling_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :create_data_labeling_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a DataLabelingJob.
            #
            # @overload get_data_labeling_job(request, options = nil)
            #   Pass arguments to `get_data_labeling_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetDataLabelingJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetDataLabelingJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_data_labeling_job(name: nil)
            #   Pass arguments to `get_data_labeling_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the DataLabelingJob.
            #     Format:
            #     `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::DataLabelingJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::DataLabelingJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetDataLabelingJobRequest.new
            #
            #   # Call the get_data_labeling_job method.
            #   result = client.get_data_labeling_job request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::DataLabelingJob.
            #   p result
            #
            def get_data_labeling_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetDataLabelingJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_data_labeling_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_data_labeling_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_data_labeling_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :get_data_labeling_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists DataLabelingJobs in a Location.
            #
            # @overload list_data_labeling_jobs(request, options = nil)
            #   Pass arguments to `list_data_labeling_jobs` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListDataLabelingJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListDataLabelingJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_data_labeling_jobs(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil, order_by: nil)
            #   Pass arguments to `list_data_labeling_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent of the DataLabelingJob.
            #     Format: `projects/{project}/locations/{location}`
            #   @param filter [::String]
            #     The standard list filter.
            #
            #     Supported fields:
            #
            #       * `display_name` supports `=`, `!=` comparisons, and `:` wildcard.
            #       * `state` supports `=`, `!=` comparisons.
            #       * `create_time` supports `=`, `!=`,`<`, `<=`,`>`, `>=` comparisons.
            #         `create_time` must be in RFC 3339 format.
            #       * `labels` supports general map functions that is:
            #         `labels.key=value` - key:value equality
            #         `labels.key:* - key existence
            #
            #     Some examples of using the filter are:
            #
            #       * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"`
            #       * `state!="JOB_STATE_FAILED" OR display_name="my_job"`
            #       * `NOT display_name="my_job"`
            #       * `create_time>"2021-05-18T00:00:00Z"`
            #       * `labels.keyA=valueA`
            #       * `labels.keyB:*`
            #   @param page_size [::Integer]
            #     The standard list page size.
            #   @param page_token [::String]
            #     The standard list page token.
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read. FieldMask represents a set of
            #     symbolic field paths. For example, the mask can be `paths: "name"`. The
            #     "name" here is a field in DataLabelingJob.
            #     If this field is not set, all fields of the DataLabelingJob are returned.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order by, sorted in ascending order by
            #     default.
            #     Use `desc` after a field name for descending.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::DataLabelingJob>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::DataLabelingJob>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListDataLabelingJobsRequest.new
            #
            #   # Call the list_data_labeling_jobs method.
            #   result = client.list_data_labeling_jobs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::DataLabelingJob.
            #     p item
            #   end
            #
            def list_data_labeling_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListDataLabelingJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_data_labeling_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_data_labeling_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_data_labeling_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :list_data_labeling_jobs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @job_service_stub, :list_data_labeling_jobs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a DataLabelingJob.
            #
            # @overload delete_data_labeling_job(request, options = nil)
            #   Pass arguments to `delete_data_labeling_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteDataLabelingJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteDataLabelingJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_data_labeling_job(name: nil)
            #   Pass arguments to `delete_data_labeling_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the DataLabelingJob to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteDataLabelingJobRequest.new
            #
            #   # Call the delete_data_labeling_job method.
            #   result = client.delete_data_labeling_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_data_labeling_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteDataLabelingJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_data_labeling_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_data_labeling_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_data_labeling_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :delete_data_labeling_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Cancels a DataLabelingJob. Success of cancellation is not guaranteed.
            #
            # @overload cancel_data_labeling_job(request, options = nil)
            #   Pass arguments to `cancel_data_labeling_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CancelDataLabelingJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CancelDataLabelingJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload cancel_data_labeling_job(name: nil)
            #   Pass arguments to `cancel_data_labeling_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the DataLabelingJob.
            #     Format:
            #     `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CancelDataLabelingJobRequest.new
            #
            #   # Call the cancel_data_labeling_job method.
            #   result = client.cancel_data_labeling_job request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def cancel_data_labeling_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CancelDataLabelingJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.cancel_data_labeling_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.cancel_data_labeling_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.cancel_data_labeling_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :cancel_data_labeling_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a HyperparameterTuningJob
            #
            # @overload create_hyperparameter_tuning_job(request, options = nil)
            #   Pass arguments to `create_hyperparameter_tuning_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateHyperparameterTuningJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateHyperparameterTuningJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_hyperparameter_tuning_job(parent: nil, hyperparameter_tuning_job: nil)
            #   Pass arguments to `create_hyperparameter_tuning_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to create the
            #     HyperparameterTuningJob in. Format:
            #     `projects/{project}/locations/{location}`
            #   @param hyperparameter_tuning_job [::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob, ::Hash]
            #     Required. The HyperparameterTuningJob to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateHyperparameterTuningJobRequest.new
            #
            #   # Call the create_hyperparameter_tuning_job method.
            #   result = client.create_hyperparameter_tuning_job request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::HyperparameterTuningJob.
            #   p result
            #
            def create_hyperparameter_tuning_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateHyperparameterTuningJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_hyperparameter_tuning_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_hyperparameter_tuning_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_hyperparameter_tuning_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :create_hyperparameter_tuning_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a HyperparameterTuningJob
            #
            # @overload get_hyperparameter_tuning_job(request, options = nil)
            #   Pass arguments to `get_hyperparameter_tuning_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetHyperparameterTuningJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetHyperparameterTuningJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_hyperparameter_tuning_job(name: nil)
            #   Pass arguments to `get_hyperparameter_tuning_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the HyperparameterTuningJob resource.
            #     Format:
            #     `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyperparameter_tuning_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetHyperparameterTuningJobRequest.new
            #
            #   # Call the get_hyperparameter_tuning_job method.
            #   result = client.get_hyperparameter_tuning_job request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::HyperparameterTuningJob.
            #   p result
            #
            def get_hyperparameter_tuning_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetHyperparameterTuningJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_hyperparameter_tuning_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_hyperparameter_tuning_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_hyperparameter_tuning_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :get_hyperparameter_tuning_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists HyperparameterTuningJobs in a Location.
            #
            # @overload list_hyperparameter_tuning_jobs(request, options = nil)
            #   Pass arguments to `list_hyperparameter_tuning_jobs` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListHyperparameterTuningJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListHyperparameterTuningJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_hyperparameter_tuning_jobs(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil)
            #   Pass arguments to `list_hyperparameter_tuning_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to list the
            #     HyperparameterTuningJobs from. Format:
            #     `projects/{project}/locations/{location}`
            #   @param filter [::String]
            #     The standard list filter.
            #
            #     Supported fields:
            #
            #       * `display_name` supports `=`, `!=` comparisons, and `:` wildcard.
            #       * `state` supports `=`, `!=` comparisons.
            #       * `create_time` supports `=`, `!=`,`<`, `<=`,`>`, `>=` comparisons.
            #         `create_time` must be in RFC 3339 format.
            #       * `labels` supports general map functions that is:
            #         `labels.key=value` - key:value equality
            #         `labels.key:* - key existence
            #
            #     Some examples of using the filter are:
            #
            #       * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"`
            #       * `state!="JOB_STATE_FAILED" OR display_name="my_job"`
            #       * `NOT display_name="my_job"`
            #       * `create_time>"2021-05-18T00:00:00Z"`
            #       * `labels.keyA=valueA`
            #       * `labels.keyB:*`
            #   @param page_size [::Integer]
            #     The standard list page size.
            #   @param page_token [::String]
            #     The standard list page token.
            #     Typically obtained via
            #     {::Google::Cloud::AIPlatform::V1::ListHyperparameterTuningJobsResponse#next_page_token ListHyperparameterTuningJobsResponse.next_page_token}
            #     of the previous
            #     {::Google::Cloud::AIPlatform::V1::JobService::Client#list_hyperparameter_tuning_jobs JobService.ListHyperparameterTuningJobs}
            #     call.
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListHyperparameterTuningJobsRequest.new
            #
            #   # Call the list_hyperparameter_tuning_jobs method.
            #   result = client.list_hyperparameter_tuning_jobs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob.
            #     p item
            #   end
            #
            def list_hyperparameter_tuning_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListHyperparameterTuningJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_hyperparameter_tuning_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_hyperparameter_tuning_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_hyperparameter_tuning_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :list_hyperparameter_tuning_jobs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @job_service_stub, :list_hyperparameter_tuning_jobs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a HyperparameterTuningJob.
            #
            # @overload delete_hyperparameter_tuning_job(request, options = nil)
            #   Pass arguments to `delete_hyperparameter_tuning_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteHyperparameterTuningJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteHyperparameterTuningJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_hyperparameter_tuning_job(name: nil)
            #   Pass arguments to `delete_hyperparameter_tuning_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the HyperparameterTuningJob resource to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyperparameter_tuning_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteHyperparameterTuningJobRequest.new
            #
            #   # Call the delete_hyperparameter_tuning_job method.
            #   result = client.delete_hyperparameter_tuning_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_hyperparameter_tuning_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteHyperparameterTuningJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_hyperparameter_tuning_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_hyperparameter_tuning_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_hyperparameter_tuning_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :delete_hyperparameter_tuning_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Cancels a HyperparameterTuningJob.
            # Starts asynchronous cancellation on the HyperparameterTuningJob. The server
            # makes a best effort to cancel the job, but success is not
            # guaranteed. Clients can use
            # {::Google::Cloud::AIPlatform::V1::JobService::Client#get_hyperparameter_tuning_job JobService.GetHyperparameterTuningJob}
            # or other methods to check whether the cancellation succeeded or whether the
            # job completed despite cancellation. On successful cancellation,
            # the HyperparameterTuningJob is not deleted; instead it becomes a job with
            # a
            # {::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob#error HyperparameterTuningJob.error}
            # value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
            # corresponding to `Code.CANCELLED`, and
            # {::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob#state HyperparameterTuningJob.state}
            # is set to `CANCELLED`.
            #
            # @overload cancel_hyperparameter_tuning_job(request, options = nil)
            #   Pass arguments to `cancel_hyperparameter_tuning_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CancelHyperparameterTuningJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CancelHyperparameterTuningJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload cancel_hyperparameter_tuning_job(name: nil)
            #   Pass arguments to `cancel_hyperparameter_tuning_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the HyperparameterTuningJob to cancel.
            #     Format:
            #     `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyperparameter_tuning_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CancelHyperparameterTuningJobRequest.new
            #
            #   # Call the cancel_hyperparameter_tuning_job method.
            #   result = client.cancel_hyperparameter_tuning_job request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def cancel_hyperparameter_tuning_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CancelHyperparameterTuningJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.cancel_hyperparameter_tuning_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.cancel_hyperparameter_tuning_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.cancel_hyperparameter_tuning_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :cancel_hyperparameter_tuning_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a NasJob
            #
            # @overload create_nas_job(request, options = nil)
            #   Pass arguments to `create_nas_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateNasJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateNasJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_nas_job(parent: nil, nas_job: nil)
            #   Pass arguments to `create_nas_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to create the NasJob in.
            #     Format: `projects/{project}/locations/{location}`
            #   @param nas_job [::Google::Cloud::AIPlatform::V1::NasJob, ::Hash]
            #     Required. The NasJob to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::NasJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::NasJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateNasJobRequest.new
            #
            #   # Call the create_nas_job method.
            #   result = client.create_nas_job request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::NasJob.
            #   p result
            #
            def create_nas_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateNasJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_nas_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_nas_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_nas_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :create_nas_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a NasJob
            #
            # @overload get_nas_job(request, options = nil)
            #   Pass arguments to `get_nas_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetNasJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetNasJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_nas_job(name: nil)
            #   Pass arguments to `get_nas_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the NasJob resource.
            #     Format:
            #     `projects/{project}/locations/{location}/nasJobs/{nas_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::NasJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::NasJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetNasJobRequest.new
            #
            #   # Call the get_nas_job method.
            #   result = client.get_nas_job request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::NasJob.
            #   p result
            #
            def get_nas_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetNasJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_nas_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_nas_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_nas_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :get_nas_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists NasJobs in a Location.
            #
            # @overload list_nas_jobs(request, options = nil)
            #   Pass arguments to `list_nas_jobs` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListNasJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListNasJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_nas_jobs(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil)
            #   Pass arguments to `list_nas_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to list the NasJobs
            #     from. Format: `projects/{project}/locations/{location}`
            #   @param filter [::String]
            #     The standard list filter.
            #
            #     Supported fields:
            #
            #       * `display_name` supports `=`, `!=` comparisons, and `:` wildcard.
            #       * `state` supports `=`, `!=` comparisons.
            #       * `create_time` supports `=`, `!=`,`<`, `<=`,`>`, `>=` comparisons.
            #         `create_time` must be in RFC 3339 format.
            #       * `labels` supports general map functions that is:
            #         `labels.key=value` - key:value equality
            #         `labels.key:* - key existence
            #
            #     Some examples of using the filter are:
            #
            #       * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"`
            #       * `state!="JOB_STATE_FAILED" OR display_name="my_job"`
            #       * `NOT display_name="my_job"`
            #       * `create_time>"2021-05-18T00:00:00Z"`
            #       * `labels.keyA=valueA`
            #       * `labels.keyB:*`
            #   @param page_size [::Integer]
            #     The standard list page size.
            #   @param page_token [::String]
            #     The standard list page token.
            #     Typically obtained via
            #     {::Google::Cloud::AIPlatform::V1::ListNasJobsResponse#next_page_token ListNasJobsResponse.next_page_token}
            #     of the previous
            #     {::Google::Cloud::AIPlatform::V1::JobService::Client#list_nas_jobs JobService.ListNasJobs}
            #     call.
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::NasJob>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::NasJob>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListNasJobsRequest.new
            #
            #   # Call the list_nas_jobs method.
            #   result = client.list_nas_jobs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::NasJob.
            #     p item
            #   end
            #
            def list_nas_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListNasJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_nas_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_nas_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_nas_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :list_nas_jobs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @job_service_stub, :list_nas_jobs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a NasJob.
            #
            # @overload delete_nas_job(request, options = nil)
            #   Pass arguments to `delete_nas_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteNasJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteNasJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_nas_job(name: nil)
            #   Pass arguments to `delete_nas_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the NasJob resource to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/nasJobs/{nas_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteNasJobRequest.new
            #
            #   # Call the delete_nas_job method.
            #   result = client.delete_nas_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_nas_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteNasJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_nas_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_nas_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_nas_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :delete_nas_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Cancels a NasJob.
            # Starts asynchronous cancellation on the NasJob. The server
            # makes a best effort to cancel the job, but success is not
            # guaranteed. Clients can use
            # {::Google::Cloud::AIPlatform::V1::JobService::Client#get_nas_job JobService.GetNasJob} or
            # other methods to check whether the cancellation succeeded or whether the
            # job completed despite cancellation. On successful cancellation,
            # the NasJob is not deleted; instead it becomes a job with
            # a {::Google::Cloud::AIPlatform::V1::NasJob#error NasJob.error} value with a
            # {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
            # `Code.CANCELLED`, and
            # {::Google::Cloud::AIPlatform::V1::NasJob#state NasJob.state} is set to
            # `CANCELLED`.
            #
            # @overload cancel_nas_job(request, options = nil)
            #   Pass arguments to `cancel_nas_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CancelNasJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CancelNasJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload cancel_nas_job(name: nil)
            #   Pass arguments to `cancel_nas_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the NasJob to cancel.
            #     Format:
            #     `projects/{project}/locations/{location}/nasJobs/{nas_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CancelNasJobRequest.new
            #
            #   # Call the cancel_nas_job method.
            #   result = client.cancel_nas_job request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def cancel_nas_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CancelNasJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.cancel_nas_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.cancel_nas_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.cancel_nas_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :cancel_nas_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a NasTrialDetail.
            #
            # @overload get_nas_trial_detail(request, options = nil)
            #   Pass arguments to `get_nas_trial_detail` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetNasTrialDetailRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetNasTrialDetailRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_nas_trial_detail(name: nil)
            #   Pass arguments to `get_nas_trial_detail` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the NasTrialDetail resource.
            #     Format:
            #     `projects/{project}/locations/{location}/nasJobs/{nas_job}/nasTrialDetails/{nas_trial_detail}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::NasTrialDetail]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::NasTrialDetail]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetNasTrialDetailRequest.new
            #
            #   # Call the get_nas_trial_detail method.
            #   result = client.get_nas_trial_detail request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::NasTrialDetail.
            #   p result
            #
            def get_nas_trial_detail request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetNasTrialDetailRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_nas_trial_detail.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_nas_trial_detail.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_nas_trial_detail.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :get_nas_trial_detail, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List top NasTrialDetails of a NasJob.
            #
            # @overload list_nas_trial_details(request, options = nil)
            #   Pass arguments to `list_nas_trial_details` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListNasTrialDetailsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListNasTrialDetailsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_nas_trial_details(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_nas_trial_details` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the NasJob resource.
            #     Format:
            #     `projects/{project}/locations/{location}/nasJobs/{nas_job}`
            #   @param page_size [::Integer]
            #     The standard list page size.
            #   @param page_token [::String]
            #     The standard list page token.
            #     Typically obtained via
            #     {::Google::Cloud::AIPlatform::V1::ListNasTrialDetailsResponse#next_page_token ListNasTrialDetailsResponse.next_page_token}
            #     of the previous
            #     {::Google::Cloud::AIPlatform::V1::JobService::Client#list_nas_trial_details JobService.ListNasTrialDetails}
            #     call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::NasTrialDetail>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::NasTrialDetail>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListNasTrialDetailsRequest.new
            #
            #   # Call the list_nas_trial_details method.
            #   result = client.list_nas_trial_details request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::NasTrialDetail.
            #     p item
            #   end
            #
            def list_nas_trial_details request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListNasTrialDetailsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_nas_trial_details.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_nas_trial_details.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_nas_trial_details.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :list_nas_trial_details, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @job_service_stub, :list_nas_trial_details, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a BatchPredictionJob. A BatchPredictionJob once created will
            # right away be attempted to start.
            #
            # @overload create_batch_prediction_job(request, options = nil)
            #   Pass arguments to `create_batch_prediction_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateBatchPredictionJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateBatchPredictionJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_batch_prediction_job(parent: nil, batch_prediction_job: nil)
            #   Pass arguments to `create_batch_prediction_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to create the
            #     BatchPredictionJob in. Format: `projects/{project}/locations/{location}`
            #   @param batch_prediction_job [::Google::Cloud::AIPlatform::V1::BatchPredictionJob, ::Hash]
            #     Required. The BatchPredictionJob to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::BatchPredictionJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::BatchPredictionJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateBatchPredictionJobRequest.new
            #
            #   # Call the create_batch_prediction_job method.
            #   result = client.create_batch_prediction_job request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::BatchPredictionJob.
            #   p result
            #
            def create_batch_prediction_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateBatchPredictionJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_batch_prediction_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_batch_prediction_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_batch_prediction_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :create_batch_prediction_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a BatchPredictionJob
            #
            # @overload get_batch_prediction_job(request, options = nil)
            #   Pass arguments to `get_batch_prediction_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetBatchPredictionJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetBatchPredictionJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_batch_prediction_job(name: nil)
            #   Pass arguments to `get_batch_prediction_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the BatchPredictionJob resource.
            #     Format:
            #     `projects/{project}/locations/{location}/batchPredictionJobs/{batch_prediction_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::BatchPredictionJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::BatchPredictionJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetBatchPredictionJobRequest.new
            #
            #   # Call the get_batch_prediction_job method.
            #   result = client.get_batch_prediction_job request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::BatchPredictionJob.
            #   p result
            #
            def get_batch_prediction_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetBatchPredictionJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_batch_prediction_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_batch_prediction_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_batch_prediction_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :get_batch_prediction_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists BatchPredictionJobs in a Location.
            #
            # @overload list_batch_prediction_jobs(request, options = nil)
            #   Pass arguments to `list_batch_prediction_jobs` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListBatchPredictionJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListBatchPredictionJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_batch_prediction_jobs(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil)
            #   Pass arguments to `list_batch_prediction_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to list the BatchPredictionJobs
            #     from. Format: `projects/{project}/locations/{location}`
            #   @param filter [::String]
            #     The standard list filter.
            #
            #     Supported fields:
            #
            #       * `display_name` supports `=`, `!=` comparisons, and `:` wildcard.
            #       * `model_display_name` supports `=`, `!=` comparisons.
            #       * `state` supports `=`, `!=` comparisons.
            #       * `create_time` supports `=`, `!=`,`<`, `<=`,`>`, `>=` comparisons.
            #         `create_time` must be in RFC 3339 format.
            #       * `labels` supports general map functions that is:
            #         `labels.key=value` - key:value equality
            #         `labels.key:* - key existence
            #
            #     Some examples of using the filter are:
            #
            #       * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"`
            #       * `state!="JOB_STATE_FAILED" OR display_name="my_job"`
            #       * `NOT display_name="my_job"`
            #       * `create_time>"2021-05-18T00:00:00Z"`
            #       * `labels.keyA=valueA`
            #       * `labels.keyB:*`
            #   @param page_size [::Integer]
            #     The standard list page size.
            #   @param page_token [::String]
            #     The standard list page token.
            #     Typically obtained via
            #     {::Google::Cloud::AIPlatform::V1::ListBatchPredictionJobsResponse#next_page_token ListBatchPredictionJobsResponse.next_page_token}
            #     of the previous
            #     {::Google::Cloud::AIPlatform::V1::JobService::Client#list_batch_prediction_jobs JobService.ListBatchPredictionJobs}
            #     call.
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::BatchPredictionJob>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::BatchPredictionJob>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListBatchPredictionJobsRequest.new
            #
            #   # Call the list_batch_prediction_jobs method.
            #   result = client.list_batch_prediction_jobs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::BatchPredictionJob.
            #     p item
            #   end
            #
            def list_batch_prediction_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListBatchPredictionJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_batch_prediction_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_batch_prediction_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_batch_prediction_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :list_batch_prediction_jobs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @job_service_stub, :list_batch_prediction_jobs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a BatchPredictionJob. Can only be called on jobs that already
            # finished.
            #
            # @overload delete_batch_prediction_job(request, options = nil)
            #   Pass arguments to `delete_batch_prediction_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteBatchPredictionJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteBatchPredictionJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_batch_prediction_job(name: nil)
            #   Pass arguments to `delete_batch_prediction_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the BatchPredictionJob resource to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/batchPredictionJobs/{batch_prediction_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteBatchPredictionJobRequest.new
            #
            #   # Call the delete_batch_prediction_job method.
            #   result = client.delete_batch_prediction_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_batch_prediction_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteBatchPredictionJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_batch_prediction_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_batch_prediction_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_batch_prediction_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :delete_batch_prediction_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Cancels a BatchPredictionJob.
            #
            # Starts asynchronous cancellation on the BatchPredictionJob. The server
            # makes the best effort to cancel the job, but success is not
            # guaranteed. Clients can use
            # {::Google::Cloud::AIPlatform::V1::JobService::Client#get_batch_prediction_job JobService.GetBatchPredictionJob}
            # or other methods to check whether the cancellation succeeded or whether the
            # job completed despite cancellation. On a successful cancellation,
            # the BatchPredictionJob is not deleted;instead its
            # {::Google::Cloud::AIPlatform::V1::BatchPredictionJob#state BatchPredictionJob.state}
            # is set to `CANCELLED`. Any files already outputted by the job are not
            # deleted.
            #
            # @overload cancel_batch_prediction_job(request, options = nil)
            #   Pass arguments to `cancel_batch_prediction_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CancelBatchPredictionJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CancelBatchPredictionJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload cancel_batch_prediction_job(name: nil)
            #   Pass arguments to `cancel_batch_prediction_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the BatchPredictionJob to cancel.
            #     Format:
            #     `projects/{project}/locations/{location}/batchPredictionJobs/{batch_prediction_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CancelBatchPredictionJobRequest.new
            #
            #   # Call the cancel_batch_prediction_job method.
            #   result = client.cancel_batch_prediction_job request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def cancel_batch_prediction_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CancelBatchPredictionJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.cancel_batch_prediction_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.cancel_batch_prediction_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.cancel_batch_prediction_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :cancel_batch_prediction_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a ModelDeploymentMonitoringJob. It will run periodically on a
            # configured interval.
            #
            # @overload create_model_deployment_monitoring_job(request, options = nil)
            #   Pass arguments to `create_model_deployment_monitoring_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateModelDeploymentMonitoringJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateModelDeploymentMonitoringJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_model_deployment_monitoring_job(parent: nil, model_deployment_monitoring_job: nil)
            #   Pass arguments to `create_model_deployment_monitoring_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent of the ModelDeploymentMonitoringJob.
            #     Format: `projects/{project}/locations/{location}`
            #   @param model_deployment_monitoring_job [::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob, ::Hash]
            #     Required. The ModelDeploymentMonitoringJob to create
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateModelDeploymentMonitoringJobRequest.new
            #
            #   # Call the create_model_deployment_monitoring_job method.
            #   result = client.create_model_deployment_monitoring_job request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob.
            #   p result
            #
            def create_model_deployment_monitoring_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateModelDeploymentMonitoringJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_model_deployment_monitoring_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_model_deployment_monitoring_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_model_deployment_monitoring_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :create_model_deployment_monitoring_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Searches Model Monitoring Statistics generated within a given time window.
            #
            # @overload search_model_deployment_monitoring_stats_anomalies(request, options = nil)
            #   Pass arguments to `search_model_deployment_monitoring_stats_anomalies` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::SearchModelDeploymentMonitoringStatsAnomaliesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::SearchModelDeploymentMonitoringStatsAnomaliesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_model_deployment_monitoring_stats_anomalies(model_deployment_monitoring_job: nil, deployed_model_id: nil, feature_display_name: nil, objectives: nil, page_size: nil, page_token: nil, start_time: nil, end_time: nil)
            #   Pass arguments to `search_model_deployment_monitoring_stats_anomalies` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param model_deployment_monitoring_job [::String]
            #     Required. ModelDeploymentMonitoring Job resource name.
            #     Format:
            #     `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
            #   @param deployed_model_id [::String]
            #     Required. The DeployedModel ID of the
            #     [ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
            #   @param feature_display_name [::String]
            #     The feature display name. If specified, only return the stats belonging to
            #     this feature. Format:
            #     {::Google::Cloud::AIPlatform::V1::ModelMonitoringStatsAnomalies::FeatureHistoricStatsAnomalies#feature_display_name ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name},
            #     example: "user_destination".
            #   @param objectives [::Array<::Google::Cloud::AIPlatform::V1::SearchModelDeploymentMonitoringStatsAnomaliesRequest::StatsAnomaliesObjective, ::Hash>]
            #     Required. Objectives of the stats to retrieve.
            #   @param page_size [::Integer]
            #     The standard list page size.
            #   @param page_token [::String]
            #     A page token received from a previous
            #     {::Google::Cloud::AIPlatform::V1::JobService::Client#search_model_deployment_monitoring_stats_anomalies JobService.SearchModelDeploymentMonitoringStatsAnomalies}
            #     call.
            #   @param start_time [::Google::Protobuf::Timestamp, ::Hash]
            #     The earliest timestamp of stats being generated.
            #     If not set, indicates fetching stats till the earliest possible one.
            #   @param end_time [::Google::Protobuf::Timestamp, ::Hash]
            #     The latest timestamp of stats being generated.
            #     If not set, indicates feching stats till the latest possible one.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::ModelMonitoringStatsAnomalies>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::ModelMonitoringStatsAnomalies>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::SearchModelDeploymentMonitoringStatsAnomaliesRequest.new
            #
            #   # Call the search_model_deployment_monitoring_stats_anomalies method.
            #   result = client.search_model_deployment_monitoring_stats_anomalies request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::ModelMonitoringStatsAnomalies.
            #     p item
            #   end
            #
            def search_model_deployment_monitoring_stats_anomalies request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::SearchModelDeploymentMonitoringStatsAnomaliesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_model_deployment_monitoring_stats_anomalies.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.model_deployment_monitoring_job
                header_params["model_deployment_monitoring_job"] = request.model_deployment_monitoring_job
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_model_deployment_monitoring_stats_anomalies.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_model_deployment_monitoring_stats_anomalies.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :search_model_deployment_monitoring_stats_anomalies, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @job_service_stub, :search_model_deployment_monitoring_stats_anomalies, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a ModelDeploymentMonitoringJob.
            #
            # @overload get_model_deployment_monitoring_job(request, options = nil)
            #   Pass arguments to `get_model_deployment_monitoring_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetModelDeploymentMonitoringJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetModelDeploymentMonitoringJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_model_deployment_monitoring_job(name: nil)
            #   Pass arguments to `get_model_deployment_monitoring_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the ModelDeploymentMonitoringJob.
            #     Format:
            #     `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetModelDeploymentMonitoringJobRequest.new
            #
            #   # Call the get_model_deployment_monitoring_job method.
            #   result = client.get_model_deployment_monitoring_job request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob.
            #   p result
            #
            def get_model_deployment_monitoring_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetModelDeploymentMonitoringJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_model_deployment_monitoring_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_model_deployment_monitoring_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_model_deployment_monitoring_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :get_model_deployment_monitoring_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists ModelDeploymentMonitoringJobs in a Location.
            #
            # @overload list_model_deployment_monitoring_jobs(request, options = nil)
            #   Pass arguments to `list_model_deployment_monitoring_jobs` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListModelDeploymentMonitoringJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListModelDeploymentMonitoringJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_model_deployment_monitoring_jobs(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil)
            #   Pass arguments to `list_model_deployment_monitoring_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent of the ModelDeploymentMonitoringJob.
            #     Format: `projects/{project}/locations/{location}`
            #   @param filter [::String]
            #     The standard list filter.
            #
            #     Supported fields:
            #
            #       * `display_name` supports `=`, `!=` comparisons, and `:` wildcard.
            #       * `state` supports `=`, `!=` comparisons.
            #       * `create_time` supports `=`, `!=`,`<`, `<=`,`>`, `>=` comparisons.
            #         `create_time` must be in RFC 3339 format.
            #       * `labels` supports general map functions that is:
            #         `labels.key=value` - key:value equality
            #         `labels.key:* - key existence
            #
            #     Some examples of using the filter are:
            #
            #       * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"`
            #       * `state!="JOB_STATE_FAILED" OR display_name="my_job"`
            #       * `NOT display_name="my_job"`
            #       * `create_time>"2021-05-18T00:00:00Z"`
            #       * `labels.keyA=valueA`
            #       * `labels.keyB:*`
            #   @param page_size [::Integer]
            #     The standard list page size.
            #   @param page_token [::String]
            #     The standard list page token.
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListModelDeploymentMonitoringJobsRequest.new
            #
            #   # Call the list_model_deployment_monitoring_jobs method.
            #   result = client.list_model_deployment_monitoring_jobs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob.
            #     p item
            #   end
            #
            def list_model_deployment_monitoring_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListModelDeploymentMonitoringJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_model_deployment_monitoring_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_model_deployment_monitoring_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_model_deployment_monitoring_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :list_model_deployment_monitoring_jobs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @job_service_stub, :list_model_deployment_monitoring_jobs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a ModelDeploymentMonitoringJob.
            #
            # @overload update_model_deployment_monitoring_job(request, options = nil)
            #   Pass arguments to `update_model_deployment_monitoring_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateModelDeploymentMonitoringJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateModelDeploymentMonitoringJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_model_deployment_monitoring_job(model_deployment_monitoring_job: nil, update_mask: nil)
            #   Pass arguments to `update_model_deployment_monitoring_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param model_deployment_monitoring_job [::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob, ::Hash]
            #     Required. The model monitoring configuration which replaces the resource on
            #     the server.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The update mask is used to specify the fields to be overwritten
            #     in the ModelDeploymentMonitoringJob resource by the update. The fields
            #     specified in the update_mask are relative to the resource, not the full
            #     request. A field will be overwritten if it is in the mask. If the user does
            #     not provide a mask then only the non-empty fields present in the request
            #     will be overwritten. Set the update_mask to `*` to override all fields. For
            #     the objective config, the user can either provide the update mask for
            #     model_deployment_monitoring_objective_configs or any combination of its
            #     nested fields, such as:
            #     model_deployment_monitoring_objective_configs.objective_config.training_dataset.
            #
            #     Updatable fields:
            #
            #       * `display_name`
            #       * `model_deployment_monitoring_schedule_config`
            #       * `model_monitoring_alert_config`
            #       * `logging_sampling_strategy`
            #       * `labels`
            #       * `log_ttl`
            #       * `enable_monitoring_pipeline_logs`
            #     .  and
            #       * `model_deployment_monitoring_objective_configs`
            #     .  or
            #       * `model_deployment_monitoring_objective_configs.objective_config.training_dataset`
            #       * `model_deployment_monitoring_objective_configs.objective_config.training_prediction_skew_detection_config`
            #       * `model_deployment_monitoring_objective_configs.objective_config.prediction_drift_detection_config`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateModelDeploymentMonitoringJobRequest.new
            #
            #   # Call the update_model_deployment_monitoring_job method.
            #   result = client.update_model_deployment_monitoring_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_model_deployment_monitoring_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateModelDeploymentMonitoringJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_model_deployment_monitoring_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.model_deployment_monitoring_job&.name
                header_params["model_deployment_monitoring_job.name"] = request.model_deployment_monitoring_job.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_model_deployment_monitoring_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_model_deployment_monitoring_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :update_model_deployment_monitoring_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a ModelDeploymentMonitoringJob.
            #
            # @overload delete_model_deployment_monitoring_job(request, options = nil)
            #   Pass arguments to `delete_model_deployment_monitoring_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteModelDeploymentMonitoringJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteModelDeploymentMonitoringJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_model_deployment_monitoring_job(name: nil)
            #   Pass arguments to `delete_model_deployment_monitoring_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the model monitoring job to delete.
            #     Format:
            #     `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteModelDeploymentMonitoringJobRequest.new
            #
            #   # Call the delete_model_deployment_monitoring_job method.
            #   result = client.delete_model_deployment_monitoring_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_model_deployment_monitoring_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteModelDeploymentMonitoringJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_model_deployment_monitoring_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_model_deployment_monitoring_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_model_deployment_monitoring_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :delete_model_deployment_monitoring_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Pauses a ModelDeploymentMonitoringJob. If the job is running, the server
            # makes a best effort to cancel the job. Will mark
            # {::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob#state ModelDeploymentMonitoringJob.state}
            # to 'PAUSED'.
            #
            # @overload pause_model_deployment_monitoring_job(request, options = nil)
            #   Pass arguments to `pause_model_deployment_monitoring_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::PauseModelDeploymentMonitoringJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::PauseModelDeploymentMonitoringJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload pause_model_deployment_monitoring_job(name: nil)
            #   Pass arguments to `pause_model_deployment_monitoring_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the ModelDeploymentMonitoringJob to pause.
            #     Format:
            #     `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::PauseModelDeploymentMonitoringJobRequest.new
            #
            #   # Call the pause_model_deployment_monitoring_job method.
            #   result = client.pause_model_deployment_monitoring_job request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def pause_model_deployment_monitoring_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::PauseModelDeploymentMonitoringJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.pause_model_deployment_monitoring_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.pause_model_deployment_monitoring_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.pause_model_deployment_monitoring_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :pause_model_deployment_monitoring_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Resumes a paused ModelDeploymentMonitoringJob. It will start to run from
            # next scheduled time. A deleted ModelDeploymentMonitoringJob can't be
            # resumed.
            #
            # @overload resume_model_deployment_monitoring_job(request, options = nil)
            #   Pass arguments to `resume_model_deployment_monitoring_job` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ResumeModelDeploymentMonitoringJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ResumeModelDeploymentMonitoringJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload resume_model_deployment_monitoring_job(name: nil)
            #   Pass arguments to `resume_model_deployment_monitoring_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the ModelDeploymentMonitoringJob to resume.
            #     Format:
            #     `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::JobService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ResumeModelDeploymentMonitoringJobRequest.new
            #
            #   # Call the resume_model_deployment_monitoring_job method.
            #   result = client.resume_model_deployment_monitoring_job request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def resume_model_deployment_monitoring_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ResumeModelDeploymentMonitoringJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.resume_model_deployment_monitoring_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.resume_model_deployment_monitoring_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.resume_model_deployment_monitoring_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @job_service_stub.call_rpc :resume_model_deployment_monitoring_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the JobService API.
            #
            # This class represents the configuration for JobService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::AIPlatform::V1::JobService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_custom_job to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::AIPlatform::V1::JobService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_custom_job.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_custom_job.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the JobService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_custom_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_custom_job
                ##
                # RPC-specific configuration for `get_custom_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_custom_job
                ##
                # RPC-specific configuration for `list_custom_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_custom_jobs
                ##
                # RPC-specific configuration for `delete_custom_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_custom_job
                ##
                # RPC-specific configuration for `cancel_custom_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :cancel_custom_job
                ##
                # RPC-specific configuration for `create_data_labeling_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_data_labeling_job
                ##
                # RPC-specific configuration for `get_data_labeling_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_data_labeling_job
                ##
                # RPC-specific configuration for `list_data_labeling_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_data_labeling_jobs
                ##
                # RPC-specific configuration for `delete_data_labeling_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_data_labeling_job
                ##
                # RPC-specific configuration for `cancel_data_labeling_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :cancel_data_labeling_job
                ##
                # RPC-specific configuration for `create_hyperparameter_tuning_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_hyperparameter_tuning_job
                ##
                # RPC-specific configuration for `get_hyperparameter_tuning_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_hyperparameter_tuning_job
                ##
                # RPC-specific configuration for `list_hyperparameter_tuning_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_hyperparameter_tuning_jobs
                ##
                # RPC-specific configuration for `delete_hyperparameter_tuning_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_hyperparameter_tuning_job
                ##
                # RPC-specific configuration for `cancel_hyperparameter_tuning_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :cancel_hyperparameter_tuning_job
                ##
                # RPC-specific configuration for `create_nas_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_nas_job
                ##
                # RPC-specific configuration for `get_nas_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_nas_job
                ##
                # RPC-specific configuration for `list_nas_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_nas_jobs
                ##
                # RPC-specific configuration for `delete_nas_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_nas_job
                ##
                # RPC-specific configuration for `cancel_nas_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :cancel_nas_job
                ##
                # RPC-specific configuration for `get_nas_trial_detail`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_nas_trial_detail
                ##
                # RPC-specific configuration for `list_nas_trial_details`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_nas_trial_details
                ##
                # RPC-specific configuration for `create_batch_prediction_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_batch_prediction_job
                ##
                # RPC-specific configuration for `get_batch_prediction_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_batch_prediction_job
                ##
                # RPC-specific configuration for `list_batch_prediction_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_batch_prediction_jobs
                ##
                # RPC-specific configuration for `delete_batch_prediction_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_batch_prediction_job
                ##
                # RPC-specific configuration for `cancel_batch_prediction_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :cancel_batch_prediction_job
                ##
                # RPC-specific configuration for `create_model_deployment_monitoring_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_model_deployment_monitoring_job
                ##
                # RPC-specific configuration for `search_model_deployment_monitoring_stats_anomalies`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_model_deployment_monitoring_stats_anomalies
                ##
                # RPC-specific configuration for `get_model_deployment_monitoring_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_model_deployment_monitoring_job
                ##
                # RPC-specific configuration for `list_model_deployment_monitoring_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_model_deployment_monitoring_jobs
                ##
                # RPC-specific configuration for `update_model_deployment_monitoring_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_model_deployment_monitoring_job
                ##
                # RPC-specific configuration for `delete_model_deployment_monitoring_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_model_deployment_monitoring_job
                ##
                # RPC-specific configuration for `pause_model_deployment_monitoring_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :pause_model_deployment_monitoring_job
                ##
                # RPC-specific configuration for `resume_model_deployment_monitoring_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :resume_model_deployment_monitoring_job

                # @private
                def initialize parent_rpcs = nil
                  create_custom_job_config = parent_rpcs.create_custom_job if parent_rpcs.respond_to? :create_custom_job
                  @create_custom_job = ::Gapic::Config::Method.new create_custom_job_config
                  get_custom_job_config = parent_rpcs.get_custom_job if parent_rpcs.respond_to? :get_custom_job
                  @get_custom_job = ::Gapic::Config::Method.new get_custom_job_config
                  list_custom_jobs_config = parent_rpcs.list_custom_jobs if parent_rpcs.respond_to? :list_custom_jobs
                  @list_custom_jobs = ::Gapic::Config::Method.new list_custom_jobs_config
                  delete_custom_job_config = parent_rpcs.delete_custom_job if parent_rpcs.respond_to? :delete_custom_job
                  @delete_custom_job = ::Gapic::Config::Method.new delete_custom_job_config
                  cancel_custom_job_config = parent_rpcs.cancel_custom_job if parent_rpcs.respond_to? :cancel_custom_job
                  @cancel_custom_job = ::Gapic::Config::Method.new cancel_custom_job_config
                  create_data_labeling_job_config = parent_rpcs.create_data_labeling_job if parent_rpcs.respond_to? :create_data_labeling_job
                  @create_data_labeling_job = ::Gapic::Config::Method.new create_data_labeling_job_config
                  get_data_labeling_job_config = parent_rpcs.get_data_labeling_job if parent_rpcs.respond_to? :get_data_labeling_job
                  @get_data_labeling_job = ::Gapic::Config::Method.new get_data_labeling_job_config
                  list_data_labeling_jobs_config = parent_rpcs.list_data_labeling_jobs if parent_rpcs.respond_to? :list_data_labeling_jobs
                  @list_data_labeling_jobs = ::Gapic::Config::Method.new list_data_labeling_jobs_config
                  delete_data_labeling_job_config = parent_rpcs.delete_data_labeling_job if parent_rpcs.respond_to? :delete_data_labeling_job
                  @delete_data_labeling_job = ::Gapic::Config::Method.new delete_data_labeling_job_config
                  cancel_data_labeling_job_config = parent_rpcs.cancel_data_labeling_job if parent_rpcs.respond_to? :cancel_data_labeling_job
                  @cancel_data_labeling_job = ::Gapic::Config::Method.new cancel_data_labeling_job_config
                  create_hyperparameter_tuning_job_config = parent_rpcs.create_hyperparameter_tuning_job if parent_rpcs.respond_to? :create_hyperparameter_tuning_job
                  @create_hyperparameter_tuning_job = ::Gapic::Config::Method.new create_hyperparameter_tuning_job_config
                  get_hyperparameter_tuning_job_config = parent_rpcs.get_hyperparameter_tuning_job if parent_rpcs.respond_to? :get_hyperparameter_tuning_job
                  @get_hyperparameter_tuning_job = ::Gapic::Config::Method.new get_hyperparameter_tuning_job_config
                  list_hyperparameter_tuning_jobs_config = parent_rpcs.list_hyperparameter_tuning_jobs if parent_rpcs.respond_to? :list_hyperparameter_tuning_jobs
                  @list_hyperparameter_tuning_jobs = ::Gapic::Config::Method.new list_hyperparameter_tuning_jobs_config
                  delete_hyperparameter_tuning_job_config = parent_rpcs.delete_hyperparameter_tuning_job if parent_rpcs.respond_to? :delete_hyperparameter_tuning_job
                  @delete_hyperparameter_tuning_job = ::Gapic::Config::Method.new delete_hyperparameter_tuning_job_config
                  cancel_hyperparameter_tuning_job_config = parent_rpcs.cancel_hyperparameter_tuning_job if parent_rpcs.respond_to? :cancel_hyperparameter_tuning_job
                  @cancel_hyperparameter_tuning_job = ::Gapic::Config::Method.new cancel_hyperparameter_tuning_job_config
                  create_nas_job_config = parent_rpcs.create_nas_job if parent_rpcs.respond_to? :create_nas_job
                  @create_nas_job = ::Gapic::Config::Method.new create_nas_job_config
                  get_nas_job_config = parent_rpcs.get_nas_job if parent_rpcs.respond_to? :get_nas_job
                  @get_nas_job = ::Gapic::Config::Method.new get_nas_job_config
                  list_nas_jobs_config = parent_rpcs.list_nas_jobs if parent_rpcs.respond_to? :list_nas_jobs
                  @list_nas_jobs = ::Gapic::Config::Method.new list_nas_jobs_config
                  delete_nas_job_config = parent_rpcs.delete_nas_job if parent_rpcs.respond_to? :delete_nas_job
                  @delete_nas_job = ::Gapic::Config::Method.new delete_nas_job_config
                  cancel_nas_job_config = parent_rpcs.cancel_nas_job if parent_rpcs.respond_to? :cancel_nas_job
                  @cancel_nas_job = ::Gapic::Config::Method.new cancel_nas_job_config
                  get_nas_trial_detail_config = parent_rpcs.get_nas_trial_detail if parent_rpcs.respond_to? :get_nas_trial_detail
                  @get_nas_trial_detail = ::Gapic::Config::Method.new get_nas_trial_detail_config
                  list_nas_trial_details_config = parent_rpcs.list_nas_trial_details if parent_rpcs.respond_to? :list_nas_trial_details
                  @list_nas_trial_details = ::Gapic::Config::Method.new list_nas_trial_details_config
                  create_batch_prediction_job_config = parent_rpcs.create_batch_prediction_job if parent_rpcs.respond_to? :create_batch_prediction_job
                  @create_batch_prediction_job = ::Gapic::Config::Method.new create_batch_prediction_job_config
                  get_batch_prediction_job_config = parent_rpcs.get_batch_prediction_job if parent_rpcs.respond_to? :get_batch_prediction_job
                  @get_batch_prediction_job = ::Gapic::Config::Method.new get_batch_prediction_job_config
                  list_batch_prediction_jobs_config = parent_rpcs.list_batch_prediction_jobs if parent_rpcs.respond_to? :list_batch_prediction_jobs
                  @list_batch_prediction_jobs = ::Gapic::Config::Method.new list_batch_prediction_jobs_config
                  delete_batch_prediction_job_config = parent_rpcs.delete_batch_prediction_job if parent_rpcs.respond_to? :delete_batch_prediction_job
                  @delete_batch_prediction_job = ::Gapic::Config::Method.new delete_batch_prediction_job_config
                  cancel_batch_prediction_job_config = parent_rpcs.cancel_batch_prediction_job if parent_rpcs.respond_to? :cancel_batch_prediction_job
                  @cancel_batch_prediction_job = ::Gapic::Config::Method.new cancel_batch_prediction_job_config
                  create_model_deployment_monitoring_job_config = parent_rpcs.create_model_deployment_monitoring_job if parent_rpcs.respond_to? :create_model_deployment_monitoring_job
                  @create_model_deployment_monitoring_job = ::Gapic::Config::Method.new create_model_deployment_monitoring_job_config
                  search_model_deployment_monitoring_stats_anomalies_config = parent_rpcs.search_model_deployment_monitoring_stats_anomalies if parent_rpcs.respond_to? :search_model_deployment_monitoring_stats_anomalies
                  @search_model_deployment_monitoring_stats_anomalies = ::Gapic::Config::Method.new search_model_deployment_monitoring_stats_anomalies_config
                  get_model_deployment_monitoring_job_config = parent_rpcs.get_model_deployment_monitoring_job if parent_rpcs.respond_to? :get_model_deployment_monitoring_job
                  @get_model_deployment_monitoring_job = ::Gapic::Config::Method.new get_model_deployment_monitoring_job_config
                  list_model_deployment_monitoring_jobs_config = parent_rpcs.list_model_deployment_monitoring_jobs if parent_rpcs.respond_to? :list_model_deployment_monitoring_jobs
                  @list_model_deployment_monitoring_jobs = ::Gapic::Config::Method.new list_model_deployment_monitoring_jobs_config
                  update_model_deployment_monitoring_job_config = parent_rpcs.update_model_deployment_monitoring_job if parent_rpcs.respond_to? :update_model_deployment_monitoring_job
                  @update_model_deployment_monitoring_job = ::Gapic::Config::Method.new update_model_deployment_monitoring_job_config
                  delete_model_deployment_monitoring_job_config = parent_rpcs.delete_model_deployment_monitoring_job if parent_rpcs.respond_to? :delete_model_deployment_monitoring_job
                  @delete_model_deployment_monitoring_job = ::Gapic::Config::Method.new delete_model_deployment_monitoring_job_config
                  pause_model_deployment_monitoring_job_config = parent_rpcs.pause_model_deployment_monitoring_job if parent_rpcs.respond_to? :pause_model_deployment_monitoring_job
                  @pause_model_deployment_monitoring_job = ::Gapic::Config::Method.new pause_model_deployment_monitoring_job_config
                  resume_model_deployment_monitoring_job_config = parent_rpcs.resume_model_deployment_monitoring_job if parent_rpcs.respond_to? :resume_model_deployment_monitoring_job
                  @resume_model_deployment_monitoring_job = ::Gapic::Config::Method.new resume_model_deployment_monitoring_job_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
