# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/featurestore_service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module AIPlatform
      module V1
        module FeaturestoreService
          ##
          # Client for the FeaturestoreService service.
          #
          # The service that handles CRUD and List for resources for Featurestore.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :featurestore_service_stub

            ##
            # Configure the FeaturestoreService Client class.
            #
            # See {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all FeaturestoreService clients
            #   ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the FeaturestoreService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @featurestore_service_stub.universe_domain
            end

            ##
            # Create a new FeaturestoreService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the FeaturestoreService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/aiplatform/v1/featurestore_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @featurestore_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @featurestore_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @featurestore_service_stub.endpoint
                config.universe_domain = @featurestore_service_stub.universe_domain
                config.logger = @featurestore_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @featurestore_service_stub.endpoint
                config.universe_domain = @featurestore_service_stub.universe_domain
                config.logger = @featurestore_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::AIPlatform::V1::FeaturestoreService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @featurestore_service_stub.logger
            end

            # Service calls

            ##
            # Creates a new Featurestore in a given project and location.
            #
            # @overload create_featurestore(request, options = nil)
            #   Pass arguments to `create_featurestore` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateFeaturestoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateFeaturestoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_featurestore(parent: nil, featurestore: nil, featurestore_id: nil)
            #   Pass arguments to `create_featurestore` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to create Featurestores.
            #     Format:
            #     `projects/{project}/locations/{location}`
            #   @param featurestore [::Google::Cloud::AIPlatform::V1::Featurestore, ::Hash]
            #     Required. The Featurestore to create.
            #   @param featurestore_id [::String]
            #     Required. The ID to use for this Featurestore, which will become the final
            #     component of the Featurestore's resource name.
            #
            #     This value may be up to 60 characters, and valid characters are
            #     `[a-z0-9_]`. The first character cannot be a number.
            #
            #     The value must be unique within the project and location.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateFeaturestoreRequest.new
            #
            #   # Call the create_featurestore method.
            #   result = client.create_featurestore request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_featurestore request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateFeaturestoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_featurestore.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_featurestore.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_featurestore.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :create_featurestore, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Featurestore.
            #
            # @overload get_featurestore(request, options = nil)
            #   Pass arguments to `get_featurestore` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetFeaturestoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetFeaturestoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_featurestore(name: nil)
            #   Pass arguments to `get_featurestore` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Featurestore resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Featurestore]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Featurestore]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetFeaturestoreRequest.new
            #
            #   # Call the get_featurestore method.
            #   result = client.get_featurestore request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Featurestore.
            #   p result
            #
            def get_featurestore request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetFeaturestoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_featurestore.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_featurestore.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_featurestore.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :get_featurestore, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Featurestores in a given project and location.
            #
            # @overload list_featurestores(request, options = nil)
            #   Pass arguments to `list_featurestores` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListFeaturestoresRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListFeaturestoresRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_featurestores(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil, read_mask: nil)
            #   Pass arguments to `list_featurestores` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to list Featurestores.
            #     Format:
            #     `projects/{project}/locations/{location}`
            #   @param filter [::String]
            #     Lists the featurestores that match the filter expression. The following
            #     fields are supported:
            #
            #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
            #     Values must be
            #       in RFC 3339 format.
            #     * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
            #     Values must be
            #       in RFC 3339 format.
            #     * `online_serving_config.fixed_node_count`: Supports `=`, `!=`, `<`, `>`,
            #     `<=`, and `>=` comparisons.
            #     * `labels`: Supports key-value equality and key presence.
            #
            #     Examples:
            #
            #     * `create_time > "2020-01-01" OR update_time > "2020-01-01"`
            #        Featurestores created or updated after 2020-01-01.
            #     * `labels.env = "prod"`
            #        Featurestores with label "env" set to "prod".
            #   @param page_size [::Integer]
            #     The maximum number of Featurestores to return. The service may return fewer
            #     than this value. If unspecified, at most 100 Featurestores will be
            #     returned. The maximum value is 100; any value greater than 100 will be
            #     coerced to 100.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_featurestores FeaturestoreService.ListFeaturestores}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_featurestores FeaturestoreService.ListFeaturestores}
            #     must match the call that provided the page token.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order by, sorted in ascending order.
            #     Use "desc" after a field name for descending.
            #     Supported Fields:
            #
            #       * `create_time`
            #       * `update_time`
            #       * `online_serving_config.fixed_node_count`
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Featurestore>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Featurestore>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListFeaturestoresRequest.new
            #
            #   # Call the list_featurestores method.
            #   result = client.list_featurestores request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Featurestore.
            #     p item
            #   end
            #
            def list_featurestores request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListFeaturestoresRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_featurestores.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_featurestores.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_featurestores.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :list_featurestores, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @featurestore_service_stub, :list_featurestores, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single Featurestore.
            #
            # @overload update_featurestore(request, options = nil)
            #   Pass arguments to `update_featurestore` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateFeaturestoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateFeaturestoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_featurestore(featurestore: nil, update_mask: nil)
            #   Pass arguments to `update_featurestore` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param featurestore [::Google::Cloud::AIPlatform::V1::Featurestore, ::Hash]
            #     Required. The Featurestore's `name` field is used to identify the
            #     Featurestore to be updated. Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Field mask is used to specify the fields to be overwritten in the
            #     Featurestore resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then only the non-empty fields present in the
            #     request will be overwritten. Set the update_mask to `*` to override all
            #     fields.
            #
            #     Updatable fields:
            #
            #       * `labels`
            #       * `online_serving_config.fixed_node_count`
            #       * `online_serving_config.scaling`
            #       * `online_storage_ttl_days`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateFeaturestoreRequest.new
            #
            #   # Call the update_featurestore method.
            #   result = client.update_featurestore request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_featurestore request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateFeaturestoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_featurestore.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.featurestore&.name
                header_params["featurestore.name"] = request.featurestore.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_featurestore.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_featurestore.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :update_featurestore, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Featurestore. The Featurestore must not contain any
            # EntityTypes or `force` must be set to true for the request to succeed.
            #
            # @overload delete_featurestore(request, options = nil)
            #   Pass arguments to `delete_featurestore` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteFeaturestoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteFeaturestoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_featurestore(name: nil, force: nil)
            #   Pass arguments to `delete_featurestore` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Featurestore to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}`
            #   @param force [::Boolean]
            #     If set to true, any EntityTypes and Features for this Featurestore will
            #     also be deleted. (Otherwise, the request will only work if the Featurestore
            #     has no EntityTypes.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteFeaturestoreRequest.new
            #
            #   # Call the delete_featurestore method.
            #   result = client.delete_featurestore request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_featurestore request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteFeaturestoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_featurestore.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_featurestore.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_featurestore.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :delete_featurestore, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new EntityType in a given Featurestore.
            #
            # @overload create_entity_type(request, options = nil)
            #   Pass arguments to `create_entity_type` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateEntityTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateEntityTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_entity_type(parent: nil, entity_type: nil, entity_type_id: nil)
            #   Pass arguments to `create_entity_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Featurestore to create EntityTypes.
            #     Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}`
            #   @param entity_type [::Google::Cloud::AIPlatform::V1::EntityType, ::Hash]
            #     The EntityType to create.
            #   @param entity_type_id [::String]
            #     Required. The ID to use for the EntityType, which will become the final
            #     component of the EntityType's resource name.
            #
            #     This value may be up to 60 characters, and valid characters are
            #     `[a-z0-9_]`. The first character cannot be a number.
            #
            #     The value must be unique within a featurestore.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateEntityTypeRequest.new
            #
            #   # Call the create_entity_type method.
            #   result = client.create_entity_type request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_entity_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateEntityTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_entity_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_entity_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_entity_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :create_entity_type, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single EntityType.
            #
            # @overload get_entity_type(request, options = nil)
            #   Pass arguments to `get_entity_type` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetEntityTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetEntityTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_entity_type(name: nil)
            #   Pass arguments to `get_entity_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the EntityType resource.
            #     Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::EntityType]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::EntityType]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetEntityTypeRequest.new
            #
            #   # Call the get_entity_type method.
            #   result = client.get_entity_type request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::EntityType.
            #   p result
            #
            def get_entity_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetEntityTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_entity_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_entity_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_entity_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :get_entity_type, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists EntityTypes in a given Featurestore.
            #
            # @overload list_entity_types(request, options = nil)
            #   Pass arguments to `list_entity_types` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListEntityTypesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListEntityTypesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_entity_types(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil, read_mask: nil)
            #   Pass arguments to `list_entity_types` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Featurestore to list EntityTypes.
            #     Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}`
            #   @param filter [::String]
            #     Lists the EntityTypes that match the filter expression. The following
            #     filters are supported:
            #
            #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
            #     Values must be in RFC 3339 format.
            #     * `update_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
            #     Values must be in RFC 3339 format.
            #     * `labels`: Supports key-value equality as well as key presence.
            #
            #     Examples:
            #
            #     * `create_time > \"2020-01-31T15:30:00.000000Z\" OR
            #          update_time > \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created
            #          or updated after 2020-01-31T15:30:00.000000Z.
            #     * `labels.active = yes AND labels.env = prod` --> EntityTypes having both
            #         (active: yes) and (env: prod) labels.
            #     * `labels.env: *` --> Any EntityType which has a label with 'env' as the
            #       key.
            #   @param page_size [::Integer]
            #     The maximum number of EntityTypes to return. The service may return fewer
            #     than this value. If unspecified, at most 1000 EntityTypes will be returned.
            #     The maximum value is 1000; any value greater than 1000 will be coerced to
            #     1000.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_entity_types FeaturestoreService.ListEntityTypes}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_entity_types FeaturestoreService.ListEntityTypes}
            #     must match the call that provided the page token.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order by, sorted in ascending order.
            #     Use "desc" after a field name for descending.
            #
            #     Supported fields:
            #
            #       * `entity_type_id`
            #       * `create_time`
            #       * `update_time`
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::EntityType>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::EntityType>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListEntityTypesRequest.new
            #
            #   # Call the list_entity_types method.
            #   result = client.list_entity_types request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::EntityType.
            #     p item
            #   end
            #
            def list_entity_types request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListEntityTypesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_entity_types.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_entity_types.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_entity_types.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :list_entity_types, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @featurestore_service_stub, :list_entity_types, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single EntityType.
            #
            # @overload update_entity_type(request, options = nil)
            #   Pass arguments to `update_entity_type` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateEntityTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateEntityTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_entity_type(entity_type: nil, update_mask: nil)
            #   Pass arguments to `update_entity_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param entity_type [::Google::Cloud::AIPlatform::V1::EntityType, ::Hash]
            #     Required. The EntityType's `name` field is used to identify the EntityType
            #     to be updated. Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Field mask is used to specify the fields to be overwritten in the
            #     EntityType resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then only the non-empty fields present in the
            #     request will be overwritten. Set the update_mask to `*` to override all
            #     fields.
            #
            #     Updatable fields:
            #
            #       * `description`
            #       * `labels`
            #       * `monitoring_config.snapshot_analysis.disabled`
            #       * `monitoring_config.snapshot_analysis.monitoring_interval_days`
            #       * `monitoring_config.snapshot_analysis.staleness_days`
            #       * `monitoring_config.import_features_analysis.state`
            #       * `monitoring_config.import_features_analysis.anomaly_detection_baseline`
            #       * `monitoring_config.numerical_threshold_config.value`
            #       * `monitoring_config.categorical_threshold_config.value`
            #       * `offline_storage_ttl_days`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::EntityType]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::EntityType]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateEntityTypeRequest.new
            #
            #   # Call the update_entity_type method.
            #   result = client.update_entity_type request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::EntityType.
            #   p result
            #
            def update_entity_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateEntityTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_entity_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.entity_type&.name
                header_params["entity_type.name"] = request.entity_type.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_entity_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_entity_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :update_entity_type, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single EntityType. The EntityType must not have any Features
            # or `force` must be set to true for the request to succeed.
            #
            # @overload delete_entity_type(request, options = nil)
            #   Pass arguments to `delete_entity_type` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteEntityTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteEntityTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_entity_type(name: nil, force: nil)
            #   Pass arguments to `delete_entity_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the EntityType to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
            #   @param force [::Boolean]
            #     If set to true, any Features for this EntityType will also be deleted.
            #     (Otherwise, the request will only work if the EntityType has no Features.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteEntityTypeRequest.new
            #
            #   # Call the delete_entity_type method.
            #   result = client.delete_entity_type request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_entity_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteEntityTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_entity_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_entity_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_entity_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :delete_entity_type, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Feature in a given EntityType.
            #
            # @overload create_feature(request, options = nil)
            #   Pass arguments to `create_feature` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateFeatureRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateFeatureRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_feature(parent: nil, feature: nil, feature_id: nil)
            #   Pass arguments to `create_feature` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the EntityType or FeatureGroup to create a
            #     Feature. Format for entity_type as parent:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
            #     Format for feature_group as parent:
            #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
            #   @param feature [::Google::Cloud::AIPlatform::V1::Feature, ::Hash]
            #     Required. The Feature to create.
            #   @param feature_id [::String]
            #     Required. The ID to use for the Feature, which will become the final
            #     component of the Feature's resource name.
            #
            #     This value may be up to 128 characters, and valid characters are
            #     `[a-z0-9_]`. The first character cannot be a number.
            #
            #     The value must be unique within an EntityType/FeatureGroup.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateFeatureRequest.new
            #
            #   # Call the create_feature method.
            #   result = client.create_feature request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_feature request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateFeatureRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_feature.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_feature.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_feature.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :create_feature, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a batch of Features in a given EntityType.
            #
            # @overload batch_create_features(request, options = nil)
            #   Pass arguments to `batch_create_features` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::BatchCreateFeaturesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::BatchCreateFeaturesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_create_features(parent: nil, requests: nil)
            #   Pass arguments to `batch_create_features` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the EntityType/FeatureGroup to create the
            #     batch of Features under. Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
            #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
            #   @param requests [::Array<::Google::Cloud::AIPlatform::V1::CreateFeatureRequest, ::Hash>]
            #     Required. The request message specifying the Features to create. All
            #     Features must be created under the same parent EntityType / FeatureGroup.
            #     The `parent` field in each child request message can be omitted. If
            #     `parent` is set in a child request, then the value must match the `parent`
            #     value in this request message.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::BatchCreateFeaturesRequest.new
            #
            #   # Call the batch_create_features method.
            #   result = client.batch_create_features request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def batch_create_features request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::BatchCreateFeaturesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_create_features.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_create_features.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_create_features.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :batch_create_features, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Feature.
            #
            # @overload get_feature(request, options = nil)
            #   Pass arguments to `get_feature` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetFeatureRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetFeatureRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_feature(name: nil)
            #   Pass arguments to `get_feature` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Feature resource.
            #     Format for entity_type as parent:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
            #     Format for feature_group as parent:
            #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Feature]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Feature]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetFeatureRequest.new
            #
            #   # Call the get_feature method.
            #   result = client.get_feature request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Feature.
            #   p result
            #
            def get_feature request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetFeatureRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_feature.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_feature.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_feature.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :get_feature, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Features in a given EntityType.
            #
            # @overload list_features(request, options = nil)
            #   Pass arguments to `list_features` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListFeaturesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListFeaturesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_features(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil, read_mask: nil, latest_stats_count: nil)
            #   Pass arguments to `list_features` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to list Features.
            #     Format for entity_type as parent:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
            #     Format for feature_group as parent:
            #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
            #   @param filter [::String]
            #     Lists the Features that match the filter expression. The following
            #     filters are supported:
            #
            #     * `value_type`: Supports = and != comparisons.
            #     * `create_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
            #     be in RFC 3339 format.
            #     * `update_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
            #     be in RFC 3339 format.
            #     * `labels`: Supports key-value equality as well as key presence.
            #
            #     Examples:
            #
            #     * `value_type = DOUBLE` --> Features whose type is DOUBLE.
            #     * `create_time > \"2020-01-31T15:30:00.000000Z\" OR
            #          update_time > \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created
            #          or updated after 2020-01-31T15:30:00.000000Z.
            #     * `labels.active = yes AND labels.env = prod` --> Features having both
            #         (active: yes) and (env: prod) labels.
            #     * `labels.env: *` --> Any Feature which has a label with 'env' as the
            #       key.
            #   @param page_size [::Integer]
            #     The maximum number of Features to return. The service may return fewer
            #     than this value. If unspecified, at most 1000 Features will be returned.
            #     The maximum value is 1000; any value greater than 1000 will be coerced to
            #     1000.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_features FeaturestoreService.ListFeatures}
            #     call or
            #     {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#list_features FeatureRegistryService.ListFeatures}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_features FeaturestoreService.ListFeatures}
            #     or
            #     {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#list_features FeatureRegistryService.ListFeatures}
            #     must match the call that provided the page token.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order by, sorted in ascending order.
            #     Use "desc" after a field name for descending.
            #     Supported fields:
            #
            #       * `feature_id`
            #       * `value_type` (Not supported for FeatureRegistry Feature)
            #       * `create_time`
            #       * `update_time`
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read.
            #   @param latest_stats_count [::Integer]
            #     Only applicable for Vertex AI Feature Store (Legacy).
            #     If set, return the most recent
            #     {::Google::Cloud::AIPlatform::V1::ListFeaturesRequest#latest_stats_count ListFeaturesRequest.latest_stats_count}
            #     of stats for each Feature in response. Valid value is [0, 10]. If number of
            #     stats exists <
            #     {::Google::Cloud::AIPlatform::V1::ListFeaturesRequest#latest_stats_count ListFeaturesRequest.latest_stats_count},
            #     return all existing stats.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Feature>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Feature>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListFeaturesRequest.new
            #
            #   # Call the list_features method.
            #   result = client.list_features request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Feature.
            #     p item
            #   end
            #
            def list_features request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListFeaturesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_features.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_features.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_features.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :list_features, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @featurestore_service_stub, :list_features, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single Feature.
            #
            # @overload update_feature(request, options = nil)
            #   Pass arguments to `update_feature` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateFeatureRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateFeatureRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_feature(feature: nil, update_mask: nil)
            #   Pass arguments to `update_feature` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param feature [::Google::Cloud::AIPlatform::V1::Feature, ::Hash]
            #     Required. The Feature's `name` field is used to identify the Feature to be
            #     updated.
            #     Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
            #     `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Field mask is used to specify the fields to be overwritten in the
            #     Features resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then only the non-empty fields present in the
            #     request will be overwritten. Set the update_mask to `*` to override all
            #     fields.
            #
            #     Updatable fields:
            #
            #       * `description`
            #       * `labels`
            #       * `disable_monitoring` (Not supported for FeatureRegistryService Feature)
            #       * `point_of_contact` (Not supported for FeaturestoreService FeatureStore)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Feature]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Feature]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateFeatureRequest.new
            #
            #   # Call the update_feature method.
            #   result = client.update_feature request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Feature.
            #   p result
            #
            def update_feature request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateFeatureRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_feature.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.feature&.name
                header_params["feature.name"] = request.feature.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_feature.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_feature.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :update_feature, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Feature.
            #
            # @overload delete_feature(request, options = nil)
            #   Pass arguments to `delete_feature` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteFeatureRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteFeatureRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_feature(name: nil)
            #   Pass arguments to `delete_feature` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Features to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
            #     `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteFeatureRequest.new
            #
            #   # Call the delete_feature method.
            #   result = client.delete_feature request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_feature request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteFeatureRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_feature.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_feature.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_feature.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :delete_feature, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Imports Feature values into the Featurestore from a source storage.
            #
            # The progress of the import is tracked by the returned operation. The
            # imported features are guaranteed to be visible to subsequent read
            # operations after the operation is marked as successfully done.
            #
            # If an import operation fails, the Feature values returned from
            # reads and exports may be inconsistent. If consistency is
            # required, the caller must retry the same import request again and wait till
            # the new operation returned is marked as successfully done.
            #
            # There are also scenarios where the caller can cause inconsistency.
            #
            #  - Source data for import contains multiple distinct Feature values for
            #    the same entity ID and timestamp.
            #  - Source is modified during an import. This includes adding, updating, or
            #  removing source data and/or metadata. Examples of updating metadata
            #  include but are not limited to changing storage location, storage class,
            #  or retention policy.
            #  - Online serving cluster is under-provisioned.
            #
            # @overload import_feature_values(request, options = nil)
            #   Pass arguments to `import_feature_values` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ImportFeatureValuesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ImportFeatureValuesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload import_feature_values(avro_source: nil, bigquery_source: nil, csv_source: nil, feature_time_field: nil, feature_time: nil, entity_type: nil, entity_id_field: nil, feature_specs: nil, disable_online_serving: nil, worker_count: nil, disable_ingestion_analysis: nil)
            #   Pass arguments to `import_feature_values` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param avro_source [::Google::Cloud::AIPlatform::V1::AvroSource, ::Hash]
            #     Note: The following parameters are mutually exclusive: `avro_source`, `bigquery_source`, `csv_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param bigquery_source [::Google::Cloud::AIPlatform::V1::BigQuerySource, ::Hash]
            #     Note: The following parameters are mutually exclusive: `bigquery_source`, `avro_source`, `csv_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param csv_source [::Google::Cloud::AIPlatform::V1::CsvSource, ::Hash]
            #     Note: The following parameters are mutually exclusive: `csv_source`, `avro_source`, `bigquery_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param feature_time_field [::String]
            #     Source column that holds the Feature timestamp for all Feature
            #     values in each entity.
            #
            #     Note: The following parameters are mutually exclusive: `feature_time_field`, `feature_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param feature_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Single Feature timestamp for all entities being imported. The
            #     timestamp must not have higher than millisecond precision.
            #
            #     Note: The following parameters are mutually exclusive: `feature_time`, `feature_time_field`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param entity_type [::String]
            #     Required. The resource name of the EntityType grouping the Features for
            #     which values are being imported. Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
            #   @param entity_id_field [::String]
            #     Source column that holds entity IDs. If not provided, entity IDs are
            #     extracted from the column named entity_id.
            #   @param feature_specs [::Array<::Google::Cloud::AIPlatform::V1::ImportFeatureValuesRequest::FeatureSpec, ::Hash>]
            #     Required. Specifications defining which Feature values to import from the
            #     entity. The request fails if no feature_specs are provided, and having
            #     multiple feature_specs for one Feature is not allowed.
            #   @param disable_online_serving [::Boolean]
            #     If set, data will not be imported for online serving. This
            #     is typically used for backfilling, where Feature generation timestamps are
            #     not in the timestamp range needed for online serving.
            #   @param worker_count [::Integer]
            #     Specifies the number of workers that are used to write data to the
            #     Featurestore. Consider the online serving capacity that you require to
            #     achieve the desired import throughput without interfering with online
            #     serving. The value must be positive, and less than or equal to 100.
            #     If not set, defaults to using 1 worker. The low count ensures minimal
            #     impact on online serving performance.
            #   @param disable_ingestion_analysis [::Boolean]
            #     If true, API doesn't start ingestion analysis pipeline.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ImportFeatureValuesRequest.new
            #
            #   # Call the import_feature_values method.
            #   result = client.import_feature_values request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def import_feature_values request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ImportFeatureValuesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.import_feature_values.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.entity_type
                header_params["entity_type"] = request.entity_type
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.import_feature_values.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.import_feature_values.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :import_feature_values, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Batch reads Feature values from a Featurestore.
            #
            # This API enables batch reading Feature values, where each read
            # instance in the batch may read Feature values of entities from one or
            # more EntityTypes. Point-in-time correctness is guaranteed for Feature
            # values of each read instance as of each instance's read timestamp.
            #
            # @overload batch_read_feature_values(request, options = nil)
            #   Pass arguments to `batch_read_feature_values` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_read_feature_values(csv_read_instances: nil, bigquery_read_instances: nil, featurestore: nil, destination: nil, pass_through_fields: nil, entity_type_specs: nil, start_time: nil)
            #   Pass arguments to `batch_read_feature_values` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param csv_read_instances [::Google::Cloud::AIPlatform::V1::CsvSource, ::Hash]
            #     Each read instance consists of exactly one read timestamp and one or more
            #     entity IDs identifying entities of the corresponding EntityTypes whose
            #     Features are requested.
            #
            #     Each output instance contains Feature values of requested entities
            #     concatenated together as of the read time.
            #
            #     An example read instance may be `foo_entity_id, bar_entity_id,
            #     2020-01-01T10:00:00.123Z`.
            #
            #     An example output instance may be `foo_entity_id, bar_entity_id,
            #     2020-01-01T10:00:00.123Z, foo_entity_feature1_value,
            #     bar_entity_feature2_value`.
            #
            #     Timestamp in each read instance must be millisecond-aligned.
            #
            #     `csv_read_instances` are read instances stored in a plain-text CSV file.
            #     The header should be:
            #         [ENTITY_TYPE_ID1], [ENTITY_TYPE_ID2], ..., timestamp
            #
            #     The columns can be in any order.
            #
            #     Values in the timestamp column must use the RFC 3339 format, e.g.
            #     `2012-07-30T10:43:17.123Z`.
            #
            #     Note: The following parameters are mutually exclusive: `csv_read_instances`, `bigquery_read_instances`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param bigquery_read_instances [::Google::Cloud::AIPlatform::V1::BigQuerySource, ::Hash]
            #     Similar to csv_read_instances, but from BigQuery source.
            #
            #     Note: The following parameters are mutually exclusive: `bigquery_read_instances`, `csv_read_instances`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param featurestore [::String]
            #     Required. The resource name of the Featurestore from which to query Feature
            #     values. Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}`
            #   @param destination [::Google::Cloud::AIPlatform::V1::FeatureValueDestination, ::Hash]
            #     Required. Specifies output location and format.
            #   @param pass_through_fields [::Array<::Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest::PassThroughField, ::Hash>]
            #     When not empty, the specified fields in the *_read_instances source will be
            #     joined as-is in the output, in addition to those fields from the
            #     Featurestore Entity.
            #
            #     For BigQuery source, the type of the pass-through values will be
            #     automatically inferred. For CSV source, the pass-through values will be
            #     passed as opaque bytes.
            #   @param entity_type_specs [::Array<::Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest::EntityTypeSpec, ::Hash>]
            #     Required. Specifies EntityType grouping Features to read values of and
            #     settings.
            #   @param start_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Optional. Excludes Feature values with feature generation timestamp before
            #     this timestamp. If not set, retrieve oldest values kept in Feature Store.
            #     Timestamp, if present, must not have higher than millisecond precision.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest.new
            #
            #   # Call the batch_read_feature_values method.
            #   result = client.batch_read_feature_values request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def batch_read_feature_values request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_read_feature_values.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.featurestore
                header_params["featurestore"] = request.featurestore
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_read_feature_values.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_read_feature_values.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :batch_read_feature_values, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Exports Feature values from all the entities of a target EntityType.
            #
            # @overload export_feature_values(request, options = nil)
            #   Pass arguments to `export_feature_values` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ExportFeatureValuesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ExportFeatureValuesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload export_feature_values(snapshot_export: nil, full_export: nil, entity_type: nil, destination: nil, feature_selector: nil, settings: nil)
            #   Pass arguments to `export_feature_values` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param snapshot_export [::Google::Cloud::AIPlatform::V1::ExportFeatureValuesRequest::SnapshotExport, ::Hash]
            #     Exports the latest Feature values of all entities of the EntityType
            #     within a time range.
            #
            #     Note: The following parameters are mutually exclusive: `snapshot_export`, `full_export`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param full_export [::Google::Cloud::AIPlatform::V1::ExportFeatureValuesRequest::FullExport, ::Hash]
            #     Exports all historical values of all entities of the EntityType within a
            #     time range
            #
            #     Note: The following parameters are mutually exclusive: `full_export`, `snapshot_export`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param entity_type [::String]
            #     Required. The resource name of the EntityType from which to export Feature
            #     values. Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
            #   @param destination [::Google::Cloud::AIPlatform::V1::FeatureValueDestination, ::Hash]
            #     Required. Specifies destination location and format.
            #   @param feature_selector [::Google::Cloud::AIPlatform::V1::FeatureSelector, ::Hash]
            #     Required. Selects Features to export values of.
            #   @param settings [::Array<::Google::Cloud::AIPlatform::V1::DestinationFeatureSetting, ::Hash>]
            #     Per-Feature export settings.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ExportFeatureValuesRequest.new
            #
            #   # Call the export_feature_values method.
            #   result = client.export_feature_values request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def export_feature_values request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ExportFeatureValuesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.export_feature_values.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.entity_type
                header_params["entity_type"] = request.entity_type
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.export_feature_values.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.export_feature_values.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :export_feature_values, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete Feature values from Featurestore.
            #
            # The progress of the deletion is tracked by the returned operation. The
            # deleted feature values are guaranteed to be invisible to subsequent read
            # operations after the operation is marked as successfully done.
            #
            # If a delete feature values operation fails, the feature values
            # returned from reads and exports may be inconsistent. If consistency is
            # required, the caller must retry the same delete request again and wait till
            # the new operation returned is marked as successfully done.
            #
            # @overload delete_feature_values(request, options = nil)
            #   Pass arguments to `delete_feature_values` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_feature_values(select_entity: nil, select_time_range_and_feature: nil, entity_type: nil)
            #   Pass arguments to `delete_feature_values` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param select_entity [::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesRequest::SelectEntity, ::Hash]
            #     Select feature values to be deleted by specifying entities.
            #
            #     Note: The following parameters are mutually exclusive: `select_entity`, `select_time_range_and_feature`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param select_time_range_and_feature [::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesRequest::SelectTimeRangeAndFeature, ::Hash]
            #     Select feature values to be deleted by specifying time range and
            #     features.
            #
            #     Note: The following parameters are mutually exclusive: `select_time_range_and_feature`, `select_entity`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param entity_type [::String]
            #     Required. The resource name of the EntityType grouping the Features for
            #     which values are being deleted from. Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteFeatureValuesRequest.new
            #
            #   # Call the delete_feature_values method.
            #   result = client.delete_feature_values request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_feature_values request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_feature_values.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.entity_type
                header_params["entity_type"] = request.entity_type
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_feature_values.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_feature_values.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :delete_feature_values, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Searches Features matching a query in a given project.
            #
            # @overload search_features(request, options = nil)
            #   Pass arguments to `search_features` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::SearchFeaturesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::SearchFeaturesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_features(location: nil, query: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `search_features` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param location [::String]
            #     Required. The resource name of the Location to search Features.
            #     Format:
            #     `projects/{project}/locations/{location}`
            #   @param query [::String]
            #     Query string that is a conjunction of field-restricted queries and/or
            #     field-restricted filters.  Field-restricted queries and filters can be
            #     combined using `AND` to form a conjunction.
            #
            #     A field query is in the form FIELD:QUERY. This implicitly checks if QUERY
            #     exists as a substring within Feature's FIELD. The QUERY
            #     and the FIELD are converted to a sequence of words (i.e. tokens) for
            #     comparison. This is done by:
            #
            #       * Removing leading/trailing whitespace and tokenizing the search value.
            #       Characters that are not one of alphanumeric `[a-zA-Z0-9]`, underscore
            #       `_`, or asterisk `*` are treated as delimiters for tokens. `*` is treated
            #       as a wildcard that matches characters within a token.
            #       * Ignoring case.
            #       * Prepending an asterisk to the first and appending an asterisk to the
            #       last token in QUERY.
            #
            #     A QUERY must be either a singular token or a phrase. A phrase is one or
            #     multiple words enclosed in double quotation marks ("). With phrases, the
            #     order of the words is important. Words in the phrase must be matching in
            #     order and consecutively.
            #
            #     Supported FIELDs for field-restricted queries:
            #
            #     * `feature_id`
            #     * `description`
            #     * `entity_type_id`
            #
            #     Examples:
            #
            #     * `feature_id: foo` --> Matches a Feature with ID containing the substring
            #     `foo` (eg. `foo`, `foofeature`, `barfoo`).
            #     * `feature_id: foo*feature` --> Matches a Feature with ID containing the
            #     substring `foo*feature` (eg. `foobarfeature`).
            #     * `feature_id: foo AND description: bar` --> Matches a Feature with ID
            #     containing the substring `foo` and description containing the substring
            #     `bar`.
            #
            #     Besides field queries, the following exact-match filters are
            #     supported. The exact-match filters do not support wildcards. Unlike
            #     field-restricted queries, exact-match filters are case-sensitive.
            #
            #     * `feature_id`: Supports = comparisons.
            #     * `description`: Supports = comparisons. Multi-token filters should be
            #     enclosed in quotes.
            #     * `entity_type_id`: Supports = comparisons.
            #     * `value_type`: Supports = and != comparisons.
            #     * `labels`: Supports key-value equality as well as key presence.
            #     * `featurestore_id`: Supports = comparisons.
            #
            #     Examples:
            #
            #     * `description = "foo bar"` --> Any Feature with description exactly equal
            #     to `foo bar`
            #     * `value_type = DOUBLE` --> Features whose type is DOUBLE.
            #     * `labels.active = yes AND labels.env = prod` --> Features having both
            #         (active: yes) and (env: prod) labels.
            #     * `labels.env: *` --> Any Feature which has a label with `env` as the
            #       key.
            #   @param page_size [::Integer]
            #     The maximum number of Features to return. The service may return fewer
            #     than this value. If unspecified, at most 100 Features will be returned.
            #     The maximum value is 100; any value greater than 100 will be coerced to
            #     100.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#search_features FeaturestoreService.SearchFeatures}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#search_features FeaturestoreService.SearchFeatures},
            #     except `page_size`, must match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Feature>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Feature>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::SearchFeaturesRequest.new
            #
            #   # Call the search_features method.
            #   result = client.search_features request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Feature.
            #     p item
            #   end
            #
            def search_features request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::SearchFeaturesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_features.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.location
                header_params["location"] = request.location
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_features.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_features.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @featurestore_service_stub.call_rpc :search_features, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @featurestore_service_stub, :search_features, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the FeaturestoreService API.
            #
            # This class represents the configuration for FeaturestoreService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_featurestore to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_featurestore.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_featurestore.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the FeaturestoreService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_featurestore`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_featurestore
                ##
                # RPC-specific configuration for `get_featurestore`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_featurestore
                ##
                # RPC-specific configuration for `list_featurestores`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_featurestores
                ##
                # RPC-specific configuration for `update_featurestore`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_featurestore
                ##
                # RPC-specific configuration for `delete_featurestore`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_featurestore
                ##
                # RPC-specific configuration for `create_entity_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_entity_type
                ##
                # RPC-specific configuration for `get_entity_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_entity_type
                ##
                # RPC-specific configuration for `list_entity_types`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_entity_types
                ##
                # RPC-specific configuration for `update_entity_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_entity_type
                ##
                # RPC-specific configuration for `delete_entity_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_entity_type
                ##
                # RPC-specific configuration for `create_feature`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_feature
                ##
                # RPC-specific configuration for `batch_create_features`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_create_features
                ##
                # RPC-specific configuration for `get_feature`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_feature
                ##
                # RPC-specific configuration for `list_features`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_features
                ##
                # RPC-specific configuration for `update_feature`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_feature
                ##
                # RPC-specific configuration for `delete_feature`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_feature
                ##
                # RPC-specific configuration for `import_feature_values`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :import_feature_values
                ##
                # RPC-specific configuration for `batch_read_feature_values`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_read_feature_values
                ##
                # RPC-specific configuration for `export_feature_values`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :export_feature_values
                ##
                # RPC-specific configuration for `delete_feature_values`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_feature_values
                ##
                # RPC-specific configuration for `search_features`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_features

                # @private
                def initialize parent_rpcs = nil
                  create_featurestore_config = parent_rpcs.create_featurestore if parent_rpcs.respond_to? :create_featurestore
                  @create_featurestore = ::Gapic::Config::Method.new create_featurestore_config
                  get_featurestore_config = parent_rpcs.get_featurestore if parent_rpcs.respond_to? :get_featurestore
                  @get_featurestore = ::Gapic::Config::Method.new get_featurestore_config
                  list_featurestores_config = parent_rpcs.list_featurestores if parent_rpcs.respond_to? :list_featurestores
                  @list_featurestores = ::Gapic::Config::Method.new list_featurestores_config
                  update_featurestore_config = parent_rpcs.update_featurestore if parent_rpcs.respond_to? :update_featurestore
                  @update_featurestore = ::Gapic::Config::Method.new update_featurestore_config
                  delete_featurestore_config = parent_rpcs.delete_featurestore if parent_rpcs.respond_to? :delete_featurestore
                  @delete_featurestore = ::Gapic::Config::Method.new delete_featurestore_config
                  create_entity_type_config = parent_rpcs.create_entity_type if parent_rpcs.respond_to? :create_entity_type
                  @create_entity_type = ::Gapic::Config::Method.new create_entity_type_config
                  get_entity_type_config = parent_rpcs.get_entity_type if parent_rpcs.respond_to? :get_entity_type
                  @get_entity_type = ::Gapic::Config::Method.new get_entity_type_config
                  list_entity_types_config = parent_rpcs.list_entity_types if parent_rpcs.respond_to? :list_entity_types
                  @list_entity_types = ::Gapic::Config::Method.new list_entity_types_config
                  update_entity_type_config = parent_rpcs.update_entity_type if parent_rpcs.respond_to? :update_entity_type
                  @update_entity_type = ::Gapic::Config::Method.new update_entity_type_config
                  delete_entity_type_config = parent_rpcs.delete_entity_type if parent_rpcs.respond_to? :delete_entity_type
                  @delete_entity_type = ::Gapic::Config::Method.new delete_entity_type_config
                  create_feature_config = parent_rpcs.create_feature if parent_rpcs.respond_to? :create_feature
                  @create_feature = ::Gapic::Config::Method.new create_feature_config
                  batch_create_features_config = parent_rpcs.batch_create_features if parent_rpcs.respond_to? :batch_create_features
                  @batch_create_features = ::Gapic::Config::Method.new batch_create_features_config
                  get_feature_config = parent_rpcs.get_feature if parent_rpcs.respond_to? :get_feature
                  @get_feature = ::Gapic::Config::Method.new get_feature_config
                  list_features_config = parent_rpcs.list_features if parent_rpcs.respond_to? :list_features
                  @list_features = ::Gapic::Config::Method.new list_features_config
                  update_feature_config = parent_rpcs.update_feature if parent_rpcs.respond_to? :update_feature
                  @update_feature = ::Gapic::Config::Method.new update_feature_config
                  delete_feature_config = parent_rpcs.delete_feature if parent_rpcs.respond_to? :delete_feature
                  @delete_feature = ::Gapic::Config::Method.new delete_feature_config
                  import_feature_values_config = parent_rpcs.import_feature_values if parent_rpcs.respond_to? :import_feature_values
                  @import_feature_values = ::Gapic::Config::Method.new import_feature_values_config
                  batch_read_feature_values_config = parent_rpcs.batch_read_feature_values if parent_rpcs.respond_to? :batch_read_feature_values
                  @batch_read_feature_values = ::Gapic::Config::Method.new batch_read_feature_values_config
                  export_feature_values_config = parent_rpcs.export_feature_values if parent_rpcs.respond_to? :export_feature_values
                  @export_feature_values = ::Gapic::Config::Method.new export_feature_values_config
                  delete_feature_values_config = parent_rpcs.delete_feature_values if parent_rpcs.respond_to? :delete_feature_values
                  @delete_feature_values = ::Gapic::Config::Method.new delete_feature_values_config
                  search_features_config = parent_rpcs.search_features if parent_rpcs.respond_to? :search_features
                  @search_features = ::Gapic::Config::Method.new search_features_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
