# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/feature_registry_service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module AIPlatform
      module V1
        module FeatureRegistryService
          ##
          # Client for the FeatureRegistryService service.
          #
          # The service that handles CRUD and List for resources for
          # FeatureRegistry.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :feature_registry_service_stub

            ##
            # Configure the FeatureRegistryService Client class.
            #
            # See {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all FeatureRegistryService clients
            #   ::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the FeatureRegistryService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @feature_registry_service_stub.universe_domain
            end

            ##
            # Create a new FeatureRegistryService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the FeatureRegistryService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/aiplatform/v1/feature_registry_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @feature_registry_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @feature_registry_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @feature_registry_service_stub.endpoint
                config.universe_domain = @feature_registry_service_stub.universe_domain
                config.logger = @feature_registry_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @feature_registry_service_stub.endpoint
                config.universe_domain = @feature_registry_service_stub.universe_domain
                config.logger = @feature_registry_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @feature_registry_service_stub.logger
            end

            # Service calls

            ##
            # Creates a new FeatureGroup in a given project and location.
            #
            # @overload create_feature_group(request, options = nil)
            #   Pass arguments to `create_feature_group` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateFeatureGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateFeatureGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_feature_group(parent: nil, feature_group: nil, feature_group_id: nil)
            #   Pass arguments to `create_feature_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to create FeatureGroups.
            #     Format:
            #     `projects/{project}/locations/{location}`
            #   @param feature_group [::Google::Cloud::AIPlatform::V1::FeatureGroup, ::Hash]
            #     Required. The FeatureGroup to create.
            #   @param feature_group_id [::String]
            #     Required. The ID to use for this FeatureGroup, which will become the final
            #     component of the FeatureGroup's resource name.
            #
            #     This value may be up to 128 characters, and valid characters are
            #     `[a-z0-9_]`. The first character cannot be a number.
            #
            #     The value must be unique within the project and location.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateFeatureGroupRequest.new
            #
            #   # Call the create_feature_group method.
            #   result = client.create_feature_group request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_feature_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateFeatureGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_feature_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_feature_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_feature_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_registry_service_stub.call_rpc :create_feature_group, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single FeatureGroup.
            #
            # @overload get_feature_group(request, options = nil)
            #   Pass arguments to `get_feature_group` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetFeatureGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetFeatureGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_feature_group(name: nil)
            #   Pass arguments to `get_feature_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the FeatureGroup resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::FeatureGroup]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::FeatureGroup]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetFeatureGroupRequest.new
            #
            #   # Call the get_feature_group method.
            #   result = client.get_feature_group request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::FeatureGroup.
            #   p result
            #
            def get_feature_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetFeatureGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_feature_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_feature_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_feature_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_registry_service_stub.call_rpc :get_feature_group, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists FeatureGroups in a given project and location.
            #
            # @overload list_feature_groups(request, options = nil)
            #   Pass arguments to `list_feature_groups` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListFeatureGroupsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListFeatureGroupsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_feature_groups(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil)
            #   Pass arguments to `list_feature_groups` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to list FeatureGroups.
            #     Format:
            #     `projects/{project}/locations/{location}`
            #   @param filter [::String]
            #     Lists the FeatureGroups that match the filter expression. The
            #     following fields are supported:
            #
            #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
            #     Values must be
            #       in RFC 3339 format.
            #     * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
            #     Values must be
            #       in RFC 3339 format.
            #     * `labels`: Supports key-value equality and key presence.
            #
            #     Examples:
            #
            #     * `create_time > "2020-01-01" OR update_time > "2020-01-01"`
            #        FeatureGroups created or updated after 2020-01-01.
            #     * `labels.env = "prod"`
            #        FeatureGroups with label "env" set to "prod".
            #   @param page_size [::Integer]
            #     The maximum number of FeatureGroups to return. The service may return
            #     fewer than this value. If unspecified, at most 100 FeatureGroups will
            #     be returned. The maximum value is 100; any value greater than 100 will be
            #     coerced to 100.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#list_feature_groups FeatureRegistryService.ListFeatureGroups}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#list_feature_groups FeatureRegistryService.ListFeatureGroups}
            #     must match the call that provided the page token.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order by, sorted in ascending order.
            #     Use "desc" after a field name for descending.
            #     Supported Fields:
            #
            #       * `create_time`
            #       * `update_time`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::FeatureGroup>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::FeatureGroup>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListFeatureGroupsRequest.new
            #
            #   # Call the list_feature_groups method.
            #   result = client.list_feature_groups request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::FeatureGroup.
            #     p item
            #   end
            #
            def list_feature_groups request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListFeatureGroupsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_feature_groups.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_feature_groups.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_feature_groups.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_registry_service_stub.call_rpc :list_feature_groups, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @feature_registry_service_stub, :list_feature_groups, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single FeatureGroup.
            #
            # @overload update_feature_group(request, options = nil)
            #   Pass arguments to `update_feature_group` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateFeatureGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateFeatureGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_feature_group(feature_group: nil, update_mask: nil)
            #   Pass arguments to `update_feature_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param feature_group [::Google::Cloud::AIPlatform::V1::FeatureGroup, ::Hash]
            #     Required. The FeatureGroup's `name` field is used to identify the
            #     FeatureGroup to be updated. Format:
            #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Field mask is used to specify the fields to be overwritten in the
            #     FeatureGroup resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then only the non-empty fields present in the
            #     request will be overwritten. Set the update_mask to `*` to override all
            #     fields.
            #
            #     Updatable fields:
            #
            #       * `labels`
            #       * `description`
            #       * `big_query`
            #       * `big_query.entity_id_columns`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateFeatureGroupRequest.new
            #
            #   # Call the update_feature_group method.
            #   result = client.update_feature_group request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_feature_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateFeatureGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_feature_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.feature_group&.name
                header_params["feature_group.name"] = request.feature_group.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_feature_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_feature_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_registry_service_stub.call_rpc :update_feature_group, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single FeatureGroup.
            #
            # @overload delete_feature_group(request, options = nil)
            #   Pass arguments to `delete_feature_group` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteFeatureGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteFeatureGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_feature_group(name: nil, force: nil)
            #   Pass arguments to `delete_feature_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the FeatureGroup to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
            #   @param force [::Boolean]
            #     If set to true, any Features under this FeatureGroup
            #     will also be deleted. (Otherwise, the request will only work if the
            #     FeatureGroup has no Features.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteFeatureGroupRequest.new
            #
            #   # Call the delete_feature_group method.
            #   result = client.delete_feature_group request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_feature_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteFeatureGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_feature_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_feature_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_feature_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_registry_service_stub.call_rpc :delete_feature_group, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Feature in a given FeatureGroup.
            #
            # @overload create_feature(request, options = nil)
            #   Pass arguments to `create_feature` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateFeatureRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateFeatureRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_feature(parent: nil, feature: nil, feature_id: nil)
            #   Pass arguments to `create_feature` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the EntityType or FeatureGroup to create a
            #     Feature. Format for entity_type as parent:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
            #     Format for feature_group as parent:
            #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
            #   @param feature [::Google::Cloud::AIPlatform::V1::Feature, ::Hash]
            #     Required. The Feature to create.
            #   @param feature_id [::String]
            #     Required. The ID to use for the Feature, which will become the final
            #     component of the Feature's resource name.
            #
            #     This value may be up to 128 characters, and valid characters are
            #     `[a-z0-9_]`. The first character cannot be a number.
            #
            #     The value must be unique within an EntityType/FeatureGroup.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateFeatureRequest.new
            #
            #   # Call the create_feature method.
            #   result = client.create_feature request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_feature request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateFeatureRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_feature.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_feature.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_feature.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_registry_service_stub.call_rpc :create_feature, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a batch of Features in a given FeatureGroup.
            #
            # @overload batch_create_features(request, options = nil)
            #   Pass arguments to `batch_create_features` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::BatchCreateFeaturesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::BatchCreateFeaturesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_create_features(parent: nil, requests: nil)
            #   Pass arguments to `batch_create_features` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the EntityType/FeatureGroup to create the
            #     batch of Features under. Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
            #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
            #   @param requests [::Array<::Google::Cloud::AIPlatform::V1::CreateFeatureRequest, ::Hash>]
            #     Required. The request message specifying the Features to create. All
            #     Features must be created under the same parent EntityType / FeatureGroup.
            #     The `parent` field in each child request message can be omitted. If
            #     `parent` is set in a child request, then the value must match the `parent`
            #     value in this request message.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::BatchCreateFeaturesRequest.new
            #
            #   # Call the batch_create_features method.
            #   result = client.batch_create_features request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def batch_create_features request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::BatchCreateFeaturesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_create_features.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_create_features.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_create_features.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_registry_service_stub.call_rpc :batch_create_features, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Feature.
            #
            # @overload get_feature(request, options = nil)
            #   Pass arguments to `get_feature` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetFeatureRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetFeatureRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_feature(name: nil)
            #   Pass arguments to `get_feature` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Feature resource.
            #     Format for entity_type as parent:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
            #     Format for feature_group as parent:
            #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Feature]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Feature]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetFeatureRequest.new
            #
            #   # Call the get_feature method.
            #   result = client.get_feature request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Feature.
            #   p result
            #
            def get_feature request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetFeatureRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_feature.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_feature.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_feature.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_registry_service_stub.call_rpc :get_feature, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Features in a given FeatureGroup.
            #
            # @overload list_features(request, options = nil)
            #   Pass arguments to `list_features` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListFeaturesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListFeaturesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_features(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil, read_mask: nil, latest_stats_count: nil)
            #   Pass arguments to `list_features` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to list Features.
            #     Format for entity_type as parent:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
            #     Format for feature_group as parent:
            #     `projects/{project}/locations/{location}/featureGroups/{feature_group}`
            #   @param filter [::String]
            #     Lists the Features that match the filter expression. The following
            #     filters are supported:
            #
            #     * `value_type`: Supports = and != comparisons.
            #     * `create_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
            #     be in RFC 3339 format.
            #     * `update_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
            #     be in RFC 3339 format.
            #     * `labels`: Supports key-value equality as well as key presence.
            #
            #     Examples:
            #
            #     * `value_type = DOUBLE` --> Features whose type is DOUBLE.
            #     * `create_time > \"2020-01-31T15:30:00.000000Z\" OR
            #          update_time > \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created
            #          or updated after 2020-01-31T15:30:00.000000Z.
            #     * `labels.active = yes AND labels.env = prod` --> Features having both
            #         (active: yes) and (env: prod) labels.
            #     * `labels.env: *` --> Any Feature which has a label with 'env' as the
            #       key.
            #   @param page_size [::Integer]
            #     The maximum number of Features to return. The service may return fewer
            #     than this value. If unspecified, at most 1000 Features will be returned.
            #     The maximum value is 1000; any value greater than 1000 will be coerced to
            #     1000.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_features FeaturestoreService.ListFeatures}
            #     call or
            #     {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#list_features FeatureRegistryService.ListFeatures}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client#list_features FeaturestoreService.ListFeatures}
            #     or
            #     {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client#list_features FeatureRegistryService.ListFeatures}
            #     must match the call that provided the page token.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order by, sorted in ascending order.
            #     Use "desc" after a field name for descending.
            #     Supported fields:
            #
            #       * `feature_id`
            #       * `value_type` (Not supported for FeatureRegistry Feature)
            #       * `create_time`
            #       * `update_time`
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask specifying which fields to read.
            #   @param latest_stats_count [::Integer]
            #     Only applicable for Vertex AI Feature Store (Legacy).
            #     If set, return the most recent
            #     {::Google::Cloud::AIPlatform::V1::ListFeaturesRequest#latest_stats_count ListFeaturesRequest.latest_stats_count}
            #     of stats for each Feature in response. Valid value is [0, 10]. If number of
            #     stats exists <
            #     {::Google::Cloud::AIPlatform::V1::ListFeaturesRequest#latest_stats_count ListFeaturesRequest.latest_stats_count},
            #     return all existing stats.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Feature>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Feature>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListFeaturesRequest.new
            #
            #   # Call the list_features method.
            #   result = client.list_features request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Feature.
            #     p item
            #   end
            #
            def list_features request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListFeaturesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_features.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_features.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_features.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_registry_service_stub.call_rpc :list_features, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @feature_registry_service_stub, :list_features, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single Feature.
            #
            # @overload update_feature(request, options = nil)
            #   Pass arguments to `update_feature` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateFeatureRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateFeatureRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_feature(feature: nil, update_mask: nil)
            #   Pass arguments to `update_feature` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param feature [::Google::Cloud::AIPlatform::V1::Feature, ::Hash]
            #     Required. The Feature's `name` field is used to identify the Feature to be
            #     updated.
            #     Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
            #     `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Field mask is used to specify the fields to be overwritten in the
            #     Features resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then only the non-empty fields present in the
            #     request will be overwritten. Set the update_mask to `*` to override all
            #     fields.
            #
            #     Updatable fields:
            #
            #       * `description`
            #       * `labels`
            #       * `disable_monitoring` (Not supported for FeatureRegistryService Feature)
            #       * `point_of_contact` (Not supported for FeaturestoreService FeatureStore)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateFeatureRequest.new
            #
            #   # Call the update_feature method.
            #   result = client.update_feature request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_feature request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateFeatureRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_feature.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.feature&.name
                header_params["feature.name"] = request.feature.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_feature.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_feature.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_registry_service_stub.call_rpc :update_feature, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Feature.
            #
            # @overload delete_feature(request, options = nil)
            #   Pass arguments to `delete_feature` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteFeatureRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteFeatureRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_feature(name: nil)
            #   Pass arguments to `delete_feature` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Features to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
            #     `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteFeatureRequest.new
            #
            #   # Call the delete_feature method.
            #   result = client.delete_feature request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_feature request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteFeatureRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_feature.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_feature.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_feature.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_registry_service_stub.call_rpc :delete_feature, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the FeatureRegistryService API.
            #
            # This class represents the configuration for FeatureRegistryService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_feature_group to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_feature_group.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_feature_group.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the FeatureRegistryService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_feature_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_feature_group
                ##
                # RPC-specific configuration for `get_feature_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_feature_group
                ##
                # RPC-specific configuration for `list_feature_groups`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_feature_groups
                ##
                # RPC-specific configuration for `update_feature_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_feature_group
                ##
                # RPC-specific configuration for `delete_feature_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_feature_group
                ##
                # RPC-specific configuration for `create_feature`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_feature
                ##
                # RPC-specific configuration for `batch_create_features`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_create_features
                ##
                # RPC-specific configuration for `get_feature`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_feature
                ##
                # RPC-specific configuration for `list_features`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_features
                ##
                # RPC-specific configuration for `update_feature`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_feature
                ##
                # RPC-specific configuration for `delete_feature`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_feature

                # @private
                def initialize parent_rpcs = nil
                  create_feature_group_config = parent_rpcs.create_feature_group if parent_rpcs.respond_to? :create_feature_group
                  @create_feature_group = ::Gapic::Config::Method.new create_feature_group_config
                  get_feature_group_config = parent_rpcs.get_feature_group if parent_rpcs.respond_to? :get_feature_group
                  @get_feature_group = ::Gapic::Config::Method.new get_feature_group_config
                  list_feature_groups_config = parent_rpcs.list_feature_groups if parent_rpcs.respond_to? :list_feature_groups
                  @list_feature_groups = ::Gapic::Config::Method.new list_feature_groups_config
                  update_feature_group_config = parent_rpcs.update_feature_group if parent_rpcs.respond_to? :update_feature_group
                  @update_feature_group = ::Gapic::Config::Method.new update_feature_group_config
                  delete_feature_group_config = parent_rpcs.delete_feature_group if parent_rpcs.respond_to? :delete_feature_group
                  @delete_feature_group = ::Gapic::Config::Method.new delete_feature_group_config
                  create_feature_config = parent_rpcs.create_feature if parent_rpcs.respond_to? :create_feature
                  @create_feature = ::Gapic::Config::Method.new create_feature_config
                  batch_create_features_config = parent_rpcs.batch_create_features if parent_rpcs.respond_to? :batch_create_features
                  @batch_create_features = ::Gapic::Config::Method.new batch_create_features_config
                  get_feature_config = parent_rpcs.get_feature if parent_rpcs.respond_to? :get_feature
                  @get_feature = ::Gapic::Config::Method.new get_feature_config
                  list_features_config = parent_rpcs.list_features if parent_rpcs.respond_to? :list_features
                  @list_features = ::Gapic::Config::Method.new list_features_config
                  update_feature_config = parent_rpcs.update_feature if parent_rpcs.respond_to? :update_feature
                  @update_feature = ::Gapic::Config::Method.new update_feature_config
                  delete_feature_config = parent_rpcs.delete_feature if parent_rpcs.respond_to? :delete_feature
                  @delete_feature = ::Gapic::Config::Method.new delete_feature_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
