# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        module FeatureOnlineStoreService
          # Path helper methods for the FeatureOnlineStoreService API.
          module Paths
            ##
            # Create a fully-qualified FeatureView resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
            #
            # @param project [String]
            # @param location [String]
            # @param feature_online_store [String]
            # @param feature_view [String]
            #
            # @return [::String]
            def feature_view_path project:, location:, feature_online_store:, feature_view:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "feature_online_store cannot contain /" if feature_online_store.to_s.include? "/"

              "projects/#{project}/locations/#{location}/featureOnlineStores/#{feature_online_store}/featureViews/#{feature_view}"
            end

            extend self
          end
        end
      end
    end
  end
end
