# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/feature_online_store_admin_service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module AIPlatform
      module V1
        module FeatureOnlineStoreAdminService
          ##
          # Client for the FeatureOnlineStoreAdminService service.
          #
          # The service that handles CRUD and List for resources for
          # FeatureOnlineStore.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :feature_online_store_admin_service_stub

            ##
            # Configure the FeatureOnlineStoreAdminService Client class.
            #
            # See {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all FeatureOnlineStoreAdminService clients
            #   ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the FeatureOnlineStoreAdminService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @feature_online_store_admin_service_stub.universe_domain
            end

            ##
            # Create a new FeatureOnlineStoreAdminService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the FeatureOnlineStoreAdminService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/aiplatform/v1/feature_online_store_admin_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @feature_online_store_admin_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @feature_online_store_admin_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @feature_online_store_admin_service_stub.endpoint
                config.universe_domain = @feature_online_store_admin_service_stub.universe_domain
                config.logger = @feature_online_store_admin_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @feature_online_store_admin_service_stub.endpoint
                config.universe_domain = @feature_online_store_admin_service_stub.universe_domain
                config.logger = @feature_online_store_admin_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @feature_online_store_admin_service_stub.logger
            end

            # Service calls

            ##
            # Creates a new FeatureOnlineStore in a given project and location.
            #
            # @overload create_feature_online_store(request, options = nil)
            #   Pass arguments to `create_feature_online_store` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateFeatureOnlineStoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateFeatureOnlineStoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_feature_online_store(parent: nil, feature_online_store: nil, feature_online_store_id: nil)
            #   Pass arguments to `create_feature_online_store` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to create FeatureOnlineStores.
            #     Format:
            #     `projects/{project}/locations/{location}`
            #   @param feature_online_store [::Google::Cloud::AIPlatform::V1::FeatureOnlineStore, ::Hash]
            #     Required. The FeatureOnlineStore to create.
            #   @param feature_online_store_id [::String]
            #     Required. The ID to use for this FeatureOnlineStore, which will become the
            #     final component of the FeatureOnlineStore's resource name.
            #
            #     This value may be up to 60 characters, and valid characters are
            #     `[a-z0-9_]`. The first character cannot be a number.
            #
            #     The value must be unique within the project and location.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateFeatureOnlineStoreRequest.new
            #
            #   # Call the create_feature_online_store method.
            #   result = client.create_feature_online_store request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_feature_online_store request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateFeatureOnlineStoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_feature_online_store.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_feature_online_store.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_feature_online_store.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_online_store_admin_service_stub.call_rpc :create_feature_online_store, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single FeatureOnlineStore.
            #
            # @overload get_feature_online_store(request, options = nil)
            #   Pass arguments to `get_feature_online_store` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetFeatureOnlineStoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetFeatureOnlineStoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_feature_online_store(name: nil)
            #   Pass arguments to `get_feature_online_store` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the FeatureOnlineStore resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::FeatureOnlineStore]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::FeatureOnlineStore]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetFeatureOnlineStoreRequest.new
            #
            #   # Call the get_feature_online_store method.
            #   result = client.get_feature_online_store request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::FeatureOnlineStore.
            #   p result
            #
            def get_feature_online_store request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetFeatureOnlineStoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_feature_online_store.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_feature_online_store.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_feature_online_store.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_online_store_admin_service_stub.call_rpc :get_feature_online_store, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists FeatureOnlineStores in a given project and location.
            #
            # @overload list_feature_online_stores(request, options = nil)
            #   Pass arguments to `list_feature_online_stores` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListFeatureOnlineStoresRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListFeatureOnlineStoresRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_feature_online_stores(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil)
            #   Pass arguments to `list_feature_online_stores` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to list FeatureOnlineStores.
            #     Format:
            #     `projects/{project}/locations/{location}`
            #   @param filter [::String]
            #     Lists the FeatureOnlineStores that match the filter expression. The
            #     following fields are supported:
            #
            #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
            #     Values must be
            #       in RFC 3339 format.
            #     * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
            #     Values must be
            #       in RFC 3339 format.
            #     * `labels`: Supports key-value equality and key presence.
            #
            #     Examples:
            #
            #     * `create_time > "2020-01-01" OR update_time > "2020-01-01"`
            #        FeatureOnlineStores created or updated after 2020-01-01.
            #     * `labels.env = "prod"`
            #        FeatureOnlineStores with label "env" set to "prod".
            #   @param page_size [::Integer]
            #     The maximum number of FeatureOnlineStores to return. The service may return
            #     fewer than this value. If unspecified, at most 100 FeatureOnlineStores will
            #     be returned. The maximum value is 100; any value greater than 100 will be
            #     coerced to 100.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_online_stores FeatureOnlineStoreAdminService.ListFeatureOnlineStores}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_online_stores FeatureOnlineStoreAdminService.ListFeatureOnlineStores}
            #     must match the call that provided the page token.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order by, sorted in ascending order.
            #     Use "desc" after a field name for descending.
            #     Supported Fields:
            #
            #       * `create_time`
            #       * `update_time`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::FeatureOnlineStore>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::FeatureOnlineStore>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListFeatureOnlineStoresRequest.new
            #
            #   # Call the list_feature_online_stores method.
            #   result = client.list_feature_online_stores request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::FeatureOnlineStore.
            #     p item
            #   end
            #
            def list_feature_online_stores request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListFeatureOnlineStoresRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_feature_online_stores.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_feature_online_stores.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_feature_online_stores.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_online_store_admin_service_stub.call_rpc :list_feature_online_stores, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @feature_online_store_admin_service_stub, :list_feature_online_stores, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single FeatureOnlineStore.
            #
            # @overload update_feature_online_store(request, options = nil)
            #   Pass arguments to `update_feature_online_store` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateFeatureOnlineStoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateFeatureOnlineStoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_feature_online_store(feature_online_store: nil, update_mask: nil)
            #   Pass arguments to `update_feature_online_store` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param feature_online_store [::Google::Cloud::AIPlatform::V1::FeatureOnlineStore, ::Hash]
            #     Required. The FeatureOnlineStore's `name` field is used to identify the
            #     FeatureOnlineStore to be updated. Format:
            #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Field mask is used to specify the fields to be overwritten in the
            #     FeatureOnlineStore resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then only the non-empty fields present in the
            #     request will be overwritten. Set the update_mask to `*` to override all
            #     fields.
            #
            #     Updatable fields:
            #
            #       * `labels`
            #       * `description`
            #       * `bigtable`
            #       * `bigtable.auto_scaling`
            #       * `bigtable.enable_multi_region_replica`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateFeatureOnlineStoreRequest.new
            #
            #   # Call the update_feature_online_store method.
            #   result = client.update_feature_online_store request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_feature_online_store request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateFeatureOnlineStoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_feature_online_store.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.feature_online_store&.name
                header_params["feature_online_store.name"] = request.feature_online_store.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_feature_online_store.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_feature_online_store.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_online_store_admin_service_stub.call_rpc :update_feature_online_store, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single FeatureOnlineStore. The FeatureOnlineStore must not
            # contain any FeatureViews.
            #
            # @overload delete_feature_online_store(request, options = nil)
            #   Pass arguments to `delete_feature_online_store` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteFeatureOnlineStoreRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteFeatureOnlineStoreRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_feature_online_store(name: nil, force: nil)
            #   Pass arguments to `delete_feature_online_store` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the FeatureOnlineStore to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
            #   @param force [::Boolean]
            #     If set to true, any FeatureViews and Features for this FeatureOnlineStore
            #     will also be deleted. (Otherwise, the request will only work if the
            #     FeatureOnlineStore has no FeatureViews.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteFeatureOnlineStoreRequest.new
            #
            #   # Call the delete_feature_online_store method.
            #   result = client.delete_feature_online_store request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_feature_online_store request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteFeatureOnlineStoreRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_feature_online_store.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_feature_online_store.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_feature_online_store.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_online_store_admin_service_stub.call_rpc :delete_feature_online_store, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new FeatureView in a given FeatureOnlineStore.
            #
            # @overload create_feature_view(request, options = nil)
            #   Pass arguments to `create_feature_view` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateFeatureViewRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateFeatureViewRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_feature_view(parent: nil, feature_view: nil, feature_view_id: nil, run_sync_immediately: nil)
            #   Pass arguments to `create_feature_view` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the FeatureOnlineStore to create
            #     FeatureViews. Format:
            #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
            #   @param feature_view [::Google::Cloud::AIPlatform::V1::FeatureView, ::Hash]
            #     Required. The FeatureView to create.
            #   @param feature_view_id [::String]
            #     Required. The ID to use for the FeatureView, which will become the final
            #     component of the FeatureView's resource name.
            #
            #     This value may be up to 60 characters, and valid characters are
            #     `[a-z0-9_]`. The first character cannot be a number.
            #
            #     The value must be unique within a FeatureOnlineStore.
            #   @param run_sync_immediately [::Boolean]
            #     Immutable. If set to true, one on demand sync will be run immediately,
            #     regardless whether the
            #     {::Google::Cloud::AIPlatform::V1::FeatureView#sync_config FeatureView.sync_config}
            #     is configured or not.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateFeatureViewRequest.new
            #
            #   # Call the create_feature_view method.
            #   result = client.create_feature_view request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_feature_view request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateFeatureViewRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_feature_view.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_feature_view.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_feature_view.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_online_store_admin_service_stub.call_rpc :create_feature_view, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single FeatureView.
            #
            # @overload get_feature_view(request, options = nil)
            #   Pass arguments to `get_feature_view` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetFeatureViewRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetFeatureViewRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_feature_view(name: nil)
            #   Pass arguments to `get_feature_view` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the FeatureView resource.
            #     Format:
            #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::FeatureView]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::FeatureView]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetFeatureViewRequest.new
            #
            #   # Call the get_feature_view method.
            #   result = client.get_feature_view request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::FeatureView.
            #   p result
            #
            def get_feature_view request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetFeatureViewRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_feature_view.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_feature_view.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_feature_view.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_online_store_admin_service_stub.call_rpc :get_feature_view, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists FeatureViews in a given FeatureOnlineStore.
            #
            # @overload list_feature_views(request, options = nil)
            #   Pass arguments to `list_feature_views` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListFeatureViewsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListFeatureViewsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_feature_views(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil)
            #   Pass arguments to `list_feature_views` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the FeatureOnlineStore to list FeatureViews.
            #     Format:
            #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
            #   @param filter [::String]
            #     Lists the FeatureViews that match the filter expression. The following
            #     filters are supported:
            #
            #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
            #     Values must be in RFC 3339 format.
            #     * `update_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
            #     Values must be in RFC 3339 format.
            #     * `labels`: Supports key-value equality as well as key presence.
            #
            #     Examples:
            #
            #     * `create_time > \"2020-01-31T15:30:00.000000Z\" OR
            #          update_time > \"2020-01-31T15:30:00.000000Z\"` --> FeatureViews
            #          created or updated after 2020-01-31T15:30:00.000000Z.
            #     * `labels.active = yes AND labels.env = prod` --> FeatureViews having both
            #         (active: yes) and (env: prod) labels.
            #     * `labels.env: *` --> Any FeatureView which has a label with 'env' as the
            #       key.
            #   @param page_size [::Integer]
            #     The maximum number of FeatureViews to return. The service may return fewer
            #     than this value. If unspecified, at most 1000 FeatureViews will be
            #     returned. The maximum value is 1000; any value greater than 1000 will be
            #     coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_views FeatureOnlineStoreAdminService.ListFeatureViews}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_views FeatureOnlineStoreAdminService.ListFeatureViews}
            #     must match the call that provided the page token.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order by, sorted in ascending order.
            #     Use "desc" after a field name for descending.
            #
            #     Supported fields:
            #
            #       * `feature_view_id`
            #       * `create_time`
            #       * `update_time`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::FeatureView>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::FeatureView>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListFeatureViewsRequest.new
            #
            #   # Call the list_feature_views method.
            #   result = client.list_feature_views request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::FeatureView.
            #     p item
            #   end
            #
            def list_feature_views request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListFeatureViewsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_feature_views.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_feature_views.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_feature_views.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_online_store_admin_service_stub.call_rpc :list_feature_views, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @feature_online_store_admin_service_stub, :list_feature_views, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single FeatureView.
            #
            # @overload update_feature_view(request, options = nil)
            #   Pass arguments to `update_feature_view` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateFeatureViewRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateFeatureViewRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_feature_view(feature_view: nil, update_mask: nil)
            #   Pass arguments to `update_feature_view` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param feature_view [::Google::Cloud::AIPlatform::V1::FeatureView, ::Hash]
            #     Required. The FeatureView's `name` field is used to identify the
            #     FeatureView to be updated. Format:
            #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Field mask is used to specify the fields to be overwritten in the
            #     FeatureView resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then only the non-empty fields present in the
            #     request will be overwritten. Set the update_mask to `*` to override all
            #     fields.
            #
            #     Updatable fields:
            #
            #       * `labels`
            #       * `service_agent_type`
            #       * `big_query_source`
            #       * `big_query_source.uri`
            #       * `big_query_source.entity_id_columns`
            #       * `feature_registry_source`
            #       * `feature_registry_source.feature_groups`
            #       * `sync_config`
            #       * `sync_config.cron`
            #       * `optimized_config.automatic_resources`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateFeatureViewRequest.new
            #
            #   # Call the update_feature_view method.
            #   result = client.update_feature_view request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_feature_view request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateFeatureViewRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_feature_view.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.feature_view&.name
                header_params["feature_view.name"] = request.feature_view.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_feature_view.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_feature_view.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_online_store_admin_service_stub.call_rpc :update_feature_view, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single FeatureView.
            #
            # @overload delete_feature_view(request, options = nil)
            #   Pass arguments to `delete_feature_view` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteFeatureViewRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteFeatureViewRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_feature_view(name: nil)
            #   Pass arguments to `delete_feature_view` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the FeatureView to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteFeatureViewRequest.new
            #
            #   # Call the delete_feature_view method.
            #   result = client.delete_feature_view request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_feature_view request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteFeatureViewRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_feature_view.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_feature_view.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_feature_view.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_online_store_admin_service_stub.call_rpc :delete_feature_view, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Triggers on-demand sync for the FeatureView.
            #
            # @overload sync_feature_view(request, options = nil)
            #   Pass arguments to `sync_feature_view` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::SyncFeatureViewRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::SyncFeatureViewRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload sync_feature_view(feature_view: nil)
            #   Pass arguments to `sync_feature_view` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param feature_view [::String]
            #     Required. Format:
            #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::SyncFeatureViewResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::SyncFeatureViewResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::SyncFeatureViewRequest.new
            #
            #   # Call the sync_feature_view method.
            #   result = client.sync_feature_view request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::SyncFeatureViewResponse.
            #   p result
            #
            def sync_feature_view request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::SyncFeatureViewRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.sync_feature_view.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.feature_view
                header_params["feature_view"] = request.feature_view
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.sync_feature_view.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.sync_feature_view.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_online_store_admin_service_stub.call_rpc :sync_feature_view, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single FeatureViewSync.
            #
            # @overload get_feature_view_sync(request, options = nil)
            #   Pass arguments to `get_feature_view_sync` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetFeatureViewSyncRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetFeatureViewSyncRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_feature_view_sync(name: nil)
            #   Pass arguments to `get_feature_view_sync` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the FeatureViewSync resource.
            #     Format:
            #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Aiplatform::V1::FeatureViewSync]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Aiplatform::V1::FeatureViewSync]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetFeatureViewSyncRequest.new
            #
            #   # Call the get_feature_view_sync method.
            #   result = client.get_feature_view_sync request
            #
            #   # The returned object is of type Google::Cloud::Aiplatform::V1::FeatureViewSync.
            #   p result
            #
            def get_feature_view_sync request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetFeatureViewSyncRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_feature_view_sync.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_feature_view_sync.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_feature_view_sync.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_online_store_admin_service_stub.call_rpc :get_feature_view_sync, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists FeatureViewSyncs in a given FeatureView.
            #
            # @overload list_feature_view_syncs(request, options = nil)
            #   Pass arguments to `list_feature_view_syncs` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListFeatureViewSyncsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListFeatureViewSyncsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_feature_view_syncs(parent: nil, filter: nil, page_size: nil, page_token: nil, order_by: nil)
            #   Pass arguments to `list_feature_view_syncs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the FeatureView to list FeatureViewSyncs.
            #     Format:
            #     `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
            #   @param filter [::String]
            #     Lists the FeatureViewSyncs that match the filter expression. The following
            #     filters are supported:
            #
            #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
            #     Values must be in RFC 3339 format.
            #
            #     Examples:
            #
            #     * `create_time > \"2020-01-31T15:30:00.000000Z\"` --> FeatureViewSyncs
            #          created after 2020-01-31T15:30:00.000000Z.
            #   @param page_size [::Integer]
            #     The maximum number of FeatureViewSyncs to return. The service may return
            #     fewer than this value. If unspecified, at most 1000 FeatureViewSyncs will
            #     be returned. The maximum value is 1000; any value greater than 1000 will be
            #     coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_view_syncs FeatureOnlineStoreAdminService.ListFeatureViewSyncs}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client#list_feature_view_syncs FeatureOnlineStoreAdminService.ListFeatureViewSyncs}
            #     must match the call that provided the page token.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order by, sorted in ascending order.
            #     Use "desc" after a field name for descending.
            #
            #     Supported fields:
            #
            #       * `create_time`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Aiplatform::V1::FeatureViewSync>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Aiplatform::V1::FeatureViewSync>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListFeatureViewSyncsRequest.new
            #
            #   # Call the list_feature_view_syncs method.
            #   result = client.list_feature_view_syncs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Aiplatform::V1::FeatureViewSync.
            #     p item
            #   end
            #
            def list_feature_view_syncs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListFeatureViewSyncsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_feature_view_syncs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_feature_view_syncs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_feature_view_syncs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @feature_online_store_admin_service_stub.call_rpc :list_feature_view_syncs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @feature_online_store_admin_service_stub, :list_feature_view_syncs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the FeatureOnlineStoreAdminService API.
            #
            # This class represents the configuration for FeatureOnlineStoreAdminService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_feature_online_store to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_feature_online_store.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_feature_online_store.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the FeatureOnlineStoreAdminService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_feature_online_store`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_feature_online_store
                ##
                # RPC-specific configuration for `get_feature_online_store`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_feature_online_store
                ##
                # RPC-specific configuration for `list_feature_online_stores`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_feature_online_stores
                ##
                # RPC-specific configuration for `update_feature_online_store`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_feature_online_store
                ##
                # RPC-specific configuration for `delete_feature_online_store`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_feature_online_store
                ##
                # RPC-specific configuration for `create_feature_view`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_feature_view
                ##
                # RPC-specific configuration for `get_feature_view`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_feature_view
                ##
                # RPC-specific configuration for `list_feature_views`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_feature_views
                ##
                # RPC-specific configuration for `update_feature_view`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_feature_view
                ##
                # RPC-specific configuration for `delete_feature_view`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_feature_view
                ##
                # RPC-specific configuration for `sync_feature_view`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :sync_feature_view
                ##
                # RPC-specific configuration for `get_feature_view_sync`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_feature_view_sync
                ##
                # RPC-specific configuration for `list_feature_view_syncs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_feature_view_syncs

                # @private
                def initialize parent_rpcs = nil
                  create_feature_online_store_config = parent_rpcs.create_feature_online_store if parent_rpcs.respond_to? :create_feature_online_store
                  @create_feature_online_store = ::Gapic::Config::Method.new create_feature_online_store_config
                  get_feature_online_store_config = parent_rpcs.get_feature_online_store if parent_rpcs.respond_to? :get_feature_online_store
                  @get_feature_online_store = ::Gapic::Config::Method.new get_feature_online_store_config
                  list_feature_online_stores_config = parent_rpcs.list_feature_online_stores if parent_rpcs.respond_to? :list_feature_online_stores
                  @list_feature_online_stores = ::Gapic::Config::Method.new list_feature_online_stores_config
                  update_feature_online_store_config = parent_rpcs.update_feature_online_store if parent_rpcs.respond_to? :update_feature_online_store
                  @update_feature_online_store = ::Gapic::Config::Method.new update_feature_online_store_config
                  delete_feature_online_store_config = parent_rpcs.delete_feature_online_store if parent_rpcs.respond_to? :delete_feature_online_store
                  @delete_feature_online_store = ::Gapic::Config::Method.new delete_feature_online_store_config
                  create_feature_view_config = parent_rpcs.create_feature_view if parent_rpcs.respond_to? :create_feature_view
                  @create_feature_view = ::Gapic::Config::Method.new create_feature_view_config
                  get_feature_view_config = parent_rpcs.get_feature_view if parent_rpcs.respond_to? :get_feature_view
                  @get_feature_view = ::Gapic::Config::Method.new get_feature_view_config
                  list_feature_views_config = parent_rpcs.list_feature_views if parent_rpcs.respond_to? :list_feature_views
                  @list_feature_views = ::Gapic::Config::Method.new list_feature_views_config
                  update_feature_view_config = parent_rpcs.update_feature_view if parent_rpcs.respond_to? :update_feature_view
                  @update_feature_view = ::Gapic::Config::Method.new update_feature_view_config
                  delete_feature_view_config = parent_rpcs.delete_feature_view if parent_rpcs.respond_to? :delete_feature_view
                  @delete_feature_view = ::Gapic::Config::Method.new delete_feature_view_config
                  sync_feature_view_config = parent_rpcs.sync_feature_view if parent_rpcs.respond_to? :sync_feature_view
                  @sync_feature_view = ::Gapic::Config::Method.new sync_feature_view_config
                  get_feature_view_sync_config = parent_rpcs.get_feature_view_sync if parent_rpcs.respond_to? :get_feature_view_sync
                  @get_feature_view_sync = ::Gapic::Config::Method.new get_feature_view_sync_config
                  list_feature_view_syncs_config = parent_rpcs.list_feature_view_syncs if parent_rpcs.respond_to? :list_feature_view_syncs
                  @list_feature_view_syncs = ::Gapic::Config::Method.new list_feature_view_syncs_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
