# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/evaluation_service_pb"
require "google/cloud/ai_platform/v1/evaluation_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module AIPlatform
      module V1
        module EvaluationService
          module Rest
            ##
            # REST client for the EvaluationService service.
            #
            # Vertex AI Online Evaluation Service.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :evaluation_service_stub

              ##
              # Configure the EvaluationService Client class.
              #
              # See {::Google::Cloud::AIPlatform::V1::EvaluationService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all EvaluationService clients
              #   ::Google::Cloud::AIPlatform::V1::EvaluationService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the EvaluationService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::AIPlatform::V1::EvaluationService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @evaluation_service_stub.universe_domain
              end

              ##
              # Create a new EvaluationService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::AIPlatform::V1::EvaluationService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::AIPlatform::V1::EvaluationService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the EvaluationService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @evaluation_service_stub = ::Google::Cloud::AIPlatform::V1::EvaluationService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @evaluation_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @evaluation_service_stub.endpoint
                  config.universe_domain = @evaluation_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @evaluation_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @evaluation_service_stub.endpoint
                  config.universe_domain = @evaluation_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @evaluation_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @evaluation_service_stub.logger
              end

              # Service calls

              ##
              # Evaluates instances based on a given metric.
              #
              # @overload evaluate_instances(request, options = nil)
              #   Pass arguments to `evaluate_instances` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::EvaluateInstancesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::EvaluateInstancesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload evaluate_instances(exact_match_input: nil, bleu_input: nil, rouge_input: nil, fluency_input: nil, coherence_input: nil, safety_input: nil, groundedness_input: nil, fulfillment_input: nil, summarization_quality_input: nil, pairwise_summarization_quality_input: nil, summarization_helpfulness_input: nil, summarization_verbosity_input: nil, question_answering_quality_input: nil, pairwise_question_answering_quality_input: nil, question_answering_relevance_input: nil, question_answering_helpfulness_input: nil, question_answering_correctness_input: nil, pointwise_metric_input: nil, pairwise_metric_input: nil, tool_call_valid_input: nil, tool_name_match_input: nil, tool_parameter_key_match_input: nil, tool_parameter_kv_match_input: nil, comet_input: nil, metricx_input: nil, location: nil)
              #   Pass arguments to `evaluate_instances` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param exact_match_input [::Google::Cloud::AIPlatform::V1::ExactMatchInput, ::Hash]
              #     Auto metric instances.
              #     Instances and metric spec for exact match metric.
              #
              #     Note: The following parameters are mutually exclusive: `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param bleu_input [::Google::Cloud::AIPlatform::V1::BleuInput, ::Hash]
              #     Instances and metric spec for bleu metric.
              #
              #     Note: The following parameters are mutually exclusive: `bleu_input`, `exact_match_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param rouge_input [::Google::Cloud::AIPlatform::V1::RougeInput, ::Hash]
              #     Instances and metric spec for rouge metric.
              #
              #     Note: The following parameters are mutually exclusive: `rouge_input`, `exact_match_input`, `bleu_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param fluency_input [::Google::Cloud::AIPlatform::V1::FluencyInput, ::Hash]
              #     LLM-based metric instance.
              #     General text generation metrics, applicable to other categories.
              #     Input for fluency metric.
              #
              #     Note: The following parameters are mutually exclusive: `fluency_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param coherence_input [::Google::Cloud::AIPlatform::V1::CoherenceInput, ::Hash]
              #     Input for coherence metric.
              #
              #     Note: The following parameters are mutually exclusive: `coherence_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param safety_input [::Google::Cloud::AIPlatform::V1::SafetyInput, ::Hash]
              #     Input for safety metric.
              #
              #     Note: The following parameters are mutually exclusive: `safety_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param groundedness_input [::Google::Cloud::AIPlatform::V1::GroundednessInput, ::Hash]
              #     Input for groundedness metric.
              #
              #     Note: The following parameters are mutually exclusive: `groundedness_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param fulfillment_input [::Google::Cloud::AIPlatform::V1::FulfillmentInput, ::Hash]
              #     Input for fulfillment metric.
              #
              #     Note: The following parameters are mutually exclusive: `fulfillment_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param summarization_quality_input [::Google::Cloud::AIPlatform::V1::SummarizationQualityInput, ::Hash]
              #     Input for summarization quality metric.
              #
              #     Note: The following parameters are mutually exclusive: `summarization_quality_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param pairwise_summarization_quality_input [::Google::Cloud::AIPlatform::V1::PairwiseSummarizationQualityInput, ::Hash]
              #     Input for pairwise summarization quality metric.
              #
              #     Note: The following parameters are mutually exclusive: `pairwise_summarization_quality_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param summarization_helpfulness_input [::Google::Cloud::AIPlatform::V1::SummarizationHelpfulnessInput, ::Hash]
              #     Input for summarization helpfulness metric.
              #
              #     Note: The following parameters are mutually exclusive: `summarization_helpfulness_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param summarization_verbosity_input [::Google::Cloud::AIPlatform::V1::SummarizationVerbosityInput, ::Hash]
              #     Input for summarization verbosity metric.
              #
              #     Note: The following parameters are mutually exclusive: `summarization_verbosity_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param question_answering_quality_input [::Google::Cloud::AIPlatform::V1::QuestionAnsweringQualityInput, ::Hash]
              #     Input for question answering quality metric.
              #
              #     Note: The following parameters are mutually exclusive: `question_answering_quality_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param pairwise_question_answering_quality_input [::Google::Cloud::AIPlatform::V1::PairwiseQuestionAnsweringQualityInput, ::Hash]
              #     Input for pairwise question answering quality metric.
              #
              #     Note: The following parameters are mutually exclusive: `pairwise_question_answering_quality_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param question_answering_relevance_input [::Google::Cloud::AIPlatform::V1::QuestionAnsweringRelevanceInput, ::Hash]
              #     Input for question answering relevance metric.
              #
              #     Note: The following parameters are mutually exclusive: `question_answering_relevance_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param question_answering_helpfulness_input [::Google::Cloud::AIPlatform::V1::QuestionAnsweringHelpfulnessInput, ::Hash]
              #     Input for question answering helpfulness
              #     metric.
              #
              #     Note: The following parameters are mutually exclusive: `question_answering_helpfulness_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param question_answering_correctness_input [::Google::Cloud::AIPlatform::V1::QuestionAnsweringCorrectnessInput, ::Hash]
              #     Input for question answering correctness
              #     metric.
              #
              #     Note: The following parameters are mutually exclusive: `question_answering_correctness_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param pointwise_metric_input [::Google::Cloud::AIPlatform::V1::PointwiseMetricInput, ::Hash]
              #     Input for pointwise metric.
              #
              #     Note: The following parameters are mutually exclusive: `pointwise_metric_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param pairwise_metric_input [::Google::Cloud::AIPlatform::V1::PairwiseMetricInput, ::Hash]
              #     Input for pairwise metric.
              #
              #     Note: The following parameters are mutually exclusive: `pairwise_metric_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param tool_call_valid_input [::Google::Cloud::AIPlatform::V1::ToolCallValidInput, ::Hash]
              #     Tool call metric instances.
              #     Input for tool call valid metric.
              #
              #     Note: The following parameters are mutually exclusive: `tool_call_valid_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param tool_name_match_input [::Google::Cloud::AIPlatform::V1::ToolNameMatchInput, ::Hash]
              #     Input for tool name match metric.
              #
              #     Note: The following parameters are mutually exclusive: `tool_name_match_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param tool_parameter_key_match_input [::Google::Cloud::AIPlatform::V1::ToolParameterKeyMatchInput, ::Hash]
              #     Input for tool parameter key match metric.
              #
              #     Note: The following parameters are mutually exclusive: `tool_parameter_key_match_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_kv_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param tool_parameter_kv_match_input [::Google::Cloud::AIPlatform::V1::ToolParameterKVMatchInput, ::Hash]
              #     Input for tool parameter key value match metric.
              #
              #     Note: The following parameters are mutually exclusive: `tool_parameter_kv_match_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `comet_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param comet_input [::Google::Cloud::AIPlatform::V1::CometInput, ::Hash]
              #     Translation metrics.
              #     Input for Comet metric.
              #
              #     Note: The following parameters are mutually exclusive: `comet_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `metricx_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param metricx_input [::Google::Cloud::AIPlatform::V1::MetricxInput, ::Hash]
              #     Input for Metricx metric.
              #
              #     Note: The following parameters are mutually exclusive: `metricx_input`, `exact_match_input`, `bleu_input`, `rouge_input`, `fluency_input`, `coherence_input`, `safety_input`, `groundedness_input`, `fulfillment_input`, `summarization_quality_input`, `pairwise_summarization_quality_input`, `summarization_helpfulness_input`, `summarization_verbosity_input`, `question_answering_quality_input`, `pairwise_question_answering_quality_input`, `question_answering_relevance_input`, `question_answering_helpfulness_input`, `question_answering_correctness_input`, `pointwise_metric_input`, `pairwise_metric_input`, `tool_call_valid_input`, `tool_name_match_input`, `tool_parameter_key_match_input`, `tool_parameter_kv_match_input`, `comet_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param location [::String]
              #     Required. The resource name of the Location to evaluate the instances.
              #     Format: `projects/{project}/locations/{location}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::EvaluateInstancesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::EvaluateInstancesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::EvaluateInstancesRequest.new
              #
              #   # Call the evaluate_instances method.
              #   result = client.evaluate_instances request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::EvaluateInstancesResponse.
              #   p result
              #
              def evaluate_instances request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::EvaluateInstancesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.evaluate_instances.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.evaluate_instances.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.evaluate_instances.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.evaluate_instances request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the EvaluationService REST API.
              #
              # This class represents the configuration for EvaluationService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::AIPlatform::V1::EvaluationService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # evaluate_instances to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::AIPlatform::V1::EvaluationService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.evaluate_instances.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::AIPlatform::V1::EvaluationService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.evaluate_instances.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the EvaluationService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `evaluate_instances`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :evaluate_instances

                  # @private
                  def initialize parent_rpcs = nil
                    evaluate_instances_config = parent_rpcs.evaluate_instances if parent_rpcs.respond_to? :evaluate_instances
                    @evaluate_instances = ::Gapic::Config::Method.new evaluate_instances_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
