# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/endpoint_service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module AIPlatform
      module V1
        module EndpointService
          ##
          # Client for the EndpointService service.
          #
          # A service for managing Vertex AI's Endpoints.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :endpoint_service_stub

            ##
            # Configure the EndpointService Client class.
            #
            # See {::Google::Cloud::AIPlatform::V1::EndpointService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all EndpointService clients
            #   ::Google::Cloud::AIPlatform::V1::EndpointService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the EndpointService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::AIPlatform::V1::EndpointService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @endpoint_service_stub.universe_domain
            end

            ##
            # Create a new EndpointService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::AIPlatform::V1::EndpointService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::AIPlatform::V1::EndpointService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the EndpointService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/aiplatform/v1/endpoint_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @endpoint_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::AIPlatform::V1::EndpointService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @endpoint_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @endpoint_service_stub.endpoint
                config.universe_domain = @endpoint_service_stub.universe_domain
                config.logger = @endpoint_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @endpoint_service_stub.endpoint
                config.universe_domain = @endpoint_service_stub.universe_domain
                config.logger = @endpoint_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::AIPlatform::V1::EndpointService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @endpoint_service_stub.logger
            end

            # Service calls

            ##
            # Creates an Endpoint.
            #
            # @overload create_endpoint(request, options = nil)
            #   Pass arguments to `create_endpoint` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::CreateEndpointRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::CreateEndpointRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_endpoint(parent: nil, endpoint: nil, endpoint_id: nil)
            #   Pass arguments to `create_endpoint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location to create the Endpoint in.
            #     Format: `projects/{project}/locations/{location}`
            #   @param endpoint [::Google::Cloud::AIPlatform::V1::Endpoint, ::Hash]
            #     Required. The Endpoint to create.
            #   @param endpoint_id [::String]
            #     Immutable. The ID to use for endpoint, which will become the final
            #     component of the endpoint resource name.
            #     If not provided, Vertex AI will generate a value for this ID.
            #
            #     If the first character is a letter, this value may be up to 63 characters,
            #     and valid characters are `[a-z0-9-]`. The last character must be a letter
            #     or number.
            #
            #     If the first character is a number, this value may be up to 9 characters,
            #     and valid characters are `[0-9]` with no leading zeros.
            #
            #     When using HTTP/JSON, this field is populated
            #     based on a query string argument, such as `?endpoint_id=12345`. This is the
            #     fallback for fields that are not included in either the URI or the body.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::EndpointService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::CreateEndpointRequest.new
            #
            #   # Call the create_endpoint method.
            #   result = client.create_endpoint request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_endpoint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateEndpointRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_endpoint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_endpoint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_endpoint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @endpoint_service_stub.call_rpc :create_endpoint, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an Endpoint.
            #
            # @overload get_endpoint(request, options = nil)
            #   Pass arguments to `get_endpoint` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::GetEndpointRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::GetEndpointRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_endpoint(name: nil)
            #   Pass arguments to `get_endpoint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Endpoint resource.
            #     Format:
            #     `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Endpoint]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Endpoint]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::EndpointService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::GetEndpointRequest.new
            #
            #   # Call the get_endpoint method.
            #   result = client.get_endpoint request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Endpoint.
            #   p result
            #
            def get_endpoint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetEndpointRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_endpoint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_endpoint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_endpoint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @endpoint_service_stub.call_rpc :get_endpoint, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Endpoints in a Location.
            #
            # @overload list_endpoints(request, options = nil)
            #   Pass arguments to `list_endpoints` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::ListEndpointsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::ListEndpointsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_endpoints(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil, order_by: nil)
            #   Pass arguments to `list_endpoints` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location from which to list the
            #     Endpoints. Format: `projects/{project}/locations/{location}`
            #   @param filter [::String]
            #     Optional. An expression for filtering the results of the request. For field
            #     names both snake_case and camelCase are supported.
            #
            #       * `endpoint` supports `=` and `!=`. `endpoint` represents the Endpoint
            #         ID, i.e. the last segment of the Endpoint's
            #         {::Google::Cloud::AIPlatform::V1::Endpoint#name resource name}.
            #       * `display_name` supports `=` and `!=`.
            #       * `labels` supports general map functions that is:
            #         * `labels.key=value` - key:value equality
            #         * `labels.key:*` or `labels:key` - key existence
            #         * A key including a space must be quoted. `labels."a key"`.
            #       * `base_model_name` only supports `=`.
            #
            #     Some examples:
            #
            #       * `endpoint=1`
            #       * `displayName="myDisplayName"`
            #       * `labels.myKey="myValue"`
            #       * `baseModelName="text-bison"`
            #   @param page_size [::Integer]
            #     Optional. The standard list page size.
            #   @param page_token [::String]
            #     Optional. The standard list page token.
            #     Typically obtained via
            #     {::Google::Cloud::AIPlatform::V1::ListEndpointsResponse#next_page_token ListEndpointsResponse.next_page_token}
            #     of the previous
            #     {::Google::Cloud::AIPlatform::V1::EndpointService::Client#list_endpoints EndpointService.ListEndpoints}
            #     call.
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Mask specifying which fields to read.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order by, sorted in ascending order.
            #     Use "desc" after a field name for descending.
            #     Supported fields:
            #
            #       * `display_name`
            #       * `create_time`
            #       * `update_time`
            #
            #     Example: `display_name, create_time desc`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Endpoint>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Endpoint>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::EndpointService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::ListEndpointsRequest.new
            #
            #   # Call the list_endpoints method.
            #   result = client.list_endpoints request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Endpoint.
            #     p item
            #   end
            #
            def list_endpoints request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListEndpointsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_endpoints.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_endpoints.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_endpoints.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @endpoint_service_stub.call_rpc :list_endpoints, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @endpoint_service_stub, :list_endpoints, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an Endpoint.
            #
            # @overload update_endpoint(request, options = nil)
            #   Pass arguments to `update_endpoint` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateEndpointRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateEndpointRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_endpoint(endpoint: nil, update_mask: nil)
            #   Pass arguments to `update_endpoint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param endpoint [::Google::Cloud::AIPlatform::V1::Endpoint, ::Hash]
            #     Required. The Endpoint which replaces the resource on the server.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The update mask applies to the resource. See
            #     {::Google::Protobuf::FieldMask google.protobuf.FieldMask}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AIPlatform::V1::Endpoint]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AIPlatform::V1::Endpoint]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::EndpointService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateEndpointRequest.new
            #
            #   # Call the update_endpoint method.
            #   result = client.update_endpoint request
            #
            #   # The returned object is of type Google::Cloud::AIPlatform::V1::Endpoint.
            #   p result
            #
            def update_endpoint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateEndpointRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_endpoint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.endpoint&.name
                header_params["endpoint.name"] = request.endpoint.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_endpoint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_endpoint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @endpoint_service_stub.call_rpc :update_endpoint, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an Endpoint with a long running operation.
            #
            # @overload update_endpoint_long_running(request, options = nil)
            #   Pass arguments to `update_endpoint_long_running` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UpdateEndpointLongRunningRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UpdateEndpointLongRunningRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_endpoint_long_running(endpoint: nil)
            #   Pass arguments to `update_endpoint_long_running` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param endpoint [::Google::Cloud::AIPlatform::V1::Endpoint, ::Hash]
            #     Required. The Endpoint which replaces the resource on the server. Currently
            #     we only support updating the `client_connection_config` field, all the
            #     other fields' update will be blocked.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::EndpointService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UpdateEndpointLongRunningRequest.new
            #
            #   # Call the update_endpoint_long_running method.
            #   result = client.update_endpoint_long_running request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_endpoint_long_running request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateEndpointLongRunningRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_endpoint_long_running.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.endpoint&.name
                header_params["endpoint.name"] = request.endpoint.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_endpoint_long_running.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_endpoint_long_running.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @endpoint_service_stub.call_rpc :update_endpoint_long_running, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an Endpoint.
            #
            # @overload delete_endpoint(request, options = nil)
            #   Pass arguments to `delete_endpoint` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeleteEndpointRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeleteEndpointRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_endpoint(name: nil)
            #   Pass arguments to `delete_endpoint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Endpoint resource to be deleted.
            #     Format:
            #     `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::EndpointService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeleteEndpointRequest.new
            #
            #   # Call the delete_endpoint method.
            #   result = client.delete_endpoint request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_endpoint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteEndpointRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_endpoint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_endpoint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_endpoint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @endpoint_service_stub.call_rpc :delete_endpoint, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deploys a Model into this Endpoint, creating a DeployedModel within it.
            #
            # @overload deploy_model(request, options = nil)
            #   Pass arguments to `deploy_model` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::DeployModelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::DeployModelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload deploy_model(endpoint: nil, deployed_model: nil, traffic_split: nil)
            #   Pass arguments to `deploy_model` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param endpoint [::String]
            #     Required. The name of the Endpoint resource into which to deploy a Model.
            #     Format:
            #     `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #   @param deployed_model [::Google::Cloud::AIPlatform::V1::DeployedModel, ::Hash]
            #     Required. The DeployedModel to be created within the Endpoint. Note that
            #     {::Google::Cloud::AIPlatform::V1::Endpoint#traffic_split Endpoint.traffic_split}
            #     must be updated for the DeployedModel to start receiving traffic, either as
            #     part of this call, or via
            #     {::Google::Cloud::AIPlatform::V1::EndpointService::Client#update_endpoint EndpointService.UpdateEndpoint}.
            #   @param traffic_split [::Hash{::String => ::Integer}]
            #     A map from a DeployedModel's ID to the percentage of this Endpoint's
            #     traffic that should be forwarded to that DeployedModel.
            #
            #     If this field is non-empty, then the Endpoint's
            #     {::Google::Cloud::AIPlatform::V1::Endpoint#traffic_split traffic_split} will be
            #     overwritten with it. To refer to the ID of the just being deployed Model, a
            #     "0" should be used, and the actual ID of the new DeployedModel will be
            #     filled in its place by this method. The traffic percentage values must add
            #     up to 100.
            #
            #     If this field is empty, then the Endpoint's
            #     {::Google::Cloud::AIPlatform::V1::Endpoint#traffic_split traffic_split} is not
            #     updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::EndpointService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::DeployModelRequest.new
            #
            #   # Call the deploy_model method.
            #   result = client.deploy_model request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def deploy_model request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeployModelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.deploy_model.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.endpoint
                header_params["endpoint"] = request.endpoint
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.deploy_model.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.deploy_model.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @endpoint_service_stub.call_rpc :deploy_model, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Undeploys a Model from an Endpoint, removing a DeployedModel from it, and
            # freeing all resources it's using.
            #
            # @overload undeploy_model(request, options = nil)
            #   Pass arguments to `undeploy_model` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::UndeployModelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::UndeployModelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload undeploy_model(endpoint: nil, deployed_model_id: nil, traffic_split: nil)
            #   Pass arguments to `undeploy_model` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param endpoint [::String]
            #     Required. The name of the Endpoint resource from which to undeploy a Model.
            #     Format:
            #     `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #   @param deployed_model_id [::String]
            #     Required. The ID of the DeployedModel to be undeployed from the Endpoint.
            #   @param traffic_split [::Hash{::String => ::Integer}]
            #     If this field is provided, then the Endpoint's
            #     {::Google::Cloud::AIPlatform::V1::Endpoint#traffic_split traffic_split} will be
            #     overwritten with it. If last DeployedModel is being undeployed from the
            #     Endpoint, the [Endpoint.traffic_split] will always end up empty when this
            #     call returns. A DeployedModel will be successfully undeployed only if it
            #     doesn't have any traffic assigned to it when this method executes, or if
            #     this field unassigns any traffic to it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::EndpointService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::UndeployModelRequest.new
            #
            #   # Call the undeploy_model method.
            #   result = client.undeploy_model request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def undeploy_model request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UndeployModelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.undeploy_model.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.endpoint
                header_params["endpoint"] = request.endpoint
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.undeploy_model.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.undeploy_model.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @endpoint_service_stub.call_rpc :undeploy_model, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing deployed model. Updatable fields include
            # `min_replica_count`, `max_replica_count`, `required_replica_count`,
            # `autoscaling_metric_specs`, `disable_container_logging` (v1 only), and
            # `enable_container_logging` (v1beta1 only).
            #
            # @overload mutate_deployed_model(request, options = nil)
            #   Pass arguments to `mutate_deployed_model` via a request object, either of type
            #   {::Google::Cloud::AIPlatform::V1::MutateDeployedModelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AIPlatform::V1::MutateDeployedModelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload mutate_deployed_model(endpoint: nil, deployed_model: nil, update_mask: nil)
            #   Pass arguments to `mutate_deployed_model` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param endpoint [::String]
            #     Required. The name of the Endpoint resource into which to mutate a
            #     DeployedModel. Format:
            #     `projects/{project}/locations/{location}/endpoints/{endpoint}`
            #   @param deployed_model [::Google::Cloud::AIPlatform::V1::DeployedModel, ::Hash]
            #     Required. The DeployedModel to be mutated within the Endpoint. Only the
            #     following fields can be mutated:
            #
            #     * `min_replica_count` in either
            #     {::Google::Cloud::AIPlatform::V1::DedicatedResources DedicatedResources} or
            #     {::Google::Cloud::AIPlatform::V1::AutomaticResources AutomaticResources}
            #     * `max_replica_count` in either
            #     {::Google::Cloud::AIPlatform::V1::DedicatedResources DedicatedResources} or
            #     {::Google::Cloud::AIPlatform::V1::AutomaticResources AutomaticResources}
            #     * `required_replica_count` in
            #     {::Google::Cloud::AIPlatform::V1::DedicatedResources DedicatedResources}
            #     * {::Google::Cloud::AIPlatform::V1::DedicatedResources#autoscaling_metric_specs autoscaling_metric_specs}
            #     * `disable_container_logging` (v1 only)
            #     * `enable_container_logging` (v1beta1 only)
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The update mask applies to the resource. See
            #     {::Google::Protobuf::FieldMask google.protobuf.FieldMask}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/ai_platform/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AIPlatform::V1::EndpointService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AIPlatform::V1::MutateDeployedModelRequest.new
            #
            #   # Call the mutate_deployed_model method.
            #   result = client.mutate_deployed_model request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def mutate_deployed_model request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::MutateDeployedModelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.mutate_deployed_model.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.endpoint
                header_params["endpoint"] = request.endpoint
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.mutate_deployed_model.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.mutate_deployed_model.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @endpoint_service_stub.call_rpc :mutate_deployed_model, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the EndpointService API.
            #
            # This class represents the configuration for EndpointService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::AIPlatform::V1::EndpointService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_endpoint to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::AIPlatform::V1::EndpointService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_endpoint.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::AIPlatform::V1::EndpointService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_endpoint.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::AIPlatform::V1::EndpointService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the EndpointService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_endpoint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_endpoint
                ##
                # RPC-specific configuration for `get_endpoint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_endpoint
                ##
                # RPC-specific configuration for `list_endpoints`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_endpoints
                ##
                # RPC-specific configuration for `update_endpoint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_endpoint
                ##
                # RPC-specific configuration for `update_endpoint_long_running`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_endpoint_long_running
                ##
                # RPC-specific configuration for `delete_endpoint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_endpoint
                ##
                # RPC-specific configuration for `deploy_model`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :deploy_model
                ##
                # RPC-specific configuration for `undeploy_model`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :undeploy_model
                ##
                # RPC-specific configuration for `mutate_deployed_model`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :mutate_deployed_model

                # @private
                def initialize parent_rpcs = nil
                  create_endpoint_config = parent_rpcs.create_endpoint if parent_rpcs.respond_to? :create_endpoint
                  @create_endpoint = ::Gapic::Config::Method.new create_endpoint_config
                  get_endpoint_config = parent_rpcs.get_endpoint if parent_rpcs.respond_to? :get_endpoint
                  @get_endpoint = ::Gapic::Config::Method.new get_endpoint_config
                  list_endpoints_config = parent_rpcs.list_endpoints if parent_rpcs.respond_to? :list_endpoints
                  @list_endpoints = ::Gapic::Config::Method.new list_endpoints_config
                  update_endpoint_config = parent_rpcs.update_endpoint if parent_rpcs.respond_to? :update_endpoint
                  @update_endpoint = ::Gapic::Config::Method.new update_endpoint_config
                  update_endpoint_long_running_config = parent_rpcs.update_endpoint_long_running if parent_rpcs.respond_to? :update_endpoint_long_running
                  @update_endpoint_long_running = ::Gapic::Config::Method.new update_endpoint_long_running_config
                  delete_endpoint_config = parent_rpcs.delete_endpoint if parent_rpcs.respond_to? :delete_endpoint
                  @delete_endpoint = ::Gapic::Config::Method.new delete_endpoint_config
                  deploy_model_config = parent_rpcs.deploy_model if parent_rpcs.respond_to? :deploy_model
                  @deploy_model = ::Gapic::Config::Method.new deploy_model_config
                  undeploy_model_config = parent_rpcs.undeploy_model if parent_rpcs.respond_to? :undeploy_model
                  @undeploy_model = ::Gapic::Config::Method.new undeploy_model_config
                  mutate_deployed_model_config = parent_rpcs.mutate_deployed_model if parent_rpcs.respond_to? :mutate_deployed_model
                  @mutate_deployed_model = ::Gapic::Config::Method.new mutate_deployed_model_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
