# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        module DeploymentResourcePoolService
          # Path helper methods for the DeploymentResourcePoolService API.
          module Paths
            ##
            # Create a fully-qualified DeploymentResourcePool resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
            #
            # @param project [String]
            # @param location [String]
            # @param deployment_resource_pool [String]
            #
            # @return [::String]
            def deployment_resource_pool_path project:, location:, deployment_resource_pool:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/deploymentResourcePools/#{deployment_resource_pool}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Project resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_path project:
              "projects/#{project}"
            end

            ##
            # Create a fully-qualified Reservation resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project_id_or_number}/zones/{zone}/reservations/{reservation_name}`
            #
            # @param project_id_or_number [String]
            # @param zone [String]
            # @param reservation_name [String]
            #
            # @return [::String]
            def reservation_path project_id_or_number:, zone:, reservation_name:
              raise ::ArgumentError, "project_id_or_number cannot contain /" if project_id_or_number.to_s.include? "/"
              raise ::ArgumentError, "zone cannot contain /" if zone.to_s.include? "/"

              "projects/#{project_id_or_number}/zones/#{zone}/reservations/#{reservation_name}"
            end

            extend self
          end
        end
      end
    end
  end
end
