# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/aiplatform/v1/dataset_service_pb"
require "google/cloud/ai_platform/v1/dataset_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module AIPlatform
      module V1
        module DatasetService
          module Rest
            ##
            # REST client for the DatasetService service.
            #
            # The service that manages Vertex AI Dataset and its child resources.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "aiplatform.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :dataset_service_stub

              ##
              # Configure the DatasetService Client class.
              #
              # See {::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all DatasetService clients
              #   ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "AIPlatform", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the DatasetService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @dataset_service_stub.universe_domain
              end

              ##
              # Create a new DatasetService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the DatasetService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @dataset_service_stub = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @dataset_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @dataset_service_stub.endpoint
                  config.universe_domain = @dataset_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @dataset_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @dataset_service_stub.endpoint
                  config.universe_domain = @dataset_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @dataset_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @dataset_service_stub.logger
              end

              # Service calls

              ##
              # Creates a Dataset.
              #
              # @overload create_dataset(request, options = nil)
              #   Pass arguments to `create_dataset` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::CreateDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::CreateDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_dataset(parent: nil, dataset: nil)
              #   Pass arguments to `create_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Location to create the Dataset in.
              #     Format: `projects/{project}/locations/{location}`
              #   @param dataset [::Google::Cloud::AIPlatform::V1::Dataset, ::Hash]
              #     Required. The Dataset to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::CreateDatasetRequest.new
              #
              #   # Call the create_dataset method.
              #   result = client.create_dataset request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.create_dataset request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a Dataset.
              #
              # @overload get_dataset(request, options = nil)
              #   Pass arguments to `get_dataset` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::GetDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::GetDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_dataset(name: nil, read_mask: nil)
              #   Pass arguments to `get_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Dataset resource.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask specifying which fields to read.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::Dataset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::Dataset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::GetDatasetRequest.new
              #
              #   # Call the get_dataset method.
              #   result = client.get_dataset request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::Dataset.
              #   p result
              #
              def get_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.get_dataset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a Dataset.
              #
              # @overload update_dataset(request, options = nil)
              #   Pass arguments to `update_dataset` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::UpdateDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::UpdateDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_dataset(dataset: nil, update_mask: nil)
              #   Pass arguments to `update_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param dataset [::Google::Cloud::AIPlatform::V1::Dataset, ::Hash]
              #     Required. The Dataset which replaces the resource on the server.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The update mask applies to the resource.
              #     For the `FieldMask` definition, see
              #     {::Google::Protobuf::FieldMask google.protobuf.FieldMask}. Updatable fields:
              #
              #       * `display_name`
              #       * `description`
              #       * `labels`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::Dataset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::Dataset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::UpdateDatasetRequest.new
              #
              #   # Call the update_dataset method.
              #   result = client.update_dataset request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::Dataset.
              #   p result
              #
              def update_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.update_dataset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Datasets in a Location.
              #
              # @overload list_datasets(request, options = nil)
              #   Pass arguments to `list_datasets` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListDatasetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListDatasetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_datasets(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil, order_by: nil)
              #   Pass arguments to `list_datasets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the Dataset's parent resource.
              #     Format: `projects/{project}/locations/{location}`
              #   @param filter [::String]
              #     An expression for filtering the results of the request. For field names
              #     both snake_case and camelCase are supported.
              #
              #       * `display_name`: supports = and !=
              #       * `metadata_schema_uri`: supports = and !=
              #       * `labels` supports general map functions that is:
              #         * `labels.key=value` - key:value equality
              #         * `labels.key:* or labels:key - key existence
              #         * A key including a space must be quoted. `labels."a key"`.
              #
              #     Some examples:
              #
              #       * `displayName="myDisplayName"`
              #       * `labels.myKey="myValue"`
              #   @param page_size [::Integer]
              #     The standard list page size.
              #   @param page_token [::String]
              #     The standard list page token.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask specifying which fields to read.
              #   @param order_by [::String]
              #     A comma-separated list of fields to order by, sorted in ascending order.
              #     Use "desc" after a field name for descending.
              #     Supported fields:
              #
              #       * `display_name`
              #       * `create_time`
              #       * `update_time`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Dataset>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Dataset>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListDatasetsRequest.new
              #
              #   # Call the list_datasets method.
              #   result = client.list_datasets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Dataset.
              #     p item
              #   end
              #
              def list_datasets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListDatasetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_datasets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_datasets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_datasets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.list_datasets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataset_service_stub, :list_datasets, "datasets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a Dataset.
              #
              # @overload delete_dataset(request, options = nil)
              #   Pass arguments to `delete_dataset` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::DeleteDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::DeleteDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_dataset(name: nil)
              #   Pass arguments to `delete_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the Dataset to delete.
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::DeleteDatasetRequest.new
              #
              #   # Call the delete_dataset method.
              #   result = client.delete_dataset request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.delete_dataset request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Imports data into a Dataset.
              #
              # @overload import_data(request, options = nil)
              #   Pass arguments to `import_data` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ImportDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ImportDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_data(name: nil, import_configs: nil)
              #   Pass arguments to `import_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Dataset resource.
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}`
              #   @param import_configs [::Array<::Google::Cloud::AIPlatform::V1::ImportDataConfig, ::Hash>]
              #     Required. The desired input locations. The contents of all input locations
              #     will be imported in one batch.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ImportDataRequest.new
              #
              #   # Call the import_data method.
              #   result = client.import_data request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ImportDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.import_data request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports data from a Dataset.
              #
              # @overload export_data(request, options = nil)
              #   Pass arguments to `export_data` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ExportDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ExportDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_data(name: nil, export_config: nil)
              #   Pass arguments to `export_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Dataset resource.
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}`
              #   @param export_config [::Google::Cloud::AIPlatform::V1::ExportDataConfig, ::Hash]
              #     Required. The desired output location.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ExportDataRequest.new
              #
              #   # Call the export_data method.
              #   result = client.export_data request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ExportDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.export_data request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a version from a Dataset.
              #
              # @overload create_dataset_version(request, options = nil)
              #   Pass arguments to `create_dataset_version` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::CreateDatasetVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::CreateDatasetVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_dataset_version(parent: nil, dataset_version: nil)
              #   Pass arguments to `create_dataset_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the Dataset resource.
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}`
              #   @param dataset_version [::Google::Cloud::AIPlatform::V1::DatasetVersion, ::Hash]
              #     Required. The version to be created. The same CMEK policies with the
              #     original Dataset will be applied the dataset version. So here we don't need
              #     to specify the EncryptionSpecType here.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::CreateDatasetVersionRequest.new
              #
              #   # Call the create_dataset_version method.
              #   result = client.create_dataset_version request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_dataset_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::CreateDatasetVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_dataset_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_dataset_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_dataset_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.create_dataset_version request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a DatasetVersion.
              #
              # @overload update_dataset_version(request, options = nil)
              #   Pass arguments to `update_dataset_version` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::UpdateDatasetVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::UpdateDatasetVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_dataset_version(dataset_version: nil, update_mask: nil)
              #   Pass arguments to `update_dataset_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param dataset_version [::Google::Cloud::AIPlatform::V1::DatasetVersion, ::Hash]
              #     Required. The DatasetVersion which replaces the resource on the server.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The update mask applies to the resource.
              #     For the `FieldMask` definition, see
              #     {::Google::Protobuf::FieldMask google.protobuf.FieldMask}. Updatable fields:
              #
              #       * `display_name`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::DatasetVersion]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::DatasetVersion]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::UpdateDatasetVersionRequest.new
              #
              #   # Call the update_dataset_version method.
              #   result = client.update_dataset_version request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::DatasetVersion.
              #   p result
              #
              def update_dataset_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::UpdateDatasetVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_dataset_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_dataset_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_dataset_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.update_dataset_version request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a Dataset version.
              #
              # @overload delete_dataset_version(request, options = nil)
              #   Pass arguments to `delete_dataset_version` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::DeleteDatasetVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::DeleteDatasetVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_dataset_version(name: nil)
              #   Pass arguments to `delete_dataset_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the Dataset version to delete.
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::DeleteDatasetVersionRequest.new
              #
              #   # Call the delete_dataset_version method.
              #   result = client.delete_dataset_version request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_dataset_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteDatasetVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_dataset_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_dataset_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_dataset_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.delete_dataset_version request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a Dataset version.
              #
              # @overload get_dataset_version(request, options = nil)
              #   Pass arguments to `get_dataset_version` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::GetDatasetVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::GetDatasetVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_dataset_version(name: nil, read_mask: nil)
              #   Pass arguments to `get_dataset_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the Dataset version to delete.
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}`
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask specifying which fields to read.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::DatasetVersion]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::DatasetVersion]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::GetDatasetVersionRequest.new
              #
              #   # Call the get_dataset_version method.
              #   result = client.get_dataset_version request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::DatasetVersion.
              #   p result
              #
              def get_dataset_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetDatasetVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_dataset_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_dataset_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_dataset_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.get_dataset_version request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists DatasetVersions in a Dataset.
              #
              # @overload list_dataset_versions(request, options = nil)
              #   Pass arguments to `list_dataset_versions` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListDatasetVersionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListDatasetVersionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_dataset_versions(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil, order_by: nil)
              #   Pass arguments to `list_dataset_versions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Dataset to list DatasetVersions from.
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}`
              #   @param filter [::String]
              #     Optional. The standard list filter.
              #   @param page_size [::Integer]
              #     Optional. The standard list page size.
              #   @param page_token [::String]
              #     Optional. The standard list page token.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Mask specifying which fields to read.
              #   @param order_by [::String]
              #     Optional. A comma-separated list of fields to order by, sorted in ascending
              #     order. Use "desc" after a field name for descending.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::DatasetVersion>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::DatasetVersion>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListDatasetVersionsRequest.new
              #
              #   # Call the list_dataset_versions method.
              #   result = client.list_dataset_versions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::DatasetVersion.
              #     p item
              #   end
              #
              def list_dataset_versions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListDatasetVersionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_dataset_versions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_dataset_versions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_dataset_versions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.list_dataset_versions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataset_service_stub, :list_dataset_versions, "dataset_versions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Restores a dataset version.
              #
              # @overload restore_dataset_version(request, options = nil)
              #   Pass arguments to `restore_dataset_version` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::RestoreDatasetVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::RestoreDatasetVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload restore_dataset_version(name: nil)
              #   Pass arguments to `restore_dataset_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DatasetVersion resource.
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::RestoreDatasetVersionRequest.new
              #
              #   # Call the restore_dataset_version method.
              #   result = client.restore_dataset_version request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def restore_dataset_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::RestoreDatasetVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.restore_dataset_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.restore_dataset_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.restore_dataset_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.restore_dataset_version request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists DataItems in a Dataset.
              #
              # @overload list_data_items(request, options = nil)
              #   Pass arguments to `list_data_items` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListDataItemsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListDataItemsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_data_items(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil, order_by: nil)
              #   Pass arguments to `list_data_items` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Dataset to list DataItems from.
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}`
              #   @param filter [::String]
              #     The standard list filter.
              #   @param page_size [::Integer]
              #     The standard list page size.
              #   @param page_token [::String]
              #     The standard list page token.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask specifying which fields to read.
              #   @param order_by [::String]
              #     A comma-separated list of fields to order by, sorted in ascending order.
              #     Use "desc" after a field name for descending.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::DataItem>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::DataItem>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListDataItemsRequest.new
              #
              #   # Call the list_data_items method.
              #   result = client.list_data_items request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::DataItem.
              #     p item
              #   end
              #
              def list_data_items request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListDataItemsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_data_items.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_data_items.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_data_items.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.list_data_items request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataset_service_stub, :list_data_items, "data_items", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Searches DataItems in a Dataset.
              #
              # @overload search_data_items(request, options = nil)
              #   Pass arguments to `search_data_items` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::SearchDataItemsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::SearchDataItemsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_data_items(order_by_data_item: nil, order_by_annotation: nil, dataset: nil, saved_query: nil, data_labeling_job: nil, data_item_filter: nil, annotations_filter: nil, annotation_filters: nil, field_mask: nil, annotations_limit: nil, page_size: nil, order_by: nil, page_token: nil)
              #   Pass arguments to `search_data_items` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param order_by_data_item [::String]
              #     A comma-separated list of data item fields to order by, sorted in
              #     ascending order. Use "desc" after a field name for descending.
              #
              #     Note: The following parameters are mutually exclusive: `order_by_data_item`, `order_by_annotation`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param order_by_annotation [::Google::Cloud::AIPlatform::V1::SearchDataItemsRequest::OrderByAnnotation, ::Hash]
              #     Expression that allows ranking results based on annotation's property.
              #
              #     Note: The following parameters are mutually exclusive: `order_by_annotation`, `order_by_data_item`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param dataset [::String]
              #     Required. The resource name of the Dataset from which to search DataItems.
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}`
              #   @param saved_query [::String]
              #     The resource name of a SavedQuery(annotation set in UI).
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
              #     All of the search will be done in the context of this SavedQuery.
              #   @param data_labeling_job [::String]
              #     The resource name of a DataLabelingJob.
              #     Format:
              #     `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
              #     If this field is set, all of the search will be done in the context of
              #     this DataLabelingJob.
              #   @param data_item_filter [::String]
              #     An expression for filtering the DataItem that will be returned.
              #
              #       * `data_item_id` - for = or !=.
              #       * `labeled` - for = or !=.
              #       * `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that
              #         have at least one annotation with annotation_spec_id =
              #         `ANNOTATION_SPEC_ID` in the context of SavedQuery or DataLabelingJob.
              #
              #     For example:
              #
              #     * `data_item=1`
              #     * `has_annotation(5)`
              #   @param annotations_filter [::String]
              #     An expression for filtering the Annotations that will be returned per
              #     DataItem.
              #       * `annotation_spec_id` - for = or !=.
              #   @param annotation_filters [::Array<::String>]
              #     An expression that specifies what Annotations will be returned per
              #     DataItem. Annotations satisfied either of the conditions will be returned.
              #       * `annotation_spec_id` - for = or !=.
              #     Must specify `saved_query_id=` - saved query id that annotations should
              #     belong to.
              #   @param field_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask specifying which fields of
              #     {::Google::Cloud::AIPlatform::V1::DataItemView DataItemView} to read.
              #   @param annotations_limit [::Integer]
              #     If set, only up to this many of Annotations will be returned per
              #     DataItemView. The maximum value is 1000. If not set, the maximum value will
              #     be used.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer results than requested.
              #     Default and maximum page size is 100.
              #   @param order_by [::String]
              #     A comma-separated list of fields to order by, sorted in ascending order.
              #     Use "desc" after a field name for descending.
              #   @param page_token [::String]
              #     A token identifying a page of results for the server to return
              #     Typically obtained via
              #     {::Google::Cloud::AIPlatform::V1::SearchDataItemsResponse#next_page_token SearchDataItemsResponse.next_page_token}
              #     of the previous
              #     {::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client#search_data_items DatasetService.SearchDataItems}
              #     call.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::DataItemView>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::DataItemView>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::SearchDataItemsRequest.new
              #
              #   # Call the search_data_items method.
              #   result = client.search_data_items request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::DataItemView.
              #     p item
              #   end
              #
              def search_data_items request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::SearchDataItemsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_data_items.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_data_items.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_data_items.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.search_data_items request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataset_service_stub, :search_data_items, "data_item_views", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists SavedQueries in a Dataset.
              #
              # @overload list_saved_queries(request, options = nil)
              #   Pass arguments to `list_saved_queries` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListSavedQueriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListSavedQueriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_saved_queries(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil, order_by: nil)
              #   Pass arguments to `list_saved_queries` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Dataset to list SavedQueries from.
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}`
              #   @param filter [::String]
              #     The standard list filter.
              #   @param page_size [::Integer]
              #     The standard list page size.
              #   @param page_token [::String]
              #     The standard list page token.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask specifying which fields to read.
              #   @param order_by [::String]
              #     A comma-separated list of fields to order by, sorted in ascending order.
              #     Use "desc" after a field name for descending.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::SavedQuery>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::SavedQuery>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListSavedQueriesRequest.new
              #
              #   # Call the list_saved_queries method.
              #   result = client.list_saved_queries request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::SavedQuery.
              #     p item
              #   end
              #
              def list_saved_queries request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListSavedQueriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_saved_queries.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_saved_queries.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_saved_queries.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.list_saved_queries request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataset_service_stub, :list_saved_queries, "saved_queries", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a SavedQuery.
              #
              # @overload delete_saved_query(request, options = nil)
              #   Pass arguments to `delete_saved_query` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::DeleteSavedQueryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::DeleteSavedQueryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_saved_query(name: nil)
              #   Pass arguments to `delete_saved_query` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the SavedQuery to delete.
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::DeleteSavedQueryRequest.new
              #
              #   # Call the delete_saved_query method.
              #   result = client.delete_saved_query request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_saved_query request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::DeleteSavedQueryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_saved_query.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_saved_query.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_saved_query.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.delete_saved_query request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an AnnotationSpec.
              #
              # @overload get_annotation_spec(request, options = nil)
              #   Pass arguments to `get_annotation_spec` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::GetAnnotationSpecRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::GetAnnotationSpecRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_annotation_spec(name: nil, read_mask: nil)
              #   Pass arguments to `get_annotation_spec` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the AnnotationSpec resource.
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}/annotationSpecs/{annotation_spec}`
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask specifying which fields to read.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AIPlatform::V1::AnnotationSpec]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AIPlatform::V1::AnnotationSpec]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::GetAnnotationSpecRequest.new
              #
              #   # Call the get_annotation_spec method.
              #   result = client.get_annotation_spec request
              #
              #   # The returned object is of type Google::Cloud::AIPlatform::V1::AnnotationSpec.
              #   p result
              #
              def get_annotation_spec request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::GetAnnotationSpecRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_annotation_spec.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_annotation_spec.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_annotation_spec.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.get_annotation_spec request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Annotations belongs to a dataitem
              # This RPC is only available in InternalDatasetService. It is only used for
              # exporting conversation data to CCAI Insights.
              #
              # @overload list_annotations(request, options = nil)
              #   Pass arguments to `list_annotations` via a request object, either of type
              #   {::Google::Cloud::AIPlatform::V1::ListAnnotationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AIPlatform::V1::ListAnnotationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_annotations(parent: nil, filter: nil, page_size: nil, page_token: nil, read_mask: nil, order_by: nil)
              #   Pass arguments to `list_annotations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the DataItem to list Annotations from.
              #     Format:
              #     `projects/{project}/locations/{location}/datasets/{dataset}/dataItems/{data_item}`
              #   @param filter [::String]
              #     The standard list filter.
              #   @param page_size [::Integer]
              #     The standard list page size.
              #   @param page_token [::String]
              #     The standard list page token.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask specifying which fields to read.
              #   @param order_by [::String]
              #     A comma-separated list of fields to order by, sorted in ascending order.
              #     Use "desc" after a field name for descending.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Annotation>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AIPlatform::V1::Annotation>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ai_platform/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AIPlatform::V1::ListAnnotationsRequest.new
              #
              #   # Call the list_annotations method.
              #   result = client.list_annotations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AIPlatform::V1::Annotation.
              #     p item
              #   end
              #
              def list_annotations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AIPlatform::V1::ListAnnotationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_annotations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AIPlatform::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_annotations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_annotations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataset_service_stub.list_annotations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataset_service_stub, :list_annotations, "annotations", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the DatasetService REST API.
              #
              # This class represents the configuration for DatasetService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_dataset to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_dataset.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_dataset.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "aiplatform.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the DatasetService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_dataset
                  ##
                  # RPC-specific configuration for `get_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_dataset
                  ##
                  # RPC-specific configuration for `update_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_dataset
                  ##
                  # RPC-specific configuration for `list_datasets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_datasets
                  ##
                  # RPC-specific configuration for `delete_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_dataset
                  ##
                  # RPC-specific configuration for `import_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_data
                  ##
                  # RPC-specific configuration for `export_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_data
                  ##
                  # RPC-specific configuration for `create_dataset_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_dataset_version
                  ##
                  # RPC-specific configuration for `update_dataset_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_dataset_version
                  ##
                  # RPC-specific configuration for `delete_dataset_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_dataset_version
                  ##
                  # RPC-specific configuration for `get_dataset_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_dataset_version
                  ##
                  # RPC-specific configuration for `list_dataset_versions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_dataset_versions
                  ##
                  # RPC-specific configuration for `restore_dataset_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :restore_dataset_version
                  ##
                  # RPC-specific configuration for `list_data_items`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_data_items
                  ##
                  # RPC-specific configuration for `search_data_items`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_data_items
                  ##
                  # RPC-specific configuration for `list_saved_queries`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_saved_queries
                  ##
                  # RPC-specific configuration for `delete_saved_query`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_saved_query
                  ##
                  # RPC-specific configuration for `get_annotation_spec`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_annotation_spec
                  ##
                  # RPC-specific configuration for `list_annotations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_annotations

                  # @private
                  def initialize parent_rpcs = nil
                    create_dataset_config = parent_rpcs.create_dataset if parent_rpcs.respond_to? :create_dataset
                    @create_dataset = ::Gapic::Config::Method.new create_dataset_config
                    get_dataset_config = parent_rpcs.get_dataset if parent_rpcs.respond_to? :get_dataset
                    @get_dataset = ::Gapic::Config::Method.new get_dataset_config
                    update_dataset_config = parent_rpcs.update_dataset if parent_rpcs.respond_to? :update_dataset
                    @update_dataset = ::Gapic::Config::Method.new update_dataset_config
                    list_datasets_config = parent_rpcs.list_datasets if parent_rpcs.respond_to? :list_datasets
                    @list_datasets = ::Gapic::Config::Method.new list_datasets_config
                    delete_dataset_config = parent_rpcs.delete_dataset if parent_rpcs.respond_to? :delete_dataset
                    @delete_dataset = ::Gapic::Config::Method.new delete_dataset_config
                    import_data_config = parent_rpcs.import_data if parent_rpcs.respond_to? :import_data
                    @import_data = ::Gapic::Config::Method.new import_data_config
                    export_data_config = parent_rpcs.export_data if parent_rpcs.respond_to? :export_data
                    @export_data = ::Gapic::Config::Method.new export_data_config
                    create_dataset_version_config = parent_rpcs.create_dataset_version if parent_rpcs.respond_to? :create_dataset_version
                    @create_dataset_version = ::Gapic::Config::Method.new create_dataset_version_config
                    update_dataset_version_config = parent_rpcs.update_dataset_version if parent_rpcs.respond_to? :update_dataset_version
                    @update_dataset_version = ::Gapic::Config::Method.new update_dataset_version_config
                    delete_dataset_version_config = parent_rpcs.delete_dataset_version if parent_rpcs.respond_to? :delete_dataset_version
                    @delete_dataset_version = ::Gapic::Config::Method.new delete_dataset_version_config
                    get_dataset_version_config = parent_rpcs.get_dataset_version if parent_rpcs.respond_to? :get_dataset_version
                    @get_dataset_version = ::Gapic::Config::Method.new get_dataset_version_config
                    list_dataset_versions_config = parent_rpcs.list_dataset_versions if parent_rpcs.respond_to? :list_dataset_versions
                    @list_dataset_versions = ::Gapic::Config::Method.new list_dataset_versions_config
                    restore_dataset_version_config = parent_rpcs.restore_dataset_version if parent_rpcs.respond_to? :restore_dataset_version
                    @restore_dataset_version = ::Gapic::Config::Method.new restore_dataset_version_config
                    list_data_items_config = parent_rpcs.list_data_items if parent_rpcs.respond_to? :list_data_items
                    @list_data_items = ::Gapic::Config::Method.new list_data_items_config
                    search_data_items_config = parent_rpcs.search_data_items if parent_rpcs.respond_to? :search_data_items
                    @search_data_items = ::Gapic::Config::Method.new search_data_items_config
                    list_saved_queries_config = parent_rpcs.list_saved_queries if parent_rpcs.respond_to? :list_saved_queries
                    @list_saved_queries = ::Gapic::Config::Method.new list_saved_queries_config
                    delete_saved_query_config = parent_rpcs.delete_saved_query if parent_rpcs.respond_to? :delete_saved_query
                    @delete_saved_query = ::Gapic::Config::Method.new delete_saved_query_config
                    get_annotation_spec_config = parent_rpcs.get_annotation_spec if parent_rpcs.respond_to? :get_annotation_spec
                    @get_annotation_spec = ::Gapic::Config::Method.new get_annotation_spec_config
                    list_annotations_config = parent_rpcs.list_annotations if parent_rpcs.respond_to? :list_annotations
                    @list_annotations = ::Gapic::Config::Method.new list_annotations_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
