# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        module DatasetService
          # Path helper methods for the DatasetService API.
          module Paths
            ##
            # Create a fully-qualified AnnotationSpec resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/datasets/{dataset}/annotationSpecs/{annotation_spec}`
            #
            # @param project [String]
            # @param location [String]
            # @param dataset [String]
            # @param annotation_spec [String]
            #
            # @return [::String]
            def annotation_spec_path project:, location:, dataset:, annotation_spec:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "dataset cannot contain /" if dataset.to_s.include? "/"

              "projects/#{project}/locations/#{location}/datasets/#{dataset}/annotationSpecs/#{annotation_spec}"
            end

            ##
            # Create a fully-qualified DataItem resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/datasets/{dataset}/dataItems/{data_item}`
            #
            # @param project [String]
            # @param location [String]
            # @param dataset [String]
            # @param data_item [String]
            #
            # @return [::String]
            def data_item_path project:, location:, dataset:, data_item:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "dataset cannot contain /" if dataset.to_s.include? "/"

              "projects/#{project}/locations/#{location}/datasets/#{dataset}/dataItems/#{data_item}"
            end

            ##
            # Create a fully-qualified Dataset resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/datasets/{dataset}`
            #
            # @param project [String]
            # @param location [String]
            # @param dataset [String]
            #
            # @return [::String]
            def dataset_path project:, location:, dataset:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/datasets/#{dataset}"
            end

            ##
            # Create a fully-qualified DatasetVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}`
            #
            # @param project [String]
            # @param location [String]
            # @param dataset [String]
            # @param dataset_version [String]
            #
            # @return [::String]
            def dataset_version_path project:, location:, dataset:, dataset_version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "dataset cannot contain /" if dataset.to_s.include? "/"

              "projects/#{project}/locations/#{location}/datasets/#{dataset}/datasetVersions/#{dataset_version}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified SavedQuery resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
            #
            # @param project [String]
            # @param location [String]
            # @param dataset [String]
            # @param saved_query [String]
            #
            # @return [::String]
            def saved_query_path project:, location:, dataset:, saved_query:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "dataset cannot contain /" if dataset.to_s.include? "/"

              "projects/#{project}/locations/#{location}/datasets/#{dataset}/savedQueries/#{saved_query}"
            end

            extend self
          end
        end
      end
    end
  end
end
