# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AdvisoryNotifications
      module V1
        # A notification object for notifying customers about security and privacy
        # issues.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the notification.
        #     Format:
        #     organizations/\\{organization}/locations/\\{location}/notifications/\\{notification}
        #     or projects/\\{project}/locations/\\{location}/notifications/\\{notification}.
        # @!attribute [rw] subject
        #   @return [::Google::Cloud::AdvisoryNotifications::V1::Subject]
        #     The subject line of the notification.
        # @!attribute [rw] messages
        #   @return [::Array<::Google::Cloud::AdvisoryNotifications::V1::Message>]
        #     A list of messages in the notification.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the notification was created.
        # @!attribute [rw] notification_type
        #   @return [::Google::Cloud::AdvisoryNotifications::V1::NotificationType]
        #     Type of notification
        class Notification
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A text object containing the English text and its localized copies.
        # @!attribute [rw] en_text
        #   @return [::String]
        #     The English copy.
        # @!attribute [rw] localized_text
        #   @return [::String]
        #     The requested localized copy (if applicable).
        # @!attribute [rw] localization_state
        #   @return [::Google::Cloud::AdvisoryNotifications::V1::LocalizationState]
        #     Status of the localization.
        class Text
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A subject line of a notification.
        # @!attribute [rw] text
        #   @return [::Google::Cloud::AdvisoryNotifications::V1::Text]
        #     The text content.
        class Subject
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message which contains notification details.
        # @!attribute [rw] body
        #   @return [::Google::Cloud::AdvisoryNotifications::V1::Message::Body]
        #     The message content.
        # @!attribute [rw] attachments
        #   @return [::Array<::Google::Cloud::AdvisoryNotifications::V1::Attachment>]
        #     The attachments to download.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The Message creation timestamp.
        # @!attribute [rw] localization_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when Message was localized
        class Message
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A message body containing text.
          # @!attribute [rw] text
          #   @return [::Google::Cloud::AdvisoryNotifications::V1::Text]
          #     The text content of the message body.
          class Body
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Attachment with specific information about the issue.
        # @!attribute [rw] csv
        #   @return [::Google::Cloud::AdvisoryNotifications::V1::Csv]
        #     A CSV file attachment. Max size is 10 MB.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The title of the attachment.
        class Attachment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A representation of a CSV file attachment, as a list of column headers and
        # a list of data rows.
        # @!attribute [rw] headers
        #   @return [::Array<::String>]
        #     The list of headers for data columns in a CSV file.
        # @!attribute [rw] data_rows
        #   @return [::Array<::Google::Cloud::AdvisoryNotifications::V1::Csv::CsvRow>]
        #     The list of data rows in a CSV file, as string arrays rather than as a
        #     single comma-separated string.
        class Csv
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A representation of a single data row in a CSV file.
          # @!attribute [rw] entries
          #   @return [::Array<::String>]
          #     The data entries in a CSV file row, as a string array rather than a
          #     single comma-separated string.
          class CsvRow
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for fetching all notifications for a given parent.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of notifications.
        #     Must be of the form "organizations/\\{organization}/locations/\\{location}"
        #     or "projects/\\{project}/locations/\\{location}".
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of notifications to return. The service may return
        #     fewer than this value. If unspecified or equal to 0, at most 50
        #     notifications will be returned. The maximum value is 50; values above 50
        #     will be coerced to 50.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token returned from a previous request.
        #     When paginating, all other parameters provided in the request
        #     must match the call that returned the page token.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::AdvisoryNotifications::V1::NotificationView]
        #     Specifies which parts of the notification resource should be returned
        #     in the response.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     ISO code for requested localization language.  If unset, will be
        #     interpereted as "en". If the requested language is valid, but not supported
        #     for this notification, English will be returned with an "Not applicable"
        #     LocalizationState. If the ISO code is invalid (i.e. not a real language),
        #     this RPC will throw an error.
        class ListNotificationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of ListNotifications endpoint.
        # @!attribute [rw] notifications
        #   @return [::Array<::Google::Cloud::AdvisoryNotifications::V1::Notification>]
        #     List of notifications under a given parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     Estimation of a total number of notifications.
        class ListNotificationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for fetching a notification.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the notification to retrieve.
        #     Format:
        #     organizations/\\{organization}/locations/\\{location}/notifications/\\{notification}
        #     or projects/\\{projects}/locations/\\{location}/notifications/\\{notification}.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     ISO code for requested localization language. If unset, will be
        #     interpereted as "en". If the requested language is valid, but not supported
        #     for this notification, English will be returned with an "Not applicable"
        #     LocalizationState. If the ISO code is invalid (i.e. not a real language),
        #     this RPC will throw an error.
        class GetNotificationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings for Advisory Notifications.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the settings to retrieve.
        #     Format:
        #     organizations/\\{organization}/locations/\\{location}/settings or
        #     projects/\\{projects}/locations/\\{location}/settings.
        # @!attribute [rw] notification_settings
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::AdvisoryNotifications::V1::NotificationSettings}]
        #     Required. Map of each notification type and its settings to get/set all
        #     settings at once. The server will validate the value for each notification
        #     type.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Required. Fingerprint for optimistic concurrency returned in Get requests.
        #     Must be provided for Update requests. If the value provided does not match
        #     the value known to the server, ABORTED will be thrown, and the client
        #     should retry the read-modify-write cycle.
        class Settings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::AdvisoryNotifications::V1::NotificationSettings]
          class NotificationSettingsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Settings for each NotificationType.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether the associated NotificationType is enabled.
        class NotificationSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request of GetSettings endpoint.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the settings to retrieve.
        #     Format:
        #     organizations/\\{organization}/locations/\\{location}/settings or
        #     projects/\\{projects}/locations/\\{location}/settings.
        class GetSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request of UpdateSettings endpoint.
        # @!attribute [rw] settings
        #   @return [::Google::Cloud::AdvisoryNotifications::V1::Settings]
        #     Required. New settings.
        class UpdateSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Notification view.
        module NotificationView
          # Not specified, equivalent to BASIC.
          NOTIFICATION_VIEW_UNSPECIFIED = 0

          # Server responses only include title, creation time and Notification ID.
          # Note: for internal use responses also include the last update time,
          # the latest message text and whether notification has attachments.
          BASIC = 1

          # Include everything.
          FULL = 2
        end

        # Status of localized text.
        module LocalizationState
          # Not used.
          LOCALIZATION_STATE_UNSPECIFIED = 0

          # Localization is not applicable for requested language. This can happen
          # when:
          # - The requested language was not supported by Advisory Notifications at the
          # time of localization (including notifications created before the
          # localization feature was launched).
          # - The requested language is English, so only the English text is returned.
          LOCALIZATION_STATE_NOT_APPLICABLE = 1

          # Localization for requested language is in progress, and not ready yet.
          LOCALIZATION_STATE_PENDING = 2

          # Localization for requested language is completed.
          LOCALIZATION_STATE_COMPLETED = 3
        end

        # Type of notification
        module NotificationType
          # Default type
          NOTIFICATION_TYPE_UNSPECIFIED = 0

          # Security and privacy advisory notifications
          NOTIFICATION_TYPE_SECURITY_PRIVACY_ADVISORY = 1

          # Sensitive action notifications
          NOTIFICATION_TYPE_SENSITIVE_ACTIONS = 2

          # General security MSA
          NOTIFICATION_TYPE_SECURITY_MSA = 3

          # Threat horizons MSA
          NOTIFICATION_TYPE_THREAT_HORIZONS = 4
        end
      end
    end
  end
end
