# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AdvisoryNotifications
      module V1
        module AdvisoryNotificationsService
          # Path helper methods for the AdvisoryNotificationsService API.
          module Paths
            ##
            # Create a fully-qualified Location resource string.
            #
            # @overload location_path(organization:, location:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}`
            #
            #   @param organization [String]
            #   @param location [String]
            #
            # @overload location_path(project:, location:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}`
            #
            #   @param project [String]
            #   @param location [String]
            #
            # @return [::String]
            def location_path **args
              resources = {
                "location:organization" => (proc do |organization:, location:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}"
                end),
                "location:project" => (proc do |project:, location:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/locations/#{location}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Notification resource string.
            #
            # @overload notification_path(organization:, location:, notification:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/notifications/{notification}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param notification [String]
            #
            # @overload notification_path(project:, location:, notification:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/notifications/{notification}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param notification [String]
            #
            # @return [::String]
            def notification_path **args
              resources = {
                "location:notification:organization" => (proc do |organization:, location:, notification:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/notifications/#{notification}"
                end),
                "location:notification:project" => (proc do |project:, location:, notification:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/notifications/#{notification}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Settings resource string.
            #
            # @overload settings_path(organization:, location:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/settings`
            #
            #   @param organization [String]
            #   @param location [String]
            #
            # @overload settings_path(project:, location:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/settings`
            #
            #   @param project [String]
            #   @param location [String]
            #
            # @return [::String]
            def settings_path **args
              resources = {
                "location:organization" => (proc do |organization:, location:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/settings"
                end),
                "location:project" => (proc do |project:, location:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/settings"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            extend self
          end
        end
      end
    end
  end
end
