# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/accessapproval/v1/accessapproval_pb"
require "google/cloud/access_approval/v1/access_approval/rest"


class ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_approval_requests
    # Create test objects.
    client_result = ::Google::Cloud::AccessApproval::V1::ListApprovalRequestsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_approval_requests_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::ServiceStub.stub :transcode_list_approval_requests_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_approval_requests_client_stub do
        # Create client
        client = ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_approval_requests({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_approval_requests parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_approval_requests ::Google::Cloud::AccessApproval::V1::ListApprovalRequestsMessage.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_approval_requests({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_approval_requests(::Google::Cloud::AccessApproval::V1::ListApprovalRequestsMessage.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_approval_requests_client_stub.call_count
      end
    end
  end

  def test_get_approval_request
    # Create test objects.
    client_result = ::Google::Cloud::AccessApproval::V1::ApprovalRequest.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_approval_request_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::ServiceStub.stub :transcode_get_approval_request_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_approval_request_client_stub do
        # Create client
        client = ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_approval_request({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_approval_request name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_approval_request ::Google::Cloud::AccessApproval::V1::GetApprovalRequestMessage.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_approval_request({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_approval_request(::Google::Cloud::AccessApproval::V1::GetApprovalRequestMessage.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_approval_request_client_stub.call_count
      end
    end
  end

  def test_approve_approval_request
    # Create test objects.
    client_result = ::Google::Cloud::AccessApproval::V1::ApprovalRequest.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    expire_time = {}

    approve_approval_request_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::ServiceStub.stub :transcode_approve_approval_request_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, approve_approval_request_client_stub do
        # Create client
        client = ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.approve_approval_request({ name: name, expire_time: expire_time }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.approve_approval_request name: name, expire_time: expire_time do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.approve_approval_request ::Google::Cloud::AccessApproval::V1::ApproveApprovalRequestMessage.new(name: name, expire_time: expire_time) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.approve_approval_request({ name: name, expire_time: expire_time }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.approve_approval_request(::Google::Cloud::AccessApproval::V1::ApproveApprovalRequestMessage.new(name: name, expire_time: expire_time), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, approve_approval_request_client_stub.call_count
      end
    end
  end

  def test_dismiss_approval_request
    # Create test objects.
    client_result = ::Google::Cloud::AccessApproval::V1::ApprovalRequest.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    dismiss_approval_request_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::ServiceStub.stub :transcode_dismiss_approval_request_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, dismiss_approval_request_client_stub do
        # Create client
        client = ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.dismiss_approval_request({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.dismiss_approval_request name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.dismiss_approval_request ::Google::Cloud::AccessApproval::V1::DismissApprovalRequestMessage.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.dismiss_approval_request({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.dismiss_approval_request(::Google::Cloud::AccessApproval::V1::DismissApprovalRequestMessage.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, dismiss_approval_request_client_stub.call_count
      end
    end
  end

  def test_invalidate_approval_request
    # Create test objects.
    client_result = ::Google::Cloud::AccessApproval::V1::ApprovalRequest.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    invalidate_approval_request_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::ServiceStub.stub :transcode_invalidate_approval_request_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, invalidate_approval_request_client_stub do
        # Create client
        client = ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.invalidate_approval_request({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.invalidate_approval_request name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.invalidate_approval_request ::Google::Cloud::AccessApproval::V1::InvalidateApprovalRequestMessage.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.invalidate_approval_request({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.invalidate_approval_request(::Google::Cloud::AccessApproval::V1::InvalidateApprovalRequestMessage.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, invalidate_approval_request_client_stub.call_count
      end
    end
  end

  def test_get_access_approval_settings
    # Create test objects.
    client_result = ::Google::Cloud::AccessApproval::V1::AccessApprovalSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_access_approval_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::ServiceStub.stub :transcode_get_access_approval_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_access_approval_settings_client_stub do
        # Create client
        client = ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_access_approval_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_access_approval_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_access_approval_settings ::Google::Cloud::AccessApproval::V1::GetAccessApprovalSettingsMessage.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_access_approval_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_access_approval_settings(::Google::Cloud::AccessApproval::V1::GetAccessApprovalSettingsMessage.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_access_approval_settings_client_stub.call_count
      end
    end
  end

  def test_update_access_approval_settings
    # Create test objects.
    client_result = ::Google::Cloud::AccessApproval::V1::AccessApprovalSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    settings = {}
    update_mask = {}

    update_access_approval_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::ServiceStub.stub :transcode_update_access_approval_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_access_approval_settings_client_stub do
        # Create client
        client = ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_access_approval_settings({ settings: settings, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_access_approval_settings settings: settings, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_access_approval_settings ::Google::Cloud::AccessApproval::V1::UpdateAccessApprovalSettingsMessage.new(settings: settings, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_access_approval_settings({ settings: settings, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_access_approval_settings(::Google::Cloud::AccessApproval::V1::UpdateAccessApprovalSettingsMessage.new(settings: settings, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_access_approval_settings_client_stub.call_count
      end
    end
  end

  def test_delete_access_approval_settings
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_access_approval_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::ServiceStub.stub :transcode_delete_access_approval_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_access_approval_settings_client_stub do
        # Create client
        client = ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_access_approval_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_access_approval_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_access_approval_settings ::Google::Cloud::AccessApproval::V1::DeleteAccessApprovalSettingsMessage.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_access_approval_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_access_approval_settings(::Google::Cloud::AccessApproval::V1::DeleteAccessApprovalSettingsMessage.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_access_approval_settings_client_stub.call_count
      end
    end
  end

  def test_get_access_approval_service_account
    # Create test objects.
    client_result = ::Google::Cloud::AccessApproval::V1::AccessApprovalServiceAccount.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_access_approval_service_account_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::ServiceStub.stub :transcode_get_access_approval_service_account_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_access_approval_service_account_client_stub do
        # Create client
        client = ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_access_approval_service_account({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_access_approval_service_account name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_access_approval_service_account ::Google::Cloud::AccessApproval::V1::GetAccessApprovalServiceAccountMessage.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_access_approval_service_account({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_access_approval_service_account(::Google::Cloud::AccessApproval::V1::GetAccessApprovalServiceAccountMessage.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_access_approval_service_account_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AccessApproval::V1::AccessApproval::Rest::Client::Configuration, config
  end
end
