# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AccessApproval
      module V1
        # Home office and physical location of the principal.
        # @!attribute [rw] principal_office_country
        #   @return [::String]
        #     The "home office" location of the principal. A two-letter country code
        #     (ISO 3166-1 alpha-2), such as "US", "DE" or "GB" or a region code. In some
        #     limited situations Google systems may refer refer to a region code instead
        #     of a country code.
        #     Possible Region Codes:
        #
        #       * ASI: Asia
        #       * EUR: Europe
        #       * OCE: Oceania
        #       * AFR: Africa
        #       * NAM: North America
        #       * SAM: South America
        #       * ANT: Antarctica
        #       * ANY: Any location
        # @!attribute [rw] principal_physical_location_country
        #   @return [::String]
        #     Physical location of the principal at the time of the access. A
        #     two-letter country code (ISO 3166-1 alpha-2), such as "US", "DE" or "GB" or
        #     a region code. In some limited situations Google systems may refer refer to
        #     a region code instead of a country code.
        #     Possible Region Codes:
        #
        #       * ASI: Asia
        #       * EUR: Europe
        #       * OCE: Oceania
        #       * AFR: Africa
        #       * NAM: North America
        #       * SAM: South America
        #       * ANT: Antarctica
        #       * ANY: Any location
        class AccessLocations
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] type
        #   @return [::Google::Cloud::AccessApproval::V1::AccessReason::Type]
        #     Type of access justification.
        # @!attribute [rw] detail
        #   @return [::String]
        #     More detail about certain reason types. See comments for each type above.
        class AccessReason
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of access justification.
          module Type
            # Default value for proto, shouldn't be used.
            TYPE_UNSPECIFIED = 0

            # Customer made a request or raised an issue that required the principal to
            # access customer data. `detail` is of the form ("#####" is the issue ID):
            #
            #   * "Feedback Report: #####"
            #   * "Case Number: #####"
            #   * "Case ID: #####"
            #   * "E-PIN Reference: #####"
            #   * "Google-#####"
            #   * "T-#####"
            CUSTOMER_INITIATED_SUPPORT = 1

            # The principal accessed customer data in order to diagnose or resolve a
            # suspected issue in services. Often this access is used to confirm that
            # customers are not affected by a suspected service issue or to remediate a
            # reversible system issue.
            GOOGLE_INITIATED_SERVICE = 2

            # Google initiated service for security, fraud, abuse, or compliance
            # purposes.
            GOOGLE_INITIATED_REVIEW = 3

            # The principal was compelled to access customer data in order to respond
            # to a legal third party data request or process, including legal processes
            # from customers themselves.
            THIRD_PARTY_DATA_REQUEST = 4

            # The principal accessed customer data in order to diagnose or resolve a
            # suspected issue in services or a known outage.
            GOOGLE_RESPONSE_TO_PRODUCTION_ALERT = 5
          end
        end

        # Information about the digital signature of the resource.
        # @!attribute [rw] signature
        #   @return [::String]
        #     The digital signature.
        # @!attribute [rw] google_public_key_pem
        #   @return [::String]
        #     The public key for the Google default signing, encoded in PEM format. The
        #     signature was created using a private key which may be verified using
        #     this public key.
        #
        #     Note: The following fields are mutually exclusive: `google_public_key_pem`, `customer_kms_key_version`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] customer_kms_key_version
        #   @return [::String]
        #     The resource name of the customer CryptoKeyVersion used for signing.
        #
        #     Note: The following fields are mutually exclusive: `customer_kms_key_version`, `google_public_key_pem`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class SignatureInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A decision that has been made to approve access to a resource.
        # @!attribute [rw] approve_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which approval was granted.
        # @!attribute [rw] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the approval expires.
        # @!attribute [rw] invalidate_time
        #   @return [::Google::Protobuf::Timestamp]
        #     If set, denotes the timestamp at which the approval is invalidated.
        # @!attribute [rw] signature_info
        #   @return [::Google::Cloud::AccessApproval::V1::SignatureInfo]
        #     The signature for the ApprovalRequest and details on how it was signed.
        # @!attribute [rw] auto_approved
        #   @return [::Boolean]
        #     True when the request has been auto-approved.
        class ApproveDecision
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A decision that has been made to dismiss an approval request.
        # @!attribute [rw] dismiss_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the approval request was dismissed.
        # @!attribute [rw] implicit
        #   @return [::Boolean]
        #     This field will be true if the ApprovalRequest was implicitly dismissed due
        #     to inaction by the access approval approvers (the request is not acted
        #     on by the approvers before the exiration time).
        class DismissDecision
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The properties associated with the resource of the request.
        # @!attribute [rw] excludes_descendants
        #   @return [::Boolean]
        #     Whether an approval will exclude the descendants of the resource being
        #     requested.
        class ResourceProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request for the customer to approve access to a resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the request. Format is
        #     "\\{projects|folders|organizations}/\\{id}/approvalRequests/\\{approval_request}".
        # @!attribute [rw] requested_resource_name
        #   @return [::String]
        #     The resource for which approval is being requested. The format of the
        #     resource name is defined at
        #     https://cloud.google.com/apis/design/resource_names. The resource name here
        #     may either be a "full" resource name (e.g.
        #     "//library.googleapis.com/shelves/shelf1/books/book2") or a "relative"
        #     resource name (e.g. "shelves/shelf1/books/book2") as described in the
        #     resource name specification.
        # @!attribute [rw] requested_resource_properties
        #   @return [::Google::Cloud::AccessApproval::V1::ResourceProperties]
        #     Properties related to the resource represented by requested_resource_name.
        # @!attribute [rw] requested_reason
        #   @return [::Google::Cloud::AccessApproval::V1::AccessReason]
        #     The justification for which approval is being requested.
        # @!attribute [rw] requested_locations
        #   @return [::Google::Cloud::AccessApproval::V1::AccessLocations]
        #     The locations for which approval is being requested.
        # @!attribute [rw] request_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which approval was requested.
        # @!attribute [rw] requested_expiration
        #   @return [::Google::Protobuf::Timestamp]
        #     The requested expiration for the approval. If the request is approved,
        #     access will be granted from the time of approval until the expiration time.
        # @!attribute [rw] approve
        #   @return [::Google::Cloud::AccessApproval::V1::ApproveDecision]
        #     Access was approved.
        #
        #     Note: The following fields are mutually exclusive: `approve`, `dismiss`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] dismiss
        #   @return [::Google::Cloud::AccessApproval::V1::DismissDecision]
        #     The request was dismissed.
        #
        #     Note: The following fields are mutually exclusive: `dismiss`, `approve`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ApprovalRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the enrollment of a cloud resource into a specific service.
        # @!attribute [rw] cloud_product
        #   @return [::String]
        #     The product for which Access Approval will be enrolled. Allowed values are
        #     listed below (case-sensitive):
        #
        #       * all
        #       * GA
        #       * App Engine
        #       * BigQuery
        #       * Cloud Bigtable
        #       * Cloud Key Management Service
        #       * Compute Engine
        #       * Cloud Dataflow
        #       * Cloud Dataproc
        #       * Cloud DLP
        #       * Cloud EKM
        #       * Cloud HSM
        #       * Cloud Identity and Access Management
        #       * Cloud Logging
        #       * Cloud Pub/Sub
        #       * Cloud Spanner
        #       * Cloud SQL
        #       * Cloud Storage
        #       * Google Kubernetes Engine
        #       * Organization Policy Serivice
        #       * Persistent Disk
        #       * Resource Manager
        #       * Secret Manager
        #       * Speaker ID
        #
        #     Note: These values are supported as input for legacy purposes, but will not
        #     be returned from the API.
        #
        #       * all
        #       * ga-only
        #       * appengine.googleapis.com
        #       * bigquery.googleapis.com
        #       * bigtable.googleapis.com
        #       * container.googleapis.com
        #       * cloudkms.googleapis.com
        #       * cloudresourcemanager.googleapis.com
        #       * cloudsql.googleapis.com
        #       * compute.googleapis.com
        #       * dataflow.googleapis.com
        #       * dataproc.googleapis.com
        #       * dlp.googleapis.com
        #       * iam.googleapis.com
        #       * logging.googleapis.com
        #       * orgpolicy.googleapis.com
        #       * pubsub.googleapis.com
        #       * spanner.googleapis.com
        #       * secretmanager.googleapis.com
        #       * speakerid.googleapis.com
        #       * storage.googleapis.com
        #
        #     Calls to UpdateAccessApprovalSettings using 'all' or any of the
        #     XXX.googleapis.com will be translated to the associated product name
        #     ('all', 'App Engine', etc.).
        #
        #     Note: 'all' will enroll the resource in all products supported at both 'GA'
        #     and 'Preview' levels.
        #
        #     More information about levels of support is available at
        #     https://cloud.google.com/access-approval/docs/supported-services
        # @!attribute [rw] enrollment_level
        #   @return [::Google::Cloud::AccessApproval::V1::EnrollmentLevel]
        #     The enrollment level of the service.
        class EnrolledService
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings on a Project/Folder/Organization related to Access Approval.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the settings. Format is one of:
        #
        #       * "projects/\\{project}/accessApprovalSettings"
        #       * "folders/\\{folder}/accessApprovalSettings"
        #       * "organizations/\\{organization}/accessApprovalSettings"
        # @!attribute [rw] notification_emails
        #   @return [::Array<::String>]
        #     A list of email addresses to which notifications relating to approval
        #     requests should be sent. Notifications relating to a resource will be sent
        #     to all emails in the settings of ancestor resources of that resource. A
        #     maximum of 50 email addresses are allowed.
        # @!attribute [rw] enrolled_services
        #   @return [::Array<::Google::Cloud::AccessApproval::V1::EnrolledService>]
        #     A list of Google Cloud Services for which the given resource has Access
        #     Approval enrolled. Access requests for the resource given by name against
        #     any of these services contained here will be required to have explicit
        #     approval. If name refers to an organization, enrollment can be done for
        #     individual services. If name refers to a folder or project, enrollment can
        #     only be done on an all or nothing basis.
        #
        #     If a cloud_product is repeated in this list, the first entry will be
        #     honored and all following entries will be discarded. A maximum of 10
        #     enrolled services will be enforced, to be expanded as the set of supported
        #     services is expanded.
        # @!attribute [r] enrolled_ancestor
        #   @return [::Boolean]
        #     Output only. This field is read only (not settable via
        #     UpdateAccessApprovalSettings method). If the field is true, that
        #     indicates that at least one service is enrolled for Access Approval in one
        #     or more ancestors of the Project or Folder (this field will always be
        #     unset for the organization since organizations do not have ancestors).
        # @!attribute [rw] active_key_version
        #   @return [::String]
        #     The asymmetric crypto key version to use for signing approval requests.
        #     Empty active_key_version indicates that a Google-managed key should be used
        #     for signing. This property will be ignored if set by an ancestor of this
        #     resource, and new non-empty values may not be set.
        # @!attribute [r] ancestor_has_active_key_version
        #   @return [::Boolean]
        #     Output only. This field is read only (not settable via UpdateAccessApprovalSettings
        #     method). If the field is true, that indicates that an ancestor of this
        #     Project or Folder has set active_key_version (this field will always be
        #     unset for the organization since organizations do not have ancestors).
        # @!attribute [r] invalid_key_version
        #   @return [::Boolean]
        #     Output only. This field is read only (not settable via UpdateAccessApprovalSettings
        #     method). If the field is true, that indicates that there is some
        #     configuration issue with the active_key_version configured at this level in
        #     the resource hierarchy (e.g. it doesn't exist or the Access Approval
        #     service account doesn't have the correct permissions on it, etc.) This key
        #     version is not necessarily the effective key version at this level, as key
        #     versions are inherited top-down.
        class AccessApprovalSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Access Approval service account related to a project/folder/organization.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the Access Approval service account. Format is one of:
        #
        #       * "projects/\\{project}/serviceAccount"
        #       * "folders/\\{folder}/serviceAccount"
        #       * "organizations/\\{organization}/serviceAccount"
        # @!attribute [rw] account_email
        #   @return [::String]
        #     Email address of the service account.
        class AccessApprovalServiceAccount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list approval requests.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The parent resource. This may be "projects/\\{project}",
        #     "folders/\\{folder}", or "organizations/\\{organization}".
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter on the type of approval requests to retrieve. Must be one of the
        #     following values:
        #
        #       * [not set]: Requests that are pending or have active approvals.
        #       * ALL: All requests.
        #       * PENDING: Only pending requests.
        #       * ACTIVE: Only active (i.e. currently approved) requests.
        #       * DISMISSED: Only requests that have been dismissed, or requests that
        #         are not approved and past expiration.
        #       * EXPIRED: Only requests that have been approved, and the approval has
        #         expired.
        #       * HISTORY: Active, dismissed and expired requests.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying the page of results to return.
        class ListApprovalRequestsMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response to listing of ApprovalRequest objects.
        # @!attribute [rw] approval_requests
        #   @return [::Array<::Google::Cloud::AccessApproval::V1::ApprovalRequest>]
        #     Approval request details.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more.
        class ListApprovalRequestsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get an approval request.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the approval request to retrieve.
        #     Format:
        #     "\\{projects|folders|organizations}/\\{id}/approvalRequests/\\{approval_request}"
        class GetApprovalRequestMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to approve an ApprovalRequest.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the approval request to approve.
        # @!attribute [rw] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The expiration time of this approval.
        class ApproveApprovalRequestMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to dismiss an approval request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the ApprovalRequest to dismiss.
        class DismissApprovalRequestMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to invalidate an existing approval.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the ApprovalRequest to invalidate.
        class InvalidateApprovalRequestMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get access approval settings.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the AccessApprovalSettings to retrieve.
        #     Format: "\\{projects|folders|organizations}/\\{id}/accessApprovalSettings"
        class GetAccessApprovalSettingsMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to update access approval settings.
        # @!attribute [rw] settings
        #   @return [::Google::Cloud::AccessApproval::V1::AccessApprovalSettings]
        #     The new AccessApprovalSettings.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The update mask applies to the settings. Only the top level fields of
        #     AccessApprovalSettings (notification_emails & enrolled_services) are
        #     supported. For each field, if it is included, the currently stored value
        #     will be entirely overwritten with the value of the field passed in this
        #     request.
        #
        #     For the `FieldMask` definition, see
        #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
        #     If this field is left unset, only the notification_emails field will be
        #     updated.
        class UpdateAccessApprovalSettingsMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to delete access approval settings.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the AccessApprovalSettings to delete.
        class DeleteAccessApprovalSettingsMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get an Access Approval service account.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the AccessApprovalServiceAccount to retrieve.
        class GetAccessApprovalServiceAccountMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the type of enrollment for a given service to Access Approval.
        module EnrollmentLevel
          # Default value for proto, shouldn't be used.
          ENROLLMENT_LEVEL_UNSPECIFIED = 0

          # Service is enrolled in Access Approval for all requests
          BLOCK_ALL = 1
        end
      end
    end
  end
end
