# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/accessapproval/v1/accessapproval.proto for package 'Google.Cloud.AccessApproval.V1'
# Original file comments:
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/accessapproval/v1/accessapproval_pb'

module Google
  module Cloud
    module AccessApproval
      module V1
        module AccessApproval
          # This API allows a customer to manage accesses to cloud resources by
          # Google personnel. It defines the following resource model:
          #
          # - The API has a collection of
          #   [ApprovalRequest][google.cloud.accessapproval.v1.ApprovalRequest]
          #   resources, named `approvalRequests/{approval_request}`
          # - The API has top-level settings per Project/Folder/Organization, named
          #   `accessApprovalSettings`
          #
          # The service also periodically emails a list of recipients, defined at the
          # Project/Folder/Organization level in the accessApprovalSettings, when there
          # is a pending ApprovalRequest for them to act on. The ApprovalRequests can
          # also optionally be published to a Pub/Sub topic owned by the customer
          # (contact support if you would like to enable Pub/Sub notifications).
          #
          # ApprovalRequests can be approved or dismissed. Google personnel can only
          # access the indicated resource or resources if the request is approved
          # (subject to some exclusions:
          # https://cloud.google.com/access-approval/docs/overview#exclusions).
          #
          # Note: Using Access Approval functionality will mean that Google may not be
          # able to meet the SLAs for your chosen products, as any support response times
          # may be dramatically increased. As such the SLAs do not apply to any service
          # disruption to the extent impacted by Customer's use of Access Approval. Do
          # not enable Access Approval for projects where you may require high service
          # availability and rapid response by Google Cloud Support.
          #
          # After a request is approved or dismissed, no further action may be taken on
          # it. Requests with the requested_expiration in the past or with no activity
          # for 14 days are considered dismissed. When an approval expires, the request
          # is considered dismissed.
          #
          # If a request is not approved or dismissed, we call it pending.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.accessapproval.v1.AccessApproval'

            # Lists approval requests associated with a project, folder, or organization.
            # Approval requests can be filtered by state (pending, active, dismissed).
            # The order is reverse chronological.
            rpc :ListApprovalRequests, ::Google::Cloud::AccessApproval::V1::ListApprovalRequestsMessage, ::Google::Cloud::AccessApproval::V1::ListApprovalRequestsResponse
            # Gets an approval request. Returns NOT_FOUND if the request does not exist.
            rpc :GetApprovalRequest, ::Google::Cloud::AccessApproval::V1::GetApprovalRequestMessage, ::Google::Cloud::AccessApproval::V1::ApprovalRequest
            # Approves a request and returns the updated ApprovalRequest.
            #
            # Returns NOT_FOUND if the request does not exist. Returns
            # FAILED_PRECONDITION if the request exists but is not in a pending state.
            rpc :ApproveApprovalRequest, ::Google::Cloud::AccessApproval::V1::ApproveApprovalRequestMessage, ::Google::Cloud::AccessApproval::V1::ApprovalRequest
            # Dismisses a request. Returns the updated ApprovalRequest.
            #
            # NOTE: This does not deny access to the resource if another request has been
            # made and approved. It is equivalent in effect to ignoring the request
            # altogether.
            #
            # Returns NOT_FOUND if the request does not exist.
            #
            # Returns FAILED_PRECONDITION if the request exists but is not in a pending
            # state.
            rpc :DismissApprovalRequest, ::Google::Cloud::AccessApproval::V1::DismissApprovalRequestMessage, ::Google::Cloud::AccessApproval::V1::ApprovalRequest
            # Invalidates an existing ApprovalRequest. Returns the updated
            # ApprovalRequest.
            #
            # NOTE: This does not deny access to the resource if another request has been
            # made and approved. It only invalidates a single approval.
            #
            # Returns FAILED_PRECONDITION if the request exists but is not in an approved
            # state.
            rpc :InvalidateApprovalRequest, ::Google::Cloud::AccessApproval::V1::InvalidateApprovalRequestMessage, ::Google::Cloud::AccessApproval::V1::ApprovalRequest
            # Gets the settings associated with a project, folder, or organization.
            rpc :GetAccessApprovalSettings, ::Google::Cloud::AccessApproval::V1::GetAccessApprovalSettingsMessage, ::Google::Cloud::AccessApproval::V1::AccessApprovalSettings
            # Updates the settings associated with a project, folder, or organization.
            # Settings to update are determined by the value of field_mask.
            rpc :UpdateAccessApprovalSettings, ::Google::Cloud::AccessApproval::V1::UpdateAccessApprovalSettingsMessage, ::Google::Cloud::AccessApproval::V1::AccessApprovalSettings
            # Deletes the settings associated with a project, folder, or organization.
            # This will have the effect of disabling Access Approval for the project,
            # folder, or organization, but only if all ancestors also have Access
            # Approval disabled. If Access Approval is enabled at a higher level of the
            # hierarchy, then Access Approval will still be enabled at this level as
            # the settings are inherited.
            rpc :DeleteAccessApprovalSettings, ::Google::Cloud::AccessApproval::V1::DeleteAccessApprovalSettingsMessage, ::Google::Protobuf::Empty
            # Retrieves the service account that is used by Access Approval to access KMS
            # keys for signing approved approval requests.
            rpc :GetAccessApprovalServiceAccount, ::Google::Cloud::AccessApproval::V1::GetAccessApprovalServiceAccountMessage, ::Google::Cloud::AccessApproval::V1::AccessApprovalServiceAccount
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
